/**
 * External dependencies
 */
import { decodeEntities } from '@wordpress/html-entities';
import { registerPaymentMethod } from '@woocommerce/blocks-registry';

/**
 * Internal dependencies
 */
import { getSogecommerceServerData } from './sogecommerce-utils';

const PAYMENT_METHOD_NAME = 'sogecommercestd';
var sogecommerce_data = getSogecommerceServerData(PAYMENT_METHOD_NAME);

const Content = () => {
    return (sogecommerce_data?.description);
};

const Label = () => {
    const styles = {
        divWidth: {
            width: '95%'
        },
        imgFloat: {
            float: 'right'
        }
    }

    return (
        <div style={ styles.divWidth }>
            <span>{ sogecommerce_data?.title}</span>
            <img
                style={ styles.imgFloat }
                src={ sogecommerce_data?.logo_url + 'sogecommerce.png' }
                alt={ sogecommerce_data?.title }
            />
        </div>
    );
};

registerPaymentMethod( {
    name: PAYMENT_METHOD_NAME,
    label: <Label />,
    ariaLabel: 'Sogecommerce payment method',
    canMakePayment: () => true,
    content: <Content />,
    edit: <Content />,
    supports: {
        features: sogecommerce_data?.supports ?? [],
    },
} );
