/**
 * External dependencies
 */
import { getSetting } from '@woocommerce/settings';

/**
 * Sogecommerce data comes form the server passed on a global object.
 */

export const getSogecommerceServerData = (name) => {
    const sogecommerceServerData = getSetting( name + '_data', null );

    if ( ! sogecommerceServerData ) {
        throw new Error( 'Sogecommerce initialization data for ' + name + ' submodule is not available' );
    }

    return sogecommerceServerData;
};
