<?php

namespace Woocommerce_Preorders;

class Shop {
	public function __construct() {
		add_filter( 'woocommerce_product_add_to_cart_text', [$this, 'changeButtonText'], 10, 1 );
		add_filter( 'woocommerce_product_single_add_to_cart_text', [$this, 'changeButtonText'], 10, 1 );
		add_filter( 'woocommerce_available_variation', [$this, 'changeButtonTextForVariableProducts'], 10, 3 );
		add_action( 'woocommerce_before_add_to_cart_form', [$this, 'beforeAddToCartBtn'], 10 );
		add_action( 'preorder_product_loop_wrapper', [$this, 'addLoopClasses'], 10 );
	}
	/**
	 * Override class wrapper based on theme style.
	 *
	 * @param  [type] $classes
	 *
	 * @return void
	 */
	public function addLoopClasses( $classes ) {

		$active_theme = wp_get_theme()->get_template();

		switch ( $active_theme ) {
			
		case 'storefront':
			$classes = 'site-main';
			break;

		default:
			
			break;
		}
		
		return $classes;
	}
	public function beforeAddToCartBtn() {
		global $post, $product;
		if ( $product !== null && 'yes' == get_option( 'wc_preorders_available_date_single_product' ) ) {
			if ( 'yes' == get_post_meta( $post->ID, '_is_pre_order', true ) && strtotime( get_post_meta( $post->ID, '_pre_order_date', true ) ) > time() ) {
				$timeFormat = date_i18n( get_option( 'date_format' ), strtotime( get_post_meta( $post->ID, '_pre_order_date', true ) ) );

				$text = $this->replaceDateTxt( get_option( 'wc_preorders_avaiable_date_text', 'Available on {date_format}' ), $timeFormat );

				echo apply_filters( 'preorder_avaiable_date_text', $text );
			}
		}
	}
	/**
	 * @param  $data
	 * @param  $product
	 * @param  $variation
	 * @return mixed
	 */
	public function changeButtonTextForVariableProducts( $data, $product, $variation ) {
		if ( get_post_meta( $variation->get_id(), '_is_pre_order', true ) == 'yes' && strtotime( get_post_meta( $variation->get_id(), '_pre_order_date', true ) ) > time() ) {
			$data['is_pre_order'] = true;
		}
		return $data;
	}

	/**
	 * replace the Available date Text field
	 *
	 * @param  [str]  $string
	 * @return void
	 */
	public function replaceDateTxt( $string, $timeFormat ) {
		$find    = array( "{date_format}" );
		$replace = array( $timeFormat );

		return str_replace( $find, $replace, $string );
	}

	/**
	 * @param  $text
	 * @return mixed
	 */
	public function changeButtonText( $text ) {
		global $post, $product;

		if ( $product !== null ) {
			if ( 'yes' == get_post_meta( $post->ID, '_is_pre_order', true ) && strtotime( get_post_meta( $post->ID, '_pre_order_date', true ) ) > time() ) {
				return get_option( 'wc_preorders_button_text', 'Pre Order Now!' );
			}
		}

		return $text;
	}
}
