<?php

class Rpwsdt_Admin extends Rpwsdt_Main {

    public function __construct() {
        /* call parent class construct */
        parent::__construct();

        /* plugin admin menu hook */
        add_action("admin_menu", array($this, "adminMenu"));

        /* hook for register admin style and js */
        add_action("admin_enqueue_scripts", array($this, "adminEnqueueScripts"));
        add_action('woocommerce_admin_order_data_after_shipping_address', array($this, 'adminShippingTime'));
    }

    public function adminShippingTime($order) {
        $orderShippingTime = $order->get_meta(self::$order_shipping_time_key);
        if (!empty($orderShippingTime)) {
            $shippingText = $this->getOrderDeliveryText($orderShippingTime);
            echo '<div class="address"><p><strong>' . esc_html__('Estimation shipping time:', self::$taxdomain) . '</strong>' . $shippingText . '</p></div>';
        }
    }

    /**
     * Function for register admin js and css
     */
    public function adminEnqueueScripts() {
        wp_enqueue_script('jquery');
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('rpwsdt-admin', self::$plugin_url . "assets/js/admin.js", array('wp-color-picker'));
        wp_enqueue_style('rpwsdt-admin', self::$plugin_url . "assets/css/admin.css");
    }

    /**
     * Function for admin menu
     */
    public function adminMenu() {
        $wc_page = 'woocommerce';
        add_submenu_page($wc_page, esc_html__(self::$plugin_title, self::$taxdomain), esc_html__(self::$plugin_title, self::$taxdomain), "install_plugins", self::$plugin_slug, array($this, "settingPage"));
        add_submenu_page('rpwsdt', esc_html__(self::$plugin_title, self::$taxdomain), esc_html__(self::$plugin_title, self::$taxdomain), "install_plugins", 'rpwsdt-shipping-setting', array($this, "settingShippingPage"));
        add_submenu_page('rpwsdt', esc_html__(self::$plugin_title, self::$taxdomain), esc_html__(self::$plugin_title, self::$taxdomain), "install_plugins", 'rpwsdt-config-shipping', array($this, "configShippingPage"));
    }

    public function settingShippingPage() {
        /* include setting file */
        include_once self::$plugin_dir . "view/admin/settings-shipping.php";
    }

    public function configShippingPage() {

        /* save plugin setting */
        if (isset($_POST[self::$taxdomain])) {
            $this->saveShippingSetting();
        }

        /* include setting file */
        include_once self::$plugin_dir . "view/admin/config-shipping-settings.php";
    }

    /**
     * Plugin general setting page
     */
    public function settingPage() {
        /* save plugin setting */
        if (isset($_POST[self::$taxdomain])) {
            $this->saveSetting();
        }

        /* include setting file */
        include_once self::$plugin_dir . "view/admin/settings.php";
    }

}
