<?php

use SendCloud\Checkout\API\Checkout\Delivery\Zone\DeliveryZone;
use SendCloud\Checkout\API\Checkout\Delivery\Method\DeliveryMethod;
use SendCloud\Checkout\Utility\UnitConverter;

/**
 * Data
 *
 * @var array $data
 */
/**
 * DeliveryZone $shipping_zone.
 *
 * @var DeliveryZone $shipping_zone
 */
/**
 * DeliveryMethod
 *
 * @var DeliveryMethod $delivery_method
 */
/**
 * $is_service_point_delivery
 *
 * @var bool $is_service_point_delivery
 */
?>
<tr class="shipping-rates sc-hidden" data-name="rates-<?php echo esc_attr( $delivery_method->getId() ); ?>">
	<td colspan="6">
		<?php if ( $delivery_method->getShippingRateData()->isEnabled() ) { ?>
			<table class="shipping-rates-table">
				<thead>
				<tr>
					<td><?php esc_html_e( 'WEIGHT CLASS', 'sendcloud-shipping' ); ?></td>
					<td><?php esc_html_e( 'SHIPPING RATE', 'sendcloud-shipping' ); ?></td>
					<?php if ( $is_service_point_delivery ) { ?>
						<td><?php esc_html_e( 'CARRIERS', 'sendcloud-shipping' ); ?></td>
					<?php } ?>
					<td><?php esc_html_e( 'FREE SHIPPING ABOVE', 'sendcloud-shipping' ); ?></td>
					<td><?php esc_html_e( 'DEFAULT RATE', 'sendcloud-shipping' ); ?></td>
				</tr>
				</thead>
				<tbody>
				<?php
				if ( $is_service_point_delivery ) {
					$countEnabledRates = 0;
					$carriers   = $delivery_method->getCarriers();
					foreach ( $delivery_method->getShippingRateData()->getShippingRates() as $index => $rate ) {
						if ( $rate->isEnabled() ) {
							$countEnabledRates++;
							if ( ( $rate->getMinWeight() === null || $rate->getMaxWeight() === null ) ) {
								?>
								<tr>
								<td>
									<b><?php esc_html_e( 'Not configured', 'sendcloud-shipping' ); ?></b>
								</td>
								<td><?php echo esc_html( $data['currency'] . ' ' . $rate->getRate() ); ?></td>
								<?php
							} else {
								?>
								<tr>
								<td>
									<b><?php echo esc_html( UnitConverter::fromGrams( $data['weight_unit'], $rate->getMinWeight() ) . ' - ' . UnitConverter::fromGrams( $data['weight_unit'], $rate->getMaxWeight() ) . ' ' . $data['weight_unit'] ); ?></b>
								</td>
								<td><?php echo esc_html( $data['currency'] . ' ' . $rate->getRate() ); ?></td>
								<?php
							}
							?>
							<?php
							if ( 0 === $index ) {
								?>
								<td>
									<?php 
									echo esc_attr( implode(', ', array_map(function( $carrier) {
return $carrier->getName();
									}, $carriers))); 
									?>
								</td>
								<td>
									<?php
									echo $delivery_method->getShippingRateData()->getFreeShipping()->isEnabled() ? esc_html( $data['currency'] . ' ' . $delivery_method->getShippingRateData()->getFreeShipping()->getFromAmount() ) : esc_html__( 'Not enabled', 'sendcloud-shipping' );
									?>
								</td>
								<?php
							} else {
								?>
								<td></td>
								<td></td>
								<?php
							}
							?>
							<td><?php echo $rate->isDefault() ? esc_html( $data['currency'] . ' ' . $rate->getRate() ) : ''; ?></td>
							</tr>
							<?php
						}
					}
				} else {
					/**
					 * DeliveryZone $shipping_zone.
					 *
					 * @var DeliveryZone $shipping_zone
					 */
					foreach ( $delivery_method->getShippingRateData()->getShippingRates() as $index => $shipping_rate ) {
						if ( ! $shipping_rate->isEnabled() ) {
							continue;
						}
						?>
						<tr>
							<td>
								<b><?php echo esc_html( UnitConverter::fromGrams( $data['weight_unit'], $shipping_rate->getMinWeight() ) . ' - ' . UnitConverter::fromGrams( $data['weight_unit'], $shipping_rate->getMaxWeight() ) . ' ' . $data['weight_unit'] ); ?></b>
							</td>
							<td><?php echo esc_html( $data['currency'] . ' ' . $shipping_rate->getRate() ); ?></td>
							<td>
								<?php
								if ( 0 === $index ) {
									echo $delivery_method->getShippingRateData()->getFreeShipping()->isEnabled() ? esc_html( $data['currency'] . ' ' . $delivery_method->getShippingRateData()->getFreeShipping()->getFromAmount() ) : esc_html__( 'Not enabled', 'sendcloud-shipping' );
								} else {
									echo '';
								}
								?>
							</td>
							<td><?php echo $shipping_rate->isDefault() ? esc_html( $data['currency'] . ' ' . $shipping_rate->getRate() ) : ''; ?></td>
						</tr>
						<?php
					}
				}
				?>
				</tbody>
			</table>
		<?php 
		} else {
			include 'shipping-rates-not-enabled-banner.php';
		} 
		?>

	</td>
</tr>
