<?php

use SendCloud\Checkout\API\Checkout\Delivery\Zone\DeliveryZone;
use SendCloud\Checkout\Utility\UnitConverter;
use Sendcloud\Shipping\Checkout\Services\Zones_Display_Service;

/**
 * Contains data regarding shipping configuration
 *
 * @var array $data
 */
/**
 * DeliveryZone $shipping_zone.
 *
 * @var DeliveryZone $shipping_zone
 */

?>
<div class="sendcloud-panel-box">
	<h3>
		<?php esc_html_e( $shipping_zone->getLocation()->getName() ); ?>
	</h3>
	<hr/>
	<div class="sendcloud-shipping-methods">
		<table class="main-table">
			<thead>
			<tr>
				<td><?php esc_html_e( 'INTERNAL TITLE', 'sendcloud-shipping' ); ?></td>
				<td><?php esc_html_e( 'PUBLIC TITLE', 'sendcloud-shipping' ); ?></td>
				<td><?php esc_html_e( 'SHIPPING PRODUCT', 'sendcloud-shipping' ); ?></td>
				<td><?php esc_html_e( 'RATES ENABLED', 'sendcloud-shipping' ); ?></td>
				<td><?php esc_html_e( 'DELIVERY METHOD', 'sendcloud-shipping' ); ?></td>
				<td class="action-column"></td>
			</tr>
			</thead>
			<tbody>
			<?php
			foreach ( $shipping_zone->getDeliveryMethods() as $delivery_method ) {
				include 'delivery-method.php';
			} 
			?>
			</tbody>

		</table>
	</div>

</div>
