<?php

use SendCloud\Checkout\API\Checkout\Delivery\Method\DeliveryMethod;
use SendCloud\Checkout\API\Checkout\Delivery\Zone\DeliveryZone;
use Sendcloud\Shipping\Checkout\Services\Zones_Display_Service;
/**
 * Data
 *
 * @var array $data
 */
/**
 * DeliveryZone $shipping_zone.
 *
 * @var DeliveryZone $shipping_zone
 */
/**
 * Delivery method
 *
 * @var DeliveryMethod $delivery_method
 */

$is_service_point_delivery = $delivery_method->getType() === 'service_point_delivery';
?>
<tr class="main-info">
	<td>
		<b>
		<span class="sc-expand" data-target="rates-<?php echo esc_attr( $delivery_method->getId() ); ?>">
		<i class="sc-arrow sc-right"></i>
		</span>
			<?php echo esc_html( $delivery_method->getInternalTitle() ); ?>
		</b>
	</td>
	<td><?php echo esc_html( $delivery_method->getExternalTitle() ); ?></td>
	<td><?php echo ! $is_service_point_delivery ? esc_html( $delivery_method->getShippingProduct()->getName() ) : ''; ?></td>
	<td><?php echo $delivery_method->getShippingRateData()->isEnabled() ? 'Yes' : 'No'; ?></td>
	<td><?php echo esc_html( $data['types'][ $delivery_method->getType() ] ); ?></td>
	<td class="action-column">
		<a href="
		<?php 
		echo esc_attr( strtr( Zones_Display_Service::DELIVERY_METHOD_EDIT_URL_PATTERN, array(
			'{integration_id}' => $data['config']['integration_id'],
			'{zone_id}'        => $shipping_zone->getId(),
			'{method_id}'      => $delivery_method->getId(),
			'{type}'           => $delivery_method->getType()
		) ) ); 
		?>
		" target="_blank">
			<button class="sendcloud-button sendcloud-button--secondary edit-btn">
				<svg data-v-19c3f3ae="" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="pencil-alt"
					 role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
					 class="svg-inline--fa fa-pencil-alt fa-w-16">
					<path data-v-19c3f3ae="" fill="currentColor"
						  d="M497.9 142.1l-46.1 46.1c-4.7 4.7-12.3 4.7-17 0l-111-111c-4.7-4.7-4.7-12.3 0-17l46.1-46.1c18.7-18.7 49.1-18.7 67.9 0l60.1 60.1c18.8 18.7 18.8 49.1 0 67.9zM284.2 99.8L21.6 362.4.4 483.9c-2.9 16.4 11.4 30.6 27.8 27.8l121.5-21.3 262.6-262.6c4.7-4.7 4.7-12.3 0-17l-111-111c-4.8-4.7-12.4-4.7-17.1 0zM124.1 339.9c-5.5-5.5-5.5-14.3 0-19.8l154-154c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8l-154 154c-5.5 5.5-14.3 5.5-19.8 0zM88 424h48v36.3l-64.5 11.3-31.1-31.1L51.7 376H88v48z"
						  class=""></path>
				</svg>
			</button>
		</a>
	</td>
</tr>
<?php include 'shipping-rates.php'; ?>
