<?php

use SendCloud\Checkout\API\Checkout\Delivery\Zone\DeliveryZone;
use SendCloud\Checkout\Utility\UnitConverter;
use Sendcloud\Shipping\Checkout\Services\Zones_Display_Service;
use Sendcloud\Shipping\Utility\View;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Contains data regarding shipping configuration
 *
 * @var array $data
 */

?>

<ul id="sendcloud-config-panel">
	<li class="sendcloud-main-content">
		<div class="sendcloud-shipping-zones">
			<?php
			if ( empty( $data['shipping_zones'] ) ) {
				?>
			<div class="sendcloud-panel-box">
				<div class="sc-info-banner">
					<svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="info-circle" role="img"
						 xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
						 class="sc-info-icon svg-inline--fa fa-info-circle fa-w-16">
						<path fill="currentColor"
							  d="M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z"
							  class=""></path>
					</svg>
					<div class="ui-alert__content">
						<?php
						echo wp_kses( __( 'You haven\'t configured Checkout yet.', 'sendcloud-shipping' ) . ' <a href="' . esc_url( $data['config_url'] ) . '" target="_blank">' . __( 'Click here to go to Sendcloud.', 'sendcloud-shipping' ) . '</a>', array(
							'a' => array(
								'href'   => array(),
								'target' => array()
							)
						) );
						?>
					</div>
				</div>
				<?php if ( ! $data['permalinks_enabled'] ) { ?>
				<div class='sc-error-banner banner-add-space'>
					<svg aria-hidden='true' focusable='false' data-prefix='fas' data-icon='info-circle' role='img'
						 xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'
						 class='sc-info-icon svg-inline--fa fa-info-circle fa-w-16'>
						<path fill='red'
							  d='M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z'
						></path>
					</svg>
					<div class='ui-alert__content'>
						<?php
						echo wp_kses( __( 'The connect button is disabled when permalinks are set to \'Plain\'. Please change the permalinks configuration in order to connect.', 'sendcloud-shipping' ), array(
							'a' => array(
								'href'   => array(),
								'target' => array()
							)
						) );
				}
				?>
					</div>
					<?php
			} else {
				foreach ( $data['shipping_zones'] as $shipping_zone ) {
					include 'sendcloud-page/delivery-zone.php';
				}
			}
			?>
				</div>


	</li>
	<li class="sendcloud-side-content">
		<div id="sendcloud_shipping_connect" class="sendcloud-panel-box sendcloud-integration-info">
			<h3>
				<?php esc_html_e( 'Sendcloud Integration', 'sendcloud-shipping' ); ?>
			</h3>
			<?php if ( $data['config']['last_update_time'] ) { ?>
				<hr/>
				<div class="sc-info-banner">
					<svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="info-circle" role="img"
						 xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
						 class="sc-info-icon svg-inline--fa fa-info-circle fa-w-16">
						<path fill="currentColor"
							  d="M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z"
							  class=""></path>
					</svg>
					<div class="ui-alert__content">
						<?php
						esc_html_e( 'Last published:', 'sendcloud-shipping' );
						echo ' ' . esc_attr__( $data['config']['last_update_time'] );
						?>
					</div>
				</div>
			<?php } ?>

			<div class="sendcloud-button-text-container">
				<p>
					<?php esc_html_e( 'Want to see your WooCommerce orders in the Sendcloud Panel?', 'sendcloud-shipping' ); ?>
				</p>
				<?php
				echo '<button class="sendcloud-button sendcloud-button--primary connect-button';
				if ( ! $data['permalinks_enabled'] ) {
					echo ' sendcloud-button-disabled';
				}
				echo '">';
				esc_html_e( 'Connect', 'sendcloud-shipping' );
				echo '</button>';
				?>
			</div>

			<div class="sendcloud-button-text-container">
				<p>
					<?php esc_html_e( 'Want to change any setting?', 'sendcloud-shipping' ); ?>
				</p>
				<a href="<?php echo esc_url( $data['panel_url'] ); ?>" target="_blank" rel="noopener noreferrer">
					<button class="sendcloud-button sendcloud-button--primary">
						<?php esc_html_e( 'Go to Sendcloud', 'sendcloud-shipping' ); ?>
					</button>
				</a>
			</div>
		</div>
	</li>
</ul>
