<?php

class Rpwsdt_Main {

    /**
     * plugin url 
     * @var string
     */
    public static $plugin_url;

    /**
     * plugin directory
     * @var string
     */
    public static $plugin_dir;

    /**
     * plugin unique text domain
     * @var string
     */
    public static $taxdomain = "rpwsdt";

    /**
     * plugin title
     * @var string
     */
    public static $plugin_title = "Shipping Delivery Time";

    /**
     * plugin unique slug
     * @var string
     */
    public static $plugin_slug = "rpwsdt-setting";

    /**
     * plugin general setting key
     * @var string
     */
    public static $rpwsdt_option_key = "rpwsdt-setting";
    public static $rpwsdt_shipping_option_key = "rpwsdt-shipping-setting";
    public static $order_shipping_time_key = "__rpwsdt-order_shipping-key";

    /**
     * plugin settings
     * @var array
     */
    public $rpwsdt_settings = array();

    /**
     * plugin default settings
     * @var array
     */
    public $default_settings = array(
        'text_color' => "#ffffff",
        'text_size' => "12",
    );
    public static $day;
    public static $month;
    public $rpwsdt_shipping_settings = array();

    /**
     * Constructor
     */
    public function __construct() {
        global $rpwsdt_plugin_dir, $rpwsdt_plugin_url, $wpdb;

        /* plugin url and directory variable */
        self::$plugin_dir = $rpwsdt_plugin_dir;
        self::$plugin_url = $rpwsdt_plugin_url;

        /* load plugin setting */
        if (empty($this->rpwsdt_settings)) {
            $this->rpwsdt_settings = get_option(self::$rpwsdt_option_key);
        }
        /* load plugin setting */
        if (empty($this->rpwsdt_shipping_settings)) {
            $this->rpwsdt_shipping_settings = get_option(self::$rpwsdt_shipping_option_key);
        }

        self::$day = array(
            '0' => esc_html__("Sunday", self::$taxdomain),
            '1' => esc_html__("Monday", self::$taxdomain),
            '2' => esc_html__("Tuesday", self::$taxdomain),
            '3' => esc_html__("Wednesday", self::$taxdomain),
            '4' => esc_html__("Thursday", self::$taxdomain),
            '5' => esc_html__("Friday", self::$taxdomain),
            '6' => esc_html__("Saturday", self::$taxdomain),
        );
        self::$month = array(
            '01' => esc_html__('January', self::$taxdomain),
            '02' => esc_html__('February', self::$taxdomain),
            '03' => esc_html__('March', self::$taxdomain),
            '04' => esc_html__('April', self::$taxdomain),
            '05' => esc_html__('May', self::$taxdomain),
            '06' => esc_html__('June', self::$taxdomain),
            '07' => esc_html__('July', self::$taxdomain),
            '08' => esc_html__('August', self::$taxdomain),
            '09' => esc_html__('September', self::$taxdomain),
            '10' => esc_html__('October', self::$taxdomain),
            '11' => esc_html__('November', self::$taxdomain),
            '12' => esc_html__('December', self::$taxdomain),
        );
        
        
    }

    /**
     * Function for save plugin general settings
     */
    public function saveSetting() {
        $saveData = array();

        if (isset($_POST[self::$taxdomain])):

            update_option(self::$rpwsdt_option_key, $_POST);
            $this->rpwsdt_settings = $_POST;
        endif;
    }

    public function saveShippingSetting() {
        $saveData = array();

        if (isset($_POST[self::$taxdomain])):
            $this->rpwsdt_shipping_settings[$_POST['shipping_method_id']] = $_POST;
            update_option(self::$rpwsdt_shipping_option_key, $this->rpwsdt_shipping_settings);

        endif;
    }

    /**
     * Function for get plugin general settings
     * @return 	string 
     */
    public function getSetting($key) {
        if (!empty($this->rpwsdt_settings) && isset($this->rpwsdt_settings[$key])) {
            return $this->rpwsdt_settings[$key];
        }

        if (isset($this->default_settings[$key])) {
            return $this->default_settings[$key];
        }

        return false;
    }

    public function getShippingSetting($key, $id) {
        if (empty($this->rpwsdt_shipping_settings)) {
            return false;
        }

        if (!isset($this->rpwsdt_shipping_settings[$id])) {
            return false;
        }

        if (isset($this->rpwsdt_shipping_settings[$id][$key])) {
            return $this->rpwsdt_shipping_settings[$id][$key];
        }

        return false;
    }

    public function getShippingMethod($id, $zoneId = false) {
        $rate_table = array();
        if ($zoneId === false) {
            $methods = WC()->shipping->get_shipping_methods();
            unset($methods['flat_rate'], $methods['free_shipping'], $methods['local_pickup']);
            foreach ($methods as $instance_id => $method) :
                if ($instance_id == $id) {
                    return $method->get_method_title();
                }
            endforeach;
        } else {
            
            $zone = \WC_Shipping_Zones::get_zone($zoneId);
            $zoneMethods = $zone->get_shipping_methods();
            
            if (!empty($zoneMethods)) {
                foreach ($zoneMethods as $instance_id => $method) :
                    if ($instance_id == $id) {
                        return $method->get_method_title();
                    }

                endforeach;
            }
        }
    }
    
    public function pregReplaceDate($estDay, $response) {
        $this->estDay = $estDay;
        $response = preg_replace_callback("/{(.*?)([+-])(.*?)}/", array($this, 'callbackPregReplace'), $response);
        return $response;
    }

    public function callbackPregReplace($matches) {
        if (!isset($matches[1]) || !isset($matches[2]) || !isset($matches[3])) {
            return $matches[0];
        }

        if (!in_array(trim($matches[1]), array('d', 'date'))) {
            return $matches[0];
        }

        if (!in_array(trim($matches[2]), array('+', '-'))) {
            return $matches[0];
        }


        if (trim($matches[2]) == "-") {
            $estDay = $this->estDay - (trim($matches[3]) * 86400);
        } else {
            $estDay = $this->estDay + (trim($matches[3]) * 86400);
        }

        $this->estDay = $this->isOffDay($estDay);



        if (trim($matches[1]) == "date") {
            return date_i18n($this->getSetting('date_format'), $this->estDay);
        } else {
            $numberOfDay = $this->getDateDiff($this->estDay);
            return $numberOfDay;
        }

        return $matches[0];
    }
    
    
    public function getSpecificBlockday($method_id) {
        $specificday_block = array();
        $blockday = $this->getShippingSetting('specific_day', $method_id);
        if ($blockday && !empty($blockday['day']) && count($blockday['day']) > 0) {
            for ($i = 0; $i < count($blockday['day']); $i++):
                if ($blockday['day'][$i] == 0)
                    continue;
                if ($blockday['month'][$i] == 0)
                    continue;
                if ($blockday['year'][$i] == 0)
                    continue;
                $date = $blockday['year'][$i] . "-" . $blockday['month'][$i] . "-" . $blockday['day'][$i];
                $specificday_block[] = strtotime($date);
            endfor;
        }
        return $specificday_block;
    }
    
    
    /* return period block day */

    public function getPeriodBlockday($method_id) {
        $blockDates = array();
        $blockPeriod = $this->getShippingSetting('specific_period', $method_id);
        if ($blockPeriod && !empty($blockPeriod['fday']) && count($blockPeriod['fday']) > 0) {
            for ($i = 0; $i < count($blockPeriod['fday']); $i++):
                if ($blockPeriod['fday'][$i] == 0 || $blockPeriod['fmonth'][$i] == 0 || $blockPeriod['fyear'][$i] == 0 || $blockPeriod['tday'][$i] == 0 || $blockPeriod['tmonth'][$i] == 0 || $blockPeriod['tyear'][$i] == 0) {
                    continue;
                }
                $fromDate = $blockPeriod['fyear'][$i] . "-" . $blockPeriod['fmonth'][$i] . "-" . $blockPeriod['fday'][$i];
                $toDate = $blockPeriod['tyear'][$i] . "-" . $blockPeriod['tmonth'][$i] . "-" . $blockPeriod['tday'][$i];
                $fromTimeDate = strtotime($fromDate);
                $toTimeDate = strtotime($toDate);

                if ($fromTimeDate > $toTimeDate) {
                    continue;
                }

                while ($fromTimeDate <= $toTimeDate) {
                    $blockDates[] = $fromTimeDate;
                    $fromTimeDate = strtotime('+1 day', $fromTimeDate);
                }
            endfor;
        }
        return $blockDates;
    }
    
    
    public function getBlockDates($method_id) {
        $specificBlockDate = $this->getSpecificBlockday($method_id);
        $periodBlockDate = $this->getPeriodBlockday($method_id);
        $blockDate = array_merge($specificBlockDate, $periodBlockDate);
        return $blockDate;
    }

    public function isOffDay($estDay) {
        $blockDate = $this->getBlockDates($this->methodId);
        $blockWeekday = $this->getBlockWeekday($this->methodId);
        $weekDay = date('w', $estDay);
        if (in_array($estDay, $blockDate) || in_array($weekDay, $blockWeekday)) {
            $estDay = $estDay + 86400;
            $estDay = $this->isOffDay($estDay);
        }
        return $estDay;
    }
    
    
    public function getBlockWeekday($method_id) {
        $weekday_block = array();
        $weekday = $this->getShippingSetting('weekdayoff', $method_id);
        if ($weekday && !empty($weekday)) {
            foreach ($weekday as $bday):
                $weekday_block[] = intval($bday);
            endforeach;
        }
        return $weekday_block;
    }
    
     public function getDateDiff($estDay) {
        $date1 = date_create(date('Y-m-d'));
        $date2 = date_create(date('Y-m-d', $estDay));
        $diff = date_diff($date1, $date2);
        return $diff->format("%a");
    }
    
    public function showOrderShippingTime($shippingText, $order) {
        $orderShippingTime = $order->get_meta(self::$order_shipping_time_key);
        if (!empty($orderShippingTime)) {
            $shippingText .= $this->getOrderDeliveryText($orderShippingTime);
        }
        return $shippingText;
    }

    public function getOrderDeliveryText($time) {
        $settingText = $this->getSetting('text_order');
        $response = str_replace('{date}', date_i18n($this->getSetting('date_format'), $time), $settingText);
        $response = $this->pregReplaceDate($time, $response);
        return '<br><span class="rpwsdt_estimated_date">' . $response . '</span>';
    }

}
