<?php
/**
 * Plugin Name: Pre-Orders for WooCommerce
 * Plugin URI: https://wordpress.org/plugins/pre-orders-for-woocommerce/
 * Description: Ultimate Preorders Plugin for WooCommerce.
 * Version: 1.2.11
 * Requires PHP: 7.2.0
 * Domain Path: /languages/

 * WC tested up to: 7.4
 * Tested up to: 6.1
 * WC requires at least: 3.9
 * Author: Bright Plugins
 * Author URI: https://brightplugins.com
 * Text Domain: pre-orders-for-woocommerce
 */

defined( 'ABSPATH' ) || exit;

// Define WCPO_PLUGIN_DIR.
if ( !defined( 'WCPO_PLUGIN_DIR' ) ) {
	define( 'WCPO_PLUGIN_DIR', __DIR__ );
}
if ( !defined( 'WCPO_PLUGIN_BASE' ) ) {
	define( 'WCPO_PLUGIN_BASE', plugin_basename( __FILE__ ) );
}
if ( !defined( 'WCPO_PLUGIN_URL' ) ) {
	define( 'WCPO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}
define( 'WCPO_TEMPLATE_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/templates/' );
define( 'WCPO_PLUGIN_VER', '1.2.11' );

use Woocommerce_Preorders\Bootstrap;
use Woocommerce_Preorders\Packages;

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

require_once WCPO_PLUGIN_DIR . '/vendor/autoload.php';
/**
 * Initialize the plugin tracker
 *
 */
function appsero_init_tracker_pre_orders_for_woocommerce() {


	$client = new Appsero\Client( '4ec1293f-9d9f-4a3d-b312-c93c19e16be8', 'Preorders for WooCommerce', __FILE__ );

	// Active insights
	$client->insights()->init();

}

appsero_init_tracker_pre_orders_for_woocommerce();

require_once WCPO_PLUGIN_DIR. '/inc/ran/class-remote-notification-client.php';

if ( function_exists( 'wpi_rdnc_add_notification' ) ) {
	wpi_rdnc_add_notification( 152, '9d7bd777a9d8055e', 'https://brightplugins.com' );
}

final class Bright_Plugins_PFW {

	/**
	 * @var mixed
	 */
	static $instance = null;

	private function __construct() {

		$this->init_plugin();
	}

	/**
	 * Initializes a singleton instance
	 *
	 * @since 1.2.7
	 * @access public
	 * @static
	 *
	 * @return $instance
	 */
	public static function init() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Initialize the plugin
	 *
	 * @since 1.2.7
	 * @access public
	 *
	 * @return void
	 */
	public function init_plugin() {

		// Check if WooCommerce is active
		if ( $this->is_woocommerce_installed() ) {
			// Put your plugin code here

			add_action( 'woocommerce_loaded', function () {

				$bootstrap = new Bootstrap();
				register_activation_hook( __FILE__, [$bootstrap, 'defaultOptions'] );

				$package = new Packages();

				$this->init_advertising();
			} );
		} else {
			add_action( 'admin_notices', function () {
				$class   = 'notice notice-error';
				$message = __( 'Oops! looks like WooCommerce is disabled. Please, enable it in order to use WooCommerce Pre-Orders.', 'pre-orders-for-woocommerce' );
				printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
			} );
		}
	}

	/**
	 * Check if WooCommerce is installed
	 *
	 * @since 1.2.7
	 * @access public
	 *
	 * @return bool
	 */
	public function is_woocommerce_installed() {

		/**
		 * Checks if it is a multisite
		 */
		if ( is_multisite() ) {
			add_filter( 'active_plugins', function ( $active_plugins ) {

				$network = get_network();

				if ( !isset( $network->id ) ) {
					return $active_plugins;
				}
				$active_sitewide_plugins = get_network_option( $network->id, 'active_sitewide_plugins', null );

				if ( !empty( $active_sitewide_plugins ) ) {
					$network_active_plugins = array();

					foreach ( $active_sitewide_plugins as $key => $value ) {
						$network_active_plugins[] = $key;
					}

					$active_plugins = array_merge( $active_plugins, $network_active_plugins );
				}

				return $active_plugins;
			} );
		}

		$filter_active_plugins    = apply_filters( 'active_plugins', get_option( 'active_plugins' ) );
		$is_woocommerce_installed = in_array( 'woocommerce/woocommerce.php', $filter_active_plugins, true );

		return $is_woocommerce_installed;
	}

	/**
	 * Starts the plugin advertising
	 *
	 * @since 1.2.7
	 * @access public
	 *
	 * @return void
	 */
	public function init_advertising() {

		add_action( 'before_preoder_settings_tab', [$this, 'bvPreorderAdminBox'] );
	}

	/**
	 * Generates the advertisement of the pro version of the plugin
	 *
	 * @since 1.2.7
	 * @access public
	 *
	 * @return void
	 */
	public function bvPreorderAdminBox() {?>

        <div class="preorder-proversion-box">
            <h2 class="pp-heading">Preorder Pro Features</h2>
            <ul>
                <li><span class="dashicons dashicons-yes"></span> Unlock 3 more Pre-order Modes</li>
                <li><span class="dashicons dashicons-yes"></span> Specific Coupons for Preorder Products</li>
                <li><span class="dashicons dashicons-yes"></span> Customizable Email Notifications for Preorders</li>

                <li><span class="dashicons dashicons-yes"></span> Add Manual Preorder from Order Backend</li>
                <li><span class="dashicons dashicons-yes"></span> Apply Bulk 'Preorder' Action by Category</li>
                <li><span class="dashicons dashicons-yes"></span> Disable Payment Methods for Preoders</li>
                <li><span class="dashicons dashicons-yes"></span> Custom Pre-order Email Notifications</li>


            </ul>
            <a target="_blank" class="button" href="https://brightplugins.com/go/preorder-pro" >Get the Pro Version</a>

            <div class="bp-free-support">
                <span class="dashicons dashicons-sos"></span>
                <a target="_blank" href="https://brightplugins.com/support/" >
                    <h4>Ticket Support </h4>
                    <p>Direct help from our support team</p>
                </a>

            </div>

            <div class="bp-pro-affiliate">
                <span class="dashicons dashicons-money-alt"></span>
                <a target="_blank" href="https://brightplugins.com/affiliates-terms-and-conditions/" >
                    <h4>Affiliate Program </h4>
                    <p>Earn flat 30% on every sale!</p>
                </a>

            </div>
        </div><?php
}
}

/**
 * Initializes the main plugin
 */
function Bright_Plugins_PFW_start() {
	return Bright_Plugins_PFW::init();
}

// kick-off the plugin
Bright_Plugins_PFW_start();