<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://themeforest.net/user/rado-studio/portfolio
 * @since      1.0.0
 *
 * @package    Aventa_core
 * @subpackage Aventa_core/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Aventa_core
 * @subpackage Aventa_core/includes
 * @author     Rado studio <help.radostudio@gmail.com>
 */
class Aventa_core_i18n
{

    /**
     * Load the plugin text domain for translation.
     *
     * @since    1.0.0
     */
    public function load_plugin_textdomain()
    {

        load_plugin_textdomain(
            "aventa",
            false,
            dirname(dirname(plugin_basename(__FILE__))) . "/languages/"
        );

    }

}
