<?php
/**
 * Product Loop Start
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */
?>
<?php

$columns = rad_custom_loop_columns();

$attributes = array();
$classes     = array("products","shop-grid");
$classes[]   = (rad_get_option("shop-gutter") == 0) ? "one-unit-gutter": "two-unit-gutter";
$classes[]   = rad_get_option("shop-layout") . "-layout";
$classes[]   = (rad_get_option("shop-enable-fullwidth") == 0) ? "": "fullwidthshop";
$classes[]   = rad_get_option("product-style");
$classes[]   = "shop-". $columns ."column";
$classes[]   = (rad_get_option("shop-column-responsive") == "2")? "shop-mobile-2column" : "";
$classes[] 	 = "cat-style-" . rad_get_option("wc-category-style");

//Shop entrance animation
$entrance_animation = rad_get_option("shop-entrance-animation");
$classes[] = ($entrance_animation != "none")? "elem-grid-anim" : "";
$classes[] = ($entrance_animation != "none")? "no-resp-anim" : "";
$attributes = rad_make_anim_attributes($entrance_animation, "0", true);

if(is_shop() || is_product_category() || is_product_tag())
{
	$classes[] = "woocommerce";
}
elseif(is_product())
{
	$classes   = array("products","shop-grid", "general-layout", "shop-4column");
	$classes[] = (rad_get_option("shop-gutter") == 0) ? "one-unit-gutter": "two-unit-gutter";
	$classes[] = rad_get_option("product-style");
	$classes[] = (rad_get_option("shop-column-responsive") == "2")? "shop-mobile-2column" : "";
}

$classes = apply_filters("rad_loop_start_classes", $classes);
$attributes = apply_filters("rad_loop_start_attributes", $attributes);

$attributes = array_filter($attributes);
$attributes_html = implode(" ", array_map(
    function ($k, $v) {
        return $k ."=\"" . esc_attr($v) . "\"";
    },
    array_keys($attributes),
    $attributes
));

?>
<ul class="<?php echo esc_attr(implode(" ",array_filter($classes))); ?>" <?php echo "" . $attributes_html;//Sanitized ?>>