<article <?php post_class(); ?>>
    <?php

    $image_ids = rad_get_meta("gallery");
    if(!is_array($image_ids))
    {
        $image_ids = explode(",", $image_ids);
    }
    
    if(count($image_ids))
    {?>
    <div class="post-media carousel">
        <div class="swiper-container" data-visibleitems="1">
            <div class="swiper-wrapper">
                <?php
                foreach($image_ids as $img_id)
                {
                    $img_url = rad_get_image_url($img_id,"rad_standard-blog-detail");

                    if ($img_url != "") {
                        echo "<div class=\"swiper-slide\" style=\"background:url(" . esc_url($img_url) . ");\"></div>"; 
                    }
                }
                ?>
            </div>
            <div class="rad-carousel-next unselectable"></div>
            <div class="rad-carousel-prev unselectable"></div>
        </div>
    </div>
    <?php
    }

    get_template_part( "templates/core/single/post", "meta" ); ?>
    <div class="post-body">
    <?php
    the_content(); 
    wp_link_pages();
    ?>
    </div>
    <?php
    get_template_part( "templates/core/single/post", "share" );
    get_template_part( "templates/core/single/post", "tags" );
    get_template_part( "templates/core/single/post", "author" );
    ?>
</article>