<?php

$page_beins_with = rad_header_status();
if($page_beins_with != "header")
{
	return;
}

$breadcrumb = rad_get_option( "header-breadcrumb");
$alignment  = (rad_get_option( "header-alignment") == 2)? "center-align": "side-align";

/* WC settings*/
$cat_mode   = rad_get_option("wc-header-category");
$cat_images = (rad_get_option("wc-header-category-images") == 1) ? true:false;;

$title    = "";
$category_id = null;
$bg_image = "";


if(rad_is_wc_active() && is_product_category())
{
	$term = get_queried_object();
	$category_id = $term->term_id;
	$title = $term->name;

    if(get_term_meta( $category_id ,"cat-header-bg-image", true ) != "")
    {
        $bg_image = wp_get_attachment_url(get_term_meta( $category_id ,"cat-header-bg-image", true));
    }
}
elseif(is_page() || is_home() || ( function_exists("is_shop") && is_shop()) )
{	
	$title_type  = rad_get_meta( "title-bar" );
	
	if($title_type == "1")
	{
		$title     = rad_get_meta( "title-text", true );
	}
	elseif($title_type == "2" || $title_type == "")
	{
		$title     = rad_get_the_title();
	}

    if(rad_get_meta( "page-header-bg-image", true ) != "")
    {
        $bg_image    = rad_get_image_url(rad_get_meta( "page-header-bg-image"),"full");
    }
}

if($bg_image == "" && function_exists("get_header_image") && get_header_image())
{
	$bg_image = get_header_image();
}


if (is_category()) {
	$title = sprintf(esc_html__("All posts in: %s", "aventa"), single_cat_title("",false));
}
elseif( is_home() && $title == "" ){
	$title = esc_html__("Blog", "aventa");
}
elseif( is_tag() ){
	$title = sprintf(esc_html__("All posts tagged: %s", "aventa"), single_tag_title("",false));
}
elseif( is_day() ){
	$title = sprintf(esc_html__("Archive for: %s", "aventa"), get_the_time("F jS, Y"));
}
elseif( is_month() ){
	$title = sprintf(esc_html__("Archive for: %s", "aventa"), get_the_time("F, Y"));
}
elseif ( is_year() ){
	$title = sprintf(esc_html__("Archive for: %s", "aventa"), get_the_time("Y") );
}
elseif ( is_author() ){
	$title = sprintf(esc_html__("Posts by: %s", "aventa"), get_the_author_meta("display_name"));
}
elseif ( isset( $_GET["paged"] ) && !empty( $_GET["paged"] ) ){
	$title = esc_html__("Blog Archive", "aventa");
}

$classes  = $alignment . " overlay ";
$classes  .= (($cat_mode == "simple" || $cat_mode == "toggle") && $cat_images == true && rad_is_wc_active() && (is_product_category() || is_shop()))? "simple-sub-cat " : "";
$classes  .= ($bg_image == "") ? "no-img" : "";

?>

<div id="header" class="<?php echo esc_attr($classes) ?>">
	<?php
    if($bg_image != "")
    {
        echo "<img src=\"" . esc_url($bg_image) . "\" class=\"header-img\" alt=\"" . esc_attr(get_bloginfo("name","display")) . "\">";
    }
	?>
	<div class="container">
		<?php
		if($title != "")
		{
			echo "<h1>" . esc_html($title) . "</h1>";
		}

		if($breadcrumb == 1)
		{
			if( rad_is_wc_active() ) {
				woocommerce_breadcrumb(array("delimiter"   => "<span></span>"));
			}
		}

		$categories_output = "";

		if(is_search())
		{
			$cat_mode = "disable";
		}

		if(rad_is_wc_active() && (is_shop() || is_product_category() ) && ($cat_mode == "simple" || $cat_mode == "toggle"))
		{
			if (  $cat_mode != "disable" ) {		
				$class = ($cat_mode == "simple") ? "open" : "";
				$categories_output = rad_woocommerce_product_subcategories($category_id,$class,$cat_images);
			
				if (  $cat_mode == "toggle" && $categories_output != "") {
					echo "<a href=\"#\" id=\"cat-toggle\" class=\"hidden-phone hidden-tablet\"><span class=\"show\">". esc_html__("Show Categories","aventa") ."</span>";
					echo "<span class=\"hide\">". esc_html__("hide Categories","aventa")."</span></a>";
				}
			}
		}
		?>
	</div>
	<?php
	if ( rad_is_wc_active() && ( is_shop()  ||  is_product_category() ) && ($cat_mode == "simple" || $cat_mode == "toggle") ) {		
		echo "" . $categories_output;
	}
	?>
</div>