<?php
if (is_page_template("maintenance.php") || is_page_template("blank.php")) {
  return;
}


$class = "";
$site_title = get_bloginfo("name");

/*Topbar options */
$topbar         = rad_get_option("topbar_display");
$topBarStyle    = rad_get_option("topbar_style") == 1 ? "light":"dark";
$boxedTopBar    = rad_get_option("boxed_topbar");
$rss            = rad_get_option("rss");
$currencySwitcher = rad_get_option("menu_currency_switcher");

/*Header options */
$headerType   = rad_get_option("menu-align");
$header_state = rad_get_option("menu-state") != "" ? rad_get_option("menu-state"):"single-state";
$header_style = rad_get_option("menu-style");
$shop_cart    = rad_get_option("shop-enable-cart");
$catalog_mode = rad_get_option("catalog_mode");
$search       = rad_get_option("menu-search");
$headerWishlist = rad_get_option("header-wishlist-display");
$mobile_menu_style = rad_get_option("mobile_menu-color");

$main_logo = $second_logo = "";
rad_get_logo($main_logo,$second_logo);


$second_logo_class = "second-logo";
$main_logo_class = "main-logo";



if(rad_get_meta("menu") == "custom") // overrided menu styles in current page
{
  //initial State of menu
  if(rad_get_meta("menu-initial-state-logo") == 1) //
  {
    $main_logo_class   .= " state1-logo";
  }
  else
  {
    $second_logo_class .= " state1-logo";
  }


  //second State of menu
  if(rad_get_meta("menu-second-state-logo") == 1) //
  {
    $main_logo_class   .= " state2-logo";
  }
  else
  {
    $second_logo_class .= " state2-logo";
  }
}
else
{
  //initial State of menu
  if(rad_is_wc_active() && is_product_category())
  {
    if(rad_get_option("menu-wc-cat-initial-state-logo") == 1) //
    {
      $main_logo_class   .= " state1-logo";
    }
    else
    {
      $second_logo_class .= " state1-logo";
    }
  }
  else
  {
    //initial State of menu
    if(rad_get_option("menu-initial-state-logo") == 1) //
    {
      $main_logo_class   .= " state1-logo";
    }
    else
    {
      $second_logo_class .= " state1-logo";
    }
  }


  //second State of menu
  if(rad_get_option("menu-second-state-logo") == 1) //
  {
    $main_logo_class   .= " state2-logo";
  }
  else
  {
    $second_logo_class .= " state2-logo";
  }
}

/* header mode */
$header_mode = rad_get_option( "header-mode");


/* Hamburger menu*/
$hamburgerMenuText = rad_get_option("hamburger-menu-text") == ""? "" : "<span class=\"text\">" . str_repeat("<span>". rad_get_option("hamburger-menu-text") . "&nbsp;</span>",4) . "</span>";

$class  = rad_get_option("hamburger-logo") == 1 ? "hamburger-second-logo" : "hamburger-main-logo";
$class .= rad_get_option("collection-logo") == 1 ? " collection-main-logo" : " collection-second-logo";

if ( $headerType == 1 ) {
  $class .= " type1";
}
elseif ( $headerType == 2 ) {
  $class .= " type2";
}
else {
  $class .= " type3";
}

$class .= " " . $header_state . " " . $header_style;

if ( $topbar == 1) {  ?>
  <div id="topbar" class="hidden-phone hidden-tablet <?php echo esc_attr($topBarStyle); ?>">
    <?php
    if ($boxedTopBar == 1) { ?>
      <div class="container">
    <?php
    }

    echo rad_get_languages();

    if (rad_get_option("topbar-social-display") ) { ?>
      <?php
        $classes = array("social-icons",$topBarStyle ."-style");
        echo rad_social_icons("topbar-social", null, $classes, "icon");
    }
    ?>
    <div class="topbar-message">
      <?php if ( rad_get_option("topbar_text") ) { ?>
        <div class="topbar-text">
          <?php rad_e_option("topbar_text"); ?>
          <span class="space"></span>
          <?php rad_e_option("topbar_text"); ?>
          <span class="space"></span>
          <?php rad_e_option("topbar_text"); ?>
          <span class="space"></span>
        </div>
        <div class="topbar-text">
          <?php rad_e_option("topbar_text"); ?>
          <span class="space"></span>
          <?php rad_e_option("topbar_text"); ?>
          <span class="space"></span>
          <?php rad_e_option("topbar_text"); ?>
          <span class="space"></span>
        </div>
      <?php } ?>
    </div>
    <?php


    if ($boxedTopBar == 1) { ?>
      </div>
    <?php } ?>
  </div>
<?php
} ?>

<header id="rad-menu" class="<?php echo esc_attr($class); ?>">
  <div id="menu-bg"></div>                        
  <a class="logo" href="<?php echo get_home_url(); ?>">
    <img src="<?php echo esc_url($second_logo); ?>" alt="<?php echo esc_attr($site_title); ?>" class="<?php echo esc_attr($second_logo_class); ?>"/>
    <img src="<?php echo esc_url($main_logo); ?>" alt="<?php echo esc_attr($site_title); ?>" class="<?php echo esc_attr($main_logo_class); ?>"/>
	</a>
  <?php
  
  get_template_part( "templates/core/nav/nav", "mobile" );

  if ( has_nav_menu( "hamburger-main-nav" ) ) { ?>        
    <span class="hamburger-menu-btn hidden-phone hidden-tablet">
      <span></span>
    </span>
  <?php
  }

  if ( rad_is_wc_active() && $shop_cart == "1" && $catalog_mode == 0 ) {
      get_template_part( "templates/woocommerce/cart-icon" );
  } 

  if ( rad_is_wc_active() &&  class_exists("YITH_WCWL") && $headerWishlist == 1 ) {
    global $yith_wcwl,$wp;

    $current_url = home_url( add_query_arg( array(), $wp->request ) );
    ?>
    <span class="wishlist-btn">
      <?php echo rad_Icon_Manager::get_icon("heart"); ?>
      <span class="number"><?php echo yith_wcwl_count_products(); ?></span>
    </span>
    <div class="toggle-aside wishlist-aside bg">
    <?php
    $output = do_shortcode("[yith_wcwl_wishlist per_page=\"4\"]");
    $output = str_replace("action=\"\"", "action=\"". esc_url($current_url) ."\"", $output);
    echo "" . $output;

    $class = "";
    if(yith_wcwl_count_products() <= 0)
    {
      $class = "empty-wishlist";
    }
    ?>
      <a href="<?php echo esc_url($yith_wcwl->get_wishlist_url()); ?>" class="wishlist-more underline-style init-show <?php echo esc_attr($class); ?>"><?php esc_html_e("See all", "aventa" ) ?></a>
    </div>
  <?php 
  }

  if($search == 1)
  {
      ?>
      <span class="search-button unselectable">
        <?php echo rad_Icon_Manager::get_icon("search"); ?>
      </span>
      <?php
  }

  if ( rad_is_wc_active()  && rad_get_option("shop-login-link") == 1 ) { ?>
    <div class="header-account">
        <?php
        echo rad_get_myaccount_link();
        ?>
    </div> 


    <div class="toggle-aside login-aside bg" id="login-form">
      <?php
      if(!is_user_logged_in())
      {
        rad_load_account_page();
      }
      else
      {
        ?>
        <ul class="account-links">
          <?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) { ?>
            <li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
            <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
            </li>
          <?php } ?>
        </ul>
        <?php
      }
      ?>
    </div>
  <?php
  }

  if ( $currencySwitcher && class_exists("WOOCS")) { ?>
    <div class="header-currency visible-desktop">
      <?php echo do_shortcode( $currencySwitcher ); ?> 
    </div>       
  <?php
  }

  if ( has_nav_menu( "primary-nav" ) ) { ?>
    <nav class="navigation hidden-phone hidden-tablet">
      <?php
          wp_nav_menu(array(
            "container" =>"",
            "menu_class" => "clearfix",
            "before"     => "",
            "theme_location" => "primary-nav",
            "walker"     => new rad_Nav_Walker(),
            "fallback_cb" => false , 
            "after" => ""
          ));
      ?>
    </nav>
    <?php
  }

  ?>
  <div class="aside-close"></div>
  <?php
  if($search == 1 )
  {
    ?>
    <div class="toggle-aside search-aside bg" id="search-form">
        <?php
        $search_type = rad_get_option("search_post_type");
        if($search_type == "product" && rad_is_wc_active())
        {
          rad_woocommerce_product_subcategories_slugs();
        }
        get_template_part( "templates/core/search/search-form" ); ?>
    </div>
    <?php
  }

  if( class_exists("woocommerce") ) {
  ?>
    <div class="toggle-aside collection-aside bg">
      <h4 class="title"><?php echo esc_html__("Collections", "aventa"); ?></h4>
      <a class="shop underline-style init-show" href="<?php echo get_permalink( wc_get_page_id( "shop" ) ); ?>"><?php echo esc_html__("All our products", "aventa"); ?></a>
      <div class="sc">
      <div class="inner">
        <ul>
          <?php   
            if(function_exists('rado_collection_output'))
            {
              echo rado_collection_output();
            }
          ?>
        </ul>
      </div>
      </div>
    </div>
  <?php
  }

  if ( class_exists( "WooCommerce" )) {  ?>
    <div class="toggle-aside wc-cart-aside bg">
       <div class="cart-aside-wrapper">
        <div class="wc-loading"></div>
        <div class="widget woocommerce widget_shopping_cart">
          <div class="widget_shopping_cart_content">
          <?php woocommerce_mini_cart(); ?>
          </div>
        </div>
      </div>
    </div>
  <?php
  }

  if ( has_nav_menu( "hamburger-main-nav" ) ) { ?>
    <div class="toggle-aside hamburger-menu bg">
      <div class="hamburger-menus">
        <div class="inner sc">
          <?php
          wp_nav_menu(array(
              "container" =>"",
              "menu_class" => "hamburger-main-nav",
              "before"     => "",
              "theme_location" => "hamburger-main-nav",
              "walker"     => new rad_Simple_Nav_Walker(),
              "fallback_cb" => false , 
              "after" => ""
          ));

          wp_nav_menu(array(
              "container" =>"",
              "menu_class" => "hamburger-second-nav",
              "before"     => "",
              "theme_location" => "hamburger-second-nav",
              "walker"     => new rad_Simple_Nav_Walker(),
              "fallback_cb" => false , 
              "after" => ""
          ));
          ?>
        </div>
        <div id="hamburger-menu-bar">
        <?php
        $languages = rad_get_languages();
        if($languages != "")
        {
          echo "<div class=\"inline-lang\">" . esc_html__("Language","aventa") . $languages . "</div>";
        }
        
        $currencies = do_shortcode( $currencySwitcher );
        if($currencies != "" && class_exists("WOOCS"))
        {
          echo "<span class=\"inline-currency\">" .esc_html__("Currency","aventa") . $currencies . "</span>";
        }
        ?>
        </div>
      </div>
      <div class="hamburger-menu-img">
        <?php
        if($hamburgerMenuText != "")
        {
          echo "<div class=\"marquee\">" .$hamburgerMenuText ."</div>";
        }
        if(rad_get_option("hamburger-menu-img") != "") {
          echo "<span class=\"img\"><span style=\"background:url(" . rad_get_image_url(rad_get_option("hamburger-menu-img"),"full") . ")\"></span></span>";
        }
        ?>
      </div>
    </div>
  <?php
  }
  ?>
  <span id="overlay-layer"></span> 
  <?php
  /**
   * rad_before_header_close hook
   *
   */
  do_action( "rad_before_header_close" );
  ?>
</header>