<?php

require_once "helpers.php";

class Rad_Loader
{
    /**
     * Includes (require_once) php file(s) inside selected folder
     */
    public static function Require_Files($path, $fileName, $scope = "public")
    {

        if ($scope == "admin" && !is_admin()) {
            return;
        }

        if (is_string($fileName)) {
            require_once rad_path_combine($path, $fileName) . ".php";
        } elseif (is_array($fileName)) {
            foreach ($fileName as $name) {
                require_once rad_path_combine($path, $name) . ".php";
            }
        } else {
            //Throw error
            throw new Exception("Unknown parameter type");
        }
    }
}

//Include framework files
rad_Loader::Require_Files(RAD_THEME_INC,
    array(
        "config",
        "admin/libs/aq-resizer/aq_resizer",
        "wc-functions",
        "wp-functions",
        "assets",
        "sidebars",
        "nav-walker/menu",
        "elements",
        "admin/compatibility/compatibility",
        "icon-manager",
        "admin/customizer/init",
    ),
    "public"
);


add_action("init", "rad_include_hooks", 10);
function rad_include_hooks() {
    //Include framework files
    rad_Loader::Require_Files(RAD_THEME_INC,
        array(
            "wc-hooks",
            "wp-hooks",
        ),
        "public"
    );
}


rad_Loader::Require_Files(RAD_THEME_ADMIN,
    array(
        "fonts/font-kits",
        "demos/demo-installer",
        "menu/menu-setting",
        "3rd-party/plugins-handler",
        "wc/wc-admin-hooks",
        "admin-init",
        "meta-boxes/post",
        "meta-boxes/page",
        "meta-boxes/slider",
        "meta-boxes/product",
    ),
    "admin"
);
