<?php

/*-----------------------------------------------------------------------------------*/
/*  Load text domain
/*-----------------------------------------------------------------------------------*/

function rad_load_theme_textdomain() {
    load_theme_textdomain( "aventa", get_template_directory() . "/languages" );
}
add_action( 'after_setup_theme', 'rad_load_theme_textdomain' );
/*-----------------------------------------------------------------------------------*/
/*  Register default menus
/*-----------------------------------------------------------------------------------*/
function rad_register_menus()
{
    register_nav_menu("primary-nav", esc_html__("Primary Navigation", "aventa"));
    register_nav_menu("mobile-nav", esc_html__("Mobile Navigation", "aventa"));
    register_nav_menu("hamburger-main-nav", esc_html__("Hamburger - Main Navigation", "aventa"));
    register_nav_menu("hamburger-second-nav", esc_html__("Hamburger - Second Navigation", "aventa"));
    register_nav_menu("footer-nav1", esc_html__("Footer - Main navigation", "aventa"));
    register_nav_menu("footer-nav2", esc_html__("Footer - Second navigation", "aventa"));
}

add_action("init", "rad_register_menus");

/*-----------------------------------------------------------------------------------*/
/*  Define what the theme supports
/*-----------------------------------------------------------------------------------*/

function rad_theme_support()
{
    add_theme_support("automatic-feed-links");
    add_theme_support("post-formats", rad_get_post_formats_list());
    add_theme_support("custom-background");
    add_theme_support("html5", array("comment-list", "comment-form", "search-form", "gallery", "caption", "style", "script"));
    add_theme_support("responsive-embeds");
    add_theme_support("custom-spacing");
    add_theme_support("title-tag");
    add_theme_support("woocommerce");
    add_theme_support("post-thumbnails");
    $defaults = array(
        "height"      => 40,
        "width"       => 130,
        "flex-height" => true,
        "flex-width"  => true,
        "header-text" => array("site-title", "site-description"),
    );
    add_theme_support("custom-logo", $defaults);

    $args = array(
        "default-image"      => "",
        "default-text-color" => "000",
        "width"              => 1400,
        "height"             => 400,
        "flex-width"         => true,
        "flex-height"        => true,
    );

    add_theme_support("custom-header", $args);
    add_theme_support("wp-block-styles");
    add_theme_support("align-wide");
    add_theme_support("editor-styles");
}

add_action("after_setup_theme", "rad_theme_support");

/*-----------------------------------------------------------------------------------*/
/*  Define image sizes
/*-----------------------------------------------------------------------------------*/

rad_add_image_size_retina("post-thumbnail", 600, 600, true);
rad_add_image_size_retina("rad_thumbnail-auto-height", 400, 9999, false);
rad_add_image_size_retina("rad_standard-blog-detail", 1170, 540, true);

/*-----------------------------------------------------------------------------------*/
/*  Set content width
/*-----------------------------------------------------------------------------------*/
if (!isset($content_width)) {
    $content_width = 1200;
}
