<?php

add_action("customize_controls_print_footer_scripts", "rad_customizer_scripts");
add_action("wp_enqueue_scripts", "rad_high_priority_theme_styles", 0);
add_action("wp_enqueue_scripts", "rad_theme_scripts", 99); // use 99 to be the last added scripts
add_action("wp_print_styles", "rad_remove_styles");
add_action("wp_print_scripts", "rad_remove_scripts");

function rad_customizer_scripts()
{
    wp_enqueue_script("rado-customizer-script", RAD_THEME_INC_URI . "/admin/assets/js/admin-customizer.js", array("jquery"), "1.0.0", false);
}

function rad_high_priority_theme_styles()
{
    //google fonts
    rad_theme_fonts();

}

function rad_theme_scripts()
{

    // Suffix setup (debug mode loads un-minified scripts & styles)
    $suffix = ".min";
    $folder = "build/";
    if (defined("RAD_DEV_MODE") && RAD_DEV_MODE) {
        $suffix = "";
        $folder = "dev/";
    }

    /**************************************************
    Register styles
     **************************************************/
    //main style
    wp_register_style("rad-main-style", RAD_THEME_ASSETS_URI . "/css/" . $folder . "styles" . $suffix . ".css", false, RAD_THEME_VERSION);

    //woocommerce style
    wp_register_style("rad-woocommerce-style", RAD_THEME_ASSETS_URI . "/css/" . $folder . "woocommerce" . $suffix . ".css", false, RAD_THEME_VERSION);

    /**************************************************
    Add styles in project
     **************************************************/

    //Add overridden style
    ob_start();
    include rad_path_combine(RAD_THEME_CSS, "styles.php");

    if (function_exists("is_woocommerce")) {
        wp_add_inline_style("rad-woocommerce-style", ob_get_clean());
    } else {
        wp_add_inline_style("rad-main-style", ob_get_clean());
    }

    //main style
    wp_enqueue_style("rad-main-style");

    //woocommerce style
    if (function_exists("is_woocommerce")) {
        wp_enqueue_style("rad-woocommerce-style");
    }

    //responcive style
    wp_enqueue_style("rad-responsive-style", RAD_THEME_ASSETS_URI . "/css/" . $folder . "responsive" . $suffix . ".css", false, RAD_THEME_VERSION);

    // 3rd parties
    wp_enqueue_style("rad-libs-style", RAD_THEME_ASSETS_URI . "/css/build/libs.min.css", false, RAD_THEME_VERSION, "screen");

    // Media Element (use css file in core of WP)
    wp_enqueue_style("mediaelement");

    // all scripts
    wp_enqueue_script("rad-libs-script", RAD_THEME_ASSETS_URI . "/js/build/libs.min.js", false, RAD_THEME_VERSION, true);

    // RTL CSS
    if (is_rtl()) {
        wp_enqueue_style("rad-rtl-style", RAD_THEME_ASSETS_URI . "/css/" . $folder . "rtl" . $suffix . ".css", false, RAD_THEME_VERSION);
    }

    // Media Element (use media element.js in core of WP)
    wp_enqueue_script("mediaelement");

    //Custom Script
    wp_enqueue_script(
        "rad-main-script",
        RAD_THEME_ASSETS_URI . "/js/" . $folder . "scripts" . $suffix . ".js",
        false,
        RAD_THEME_VERSION,
        true
    );

    // Localize scripts.js with url of site
    wp_localize_script("rad-main-script", "rad_data",
        array(
            // site variables
            "home_url"         => esc_url(home_url("/")),
            "img"              => esc_url(RAD_THEME_IMAGES_URI),
            //ajax variables
            "ajax_url"         => esc_url(admin_url("admin-ajax.php")),
            "nonce"            => wp_create_nonce("ajax-nonce"),
            "loadmore"         => esc_html__("Load more", "aventa"),
            "cookie_notice"    => rad_get_option("cookies_notice"),
            "cookie_notice_id" => rad_get_option("cookies_notice_renewal"),
            "cookie_popup_id"  => rad_get_option("popup-newsletter-renewal"),
        )
    );

    wp_localize_script(
        "rad-main-script",
        "wc_single_product_params",
        array(
            "i18n_required_rating_text" => esc_html__("Please select a rating", "aventa"),
            "review_rating_required"    => get_option("woocommerce_review_rating_required"),
        )
    );

    if (is_singular() && comments_open() && get_option("thread_comments")) {
        wp_enqueue_script("comment-reply");
    }

    if(rad_is_wpbakery_frontend_editor())
    {
        // 3rd parties
        wp_enqueue_style("rad-wpbakery-frontend-style", RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery-frontend.css", false, RAD_THEME_VERSION, "screen");
    }
}

//Dequeue Styles
function rad_remove_styles()
{
    if (class_exists("Woocommerce")) {
        wp_dequeue_style("woocommerce_prettyPhoto_css");
    }

    if (class_exists("YITH_WCWL")) {
        wp_dequeue_style("yith-wcwl-font-awesome");
        wp_dequeue_style("jquery-selectBox");
    }

    if (class_exists("Size_Chart_For_Woocommerce")) {
        wp_dequeue_style("product-size-charts-plugin-for-woocommerce");
        wp_dequeue_style("product-size-charts-plugin-for-woocommerce-jquery-modal-default-theme");
    }

}

function rad_remove_scripts()
{
    global $wp_scripts;

    if (class_exists("Woocommerce")) {

        wp_dequeue_script("prettyPhoto");
        wp_dequeue_script("prettyPhoto-init");
        wp_dequeue_script("wc-single-product");
        wp_dequeue_script("vc_woocommerce-add-to-cart-js");

        if (class_exists("YITH_WCWL")) {
            wp_dequeue_script("jquery-selectBox");
            //Remove depencency of jquery-yith-wcwl to jquery-selectBox (use this way to keep jquery-yith-wcwl localizations)
            if (isset($wp_scripts->registered["jquery-yith-wcwl"]->deps[1]) && $wp_scripts->registered["jquery-yith-wcwl"]->deps[1] == "jquery-selectBox") {
                unset($wp_scripts->registered["jquery-yith-wcwl"]->deps[1]);
            }
        }

        if (class_exists("Size_Chart_For_Woocommerce")) {
            wp_dequeue_script("product-size-charts-plugin-for-woocommerce");
        }
    }

}

function rad_theme_fonts()
{

    $typekit_id       = rad_get_option("typekit-id");
    $font_collections = json_decode(rad_get_option("fonts-collection"), true);

    $customFonts = array();
    $googleFonts = array();
    $adobeFonts  = "";

    if (is_array($font_collections)) {
        foreach ($font_collections as $item) {

            if ($item["source"] == "custom") {
                $customFonts[$item["font"]] = $item["link"];
            } elseif ($item["source"] == "google") {
                $googleFonts[$item["font"]] = $item["weights"];

            } else // Adobe fonts
            {
                if ($item["embed"] = "css") {
                    $adobeFonts = "https://use.typekit.net/" . $typekit_id . ".css";
                }
            }
        }
    }

    foreach ($customFonts as $key => $value) {
        wp_enqueue_style("rad-c-fonts" . $key, $value);
    }

    //Set default font
    $body_font_spec    = rad_get_option("font-body");
    $nav_font_spec     = rad_get_option("font-navigation");
    $heading_font_spec = rad_get_option("font-headings");

    /* Check for old bug of saved options with wrong values */
    if ($body_font_spec == "default") {
        $body_font_spec = "theme_default";
    }

    if ($nav_font_spec == "default") {
        $nav_font_spec = "theme_default";
    }

    if ($heading_font_spec == "default") {
        $heading_font_spec = "theme_default";
    }

    if ($body_font_spec == "theme_default" || $nav_font_spec == "theme_default" || $heading_font_spec == "theme_default") {
        $googleFonts["DM Sans"] = "regular,500,700";
    }

    if (count($googleFonts) > 0) {
        $googleFontsURL = rad_make_google_font_url($googleFonts);
        wp_enqueue_style("rad-g-fonts", $googleFontsURL);
    }

    if ($adobeFonts != "") {
        wp_enqueue_style("rad-a-fonts", $adobeFonts);
    }

}
