<?php
$name     = $vars["key"];
$settings = $vars["settings"];
$label    = rad_array_value("label", $settings); //Optional value
$selected = $this->rad_GetValue($name);
$options  = $settings["options"];
$class    = rad_array_value("class", $settings); //Optional value
$default  = rad_array_value("default", $settings); //Optional value
?>
<div class="field imageSelect <?php echo esc_attr($class); ?>" data-name="<?php echo esc_attr($name); ?>">

	<?php if ($label != "") {?>
        <label for="field-<?php echo esc_attr($name); ?>"><?php echo esc_html($label); ?></label>
    <?php }?>

	<div class="imageList">
		<?php
foreach ($options as $key => $value) {
    $selectedClass = ($value == $selected) ? "selected" : "";
    $selectedClass .= ($value == $default && $default != "") ? " default" : "";
    ?>
			<a href="#" class="<?php echo esc_attr($value . " " . $selectedClass); ?>" style="background:url(<?php echo esc_url(RAD_THEME_INC_URI . "/admin/assets/img/icons/" . esc_html($name) . "/" . esc_html($value)); ?>.png)" data-val="<?php echo esc_attr($value); ?>"><?php echo esc_html($key); ?></a>
		<?php
}
?>
	</div>

    <input name="<?php echo esc_attr($name); ?>" type="text" value="<?php echo esc_attr($selected); ?>" />
</div>