<?php
$name     = $vars["key"];
$settings = $vars["settings"];
$class    = rad_array_value("class", $settings); //Optional value
$flags    = rad_array_value("flags", $settings); //Optional value
$label    = rad_array_value("label", $settings); //Optional value

//remove -{id} from end of name of filed[just used in admin menu page] becouse in that page we make names unique by adding -{id}
$generalKey = rtrim($name, "-" . get_the_ID());

$value = ((esc_attr($this->rad_GetValue($generalKey)) == "") && (rad_array_value("value", $settings) != "")) ? rad_array_value("value", $settings) : esc_attr($this->rad_GetValue($generalKey));

$icons      = rad_Icon_Manager::get_light_icons();
$icon_block = array();

foreach ($icons as $name => $svg) {
    $icon_block[] = "<span class=\"rad-icon-param\" data-type=\"light\" data-name=\"" . esc_attr($name) . "\">" . $svg . "</span>";
}

$icons = rad_Icon_Manager::get_solid_icons();

foreach ($icons as $name => $svg) {
    $icon_block[] = "<span class=\"rad-icon-param\" data-type=\"solid\" data-name=\"" . esc_attr($name) . "\">" . $svg . "</span>";
}

$icons = rad_Icon_Manager::get_brand_icons();

foreach ($icons as $name => $svg) {
    $icon_block[] = "<span class=\"rad-icon-param\" data-type=\"brand\" data-name=\"" . esc_attr($name) . "\">" . $svg . "</span>";
}

$vars["settings"]["label-class"] = "rad-no-float";
?>
<div class="rad-icon-param-field field" data-name="<?php echo esc_attr($name); ?>">
	<?php if ($label != "") {?>
	    <label for="field-<?php echo esc_attr($name); ?>"><?php echo esc_html($label); ?></label>
	<?php }?>
	<div class="rad-icon-param-container <?php echo esc_attr($class); ?>">
		<div class="rad-icon-params">
			<span class="close"></span>
	    <?php echo implode($icon_block); ?>
	    </div>
	    <span class="selected-icon icon<?php if ($value != "") {echo "-" . esc_attr($value);}?>" data-name="<?php echo esc_attr($value) ?>" title="<?php esc_attr_e("select an icon", "aventa");?>"></span>
	   	<span class="select-icon-text <?php if ($value != "") {echo "show";}?>"><?php esc_html_e("Select an icon", "aventa")?></span>
	    <input class="icon-filed" type="hidden" name="<?php echo esc_attr($name); ?>" data-flags="<?php echo esc_attr($flags); ?>" value="<?php echo esc_attr($value); ?>" />
	</div>
</div>