<?php
$name        = $vars["key"];
$settings    = $vars["settings"];
$label       = rad_array_value("label", $settings); //Optional value
$placeholder = rad_array_value("placeholder", $settings); //Optional value
$description = rad_array_value("description", $settings); //Optional value
$value       = $this->rad_GetValue($name);
?>
<script id="rad-typeface-tempalte" type="text/template">
  <div class="rad-typeface">
      <span class="rad-delete"></span>
      <input type="hidden" name="fonts" value="{fontname}"/>
      <input type="hidden" name="sources" value="{fontsource}"/>
      <input type="hidden" name="links" value="{fontlink}"/>
      <input type="hidden" name="embeds" value="{fontembed}"/>
      <input type="hidden" name="allweights" value="{allweights}"/>
      <div class="rad-typeface-preview"
           style="font-family:'{fontname}'">Typographgraphy is our power</div>
      <div class="rad-typeface-options">
          <span class="font-name">{fontname}</span>
          <span class="font-source">{fontsource}</span>
          <span class="font-weights">{fontweights}</span>
      </div>
  </div>
</script>
<div class="field fonts-input" data-name="<?php echo esc_attr($name); ?>">
	<label><?php echo esc_html($label); ?></label>
    <input type="hidden" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($value); ?>" />
	<?php

$items            = json_decode($value, true);
$typekitid        = rad_get_option("typekit-id");
$font_manager     = new rad_Fonts();
$googleFontNames  = $font_manager->get_google_fonts();
$typekitFontNames = $font_manager->get_typekit_fonts($typekitid);
?>
	<div class="rad-typeface lock">
      <input type="hidden" name="fonts" value="DM Sans">
      <input type="hidden" name="sources" value="google">
      <input type="hidden" name="links" value="">
      <input type="hidden" name="embeds" value="">
      <input type="hidden" name="allweights" value="regular,500,700">
      <span class="rad-badge"><?php esc_html_e("Theme default font", "aventa")?></span>
      <div class="rad-typeface-preview" style="font-family: 'DM Sans'">Typographgraphy is our power</div>
      <div class="rad-typeface-options">
          <span class="font-name">DM Sans</span>
          <span class="font-source">google</span>
          <span class="font-weights">
          	<input type="hidden" value="regular,500,700" class="fontweights" name="fontweights">
          	<span><input type="checkbox" value="regular" class="fontweightscheckbox" checked disabled>regular</span>
          	<span><input type="checkbox" value="500" class="fontweightscheckbox" checked disabled>500</span>
          	<span><input type="checkbox" value="700" class="fontweightscheckbox" checked disabled>700</span>
          </span>
      </div>
 	 </div>
	<?php
if (is_array($items)) {
    foreach ($items as $item) {
        if ($item["font"] == "DM Sans") {
            continue;
        }
        ?>
		  	<div class="rad-typeface">
				<span class="rad-delete"></span>
				<input type="hidden" name="fonts" value="<?php echo esc_attr($item["font"]) ?>"/>
				<input type="hidden" name="sources" value="<?php echo esc_attr($item["source"]) ?>"/>
				<input type="hidden" name="links" value="<?php echo esc_attr($item["link"]) ?>"/>
				<input type="hidden" name="embeds" value="<?php echo esc_attr($item["embed"]) ?>"/>
				<input type="hidden" name="allweights" value="<?php echo esc_attr($item["allweights"]) ?>"/>
				<div class="rad-typeface-preview"
				   style="font-family:'<?php echo esc_html($item["font"]) ?>'"><?php esc_html_e("Typographgraphy is our power", "aventa")?></div>
				<div class="rad-typeface-options">
				  <span class="font-name"><?php echo esc_html($item["font"]) ?></span>
				  <span class="font-source"><?php echo esc_html($item["source"]) ?></span>
				  <span class="font-weights"><?php esc_html_e("Font variants:", "aventa")?>
				      <br>
				      <input type="hidden" name="fontweights[]" class="fontweights" value="<?php echo esc_attr($item["weights"]); ?>">
				      <?php
$allweights    = explode(",", $item["allweights"]);
        $selectedFonts = explode(",", $item["weights"]);

        foreach ($allweights as $fontweight) {

            if (in_array($fontweight, $selectedFonts)) {
                echo "<span><input type=\"checkbox\" value=\"" . $fontweight . "\" class=\"fontweightscheckbox\" checked>" . $fontweight . "</span>";
            } else {
                echo "<span><input type=\"checkbox\" value=\"" . $fontweight . "\" class=\"fontweightscheckbox\">" . $fontweight . "</span>";
            }

        }

        ?>
				  	</span>
				</div>
		  </div>
		  <?php
}
}
?>
	<div class="rad-typeface-add">
	    <span class="rad-add"></span>
	    <div class="add-font-options">
	    	<label><?php esc_html_e("Select font source", "aventa")?></label>
			<select name="font-source" id="font-source">
			  	<option value="google"
			          selected="selected"><?php esc_html_e("Google fonts", "aventa")?></option>
			  	<option value="adobe"><?php esc_html_e("Adobe fonts", "aventa")?></option>
			  	<option value="custom"><?php esc_html_e("Custom font", "aventa")?></option>
			</select>
		    <span class="google-section">
			    <label><?php esc_html_e("Select the font", "aventa")?></label>
			    <select name="google-fonts" id="google-fonts">

			      <?php
foreach ($googleFontNames as $font) {
    $weights = implode(",", $font["variants"]);
    echo "<option value=\"" . $font["name"] . "\" data-weights=\"" . $weights . "\">" . $font["name"] . "</option>";
}
?>
			    </select>
		    </span>
		    <span class="custom-section">
		        <label><?php esc_html_e("Address of CSS file", "aventa")?></label>
		        <input type="text" id="css-file" name="css-file" value="" placeholder="CSS file address">
		        <label><?php esc_html_e("Font name", "aventa")?></label>
		        <input type="text" id="font-name" name="font-name" value=""
		               placeholder="<?php esc_attr_e("Font name", "aventa")?>">
		        <label><?php esc_html_e("Font variants", "aventa")?></label>
		        <input type="text" id="font-variants" name="font-variants" value=""
		               placeholder="<?php esc_attr_e("Font variants", "aventa")?>">
		        <p class="desc"><?php esc_html_e("seperated with comma", "aventa")?></p>
		    </span>
		    <span class="adobe-section">
			    <label><?php esc_html_e("Select the font", "aventa")?></label>
			    <select name="adobe-fonts" id="adobe-fonts">
			      <?php
foreach ($typekitFontNames as $key => $value) {
    $weights = $value["weights"];
    $weights = implode(",", $weights);
    echo "<option value=\"" . $key . "\" data-weights=\"" . $weights . "\">" . $key . "</option>";
}
?>
			    </select>
		        <label><?php esc_html_e("Embeding method", "aventa")?></label>
		        <select name="embeding-method" id="embeding-method">
		          <option value="css"
		                  selected="selected"><?php esc_html_e("CSS Link (Simplest)", "aventa")?></option>
		          <option value="js" disabled><?php esc_html_e("Javascript (Advanced)", "aventa")?></option>
		        </select>
		    </span>
		    <button class="add-button"><?php esc_html_e("Add font", "aventa")?></button>
		    <button class="cancel-button"><?php esc_html_e("Cancel", "aventa")?></button>
		</div>
	</div>
	<strong><?php echo esc_html($description); ?></strong>
</div>