<div id="rad-sidebar">
    <div id="rad-head">
        <div class="logo">
            <?php echo wp_kses($this->rad_GetImage("logo.jpg", RAD_THEME), array("img" => array("src" => array(), "class" => array(), "alt" => array()))); ?>
            <span class="version"><?php echo esc_html(RAD_THEME_VERSION); ?></span>
        </div>
    </div>
    <div id="rad-sidebar-accordion">
    <?php
    $tabGroups = $this->template["tab-groups"];
    $tabs      = $this->template["tabs"];
    $gcnt      = 1;

    foreach ($tabGroups as $groupKey => $group) {
        $tabsRef          = $group["tabs"];
        $activeGroupClass = $gcnt == 1 ? "class=\"active\"" : "";
        ?>
            <h3><a href="#<?php echo esc_url($group["text"]); ?>" <?php echo "" . $activeGroupClass; ?>><span class="dashicons <?php echo esc_attr($group["icon"]); ?>"></span><?php echo esc_html($group["text"]); ?></a></h3>
            <div>
                <ul class="rad-tab">
                <?php
                foreach ($tabsRef as $tabKey) {
                    $tab            = $tabs[$tabKey];
                    $tcnt           = 1;
                    $activeTabClass = $tcnt == 1 && $gcnt == 1 ? "class=\"active\"" : "";
                    //We know, in the following line esc_attr is used correctly! ?>
                    <li><a href="#<?php echo esc_attr($tab["panel"]); ?>" <?php echo "" . $activeTabClass; ?>>
                        <?php echo esc_html($tab["text"]); ?></a>
                    </li>
                    <?php
                    $tcnt++;
                }
                ?>
                </ul>
            </div>
        <?php
        $gcnt++;
    }
    ?>
    </div>
    <a class="documentation" rel="nofollow" href="<?php echo esc_url($this->template["document-url"]); ?>"><?php esc_html_e("Documentation", "aventa");?></a>
    <a class="support" rel="nofollow" href="<?php echo esc_url($this->template["support-url"]); ?>"><?php esc_html_e("Support", "aventa");?></a>
</div>