<?php

function rad_admin_get_defaults()
{
    static $values = array();

    if (count($values)) {
        return $values;
    }

    //Extract key-value pairs from settings
    $settings = rad_admin_get_form_settings();
    $panels   = $settings["panels"];

    foreach ($panels as $panel) {
        foreach ($panel["sections"] as $section) {
            foreach ($section["fields"] as $fieldKey => $field) {
                $values[$fieldKey] = rad_array_value("value", $field);
            }
        }
    }

    return $values;
}

function rad_admin_get_form_settings()
{
    static $settings = array(); //Cache the settings

    if (count($settings)) {
        return $settings;
    }

    $generalSettingsPanel = array(
        "title"    => esc_html__("General Settings", "aventa"),
        "sections" => array(
            "logo"         => array(
                "title"   => esc_html__("Logo", "aventa"),
                "tooltip" => esc_html__("Logo", "aventa"),
                "fields"  => array(
                    "logo" => array(
                        "type" => "label",
                        "desc" => esc_html__("You can upload 1 or 2 versions of logo (dark/light) through WP Admin menu > Appearence > customize > Site identity.", "aventa"),
                    ),
                ),
            ), // Menu types
            "favicon"      => array(
                "title"   => esc_html__("Custom Favicon", "aventa"),
                "tooltip" => esc_html__("Custom Favicon", "aventa"),
                "fields"  => array(
                    "logo" => array(
                        "type" => "label",
                        "desc" => esc_html__("You can upload your custom Fav icon through WP Admin menu > Appearence > customize > Site identity.", "aventa"),
                    ),
                ),
            ), // Menu types
            "retina_ready" => array(
                "title"   => esc_html__("Retina Ready", "aventa"),
                "tooltip" => esc_html__("You can enable or disable retina. notice that enabling this option generate more images", "aventa"),
                "fields"  => array(
                    "retina_ready" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ), //Enable/disable Retina Ready
            "go_up" => array(
                "title"   => esc_html__("Go-Up button", "aventa"),
                "tooltip" => esc_html__("You can enable or disable go-up button", "aventa"),
                "fields"  => array(
                    "go_up" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 0,
                        "default" => 1,
                    ),
                ),
            ), //Enable/disable go up button
        ),
    );

    // A fallback for older version of WP
    if (version_compare(get_bloginfo("version"), "4.5", "<")) {

        unset($generalSettingsPanel["sections"]["logo"]["fields"]["logo"]);
        $generalSettingsPanel["sections"]["logo"]["fields"]["main-logo-img"] = array(
            "type"    => "upload",
            "title"   => esc_html__("Upload main Logo", "aventa"),
            "label"   => esc_html__("Main version of Logo", "aventa"),
            "referer" => "rad-settings-logo",
        );
        $generalSettingsPanel["sections"]["logo"]["fields"]["second-logo-img"] = array(
            "type"    => "upload",
            "title"   => esc_html__("Upload second Logo", "aventa"),
            "label"   => esc_html__("Second version of Logo", "aventa"),
            "referer" => "rad-settings-logo",
        );
    }

    // A fallback for older version of WP
    if (version_compare(get_bloginfo("version"), "4.3", "<")) {
        $generalSettingsPanel["sections"]["favicon"] = array(
            "title"   => esc_html__("Custom Favicon", "aventa"),
            "label"   => esc_html__("Custom Favicon", "aventa"),
            "tooltip" => esc_html__("Specify custom favicon URL or upload a new one here.", "aventa"),
            "fields"  => array(
                "favicon" => array(
                    "type"    => "upload",
                    "title"   => esc_html__("Upload Favicon", "aventa"),
                    "label"   => esc_html__("Site Favicon", "aventa"),
                    "class"   => "favicon",
                    "referer" => "rad-settings-favicon",
                ),
            ),
        );
    }

    $appearancePanel = array(
        "title"    => esc_html__("Color Theme", "aventa"),
        "sections" => array(
            "accent-color"    => array(
                "title"   => esc_html__("Accent color for theme elements.", "aventa"),
                "tooltip" => esc_html__("Accent color for page elements", "aventa"),
                "fields"  => array(
                    "style-accent-color" => array(
                        "type"  => "color",
                        "label" => esc_html__("Choose", "aventa"),
                        "value" => "#000",
                    ),
                ),
            ), //accent-color sec
            "highlight-color" => array(
                "title"   => esc_html__("Highlight Color", "aventa"),
                "tooltip" => esc_html__("Color for highlighted elements", "aventa"),
                "fields"  => array(
                    "style-highlight-color" => array(
                        "type"  => "color",
                        "label" => esc_html__("Choose", "aventa"),
                        "value" => "#000",
                    ),
                ),
            ), //highlight-color sec
            "link-color"      => array(
                "title"   => esc_html__("Link Color", "aventa"),
                "tooltip" => esc_html__("Choose link or on-hover mode color.", "aventa"),
                "fields"  => array(
                    "style-link-color"       => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Normal Color", "aventa"),
                        "value" => "#000",
                    ),
                    "style-link-hover-color" => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("On-hover color", "aventa"),
                        "value" => "#777",
                    ),
                ),
            ), //link-color sec

        ),
    ); //$themeStylePanel

    $preloaderPanel = array(
        "title"    => esc_html__("Preloader", "aventa"),
        "sections" => array(
            "preloader-type"  => array(
                "title"   => esc_html__("preloader type", "aventa"),
                "tooltip" => esc_html__("Choose the type of preloader.", "aventa"),
                "fields"  => array(
                    "preloader-type" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("none", "aventa")    => "none",
                            esc_html__("logo", "aventa")    => "logo",
                            esc_html__("ripple1", "aventa") => "ripple1",
                            esc_html__("ripple2", "aventa") => "ripple2",
                            esc_html__("line", "aventa")    => "line",
                        ),
                        "class"   => "preloader-style",
                        "value"   => "ripple1",
                    ),
                ),
            ), //loader type Style
            "preloader_color" => array(
                "title"   => esc_html__("Preloader color", "aventa"),
                "tooltip" => esc_html__("Preloader colors", "aventa"),
                "fields"  => array(
                    "preloader_color"    => array(
                        "type"  => "color",
                        "class" => "preloader-color inline-field",
                        "label" => esc_html__("Color", "aventa"),
                        "value" => "#000",
                    ),
                    "preloader_bg_color" => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Background Color", "aventa"),
                        "value" => "#fff",
                    ),
                ),
            ),
            "preloader-logo"  => array(
                "title"   => esc_html__("Preloader Image", "aventa"),
                "tooltip" => esc_html__("Choose an image to appear in preloader. (PNG, GIF, JPG)", "aventa"),
                "fields"  => array(
                    "preloader-logo" => array(
                        "type"    => "upload",
                        "title"   => esc_html__("Upload preloader image", "aventa"),
                        "referer" => "rad-settings-preloader",
                    ),
                ),
            ),

        ),
    ); //$Pre loader Panel

    $PopupPanel = array(
        "title"    => esc_html__("Popup Newsletter", "aventa"),
        "sections" => array(
            "popup-newsletter"   => array(
                "title"   => esc_html__("Popup Newsletter", "aventa"),
                "tooltip" => esc_html__("This Newsletter will be shown to the visitors when they enter the site. You can enable or disable it.", "aventa"),
                "fields"  => array(
                    "popup-newsletter"                     => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                    "popup-newsletter-renewal"             => array(
                        "type"  => "random-key",
                        "title" => esc_html__("Cookie notice ID(a random string) to renewal showing cookie notice.", "aventa"),
                        "value" => "test",
                    ),
                    "popup-newsletter-renewal-description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Description", "aventa"),
                        "desc"  => esc_html__("If you want to renewal displaying popup for all users, just create a new ID.", "aventa"),
                    ),
                    "popup-nl-responsive"                  => array(
                        "type"    => "switch",
                        "label"   => esc_html__("Show it in responsive(Mobile devices)?", "aventa"),
                        "state0"  => esc_html__("No", "aventa"),
                        "state1"  => esc_html__("Yes", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ), //end popup newsletter display

            "popup-nl-title"     => array(
                "title"   => esc_html__("Popup Newsletter content", "aventa"),
                "tooltip" => esc_html__("Enter a title, Subtitle and description text.", "aventa"),
                "fields"  => array(
                    "popup-nl-title"    => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Title...", "aventa"),
                        "label"       => esc_html__("Title text", "aventa"),
                    ),
                    "popup-nl-subtitle" => array(
                        "type"        => "text",
                        "label"       => esc_html__("Subtitle text", "aventa"),
                        "placeholder" => esc_html__("Subtitle...", "aventa"),
                    ),
                    "popup-nl-text"     => array(
                        "type"  => "textarea",
                        "label" => esc_html__("Text", "aventa"),
                    ),
                    "popup-nl-img"      => array(
                        "type"    => "upload",
                        "label"   => esc_html__("Image", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                    "popup-nl-bg"       => array(
                        "type"    => "upload",
                        "label"   => esc_html__("Background Image", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                ),

            ), //popup newsletter title and subtitle
            "popup-nl-shortcode" => array(
                "title"   => esc_html__("Popup Newsletter Shortcode", "aventa"),
                "tooltip" => esc_html__("Add a newsletter shortcode in this box. You can create your desired form by MailPoet and then insert its shortcode here.", "aventa"),
                "fields"  => array(
                    "popup-nl-shortcode" => array(
                        "type"  => "text",
                        "label" => esc_html__("Newsletter Shortcode", "aventa"),
                    ),
                ),
            ),
        ),
    );

    $languagePanel = array(
        "title"    => esc_html__("language", "aventa"),
        "sections" => array(
            "topbar-language-link" => array(
                "title"   => esc_html__("Language Switcher", "aventa"),
                "tooltip" => esc_html__("This section lets you to add links to other languages of your website.", "aventa"),
                "fields"  => array(
                    "topbar-language-1"      => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Language", "aventa"),
                        "label"       => esc_html__("1st Language", "aventa"),
                    ),
                    "topbar-language-link-1" => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Link", "aventa"),
                        "label"       => esc_html__("1st Language URL", "aventa"),
                    ),
                    "topbar-language-2"      => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Language", "aventa"),
                        "label"       => esc_html__("2nd Language", "aventa"),
                    ),
                    "topbar-language-link-2" => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Link", "aventa"),
                        "label"       => esc_html__("2nd Language URL", "aventa"),
                    ),
                    "topbar-language-3"      => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Language", "aventa"),
                        "label"       => esc_html__("3rd Language", "aventa"),
                    ),
                    "topbar-language-link-3" => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Link", "aventa"),
                        "label"       => esc_html__("3rd Language URL", "aventa"),
                    ),
                ),
            ),
        ),
    );

    $topbarPanel = array(
        "title"    => esc_html__("Top Bar", "aventa"),
        "sections" => array(
            "topbar_display"        => array(
                "title"   => esc_html__("Enable top bar", "aventa"),
                "tooltip" => esc_html__("You can enable or disable the top bar here. Top bar is the bar that sticks to top of your page.", "aventa"),
                "fields"  => array(
                    "topbar_display" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ), //Enable Top bar
            "boxed_topbar"          => array(
                "title"   => esc_html__("Boxed Topbar", "aventa"),
                "tooltip" => esc_html__("You can choose the top bar to be boxed or full-width", "aventa"),
                "fields"  => array(
                    "boxed_topbar" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 0,
                    ),
                ),
            ), //Boxed tobbar
            "topbar_style"          => array(
                "title"   => esc_html__("Top bar style", "aventa"),
                "tooltip" => esc_html__("Top bar style", "aventa"),
                "fields"  => array(
                    "topbar_bg_color"     => array(
                        "type"  => "color",
                        "label" => esc_html__("Background Color", "aventa"),
                        "value" => "#1e1e1e",
                    ),
                    "topbar_border_color" => array(
                        "type"  => "color",
                        "class" => "topbar-border-color",
                        "label" => esc_html__("Border Color", "aventa"),
                        "value" => "rgba(238,238,238,0)",
                    ),
                    "topbar_style"        => array(
                        "type"    => "switch",
                        "state1"  => esc_html__("Light", "aventa"),
                        "state0"  => esc_html__("Dark", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ), //topbar background color
            "topbar_title"          => array(
                "title"   => esc_html__("Top bar title", "aventa"),
                "tooltip" => esc_html__("Insert bold title.", "aventa"),
                "fields"  => array(
                    "topbar_text" => array(
                        "type"        => "text",
                        "placeholder" => esc_html__("Add top bar text here", "aventa"),
                    ),
                ),
            ), // topbar Title
            "topbar-social-display" => array(
                "title"   => esc_html__("Top bar social icons", "aventa"),
                "tooltip" => esc_html__("You can enable or disable the top bar social icon here.", "aventa"),
                "fields"  => array(
                    "topbar-social-display" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Enable Top bar soicals icon
        ),
    ); //topbar Panel

    $fontNames                            = rad_get_fonts_collection("settings");
    $fontNamesForHeading                  = $fontNames;
    $fontNamesForHeading["theme_default"] = "Theme defaults ( google : DM Sans : 700 )";

    $cartPanel = array(
        "title"    => esc_html__("Cart", "aventa"),
        "sections" => array(
            "shop-enable-cart" => array(
                "title"   => esc_html__("Cart Button", "aventa"),
                "tooltip" => esc_html__("Enable or disable menu cart menu button", "aventa"),
                "fields"  => array(
                    "shop-enable-cart" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "cart_type"        => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("cart1", "aventa") => 1,
                            esc_html__("cart2", "aventa") => 2,
                            esc_html__("cart3", "aventa") => 3,
                        ),
                        "class"   => "cart_type",
                        "value"   => 3,
                    ),
                ),
            ),
        ),
    );

    $collectionPanel = array(
        "title"    => esc_html__("Collection", "aventa"),
        "sections" => array(
            "collection-aside" => array(
                "title"   => esc_html__("collection", "aventa"),
                "tooltip" => esc_html__("change color and background color of collection aside.", "aventa"),
                "fields"  => array(
                    "collection-logo"       => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Second logo", "aventa"),
                        "state1"  => esc_html__("Main logo", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "collection-text-color" => array(
                        "type"  => "color",
                        "label" => esc_html__("collection text color", "aventa"),
                        "value" => "#000",
                    ),
                    "collection-bg-color"   => array(
                        "type"  => "color",
                        "label" => esc_html__("collection background color", "aventa"),
                        "value" => "#fff",
                    ),
                ),
            ),
        ),
    );

    $hamburgerPanel = array(
        "title"    => esc_html__("Hamburger menu", "aventa"),
        "sections" => array(
            "hamburger-menu" => array(
                "title"   => esc_html__("Hamburger menu", "aventa"),
                "tooltip" => esc_html__("You can enable or disable hamburger menu here.", "aventa"),
                "fields"  => array(
                    "hamburger-logo"            => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Main logo", "aventa"),
                        "state1"  => esc_html__("Second logo", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "hamburger-menu-text-color" => array(
                        "type"  => "color",
                        "label" => esc_html__("Hamburger menu text color", "aventa"),
                        "value" => "#fff",
                    ),
                    "hamburger-menu-bg-color"   => array(
                        "type"  => "color",
                        "label" => esc_html__("Hamburger menu background color", "aventa"),
                        "value" => "#000",
                    ),
                    "hamburger-menu-text"       => array(
                        "type"  => "text",
                        "label" => esc_html__("Text over hamburger menu", "aventa"),
                    ),
                    "hamburger-menu-img"        => array(
                        "type"    => "upload",
                        "label"   => esc_html__("Upload image", "aventa"),
                        "referer" => "rad-hamburger-menu-image",
                    ),

                ),
            ),
        ),
    );

    $menuPanel = array(
        "title"    => esc_html__("Menu ", "aventa"),
        "sections" => array(
            "menu-align"              => array(
                "title"   => esc_html__("Menu alignment", "aventa"),
                "tooltip" => esc_html__("Select Menu alignment", "aventa"),
                "fields"  => array(
                    "menu-align" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("type-1", "aventa") => 1,
                            esc_html__("type-2", "aventa") => 2,
                            esc_html__("type-3", "aventa") => 3,
                        ),
                        "class"   => "menu-align",
                        "value"   => 1,
                    ),
                ),
            ), // Menu types
            "menu-style"              => array(
                "title"   => esc_html__("Menu style", "aventa"),
                "tooltip" => esc_html__("Select menu style with/without space on edges", "aventa"),
                "fields"  => array(
                    "menu-style" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("edge-with-space", "aventa") => "edge-with-space",
                            esc_html__("edge-no-space", "aventa")   => "edge-no-space",
                        ),
                        "class"   => "menu-style",
                        "value"   => "edge-with-space",
                    ),
                ),
            ), //Menu Style
            "menu-state"              => array(
                "title"   => esc_html__("Menu states", "aventa"),
                "tooltip" => esc_html__("Select type of menu states", "aventa"),
                "fields"  => array(
                    "menu-state" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("single-state", "aventa") => "single-state",
                            esc_html__("double-state", "aventa") => "double-state",
                        ),
                        "class"   => "menu-state",
                        "value"   => "single-state",
                    ),
                ),
            ), //Menu Style
            "initial-menu-color"      => array(
                "title"   => esc_html__("Initial state of Menu - styles", "aventa"),
                "tooltip" => esc_html__("Choose the color and set the opacity for initial menu.", "aventa"),
                "fields"  => array(
                    "menu-initial-state-logo"             => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Second logo", "aventa"),
                        "state1"  => esc_html__("Main logo", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "initial-menu-background-color"       => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Background Color", "aventa"),
                        "value" => "#ffffff",
                    ),
                    "initial-menu-text-color"             => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Text Color", "aventa"),
                        "value" => "#222",
                    ),
                    "initial-menu-border-color"           => array(
                        "type"  => "color",
                        "class" => "initial-border-color inline-field",
                        "label" => esc_html__("Border Color", "aventa"),
                        "value" => "#ffffff",
                    ),
                    "initial-shop-cart-text-color"        => array(
                        "type"  => "color",
                        "label" => esc_html__("Cart/Wishlist Text Color", "aventa"),
                        "value" => "#fdfdfd",
                    ),
                    "wc-category-menu-description"        => array(
                        "type"  => "label",
                        "title" => esc_html__("Initial state above WC Category header", "aventa"),
                        "desc"  => esc_html__("Set menu colors in WC category page!", "aventa"),
                    ),
                    "menu-wc-cat-initial-state-logo"      => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Second logo", "aventa"),
                        "state1"  => esc_html__("Main logo", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "initial-wc-cat-menu-text-color"      => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Text Color", "aventa"),
                        "value" => "#000000",
                    ),
                    "initial-wc-cat-shop-cart-text-color" => array(
                        "type"  => "color",
                        "label" => esc_html__("Cart/Wishlist Text Color", "aventa"),
                        "value" => "#fdfdfd",
                    ),
                ),
            ), //initial menu colors Sec
            "menu-color"              => array(
                "title"   => esc_html__("Second state of Menu - style", "aventa"),
                "tooltip" => esc_html__("Choose the color and set the opacity for menu.", "aventa"),
                "fields"  => array(
                    "menu-second-state-logo" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Second logo", "aventa"),
                        "state1"  => esc_html__("Main logo", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "menu-background-color"  => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Background Color", "aventa"),
                        "value" => "#ffffff",
                    ),
                    "menu-text-color"        => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Text Color", "aventa"),
                        "value" => "#222",
                    ),
                    "menu-border-color"      => array(
                        "type"  => "color",
                        "class" => "border-color inline-field",
                        "label" => esc_html__("Border Color", "aventa"),
                        "value" => "#ffffff",
                    ),
                    "shop-cart-text-color"   => array(
                        "type"  => "color",
                        "label" => esc_html__("Cart/Wishlist Text Color", "aventa"),
                        "value" => "#fdfdfd",
                    ),
                ),
            ), //menu colors Sec
            "mega-menu-container"     => array(
                "title"   => esc_html__("Megamenu style", "aventa"),
                "tooltip" => esc_html__("Select Megamenu style", "aventa"),
                "fields"  => array(
                    "mega-menu-container" => array(
                        "type"    => "switch",
                        "state1"  => esc_html__("Full Width", "aventa"),
                        "state0"  => esc_html__("Boxed", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ), //Menu in Container Or not
            "submenu-color"           => array(
                "title"   => esc_html__("Submenu Colors", "aventa"),
                "tooltip" => esc_html__("Choose the color and set the background for submenus.", "aventa"),
                "fields"  => array(
                    "submenu-background-color" => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Background Color", "aventa"),
                        "value" => "#fff",
                    ),
                    "submenu-text-color"       => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Text Color", "aventa"),
                        "value" => "#222",
                    ),
                ),
            ), //submenu colors Sec
            "menu-search"             => array(
                "title"   => esc_html__("Search Form", "aventa"),
                "tooltip" => esc_html__("Enable or disable search in the header. Choose an icon style for search.", "aventa"),
                "fields"  => array(
                    "menu-search"      => array(
                        "type"    => "switch",
                        "state1"  => esc_html__("Enable", "aventa"),
                        "state0"  => esc_html__("Disable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "search_post_type" => array(
                        "type"    => "select",
                        "title"   => esc_html__("Search post type", "aventa"),
                        "options" => array(
                            "product" => esc_html__("Product", "aventa"),
                            "post"    => esc_html__("Post", "aventa"),
                        ),
                        "default" => "product",
                    ),
                ),
            ), //menu Style
            "header-wishlist-display" => array(
                "title"   => esc_html__("Header wishlist", "aventa"),
                "tooltip" => esc_html__("You can enable or disable the wishlist here.", "aventa"),
                "fields"  => array(
                    "header-wishlist-display" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Enable Top bar soicals icon
            "shop-login-link"         => array(
                "title"   => esc_html__("Login/My-account link", "aventa"),
                "tooltip" => esc_html__("Display login/My-account link.", "aventa"),
                "fields"  => array(
                    "shop-login-link" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Shop login Link
            "menu_currency_switcher"  => array(
                "type"    => "text",
                "title"   => esc_html__("Currency Switcher", "aventa"),
                "tooltip" => esc_html__("add \"Currency Switcher shortcode\" to display in menu. shortcode is [woocs].", "aventa"),
                "fields"  => array(
                    "menu_currency_switcher" => array(
                        "type"        => "text",
                        "label"       => esc_html__("Currency Switcher shotcode", "aventa"),
                        "placeholder" => esc_html__("[woocs]", "aventa"),
                    ),
                ),

            ),
        ),
    ); //$menuPanel End
    $fontsPanel = array(
        "title"    => esc_html__("Fonts", "aventa"),
        "sections" => array(

            "fonts-collection" => array(
                "title"   => esc_html__("Fonts", "aventa"),
                "tooltip" => esc_html__("Choose collection of fonts to use in your website.", "aventa"),
                "fields"  => array(
                    "typekit-id"       => array(
                        "type"        => "text",
                        "label"       => esc_html__("Typekit id", "aventa"),
                        "placeholder" => "",
                    ),
                    "fonts-collection" => array(
                        "type"        => "fonts",
                        "label"       => esc_html__("Manage the included fonts", "aventa"),
                        "description" => esc_html__("Notice! To have better site speed use minimum font or font variants!", "aventa"),
                        "placeholder" => "",
                    ),
                ),
            ),

            "font-body"        => array(
                "title"   => esc_html__("Theme Main Fonts", "aventa"),
                "tooltip" => esc_html__("Select the font that you want to be used for most of theme elements.", "aventa"),
                "fields"  => array(
                    "font-body"       => array(
                        "type"    => "select",
                        "label"   => esc_html__("Main font", "aventa"),
                        "options" => $fontNames,
                        "value"   => "theme_default",
                    ),
                    "main-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("Main font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "font-headings"   => array(
                        "type"    => "select",
                        "label"   => esc_html__("Heading tags font: H1,H2,...,H6", "aventa"),
                        "options" => $fontNamesForHeading,
                        "value"   => "theme_default",
                    ),
                    "h1-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("H1 font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "h2-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("H2 font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "h3-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("H3 font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "h4-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("H4 font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "h5-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("H5 font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "h6-font-size"       => array(
                        "type"    => "text",
                        "label"   => esc_html__("H6 font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                    "font-navigation" => array(
                        "type"    => "select",
                        "label"   => esc_html__("Menu font", "aventa"),
                        "options" => $fontNames,
                        "value"   => "theme_default",
                    ),
                    "navigation-font-size" => array(
                        "type"    => "text",
                        "label"   => esc_html__("Menu font-size(px)", "aventa"),
                        "value"   => "",
                    ),
                ),
            ),
        ),

    ); //$fontsPanel

    $blogPanel = array(
        "title"    => esc_html__("Blog", "aventa"),
        "sections" => array(
            "blog-sidebar"    => array(
                "title"   => esc_html__("Blog - sidebar", "aventa"),
                "tooltip" => esc_html__("Here you can disable or choose the sidebar position of your blog.", "aventa"),
                "fields"  => array(
                    "blog-sidebar" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("no-sidebar", "aventa")   => "no-sidebar",
                            esc_html__("with-sidebar", "aventa") => "with-sidebar",
                        ),
                        "class"   => "blog-sidebar",
                        "value"   => "with-sidebar",
                    ),
                ),
            ),
            "post-author-box" => array(
                "title"   => esc_html__("Show author info box in post pages", "aventa"),
                "tooltip" => esc_html__("Enable/disable author informations in post page.", "aventa"),
                "fields"  => array(
                    "post-author-box" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Off", "aventa"),
                        "state1"  => esc_html__("On", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ),
        ),
    ); //$blogPanel

    $sidebarPanel = array(
        "title"    => esc_html__("Sidebar", "aventa"),
        "sections" => array(
            "custom-sidebar"        => array(
                "title"   => esc_html__("Custom Sidebar", "aventa"),
                "tooltip" => esc_html__(" Select a sidebar for your pages. You can customise each sidebar widget from widget panel.", "aventa"),
                "fields"  => array(
                    "custom_sidebars"             => array(
                        "type"        => "csv",
                        "placeholder" => esc_html__("Enter a sidebar name", "aventa"),
                    ),
                    "custom-sidebars-description" => array(
                        "type"  => "label",
                        "class" => "no-margin-field",
                        "title" => esc_html__("Create new sidebar: ", "aventa"),
                        "desc"  => esc_html__("Enter your new sidebar name and save the page, then youcan access this sidebar in every page.", "aventa"),
                    ),
                ),
            ), //custom-sidebar sec
            "sidebar-position"      => array(
                "title"   => esc_html__("Pages Sidebar Position", "aventa"),
                "tooltip" => esc_html__("Choose the default sidebar position for blog & those pages that have a sidebar.", "aventa"),
                "fields"  => array(
                    "sidebar-position" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("left-side", "aventa")  => 1,
                            esc_html__("right-side", "aventa") => 2,
                        ),
                        "class"   => "page-sidebar",
                        "value"   => 2,
                    ),
                ),
            ), //sidebar-position sec
            "shop-sidebar-position" => array(
                "title"   => esc_html__("Shop Sidebar Position", "aventa"),
                "tooltip" => esc_html__("Choose the default sidebar position in WooCommerce pages.", "aventa"),
                "fields"  => array(
                    "shop-sidebar-position" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("none", "aventa")       => 0,
                            esc_html__("left-side", "aventa")  => 1,
                            esc_html__("right-side", "aventa") => 2,
                        ),
                        "class"   => "shop-sidebar",
                        "value"   => 0,
                    ),
                ),
            ),
        ),
    ); //$sidebarPanel

    $CookieLawpanel = array(
        "title"    => esc_html__("Cookie notice", "aventa"),
        "sections" => array(
            "cookies_info"         => array(
                "title"   => esc_html__("Show cookies law notice", "aventa"),
                "tooltip" => esc_html__("Under EU privacy regulations, websites must make it clear to visitors what information about them is being stored. This specifically includes cookies. Turn on this option and user will see info box at the bottom of the page that your web-site is using cookies.", "aventa"),
                "fields"  => array(
                    "cookies_notice"                     => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Off", "aventa"),
                        "state1"  => esc_html__("On", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                    "cookies_notice_renewal"             => array(
                        "type"  => "random-key",
                        "title" => esc_html__("Cookie notice ID(a random string).", "aventa"),
                        "value" => "test",
                    ),
                    "cookies_notice_renewal_description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Description", "aventa"),
                        "desc"  => esc_html__("If you want to renewal displaying notices for all users, just create a new ID.", "aventa"),
                    ),

                ),
            ), //Enable/disable Cookie Law
            "cookies_text_message" => array(
                "title"   => esc_html__("Cookies box text message", "aventa"),
                "tooltip" => esc_html__("Write some information about cookies usage that will be shown in the bar. ", "aventa"),
                "fields"  => array(
                    "cookies_text_message" => array(
                        "type"  => "textarea",
                        "label" => esc_html__("cookies Popup text", "aventa"),
                        "value" => "We use cookies to improve your experience on our website. By browsing this website, you agree to use of cookies by this website.",
                    ),
                ),
            ), // cookies popup message
            "cookies_policy_page"  => array(
                "title"   => esc_html__("Cookies policy page", "aventa"),
                "tooltip" => esc_html__("Choose page that will contain detailed information about your cookies Policy", "aventa"),
                "fields"  => array(
                    "cookies_policy_page" => array(
                        "type"  => "selectpage",
                        "label" => esc_html__("cookies policy page", "aventa"),
                    ),
                ),
            ),
        ),
    ); //$Cookie Law

    $headerSettingsPanel = array(
        "title"    => esc_html__("Header", "aventa"),
        "sections" => array(
            "header" => array(
                "title"   => esc_html__("Page begins with", "aventa"),
                "tooltip" => esc_html__("You can manage header of pages in this section.", "aventa"),
                "fields"  => array(
                    "header-mode"           => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("header", "aventa")    => "1",
                            esc_html__("top-space", "aventa") => "2",
                            esc_html__("no-space", "aventa")  => "3",
                        ),
                        "class"   => "header-mode",
                        "value"   => "1",
                    ),
                    "header-description1"   => array(
                        "type"  => "label",
                        "class" => "no-margin-field",
                        "title" => esc_html__("Header", "aventa"),
                        "desc"  => esc_html__("All pages have a header at top.", "aventa"),
                    ),
                    "header-description2"   => array(
                        "type"  => "label",
                        "class" => "no-margin-field",
                        "title" => esc_html__("Top-space", "aventa"),
                        "desc"  => esc_html__("All pages are without header and the content starts right after menu.", "aventa"),
                    ),
                    "header-description3"   => array(
                        "type"  => "label",
                        "class" => "no-margin-field",
                        "title" => esc_html__("No-space", "aventa"),
                        "desc"  => esc_html__("All pages are without header and page content starts from top of page.", "aventa"),
                    ),
                    "header-alignment"      => array(
                        "type"    => "visual-select",
                        "options" => array("sides" => 1, "center" => 2),
                        "class"   => "category-align",
                        "value"   => 2,
                    ),
                    "header-bg"             => array(
                        "type"  => "color",
                        "label" => esc_html__("Default overlay color of header", "aventa"),
                        "value" => "rgba(0,0,0,0.03)",
                    ),
                    "header-text-color"     => array(
                        "type"  => "color",
                        "label" => esc_html__("Default Text color of header", "aventa"),
                        "value" => "rgba(0,0,0,1)",
                    ),
                    "header-bg-description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Default header image", "aventa"),
                        "desc"  => esc_html__("You can set default background-image through WP admin menu > Appearence > Customize > Header image.", "aventa"),
                    ),
                    "header-breadcrumb"     => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Breadcrumb", "aventa"),
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ),
        ),
    );

    $woocomerceSettingsPanel = array(
        "title"    => esc_html__("WooCommerce", "aventa"),
        "sections" => array(
            "shop-layout"           => array(
                "title"   => esc_html__("Layout", "aventa"),
                "tooltip" => esc_html__("Choose an layout for shop products in main shop page.", "aventa"),
                "fields"  => array(
                    "shop-layout"           => array(
                        "type"    => "visual-select", // pivot/spotlight/deluxe
                        "options" => array(
                            esc_html__("general", "aventa") => "general",
                            esc_html__("sticky", "aventa")  => "sticky",
                            esc_html__("scatter", "aventa") => "scatter",
                        ),
                        "class"   => "shop-layouts",
                        "value"   => "general",
                    ),
                    "shop-enable-fullwidth" => array(
                        "type"    => "switch",
                        "title"   => esc_html__("full-width or Boxed?", "aventa"),
                        "state0"  => esc_html__("Boxed", "aventa"),
                        "state1"  => esc_html__("full-width", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ), //shop product style
            "product-style"         => array(
                "title"   => esc_html__("Product hover style", "aventa"),
                "tooltip" => esc_html__("Choose a style for products in main hover.", "aventa"),
                "fields"  => array(
                    "product-style"                   => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("bt-hover", "aventa")     => "bt-hover",
                            esc_html__("qv-hover", "aventa")     => "qv-hover",
                            esc_html__("general", "aventa")      => "general",
                            esc_html__("creative", "aventa")     => "creative",
                            esc_html__("simple-hover", "aventa") => "simple-hover",
                        ),

                        "class"   => "shop-styles",
                        "value"   => "bt-hover",
                    ),
                    "quickview-cursor"                => array(
                        "type"    => "visual-select",
                        "label"   => esc_html__("Creative-style Cursor type", "aventa"),
                        "options" => array(
                            esc_html__("text", "aventa") => "text",
                            esc_html__("icon", "aventa") => "icon",
                        ),
                        "class"   => "qv-styles",
                        "value"   => "text",
                    ),
                    "product-hover-theme"             => array(
                        "type"    => "select",
                        "label"   => esc_html__("Color style", "aventa"),
                        "options" => array(
                            "dark"  => esc_html__("Dark", "aventa"),
                            "light" => esc_html__("Light", "aventa"),
                        ),
                        "class"   => "hover-style",
                        "value"   => "dark",
                    ),
                    "shop-entrance-animation"         => array(
                        "type"    => "select",
                        "label"   => esc_html__("Entrance animation", "aventa"),
                        "options" => array(
                            "fade-in"        => esc_html__("FadeIn", "aventa"),
                            "fade-in-bottom" => esc_html__("FadeIn From Bottom", "aventa"),
                            "fade-in-top"    => esc_html__("FadeIn From Top", "aventa"),
                            "fade-in-right"  => esc_html__("FadeIn From Right", "aventa"),
                            "fade-in-left"   => esc_html__("FadeIn From Left", "aventa"),
                            "none"           => esc_html__("No animation", "aventa"),
                        ),
                        "value"   => "fade-in-bottom",
                    ),
                    "shop-gutter"                     => array(
                        "type"    => "switch",
                        "class"   => "no-on-off",
                        "title"   => esc_html__("Gutter between products", "aventa"),
                        "state0"  => esc_html__("1 unit guttter", "aventa"),
                        "state1"  => esc_html__("2 unit gutter", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                    "shop-product-rating"             => array(
                        "type"    => "switch",
                        "title"   => esc_html__("show rating on shop page?", "aventa"),
                        "state0"  => esc_html__("Hide rating", "aventa"),
                        "state1"  => esc_html__("Show rating", "aventa"),
                        "value"   => 0,
                        "class"   => "product_rating",
                        "default" => 0,
                    ),
                    "product-badges"                  => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Product badges", "aventa"),
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "percentage_sale"                 => array(
                        "type"   => "switch",
                        "title"  => esc_html__("Type of ON-SALE badge", "aventa"),
                        "state0" => esc_html__("Normal", "aventa"),
                        "state1" => esc_html__("Percentage", "aventa"),
                        "value"  => 0,
                    ),
                    "product-hover-image"             => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Show second hover image of product?", "aventa"),
                        "state0"  => esc_html__("Hide", "aventa"),
                        "state1"  => esc_html__("Show", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "product-hover-image-description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Notice!", "aventa"),
                        "desc"  => esc_html__("It uses the first image of gallery. It works with best performance and do not affect on page loading time!", "aventa"),
                    ),
                ),
            ),
            "products-per-page"     => array(
                "title"   => esc_html__("Products per page", "aventa"),
                "tooltip" => esc_html__("Choose the number of products on shop pages.", "aventa"),
                "fields"  => array(
                    "products-per-page" => array(
                        "type"    => "select",
                        "label"   => esc_html__("Products Per Page", "aventa"),
                        "options" => array(
                            "1"  => "1",
                            "2"  => "2",
                            "3"  => "3",
                            "4"  => "4",
                            "5"  => "5",
                            "6"  => "6",
                            "7"  => "7",
                            "8"  => "8",
                            "9"  => "9",
                            "10" => "10",
                            "11" => "11",
                            "12" => "12",
                            "13" => "13",
                            "14" => "14",
                            "15" => "15",
                            "16" => "16",
                            "17" => "17",
                            "18" => "18",
                            "19" => "19",
                            "20" => "20",
                            "21" => "21",
                            "22" => "22",
                            "23" => "23",
                            "24" => "24",
                            "25" => "25",
                            "26" => "26",
                            "27" => "27",
                            "28" => "28",
                            "29" => "29",
                            "30" => "30",
                            "31" => "31",
                            "32" => "32",
                            "33" => "33",
                            "34" => "34",
                            "35" => "35",
                            "36" => "36",
                            "37" => "37",
                            "38" => "38",
                            "39" => "39",
                            "40" => "40",
                        ),
                        "value"   => "12",
                    ),
                ),
            ), //shop columns
            "shop-column"           => array(
                "title"   => esc_html__("Woocommerce Columns Number", "aventa"),
                "tooltip" => esc_html__("Choose the number of products in a row on WooCommerce shop page.", "aventa"),
                "fields"  => array(
                    "shop-column"            => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("six", "aventa")   => 6,
                            esc_html__("five", "aventa")  => 5,
                            esc_html__("four", "aventa")  => 4,
                            esc_html__("three", "aventa") => 3,
                            esc_html__("two", "aventa")   => 2,
                        ),
                        "class"   => "shop-columns",
                        "value"   => 4,
                    ),
                    "shop-column-responsive" => array(
                        "type"    => "select",
                        "label"   => esc_html__("shop columns in mobile", "aventa"),
                        "options" => array(
                            "1" => "1",
                            "2" => "2",
                        ),
                        "value"   => "1",
                    ),
                ),
            ), //shop layout
            "shop-page-pagination"  => array(
                "title"   => esc_html__("Products Pagination", "aventa"),
                "tooltip" => esc_html__("Choose a type for the pagination on the shop page.", "aventa"),
                "fields"  => array(
                    "products-pagination" => array(
                        "type"    => "select",
                        "label"   => esc_html__("Products Pagination Type", "aventa"),
                        "options" => array(
                            "pagination"      => esc_html__("Normal Pagination", "aventa"),
                            "ajax_pagination" => esc_html__("Ajax Pagination", "aventa"),
                            "load_more"       => esc_html__("Load More Button", "aventa"),
                            "infinite_scroll" => esc_html__("Infinite Scroll", "aventa"),
                        ),
                        "value"   => "ajax_pagination",
                    ),
                ),
            ), //products pagination
            "shop-filter"           => array(
                "title"   => esc_html__("Shop Filter", "aventa"),
                "tooltip" => esc_html__("Enable filter for shop page, please pay attention that you can add on sale,in stock filters at the bottom of filter area by the following options.", "aventa"),
                "fields"  => array(
                    "shop-filter"                  => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "shop-filter-sticky"           => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Non-Sticky filter", "aventa"),
                        "state1"  => esc_html__("Sticky filter", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "shop-filter-on-sale"          => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Hide \"on sale\" filter", "aventa"),
                        "state1"  => esc_html__("Show  \"on sale\" filter", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "shop-filter-in-stock"         => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Hide \"in stock\" filter", "aventa"),
                        "state1"  => esc_html__("Show \"in stock\" filter", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                )
            ),
            "shop-top-categories" => array(
                "title"   => esc_html__("Shop page - top categories", "aventa"),
                "tooltip" => esc_html__("Enable/Disable showing categories above shop grid in shop page.", "aventa"),
                "fields"  => array(
                    "shop-filter-categories"       => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Hide categories", "aventa"),
                        "state1"  => esc_html__("Show categories", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "shop-filter-categories-style" => array(
                        "type"    => "select",
                        "label"   => esc_html__("Categories style", "aventa"),
                        "options" => array(
                            "simple"   => esc_html__("Simple", "aventa"),
                            "dropdown" => esc_html__("Dropdown", "aventa"),
                        ),
                        "value"   => "simple",
                    ),
                ),
            ),
            "shop-ordering"         => array(
                "title"   => esc_html__("Ordering", "aventa"),
                "tooltip" => esc_html__("Enable or disable default ordering", "aventa"),
                "fields"  => array(
                    "shop-ordering" => array(
                        "type"    => "switch",
                        "class"   => "shop-ordering-field",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ),
            "shop-result-count"     => array(
                "title"   => esc_html__("Display result count", "aventa"),
                "tooltip" => esc_html__("Enable or disable showing count of results", "aventa"),
                "fields"  => array(
                    "shop-result-count" => array(
                        "type"    => "switch",
                        "class"   => "shop-result-count-field",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Catalog Mode

            "catalog_mode"          => array(
                "title"   => esc_html__("Catalog Mode", "aventa"),
                "tooltip" => esc_html__("Enable/disable Catalog mode of your shop(Hide add to cart, disable cart and Checkout pages)", "aventa"),
                "fields"  => array(
                    "catalog_mode"       => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                    "catalog_mode_price" => array(
                        "type"   => "switch",
                        "state0" => esc_html__("Show Price", "aventa"),
                        "state1" => esc_html__("Hide Price", "aventa"),
                        "value"  => 1,
                    ),
                ),

            ), //Enable or Disable default ordering
            "shop-enable-quickview" => array(
                "title"   => esc_html__("Quick-view", "aventa"),
                "tooltip" => esc_html__("Enable or disable quick view", "aventa"),
                "fields"  => array(
                    "shop-enable-quickview" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Enable or Disable Quickview
            "product-wishlist"      => array(
                "title"   => esc_html__("Wishlist button", "aventa"),
                "tooltip" => esc_html__("Enable or disable Wishlist button", "aventa"),
                "fields"  => array(
                    "product-wishlist" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Enable or Disable wishlist button
        ),
    ); //woocomerce Settings Panel

    $shop_cat_panel = array(
        "title"    => esc_html__("Category", "aventa"),
        "sections" => array(
            "wc-header"  => array(
                "title"   => esc_html__("Woocommerce Categories in header", "aventa"),
                "tooltip" => esc_html__("You can manage the categories with these options", "aventa"),
                "fields"  => array(
                    "wc-header-category"        => array(
                        "type"    => "select",
                        "label"   => esc_html__("Header in Categories page", "aventa"),
                        "options" => array(
                            "disable"       => esc_html__("Hide header", "aventa"),
                            "simple-header" => esc_html__("Header without top categories", "aventa"),
                            "toggle"        => esc_html__("Header with toggle top categories", "aventa"),
                            "simple"        => esc_html__("Header with list of top categories", "aventa"),
                        ),
                        "class"   => "category-align",
                        "value"   => "simple-header",
                    ),
                    "wc-header-category-images" => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Display categories thumbnail images?", "aventa"),
                        "state0"  => esc_html__("No", "aventa"),
                        "state1"  => esc_html__("Yes", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ),
            "categories" => array(
                "title"   => esc_html__("Woocommerce Categories in shop grid", "aventa"),
                "tooltip" => esc_html__("You can manage the style of categories with this option", "aventa"),
                "fields"  => array(
                    "wc-category-style"             => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("hover", "aventa")   => 1,
                            esc_html__("general", "aventa") => 2,
                        ),
                        "class"   => "shop-cat-style",
                        "value"   => 1,
                    ),
                    "wc-category-style-description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Notice!", "aventa"),
                        "desc"  => esc_html__("This option is based on WC configuration and works when shop loads categories alongside products!", "aventa"),
                    ),
                    "wc-category-hover-color"       => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("overlay Color", "aventa"),
                        "value" => "rgba(0,0,0,1)",
                    ),
                    "wc-category-text-color"        => array(
                        "type"  => "color",
                        "class" => "inline-field",
                        "label" => esc_html__("Text Color", "aventa"),
                        "value" => "rgba(255,255,255,1)",
                    ),
                    "wc-category-number"            => array(
                        "type"    => "switch",
                        "label"   => esc_html__("Display the number of products", "aventa"),
                        "state0"  => esc_html__("Hide", "aventa"),
                        "state1"  => esc_html__("Show", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "wc-category-description"       => array(
                        "type"    => "switch",
                        "label"   => esc_html__("Display the description of products", "aventa"),
                        "state0"  => esc_html__("Hide", "aventa"),
                        "state1"  => esc_html__("Show", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ),
        ),
    ); //woocomerce Settings Panel

    $productDetailSettingsPanel = array(
        "title"    => esc_html__("Single product page", "aventa"),
        "sections" => array(
            "product-gallery-style" => array(
                "title"   => esc_html__("Product gallery style", "aventa"),
                "tooltip" => esc_html__("Choose product gallery style", "aventa"),
                "fields"  => array(
                    "product-gallery-style" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("carousel", "aventa") => "carousel",
                            esc_html__("vartical", "aventa") => "vartical",
                            esc_html__("classic", "aventa")  => "classic",
                            esc_html__("creative", "aventa") => "creative",
                            esc_html__("fitgrid", "aventa")  => "fitgrid",
                            esc_html__("massonry", "aventa") => "massonry",
                        ),
                        "class"   => "product-detail",
                        "value"   => "classic",
                    ),
                ),
            ), //Product detail bg color
            "product-tab-position"  => array(
                "title"   => esc_html__("Product tab position", "aventa"),
                "tooltip" => esc_html__("Choose product tab position", "aventa"),
                "fields"  => array(
                    "product-tab-position" => array(
                        "type"    => "visual-select",
                        "options" => array(
                            esc_html__("default", "aventa")            => "default",
                            esc_html__("before-add-to-cart", "aventa") => "before-add-to-cart",
                            esc_html__("after-add-to-cart", "aventa")  => "after-add-to-cart",
                        ),
                        "class"   => "product-tab-position",
                        "value"   => "default",
                    ),
                ),
            ), //Product detail bg color
            "product_breadcrumb"    => array(
                "title"   => esc_html__("product breadcrumb in Product details", "aventa"),
                "tooltip" => esc_html__("Enable/Disable this option to show breadcrunb in Product details", "aventa"),
                "fields"  => array(
                    "product_breadcrumb" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //product gallery
            "attribute_label"        => array(
                "title"   => esc_html__("Attribute label in Product single page", "aventa"),
                "tooltip" => esc_html__("Enable/Disable this option to show attribute label", "aventa"),
                "fields"  => array(
                    "attribute_label" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), "product_navigation"       => array(
                "title"   => esc_html__("product navigation in Product details", "aventa"),
                "tooltip" => esc_html__("Enable/Disable this option to next/pervious products in Product details", "aventa"),
                "fields"  => array(
                    "product_navigation" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ),
            "product_gallery_popup" => array(
                "title"   => esc_html__("Product gallery popup( Zoom )", "aventa"),
                "tooltip" => esc_html__("Enable or disable product gallery popup on product detail pages", "aventa"),
                "fields"  => array(
                    "product_gallery_popup" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                    "product_gallery_style" => array(
                        "type"   => "switch",
                        "class"  => "no-on-off",
                        "state0" => esc_html__("Light Cursor", "aventa"),
                        "state1" => esc_html__("Dark Cursor", "aventa"),
                        "value"  => 0,
                    ),
                ),
            ), "product_gallery_autoplay" => array(
                "title"   => esc_html__("product gallery autoplay", "aventa"),
                "tooltip" => esc_html__("Enable or disable product gallery autoplay on product detail pages", "aventa"),
                "fields"  => array(
                    "product_gallery_autoplay" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                ),
            ), //Product Gallery Autoplay
            //Enable or Disable related products
            "related_product"       => array(
                "title"   => esc_html__("Related products", "aventa"),
                "tooltip" => esc_html__("Enable or disable related products on product page", "aventa"),
                "fields"  => array(
                    "related_product"         => array(
                        "type"   => "switch",
                        "state0" => esc_html__("Disabled", "aventa"),
                        "state1" => esc_html__("Enabled", "aventa"),
                        "value"  => 1,
                    ),
                    "related_product_display" => array(
                        "type"   => "switch",
                        "state0" => esc_html__("Carousel mode", "aventa"),
                        "state1" => esc_html__("Grid mode", "aventa"),
                        "value"  => 1,
                    ),
                    "related_product_width"   => array(
                        "type"   => "switch",
                        "state0" => esc_html__("Full width", "aventa"),
                        "state1" => esc_html__("Container", "aventa"),
                        "value"  => 1,
                    ),
                ),
            ),
            "sticky_add_to_cart"    => array(
                "title"   => esc_html__("Sticky add to Cart", "aventa"),
                "tooltip" => esc_html__("Enable or disable Sticky add to cart button. It will be displayed after scrolling to bottom of page to have better accessibility", "aventa"),
                "fields"  => array(
                    "sticky_add_to_cart" => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disabled", "aventa"),
                        "state1"  => esc_html__("Enabled", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                ),
            ),
        ),
    ); //woocomerce Settings Panel

    $maintenanceSettingsPanel = array(
        "title"    => esc_html__("Maintenance Settings", "aventa"),
        "sections" => array(
            "maintenance" => array(
                "title"   => esc_html__("Maintenance mode", "aventa"),
                "tooltip" => esc_html__("If it is enabled, no one see frontend of the website. You should create a maintenance page and select it in the next option.", "aventa"),
                "fields"  => array(
                    "maintenance_mode"             => array(
                        "type"    => "switch",
                        "state0"  => esc_html__("Disable", "aventa"),
                        "state1"  => esc_html__("Enable", "aventa"),
                        "value"   => 0,
                        "default" => 0,
                    ),
                    "maintenance_page"             => array(
                        "label"       => esc_html__("Maintenance page", "aventa"),
                        "type"        => "selectpage",
                        "default"     => 1,
                        "maintenance" => 1,
                    ),
                    "maintenance_page-description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Notice!", "aventa"),
                        "desc"  => esc_html__("First, Create a page with maintenance template and then select it here!", "aventa"),
                    ),
                ),
            ),
        ),
    ); //maintenance Settings Panel
    $socialShareSettingsPanel = array(
        "title"    => esc_html__("Social share", "aventa"),
        "sections" => array(
            "share_buttons" => array(
                "title"   => esc_html__("Social Share buttons", "aventa"),
                "tooltip" => esc_html__("Enable/disable Social share buttons on products or posts. This setting could be overrided in each products or posts", "aventa"),
                "fields"  => array(
                    "social_share_display"   => array(
                        "type"   => "switch",
                        "label"  => esc_html__("Social Share Buttons", "aventa"),
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 1,
                    ),
                    "social_share_facebook"  => array(
                        "type"   => "switch",
                        "label"  => esc_html__("Facebook", "aventa"),
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 1,
                    ),
                    "social_share_google"    => array(
                        "type"   => "switch",
                        "label"  => esc_html__("Google+", "aventa"),
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 1,
                    ),
                    "social_share_mail"      => array(
                        "type"   => "switch",
                        "label"  => esc_html__("Email", "aventa"),
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 1,
                    ),
                    "social_share_twitter"   => array(
                        "type"   => "switch",
                        "label"  => esc_html__("Twitter", "aventa"),
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 1,
                    ),
                    "social_share_pinterest" => array(
                        "type"   => "switch",
                        "label"  => esc_html__("Pinterest", "aventa"),
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 1,
                    ),
                ),
            ),
        ),
    );

    $socialSettingsPanel = array(
        "title"    => esc_html__("Social medias", "aventa"),
        "sections" => array(
            "rss"           => array(
                "title"   => esc_html__("RSS", "aventa"),
                "tooltip" => esc_html__("RSS", "aventa"),
                "fields"  => array(
                    "rss"            => array(
                        "type"   => "switch",
                        "state0" => esc_html__("Off", "aventa"),
                        "state1" => esc_html__("On", "aventa"),
                        "value"  => 0,
                    ),
                    "social_rss_url" => array(
                        "type"  => "text",
                        "label" => esc_html__("RSS Feed", "aventa"),
                        "value" => get_bloginfo("rss2_url"),
                    ),
                ),
            ),
            "socials"       => array(
                "title"   => esc_html__("Social Network URLs", "aventa"),
                "tooltip" => esc_html__("Enter your social network addresses in respective fields. You can clear fields to hide icons from the website", "aventa"),
                "fields"  => array(
                    "social_instagram_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("Instagram", "aventa"),
                    ), //Instagram
                    "social_facebook_url"    => array(
                        "type"  => "text",
                        "label" => esc_html__("Facebook", "aventa"),
                    ), //Facebook
                    "social_twitter_url"     => array(
                        "type"  => "text",
                        "label" => esc_html__("Twitter", "aventa"),
                    ), //twitter
                    "social_vimeo_url"       => array(
                        "type"  => "text",
                        "label" => esc_html__("Vimeo", "aventa"),
                    ), //vimeo
                    "social_youtube_url"     => array(
                        "type"  => "text",
                        "label" => esc_html__("YouTube", "aventa"),
                    ), //youtube
                    "social_linkedin_url"    => array(
                        "type"  => "text",
                        "label" => esc_html__("LinkedIn", "aventa"),
                    ), //LinkedIn
                    "social_paypal_url"      => array(
                        "type"  => "text",
                        "label" => esc_html__("PayPal", "aventa"),
                    ), //Paypal
                    "social_googleplus_url"  => array(
                        "type"  => "text",
                        "label" => esc_html__("Google+", "aventa"),
                    ), //Google+
                    "social_dribbble_url"    => array(
                        "type"  => "text",
                        "label" => esc_html__("Dribbble", "aventa"),
                    ), //dribbble
                    "social_tumblr_url"      => array(
                        "type"  => "text",
                        "label" => esc_html__("Tumblr", "aventa"),
                    ), //Tumblr
                    "social_flickr_url"      => array(
                        "type"  => "text",
                        "label" => esc_html__("Flickr", "aventa"),
                    ), //flickr
                    "social_github_url"      => array(
                        "type"  => "text",
                        "label" => esc_html__("GitHub", "aventa"),
                    ), //GitHub
                    "social_lastfm_url"      => array(
                        "type"  => "text",
                        "label" => esc_html__("Last.fm", "aventa"),
                    ), //Last.fm
                    "social_skype_url"       => array(
                        "type"  => "text",
                        "label" => esc_html__("Skype", "aventa"),
                    ), //skype
                    "social_wordpress_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("WordPress", "aventa"),
                    ), //WordPress
                    "social_yahoo_url"       => array(
                        "type"  => "text",
                        "label" => esc_html__("Yahoo", "aventa"),
                    ), //yahoo
                    "social_deviantart_url"  => array(
                        "type"  => "text",
                        "label" => esc_html__("DeviantART", "aventa"),
                    ), //DeviantArt
                    "social_steam_url"       => array(
                        "type"  => "text",
                        "label" => esc_html__("Steam", "aventa"),
                    ), //Steam
                    "social_reddit_url"      => array(
                        "type"  => "text",
                        "label" => esc_html__("Reddit", "aventa"),
                    ), //reddit
                    "social_stumbleupon_url" => array(
                        "type"  => "text",
                        "label" => esc_html__("StumbleUpon", "aventa"),
                    ), //StumbleUpon
                    "social_pinterest_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("Pinterest", "aventa"),
                    ), //Pinterest
                    "social_xing_url"        => array(
                        "type"  => "text",
                        "label" => esc_html__("Xing", "aventa"),
                    ), //XING
                    "social_blogger_url"     => array(
                        "type"  => "text",
                        "label" => esc_html__("Blogger", "aventa"),
                    ), //Blogger
                    "social_soundcloud_url"  => array(
                        "type"  => "text",
                        "label" => esc_html__("SoundCloud", "aventa"),
                    ), //SoundCloud
                    "social_delicious_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("Delicious", "aventa"),
                    ), //delicious
                    "social_foursquare_url"  => array(
                        "type"  => "text",
                        "label" => esc_html__("Foursquare", "aventa"),
                    ), //Foursquare
                    "social_behance_url"     => array(
                        "type"  => "text",
                        "label" => esc_html__("Behance", "aventa"),
                    ), //Instagram
                ),
            ), //Social links
            "customSocial1" => array(
                "title"   => esc_html__("First custom social network", "aventa"),
                "tooltip" => esc_html__("Enter the social network that was not listed. The best size for image is 25x25 pixels. ", "aventa"),
                "fields"  => array(
                    "social_custom1_title" => array(
                        "title" => esc_html__("Title", "aventa"),
                        "type"  => "text",
                        "label" => esc_html__("Name", "aventa"),
                    ),
                    "social_custom1_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("URL", "aventa"),
                    ),
                    "social_custom1_image" => array(
                        "type"    => "upload",
                        "label"   => esc_html__("Icon Image", "aventa"),
                        "title"   => esc_html__("Upload icon image", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                ),
            ), //custom Social Links
            "customSocial2" => array(
                "title"   => esc_html__("Second custom social network", "aventa"),
                "tooltip" => esc_html__("Enter the social network that was not listed. The best size for image is 25x25 pixels. ", "aventa"),
                "fields"  => array(
                    "social_custom2_title" => array(
                        "title" => esc_html__("Title", "aventa"),
                        "type"  => "text",
                        "label" => esc_html__("Name", "aventa"),
                    ),
                    "social_custom2_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("URL", "aventa"),
                    ),
                    "social_custom2_image" => array(
                        "type"    => "upload",
                        "label"   => esc_html__("icon Image", "aventa"),
                        "title"   => esc_html__("Upload icon image", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                ),
            ), //custom Social Links
            "customSocial3" => array(
                "title"   => esc_html__("Second custom social network", "aventa"),
                "tooltip" => esc_html__("Enter the social network that was not listed. The best size for image is 25x25 pixels. ", "aventa"),
                "fields"  => array(
                    "social_custom3_title" => array(
                        "title" => esc_html__("Title", "aventa"),
                        "type"  => "text",
                        "label" => esc_html__("Name", "aventa"),
                    ),
                    "social_custom3_url"   => array(
                        "type"  => "text",
                        "label" => esc_html__("URL", "aventa"),
                    ),
                    "social_custom3_image" => array(
                        "type"    => "upload",
                        "label"   => esc_html__("Icon Image", "aventa"),
                        "title"   => esc_html__("Upload icon image", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                ),
            ), //custom Social Links
        ),
    );

    $footerSettingsPanel = array(
        "title"    => esc_html__("Footer Settings", "aventa"),
        "sections" => array(
            "footer_title" => array(
                "title"   => esc_html__("Footer", "aventa"),
                "tooltip" => esc_html__("Change footer style and options. ", "aventa"),
                "fields"  => array(
                    "footer-type"             => array(
                        "type"    => "visual-select",
                        "options" => array("1" => 1, "2" => 2, "3" => 3, "4" => 4, "5" => 5),
                        "class"   => "footer-types",
                        "value"   => 1,
                    ),
                    "footer-type-description" => array(
                        "type"  => "label",
                        "title" => esc_html__("Notice!", "aventa"),
                        "desc"  => esc_html__("Type1 has 3 widgetbars, Type 2 has 2 widgetbars and the other types have just 1 widgetbar", "aventa"),
                    ),
                    "footer-newsletter"       => array(
                        "type"  => "text",
                        "label" => esc_html__("Newsletter shortcode", "aventa"),
                        "value" => "",
                    ),
                    "footer-description"      => array(
                        "type"  => "textarea",
                        "label" => esc_html__("Description", "aventa"),
                        "value" => "",
                    ),
                    "footer-copyright"        => array(
                        "type"  => "text",
                        "label" => esc_html__("Copyright Text", "aventa"),
                        "value" => "&copy; 2021 Proudly powered by " . RAD_THEME,
                    ),
                    "footer-logo"             => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Logo in Footer ?", "aventa"),
                        "state0"  => esc_html__("Off", "aventa"),
                        "state1"  => esc_html__("On", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "footer-logo-style"       => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Footer Logo", "aventa"),
                        "state0"  => esc_html__("Second logo", "aventa"),
                        "state1"  => esc_html__("Main logo", "aventa"),
                        "value"   => 1,
                        "default" => 0,
                    ),
                    "footer-socials"          => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Footer socials", "aventa"),
                        "state0"  => esc_html__("Off", "aventa"),
                        "state1"  => esc_html__("On", "aventa"),
                        "value"   => 1,
                        "default" => 0,
                    ),
                    "footer-socials-type"     => array(
                        "type"    => "switch",
                        "class"   => "no-on-off",
                        "title"   => esc_html__("Social type", "aventa"),
                        "state0"  => esc_html__("text", "aventa"),
                        "state1"  => esc_html__("Icon", "aventa"),
                        "value"   => 1,
                        "default" => 1,
                    ),
                    "footer-payment"          => array(
                        "type"    => "upload",
                        "title"   => esc_html__("Upload payment image", "aventa"),
                        "label"   => esc_html__("Payment image", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                ),
            ), //widget-areas sec
            "footer-style" => array(
                "title"   => esc_html__("Style", "aventa"),
                "tooltip" => esc_html__("change default footer style", "aventa"),
                "fields"  => array(
                    "footer-style"    => array(
                        "type"    => "switch",
                        "title"   => esc_html__("Footer style", "aventa"),
                        "state0"  => esc_html__("Light", "aventa"),
                        "state1"  => esc_html__("Dark", "aventa"),
                        "value"   => 0,
                        "default" => 1,
                    ),
                    "footer-bg-image" => array(
                        "type"    => "upload",
                        "label"   => esc_html__("Background Image", "aventa"),
                        "title"   => esc_html__("Upload image as backgroud of footer", "aventa"),
                        "referer" => "rad-insert-image",
                    ),
                    "footer-bg-color" => array(
                        "type"  => "color",
                        "label" => esc_html__("Background Color", "aventa"),
                        "value" => "rgba(0,0,0,1)",
                    ),
                ),
            ),
        ),
    );

    $customizationPanel = array(
        "title"    => esc_html__("Customization", "aventa"),
        "sections" => array(
            "additional-css" => array(
                "title"   => esc_html__("Custom CSS codes", "aventa"),
                "tooltip" => esc_html__("Enter custom CSS code such as style overrides here. Please note that you should not include &lt;style&gt; tags in your css code.", "aventa"),
                "fields"  => array(
                    "additional-css" => array(
                        "type" => "textarea",
                    ),
                ),
            ),
        ),
    );

    $panels = array(
        "general"       => $generalSettingsPanel,
        "header"        => $headerSettingsPanel,
        "preloader"     => $preloaderPanel,
        "popup"         => $PopupPanel,
        "topbar"        => $topbarPanel,
        "menu"          => $menuPanel,
        "hamburger"     => $hamburgerPanel,
        "cart"          => $cartPanel,
        "collection"    => $collectionPanel,
        "appearance"    => $appearancePanel,
        "fonts"         => $fontsPanel,
        "social_share"  => $socialShareSettingsPanel,
        "social"        => $socialSettingsPanel,
        "footer"        => $footerSettingsPanel,
        "woocomerce"    => $woocomerceSettingsPanel,
        "shop_cat"      => $shop_cat_panel,
        "productDetail" => $productDetailSettingsPanel,
        "Cookie"        => $CookieLawpanel,
        "sidebar"       => $sidebarPanel,
        "language"      => $languagePanel,
        "blog"          => $blogPanel,
        "customization" => $customizationPanel,
        "Maintenance"   => $maintenanceSettingsPanel,
    );

    $tabs = array(
        "general"       => array(
            "text"  => esc_html__("General Settings", "aventa"),
            "panel" => "general",
        ),
        "preloader"     => array(
            "text"  => esc_html__("Preloader", "aventa"),
            "panel" => "preloader",
        ),
        "popup"         => array(
            "text"  => esc_html__("Popup Newsletter", "aventa"),
            "panel" => "popup",
        ),
        "topbar"        => array(
            "text"  => esc_html__("Top Bar", "aventa"),
            "panel" => "topbar",
        ),
        "menu"          => array(
            "text"  => esc_html__("Menu", "aventa"),
            "panel" => "menu",
        ),
        "hamburger"     => array(
            "text"  => esc_html__("Hamburger", "aventa"),
            "panel" => "hamburger",
        ),
        "cart"          => array(
            "text"  => esc_html__("Cart", "aventa"),
            "panel" => "cart",
        ),
        "collection"    => array(
            "text"  => esc_html__("Collection", "aventa"),
            "panel" => "collection",
        ),
        "appearance"    => array(
            "text"  => esc_html__("Color theme", "aventa"),
            "panel" => "appearance",
        ),
        "fonts"         => array(
            "text"  => esc_html__("Fonts", "aventa"),
            "panel" => "fonts",
        ),
        "footer"        => array(
            "text"  => esc_html__("Footer", "aventa"),
            "panel" => "footer",
        ),
        "header"        => array(
            "text"  => esc_html__("Header", "aventa"),
            "panel" => "header",
        ),
        "woocomerce"    => array(
            "text"  => esc_html__("General", "aventa"),
            "panel" => "woocomerce",
        ),
        "shop_cat"      => array(
            "text"  => esc_html__("shop categories", "aventa"),
            "panel" => "shop_cat",
        ),
        "productDetail" => array(
            "text"  => esc_html__("Single Product", "aventa"),
            "panel" => "productDetail",
        ),
        "blog"          => array(
            "text"  => esc_html__("Blog", "aventa"),
            "panel" => "blog",
        ),
        "sidebar"       => array(
            "text"  => esc_html__("Sidebar", "aventa"),
            "panel" => "sidebar",
        ),
        "language"      => array(
            "text"  => esc_html__("Language", "aventa"),
            "panel" => "language",
        ),
        "Cookie"        => array(
            "text"  => esc_html__("Cookie Law", "aventa"),
            "panel" => "Cookie",
        ),
        "social"        => array(
            "text"  => esc_html__("Social medias", "aventa"),
            "panel" => "social",
        ),
        "social_share"  => array(
            "text"  => esc_html__("Social share", "aventa"),
            "panel" => "social_share",
        ),
        "Maintenance"   => array(
            "text"  => esc_html__("Maintenance", "aventa"),
            "panel" => "Maintenance",
        ),
        "customization" => array(
            "text"  => esc_html__("Customization", "aventa"),
            "panel" => "customization",
        ),
    );

    $tabGroups = array(
        "theme-settings" => array(
            "text" => esc_html__("General Settings", "aventa"),
            "tabs" => array("general"),
            "icon" => "dashicons-admin-generic",
        ),
        "appearance"     => array(
            "text" => esc_html__("Appearence", "aventa"),
            "tabs" => array("appearance", "fonts", "preloader"),
            "icon" => "dashicons-admin-appearance",
        ),
        "menu"           => array(
            "text" => esc_html__("Menu", "aventa"),
            "tabs" => array("menu", "topbar", "hamburger", "cart", "collection"),
            "icon" => "dashicons-menu-alt",
        ),
        "header"         => array(
            "text" => esc_html__("Header", "aventa"),
            "tabs" => array("header"),
            "icon" => "dashicons-images-alt",
        ),
        "shop-settings"  => array(
            "text" => esc_html__("Shop", "aventa"),
            "tabs" => array("woocomerce", "shop_cat", "productDetail"),
            "icon" => "dashicons-cart",
        ),
        "blog"           => array(
            "text" => esc_html__("Blog", "aventa"),
            "tabs" => array("blog"),
            "icon" => "dashicons-text",
        ),
        "sidebar"        => array(
            "text" => esc_html__("Sidebar", "aventa"),
            "tabs" => array("sidebar"),
            "icon" => "dashicons-align-right",
        ),
        "language"       => array(
            "text" => esc_html__("Language", "aventa"),
            "tabs" => array("language"),
            "icon" => "dashicons-translation",
        ),
        "cookies"        => array(
            "text" => esc_html__("Cookies law notice", "aventa"),
            "tabs" => array("Cookie"),
            "icon" => "dashicons-warning",
        ),
        "popup"          => array(
            "text" => esc_html__("Popup newsletter", "aventa"),
            "tabs" => array("popup"),
            "icon" => "dashicons-admin-page",
        ),
        "Social"         => array(
            "text" => esc_html__("Social", "aventa"),
            "tabs" => array("social", "social_share"),
            "icon" => "dashicons-share",
        ),
        "footer"         => array(
            "text" => esc_html__("Footer", "aventa"),
            "tabs" => array("footer"),
            "icon" => "dashicons-align-center",
        ),
        "maintenance"    => array(
            "text" => esc_html__("Maintenance mode", "aventa"),
            "tabs" => array("Maintenance"),
            "icon" => "dashicons-admin-tools",
        ),
        "customization"  => array(
            "text" => esc_html__("Customization", "aventa"),
            "tabs" => array("customization"),
            "icon" => "dashicons-admin-settings",
        ),
    );

    $settings = array(
        "document-url" => "https://rado-studio.com/docs",
        "support-url"  => "https://rado-studio.com/support",
        "tabs-title"   => esc_html__("Theme Options", "aventa"),
        "tab-groups"   => $tabGroups,
        "tabs"         => $tabs,
        "panels"       => $panels,
    );

    return $settings;
}
