<?php

require_once RAD_THEME_ADMIN . "/settings/fieldtemplate.php";
require_once RAD_THEME_ADMIN . "/settings/theme-options-provider.php";

class Rad_AdminForm extends rad_FieldTemplate
{
    protected $template = array();

    public function __construct()
    {
        $this->template = rad_admin_get_form_settings();
        parent::__construct(new rad_ThemeOptionsProvider(), RAD_THEME_ADMIN . "/settings/templates");
    }

    public function displayForm()
    {
        echo "<div class=\"rad-container theme-settings\">
                <input type=\"hidden\" name=\"action\" value=\"theme_save_options\" />
                <div id=\"rad-wrap\">
                    <div class=\"theme-settings-body clear-after\">" . $this->GetBody() . "</div>
                </div>
            </div>";
    }

    private function GetBody()
    {
        return $this->rad_GetTemplate("admin-sidebar") . $this->rad_GetTemplate("admin-panels");
    }

    public function rad_GetImage($filename, $alt = "", $class = "")
    {
        return $this->rad_GetTemplate("image", array("filename" => $filename, "alt" => $alt, "class" => $class));
    }
}
