<?php
if (class_exists("rad_Meta_Box")) {

    class Rad_Slider extends rad_Meta_Box
    {

        public function __construct()
        {
            parent::__construct("slider");
        }

        public function rad_EnqueueScripts()
        {
            wp_enqueue_script("hoverIntent");
            wp_enqueue_script("rad-jquery-easing");

            wp_enqueue_style("rad-nouislider-style");
            wp_enqueue_script("rad-nouislider-script");

            wp_enqueue_style("wp-color-picker");
            wp_enqueue_script("wp-color-picker");
            wp_enqueue_script("rad-colorpicker-alpha");
            wp_enqueue_script("rad-admin-slider", RAD_THEME_INC_URI . "/admin/assets/js/meta-boxes/slider.js", array("jquery"), RAD_THEME_VERSION);
        }

        public function rad_OnProcessFieldForStore($post_id, $key, $settings)
        {
            return false;
        }

        protected function rad_GetOptions()
        {

            $fontNames = rad_get_fonts_collection("settings");

            $fields = array(
                "title"                         => array(
                    "type"  => "label",
                    "label" => esc_html__("Title", "aventa"),
                    "class" => "title-lable",
                    "desc"  => esc_html__("CREATIVE IDEAS", "aventa"),

                ),
                "title-text"                    => array(
                    "type"  => "textarea",
                    "cols"  => "10",
                    "rows"  => "4",
                    "label" => esc_html__("Title (Allowed tags : strong, em, br)", "aventa"),
                    "value" => esc_html__("Type text here!", "aventa"),
                ),
                "subtitle1"                     => array(
                    "type"  => "label",
                    "class" => "subtitle1-lable",
                    "desc"  => esc_html__("Subtitle text ", "aventa"),
                ),
                "subtitle1-text"                => array(
                    "type"  => "textarea",
                    "cols"  => "10",
                    "rows"  => "4",
                    "label" => esc_html__("Subtitle1", "aventa"),
                    "value" => esc_html__("Type text here!", "aventa"),
                ),
                "subtitle2"                     => array(
                    "type"  => "label",
                    "class" => "subtitle2-lable",
                    "desc"  => esc_html__("Subtitle 2 text", "aventa"),
                ),
                "subtitle2-text"                => array(
                    "type"  => "textarea",
                    "cols"  => "10",
                    "rows"  => "4",
                    "label" => esc_html__("Subtitle2", "aventa"),
                    "value" => esc_html__("Type text here!", "aventa"),
                ),
                "button"                        => array(
                    "type"  => "label",
                    "class" => "button-lable",
                    "desc"  => esc_html__("Click on me!", "aventa"),
                ),
                "background-image"              => array(
                    "type"    => "upload",
                    "label"   => esc_html__("Image", "aventa"),
                    "title"   => esc_html__("Upload Slider image", "aventa"),
                    "class"   => "slider-image-upload",
                    "referer" => "rad-slide-image",
                ),
                "button-url"                    => array(
                    "type"        => "text",
                    "label"       => esc_html__("URL", "aventa"),
                    "placeholder" => esc_html__("URL", "aventa"),
                ), //Button
                "button-text"                   => array(
                    "type"  => "text",
                    "label" => esc_html__("Text", "aventa"),
                    "value" => esc_html__("Click on me!", "aventa"),
                ), //Button text
                "button-text-color"             => array(
                    "type"  => "color",
                    "label" => esc_html__("Text color", "aventa"),
                    "value" => "#eee",
                ),
                "button-text-hover-color"       => array(
                    "type"  => "color",
                    "label" => esc_html__("Text hover-color", "aventa"),
                    "value" => "#fff",
                ),
                "button-background-color"       => array(
                    "type"  => "color",
                    "label" => esc_html__("Background Color", "aventa"),
                    "value" => "#333",
                ),
                "button-background-hover-color" => array(
                    "type"  => "color",
                    "label" => esc_html__("Background hover-olor", "aventa"),
                    "value" => "#111",
                ),
                "slider-style"                  => array(
                    "type"    => "visual-select",
                    "label"   => esc_html__("Style", "aventa"),
                    "title"   => esc_html__("choose your caption style", "aventa"),
                    "class"   => "caption-style-field",
                    "options" => array(
                        esc_html__("side", "aventa")   => "side",
                        esc_html__("center", "aventa") => "center",
                    ),
                    "default" => "side",
                ),
                "title-font"                    => array(
                    "type"    => "select",
                    "label"   => esc_html__("Font", "aventa"),
                    "options" => $fontNames,
                    "value"   => "theme_default_bold",
                ),
                "title-color"                   => array(
                    "type"  => "color",
                    "label" => esc_html__("Color", "aventa"),
                    "value" => "",
                ),
                "title-size"                    => array(
                    "type"        => "text",
                    "label"       => esc_html__("Font size in px", "aventa"),
                    "placeholder" => esc_html__("eg 60px", "aventa"),
                ),
                "subtitle1-font"                => array(
                    "type"    => "select",
                    "label"   => esc_html__("Font", "aventa"),
                    "options" => $fontNames,
                    "value"   => "theme_default",
                ),
                "subtitle1-color"               => array(
                    "type"  => "color",
                    "label" => esc_html__("Color", "aventa"),
                    "value" => "",
                ),
                "subtitle1-size"                => array(
                    "type"        => "text",
                    "label"       => esc_html__("Font size in px", "aventa"),
                    "placeholder" => esc_html__("eg 60px", "aventa"),
                ),
                "subtitle2-font"                => array(
                    "type"    => "select",
                    "label"   => esc_html__("Font", "aventa"),
                    "options" => $fontNames,
                    "value"   => "theme_default",
                ),
                "subtitle2-color"               => array(
                    "type"  => "color",
                    "label" => esc_html__("Color", "aventa"),
                    "value" => "",
                ),
                "subtitle2-size"                => array(
                    "type"        => "text",
                    "label"       => esc_html__("Font size in px", "aventa"),
                    "placeholder" => esc_html__("eg 60px", "aventa"),
                ),
            );

            $inputs = array(
                "subtitle"  => array(
                    "title"  => esc_html__("Subtitle", "aventa"),
                    "fields" => array(
                        "subtitle1" => $fields["subtitle1"],
                    ),
                ), //Slider subtitle
                "title"     => array(
                    "title"  => esc_html__("Title", "aventa"),
                    "fields" => array(
                        "title" => $fields["title"]),
                ), //Slider title
                "subtitle2" => array(
                    "title"  => esc_html__("Subtitle2", "aventa"),
                    "fields" => array(
                        "subtitle2" => $fields["subtitle2"],
                    ),
                ), //Slider subtitle
                "button"    => array(
                    "title"  => esc_html__("Button", "aventa"),
                    "fields" => array(
                        "button" => $fields["button"],
                    ),
                ), //button
            );

            $options = array(
                "background-options" => array(
                    "title"   => esc_html__("Background Image", "aventa"),
                    "tooltip" => esc_html__("Choose an image for slide", "aventa"),
                    "fields"  => array(
                        "background-image" => $fields["background-image"],
                        "slider-style"     => $fields["slider-style"],
                    ),
                ), //Background
                "title-options"      => array(
                    "title"   => esc_html__("Title", "aventa"),
                    "tooltip" => esc_html__("Select your favorite font for the title.", "aventa"),
                    "fields"  => array(
                        "title-text"  => $fields["title-text"],
                        "title-font"  => $fields["title-font"],
                        "title-size"  => $fields["title-size"],
                        "title-color" => $fields["title-color"],
                    ),
                ),
                "subtitle-options"   => array(
                    "title"   => esc_html__("Subtitle", "aventa"),
                    "tooltip" => esc_html__("Select your favorite font for the subtitle.", "aventa"),
                    "fields"  => array(
                        "subtitle1-text"  => $fields["subtitle1-text"],
                        "subtitle1-font"  => $fields["subtitle1-font"],
                        "subtitle1-size"  => $fields["subtitle1-size"],
                        "subtitle1-color" => $fields["subtitle1-color"],
                    ),
                ), //Slider subtitle"s Font
                "subtitle2-options"  => array(
                    "title"   => esc_html__("Subtitle2", "aventa"),
                    "tooltip" => esc_html__("Select your favorite font for the subtitle2.", "aventa"),
                    "fields"  => array(
                        "subtitle2-text"  => $fields["subtitle2-text"],
                        "subtitle2-font"  => $fields["subtitle2-font"],
                        "subtitle2-size"  => $fields["subtitle2-size"],
                        "subtitle2-color" => $fields["subtitle2-color"],
                    ),
                ), //Slider subtitle2"s Font
                "button-options"     => array(
                    "title"   => esc_html__("Button", "aventa"),
                    "tooltip" => esc_html__("By specifying a URL and a label text, you can add a button to your slide, this button redirects users to another web page.", "aventa"),
                    "fields"  => array(
                        "button-url"                    => $fields["button-url"],
                        "button-text"                   => $fields["button-text"],
                        "button-text-color"             => $fields["button-text-color"],
                        "button-background-color"       => $fields["button-background-color"],
                        "button-text-hover-color"       => $fields["button-text-hover-color"],
                        "button-background-hover-color" => $fields["button-background-hover-color"],
                    ),
                ), //button
            );

            return array(
                array(
                    "id"       => "slider_board",
                    "title"    => esc_html__("Slider board", "aventa"),
                    "context"  => "normal",
                    "priority" => "high",
                    "options"  => $inputs,
                ),
                array(
                    "id"       => "slider_options",
                    "title"    => esc_html__("Slider options", "aventa"),
                    "context"  => "normal",
                    "priority" => "default",
                    "options"  => $options,
                ),
            );
        }
    }

    function rad_builtin_slider()
    {
        new rad_Slider();
    }
    add_action("after_setup_theme", "rad_builtin_slider");
}
