<?php

if (class_exists("rad_Meta_Box")) {

    class Rad_Product extends rad_Meta_Box
    {
        public function __construct()
        {
            parent::__construct("product");
        }

        public function rad_EnqueueScripts()
        {
            wp_enqueue_script("hoverIntent");
            wp_enqueue_script("rad-jquery-easing");

            wp_enqueue_style("rad-nouislider-style");
            wp_enqueue_script("rad-nouislider-script");

            wp_enqueue_style("wp-color-picker");
            wp_enqueue_script("wp-color-picker");
            wp_enqueue_script("rad-colorpicker-alpha");
            wp_enqueue_script("rad-admin-product", RAD_THEME_INC_URI . "/admin/assets/js/meta-boxes/product.js", array("jquery"), RAD_THEME_VERSION);
        }

        protected function rad_GetOptions()
        {

            $fields = array(
                "video_type"              => array(
                    "type"    => "select",
                    "label"   => esc_html__("Video type", "aventa"),
                    "options" => array("none" => esc_html__("No video", "aventa"), "local_video_popup" => esc_html__("local video popup", "aventa"), "embeded_video_vimeo_popup" => esc_html__("Vimeo video popup", "aventa"), "embeded_video_youtube_popup" => esc_html__("Youtube video popup", "aventa")),
                ),
                "video_webm"              => array(
                    "type"        => "text",
                    "class"       => "video_webm",
                    "label"       => esc_html__(".webm extension", "aventa"),
                    "placeholder" => esc_html__(".webm video", "aventa"),
                ),
                "video_mp4"               => array(
                    "type"        => "text",
                    "class"       => "video_mp4",
                    "label"       => esc_html__(".mp4 extension", "aventa"),
                    "placeholder" => esc_html__(".mp4 video", "aventa"),
                ),
                "video_ogv"               => array(
                    "type"        => "text",
                    "class"       => "video_ogv",
                    "label"       => esc_html__(".ogv extension", "aventa"),
                    "placeholder" => esc_html__(".ogv video", "aventa"),
                ),
                "video_vimeo_id"          => array(
                    "type"  => "text",
                    "class" => "video_vimeo_id",
                    "label" => esc_html__("Vimeo Video link", "aventa"),
                ),
                "video_youtube_id"        => array(
                    "type"  => "text",
                    "class" => "video_youtube_id",
                    "label" => esc_html__("Youtube Video link", "aventa"),
                ),
                "video_play_button_color" => array(
                    "type"    => "select",
                    "class"   => "video_play_button_color",
                    "label"   => esc_html__("Select play button style.", "aventa"),
                    "options" => array(
                        "light" => esc_html__("Light", "aventa"),
                        "dark"  => esc_html__("Dark", "aventa"),
                    ),
                ),
                "extra_class"             => array(
                    "type"        => "text",
                    "label"       => esc_html__("Extra Class Names", "aventa"),
                    "placeholder" => esc_html__("class names ex: class1 class2", "aventa"),
                ), // Extra class name
                "social_share_inherit"    => array(
                    "type"    => "switch",
                    "class"   => "social_share_inherit",
                    "title"   => esc_html__("Show social share?", "aventa"),
                    "state0"  => esc_html__("Inherit from theme setting", "aventa"),
                    "state1"  => esc_html__("Custom for current page", "aventa"),
                    "default" => 0,
                    "value"   => 0,
                ),
                "product-social-share"    => array(
                    "type"    => "switch",
                    "class"   => "product-social-share",
                    "state0"  => esc_html__("Disable", "aventa"),
                    "state1"  => esc_html__("Enable", "aventa"),
                    "default" => 1,
                ),
            );

            //Option sections
            $options = array(
                "extra_class" => array(
                    "title"   => esc_html__("General", "aventa"),
                    "tooltip" => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS. use space between diffrent class name", "aventa"),
                    "fields"  => array(
                        "extra_class"          => $fields["extra_class"],
                        "social_share_inherit" => $fields["social_share_inherit"],
                        "product-social-share" => $fields["product-social-share"],
                    ),
                ),
                "video_type"  => array(
                    "title"   => esc_html__("Video", "aventa"),
                    "tooltip" => esc_html__("change video options to display in this product.", "aventa"),
                    "fields"  => array(
                        "video_type"              => $fields["video_type"],
                        "video_webm"              => $fields["video_webm"],
                        "video_mp4"               => $fields["video_mp4"],
                        "video_ogv"               => $fields["video_ogv"],
                        "video_vimeo_id"          => $fields["video_vimeo_id"],
                        "video_youtube_id"        => $fields["video_youtube_id"],
                        "video_play_button_color" => $fields["video_play_button_color"],
                    ),
                ),
            );
            return array(
                array(
                    "id"       => "product_meta_box",
                    "title"    => esc_html__("Settings", "aventa"),
                    "context"  => "normal",
                    "priority" => "default",
                    "options"  => $options,
                ), //Meta box 1
            );
        }
    }

    new rad_Product();
}
