<?php

if (class_exists("rad_Meta_Box")) {
    class Rad_Page extends rad_Meta_Box
    {
        public function __construct()
        {
            parent::__construct("page");
        }

        public function rad_EnqueueScripts()
        {
            wp_enqueue_script("hoverIntent");
            wp_enqueue_script("rad-jquery-easing");

            wp_enqueue_style("rad-nouislider-style");
            wp_enqueue_script("rad-nouislider-script");

            wp_enqueue_style("wp-color-picker");
            wp_enqueue_script("wp-color-picker");
            wp_enqueue_script("rad-colorpicker-alpha");
            wp_enqueue_script("rad-admin-page", RAD_THEME_INC_URI . "/admin/assets/js/meta-boxes/page.js", array("jquery"), RAD_THEME_VERSION);
        }

        private function rad_GetSidebars()
        {
            $sidebars = array("no-sidebar" => esc_html__("No Sidebar", "aventa"), "page-sidebar" => esc_html__("Page Sidebar", "aventa"));

            if (rad_get_option("custom_sidebars") != "") {
                $arr = explode(",", rad_get_option("custom_sidebars"));

                foreach ($arr as $bar) {
                    $sidebars[$bar] = str_replace("%666", ",", $bar);
                }

            }

            $sidebars = array_unique($sidebars);
            return $sidebars;
        }

        protected function rad_GetOptions()
        {

            $args = array(
                "orderby"    => "id",
                "order"      => "DESC",
                "hide_empty" => false,
                "fields"     => "all",
            );
            $sliderCategories = get_terms("slider_cats", $args);
            $sliderSlugName   = array();
            if (!empty($sliderCategories) && !is_wp_error($sliderCategories)) {
                foreach ($sliderCategories as $sliderCat) {
                    $sliderSlugName[$sliderCat->slug] = $sliderCat->name;
                }
            }

            $fields = array(
                "page-header-custom"      => array(
                    "type"    => "select",
                    "label"   => esc_html__("Page header", "aventa"),
                    "options" => array("inherit" => esc_html__("Inherit from theme settings", "aventa"), "custom" => esc_html__("custom", "aventa")),
                ),
                "page-header-mode"        => array(
                    "type"    => "select",
                    "label"   => esc_html__("Page begins with", "aventa"),
                    "options" => array("1" => esc_html__("Header at top", "aventa"), "2" => esc_html__("Space at top", "aventa"), "3" => esc_html__("No space at top", "aventa")),
                ),
                "page-header-bg"          => array(
                    "type"  => "color",
                    "label" => esc_html__("Overlay Color", "aventa"),
                    "value" => "rgba(0,0,0,0.03)",
                ),
                "title-bar"               => array(
                    "type"    => "select",
                    "label"   => esc_html__("Title in header", "aventa"),
                    "options" => array("2" => esc_html__("Use post title", "aventa"), "1" => esc_html__("Use custom title", "aventa"), "0" => esc_html__("Hide it", "aventa")),
                    "default" => "2",
                ),
                "title-text"              => array(
                    "type"        => "text",
                    "label"       => esc_html__("Title", "aventa"),
                    "placeholder" => esc_html__("Header use this title instead of page title", "aventa"),
                ),
                "page-header-bg-image"    => array(
                    "type"  => "upload",
                    "label" => esc_html__("Header background image", "aventa"),
                    "title" => esc_html__("Upload Background image for header", "aventa"),
                ),
                "page-header-text-color"  => array(
                    "type"  => "color",
                    "label" => esc_html__("Header Text Color", "aventa"),
                    "value" => "rgba(0,0,0,1)",
                ),
                "sidebar"                 => array(
                    "type"    => "select",
                    "label"   => esc_html__("Choose the sidebar", "aventa"),
                    "options" => $this->rad_GetSidebars(),
                ),
                "slider-type"             => array(
                    "type"    => "select",
                    "options" => array(
                        "none"           => esc_html__("none", "aventa"),
                        "builtin-slider" => esc_html__("Aventa builtin slider", "aventa"),
                        "rev-slider"     => esc_html__("revolution slider", "aventa"),
                    ),
                    "value"   => "none",
                    "label"   => esc_html__("Slider type", "aventa"),
                ),
                "slide-mode"              => array(
                    "type"    => "select",
                    "options" => array(
                        "slide" => esc_html__("Slide", "aventa"),
                        "fade"  => esc_html__("Fade", "aventa"),
                    ),
                    "class"   => "slide-mode",
                    "value"   => "fade",
                    "label"   => esc_html__("Sliding Mode", "aventa"),
                ),
                "builtin-slider-cat"      => array(
                    "type"    => "select",
                    "options" => $sliderSlugName,
                    "label"   => esc_html__("Category Of Slides", "aventa"),
                ),
                "slider-pagination-type"  => array(
                    "type"    => "select",
                    "options" => array(
                        "none"     => esc_html__("None", "aventa"),
                        "simple"   => esc_html__("Simple", "aventa"),
                        "linear"   => esc_html__("Linear", "aventa"),
                        "progress" => esc_html__("Progress", "aventa"),
                    ),
                    "value"   => "none",
                    "label"   => esc_html__("Pagination type", "aventa"),
                ),
                "slider-pagination-style" => array(
                    "type"    => "select",
                    "options" => array(
                        "light" => esc_html__("Light", "aventa"),
                        "dark"  => esc_html__("Dark", "aventa"),
                    ),
                    "value"   => "light",
                    "label"   => esc_html__("Pagination/Navigation style", "aventa"),
                ),
                "slider-pagination-align" => array(
                    "type"    => "select",
                    "options" => array(
                        "center" => esc_html__("Center", "aventa"),
                        "left"   => esc_html__("Left", "aventa"),
                        "right"  => esc_html__("Right", "aventa"),
                    ),
                    "value"   => "center",
                    "label"   => esc_html__("Pagination position", "aventa"),
                ),
                "rev-slider"              => array(
                    "type"    => "select",
                    "label"   => esc_html__("Choose a revolution slider", "aventa"),
                    "options" => rad_get_revolution_slider_slides(),
                ),
                "slider-width"            => array(
                    "type"    => "visual-select",
                    "label"   => esc_html__("Slider width", "aventa"),
                    "options" => array(
                        esc_html__("Fullscreen", "aventa")                     => "fullscreen",
                        esc_html__("Fillscreen with space in edges", "aventa") => "fullscreen-edge",
                        esc_html__("Boxed in container", "aventa")             => "boxed",
                    ),
                    "value"   => 0,
                    "default" => "fullscreen",
                ),
                "extra_class"             => array(
                    "type"        => "text",
                    "label"       => esc_html__("Extra Class Name", "aventa"),
                    "placeholder" => esc_html__("class name ex: class1 class2", "aventa"),
                ), // Extra class name
            );

            $sections = array(
                "page"             => array(
                    "title"   => esc_html__("General", "aventa"),
                    "tooltip" => esc_html__("You can choose a sidebar or add a CSS class to this page in this section.", "aventa"),
                    "fields"  => array(
                        "sidebar"     => $fields["sidebar"],
                        "extra_class" => $fields["extra_class"],
                    ),
                ),
                "page-header-mode" => array(
                    "title"   => esc_html__("Header", "aventa"),
                    "tooltip" => esc_html__("Change the Header configuration of current page.", "aventa"),
                    "fields"  => array(
                        "page-header-custom"     => $fields["page-header-custom"],
                        "page-header-mode"       => $fields["page-header-mode"],
                        "title-bar"              => $fields["title-bar"],
                        "title-text"             => $fields["title-text"],
                        "page-header-bg"         => $fields["page-header-bg"],
                        "page-header-bg-image"   => $fields["page-header-bg-image"],
                        "page-header-text-color" => $fields["page-header-text-color"],
                    ),
                ),
                "slider-type"      => array(
                    "title"   => esc_html__("Slider", "aventa"),
                    "tooltip" => esc_html__("Display slider at top of current page. Aventa Buillt-in slider or Revolution slider is available.", "aventa"),
                    "fields"  => array(
                        "slider-type"             => $fields["slider-type"],
                        "slide-mode"              => $fields["slide-mode"],
                        "slider-width"            => $fields["slider-width"],
                        "builtin-slider-cat"      => $fields["builtin-slider-cat"],
                        "slider-pagination-type"  => $fields["slider-pagination-type"],
                        "slider-pagination-align" => $fields["slider-pagination-align"],
                        "slider-pagination-style" => $fields["slider-pagination-style"],
                        "rev-slider"              => $fields["rev-slider"],
                    ),
                ),
                "menu"             => array(
                    "title"   => esc_html__("Menu", "aventa"),
                    "tooltip" => esc_html__("Override menu style for current page.", "aventa"),
                    "fields"  => array(
                        "menu_description"              => array(
                            "type"  => "label",
                            "title" => esc_html__("Current page menu style", "aventa"),
                            "desc"  => esc_html__("Change style of menu just for this page. this settings override aventa settings just for current page.", "aventa"),
                        ),
                        "menu"                          => array(
                            "type"    => "select",
                            "label"   => esc_html__("Menu style", "aventa"),
                            "options" => array("default" => esc_html__("Inherit from theme settings", "aventa"), "custom" => esc_html__("Custom", "aventa")),
                        ),
                        "menu_initial_description"      => array(
                            "type"  => "label",
                            "title" => esc_html__("Initial state", "aventa"),
                        ),
                        "menu-initial-state-logo"       => array(
                            "type"    => "switch",
                            "state0"  => esc_html__("Second logo", "aventa"),
                            "state1"  => esc_html__("Main logo", "aventa"),
                            "value"   => 1,
                            "default" => 1,
                        ),
                        "initial-menu-background-color" => array(
                            "type"  => "color",
                            "label" => esc_html__("Background Color", "aventa"),
                            "value" => "#ffffff",
                        ),
                        "initial-menu-text-color"       => array(
                            "type"  => "color",
                            "label" => esc_html__("Text Color", "aventa"),
                            "value" => "#000000",
                        ),
                        "initial-menu-border-color"     => array(
                            "type"  => "color",
                            "class" => "initial-border-color",
                            "label" => esc_html__("Border Color", "aventa"),
                            "value" => "#eee",
                        ),
                        "initial-shop-cart-text-color"  => array(
                            "type"  => "color",
                            "label" => esc_html__("Cart/Wishlist Text Color", "aventa"),
                            "value" => "#fdfdfd",
                        ),
                        "menu_second_description"       => array(
                            "type"  => "label",
                            "title" => esc_html__("Second state", "aventa"),
                        ),
                        "menu-second-state-logo"        => array(
                            "type"    => "switch",
                            "state0"  => esc_html__("Second logo", "aventa"),
                            "state1"  => esc_html__("Main logo", "aventa"),
                            "value"   => 1,
                            "default" => 1,
                        ),
                        "menu-background-color"         => array(
                            "type"  => "color",
                            "label" => esc_html__("Background Color", "aventa"),
                            "value" => "#ffffff",
                        ),
                        "menu-text-color"               => array(
                            "type"  => "color",
                            "label" => esc_html__("Text Color", "aventa"),
                            "value" => "#000000",
                        ),
                        "menu-border-color"             => array(
                            "type"  => "color",
                            "class" => "border-color",
                            "label" => esc_html__("Border Color", "aventa"),
                            "value" => "#eee",
                        ),
                        "shop-cart-text-color"          => array(
                            "type"  => "color",
                            "label" => esc_html__("Cart/Wishlist Text Color", "aventa"),
                            "value" => "#fdfdfd",
                        ),
                    ),
                ),
            );

            if (rad_get_option("menu-state") == "single-state") {
                unset($sections["menu"]);
            }

            $metaboxes = array(
                array(
                    "id"       => "rad_page_meta_box",
                    "title"    => esc_html__("Settings", "aventa"),
                    "context"  => "normal",
                    "priority" => "high",
                    "options"  => $sections,
                ),
            );

            return $metaboxes;

        }
    }

    new rad_Page();
}
