<?php
function rad_customize_register($wp_customize)
{
    //All our sections, settings, and controls of customizer will be added here

    // add a setting
    $wp_customize->add_setting(
        "rad_second_logo",
        array(
            "sanitize_callback" => "rad_customize_control_validate_image",
            "default"           => "",
            "type"              => "theme_mod",
            "capability"        => "edit_theme_options",
            "transport"         => "postMessage",
        )
    );

    // Add a control to upload the hover logo
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, "rad_second_logo", array(
        "label"    => esc_html__("Second logo ", "aventa"),
        "section"  => "title_tagline", //this is the section where the custom-logo from WordPress is
        "settings" => "rad_second_logo",
        "priority" => 8, // show it just below the custom-logo
    )));

}
add_action("customize_register", "rad_customize_register");

function rad_customize_control_validate_image($input, $setting)
{
    // Array of valid image file types
    // The array includes image mime types
    // that are included in wp_get_mime_types()
    $mimes = array(
        "jpg|jpeg|jpe" => "image/jpeg",
        "gif"          => "image/gif",
        "png"          => "image/png",
        "bmp"          => "image/bmp",
        "tiff|tif"     => "image/tiff",
        "ico"          => "image/x-icon",
        "heic"         => "image/heic",
    );
    // Return an array with file extension
    // and mime_type
    $file = wp_check_filetype($input, $mimes);
    // If $input has a valid mime_type,
    // return it; otherwise, return
    // the default.
    return ($file["ext"] ? $input : $setting->default);
}
