<?php

function rad_vc_add_custom_fields()
{

    $custom_field_types = array(
        "vc_icons"       => array(
            "callback" => "rad_vc_icons_field",
            "js"       => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/vc_icon.js",
        ),
        "vc_date"        => array(
            "callback" => "rad_vc_date_field",
        ),
        "vc_number"      => array(
            "callback" => "rad_vc_number_field",
        ),
        "vc_imageselect" => array(
            "callback" => "rad_vc_imageselect_field",
            "js"       => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/vc_imageselect.js",

        ),
        "vc_rangefield"  => array(
            "callback" => "rad_vc_range_field",
            "js"       => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/vc_rangefield.js",

        ),
        "vc_multiselect" => array(
            "callback" => "rad_vc_multi_select",
            "js"       => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/vc_multiselect.js",
        ),
    );

    foreach ($custom_field_types as $field_name => $param_spec) {
        $func = "vc_add_" . "shortcode_param";
        if (!function_exists($func)) {
            break;
        }

        if (!isset($param_spec["js"])) {
            call_user_func($func, $field_name, $param_spec["callback"]);
        } else {
            call_user_func($func, $field_name, $param_spec["callback"], $param_spec["js"]);
        }
    }
}

add_action("admin_init", "rad_vc_add_custom_fields");

function rad_vc_enqueue_main_css_forever()
{
    wp_enqueue_style("js_composer_front");
}

add_action("wp_enqueue_scripts", "rad_vc_enqueue_main_css_forever");

function rad_vc_icons_field($settings, $value)
{

    $icons      = rad_Icon_Manager::get_light_icons();
    $icon_block = array();

    foreach ($icons as $name => $svg) {
        $icon_block[] = "<span class=\"rad-icon-param\" data-type=\"light\" data-name=\"" . esc_attr($name) . "\">" . $svg . "</span>";
    }

    $icons = rad_Icon_Manager::get_solid_icons();

    foreach ($icons as $name => $svg) {
        $icon_block[] = "<span class=\"rad-icon-param\" data-type=\"solid\" data-name=\"" . esc_attr($name) . "\">" . $svg . "</span>";
    }

    $icons = rad_Icon_Manager::get_brand_icons();

    foreach ($icons as $name => $svg) {
        $icon_block[] = "<span class=\"rad-icon-param\" data-type=\"brand\" data-name=\"" . esc_attr($name) . "\">" . $svg . "</span>";
    }

    return "<div class=\"my_param_block rad-icon-param-container\">"
    . implode($icon_block)
    . "<input type=\"text\" name=\"" . esc_attr($settings["param_name"])
    . "\" class=\"wpb_vc_param_value wpb-textinput rad-input-vc-icon hidden-field-value "
    . esc_attr($settings["param_name"]) . " " . esc_attr($settings["type"]) . "_field\" type=\"text\" value=\"" . esc_attr($value) . "\" /></div>";
}

function rad_vc_date_field($settings, $value)
{

    return "<div>"
    . "<div class=\"label\">" . esc_html($settings["label"]) . "</div>"
    . "<input type=\"datetime-local\" name=\"" . esc_attr($settings["param_name"]) . "\" class=\"wpb_vc_param_value wpb-textinput " .
    esc_attr($settings["param_name"]) . " " .
    esc_attr($settings["type"]) . "_field\" value=\"" . esc_attr($value) . "\" /></div>";
}

function rad_vc_number_field($settings, $value)
{

    return "<div>"
    . "<div class=\"label\">" . esc_html($settings["label"]) . "</div>"
    . "<input type=\"number\" name=\"" . esc_attr($settings["param_name"]) . "\" class=\"wpb_vc_param_value wpb-textinput " .
    esc_attr($settings["param_name"]) . " " .
    esc_attr($settings["type"]) . "_field\" value=\"" . esc_attr($value) . "\" /></div>";
}

function rad_vc_imageselect_field($settings, $value)
{
    $name    = $settings["param_name"];
    $options = $settings["value"];

    foreach ($options as $optionkey => $optionvalue) {
        $image_options[] = sprintf("<span class=\"rad-image image-%s\" data-name=\"%s\"><img src=\"%s.png\"></span>", esc_attr($optionvalue), esc_attr($optionvalue), esc_url(RAD_THEME_INC_URI . "/admin/assets/img/icons/" . $name . "/" . $optionkey));
    }

    return "<div class=\"my_param_block rad-imageselect-container " . (array_key_exists("class", $settings) ? $settings["class"] : "") . "\">"
    . implode($image_options)
    . "<input type=\"text\" name=\"" . esc_attr($settings["param_name"])
    . "\" class=\"wpb_vc_param_value wpb-textinput rad-input-vc-imageselect hidden-field-value "
    . esc_attr($settings["param_name"]) . " " . esc_attr($settings["type"]) . "_field\" type=\"text\" value=\"" . esc_attr($value) . "\"/></div>";
}

function rad_vc_range_field($settings, $value)
{

    return "<div class=\"my_param_block rad-rangefield-container field clear-after\">"
    . "<div class=\"label\">" . esc_html($settings["label"]) . "</div>"
    . "<input type=\"range\" start=\"" . esc_attr($settings["min"]) . "\" min=\"" . esc_attr($settings["min"]) . "\" max=\"" . esc_attr($settings["max"]) . "\" step=\"" . esc_attr($settings["step"]) . "\" value=\"" . esc_attr($value) . "\" />"
    . "<input type=\"text\" name=\"" . esc_attr($settings["param_name"])
    . "\" class=\"wpb_vc_param_value wpb-textinput rad-input-vc-range hidden-field-value "
    . esc_attr($settings["param_name"]) . " " . esc_attr($settings["type"]) . "_field\" type=\"text\" value=\"" . esc_attr($value) . "\"/></div>";
}

function rad_vc_multi_select($settings, $value)
{
    $items   = $settings["options"];
    $options = array();
    foreach ($items as $optionkey => $optionvalue) {
        $options[] = sprintf("<input type=\"checkbox\" name=\"%s\" value=\"%s\" class=\"rad-checkbox-field\"> <span class=\"checkbox-label\">%s</span>", $optionvalue, $optionkey, $optionvalue);
    }

    return "<div class=\"my_param_block rad-checkbox-container field clear-after\">"
    . implode($options)
    . "<input type=\"text\" name=\"" . esc_attr($settings["param_name"])
    . "\" class=\"wpb_vc_param_value wpb-textinput rad-input-vc-checkbox hidden-field-value "
    . esc_attr($settings["param_name"]) . " " . esc_attr($settings["type"]) . "_field\" type=\"text\" value=\"" . esc_attr($value) . "\"/></div>";
}

if (!function_exists("js_composer_bridge_admin")) {

    function rad_js_composer_css_admin()
    {
        if (!isset($_GET["page"]) || $_GET["page"] != "aventa_theme_settings") {
            // presscore stuff
            wp_enqueue_style("rad-admin-vc-extend-style", RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css");
        }

    }
}

add_action("admin_enqueue_scripts", "rad_js_composer_css_admin", 15);

// animation array
$animations = array(
    "None"                => "none",
    "Fade in"             => "fade-in",
    "Fade in from top"    => "fade-in-top",
    "Fade in from left"   => "fade-in-left",
    "Fade in from right"  => "fade-in-right",
    "Fade in from bottom" => "fade-in-bottom",
);

$img_animations = array(
    esc_html__("Zoom in", "aventa") => "zoom-in",
    esc_html__("Mask", "aventa")    => "mask",
    esc_html__("None", "aventa")    => "none",
);

$headings = array(
    "H1" => "h1",
    "H2" => "h2",
    "H3" => "h3",
    "H4" => "h4",
    "H5" => "h5",
    "H6" => "h6",
);

$fonts = rad_get_fonts_collection("wpbakery");

$fontsize = array(
    "20"  => "20",
    "24"  => "24",
    "32"  => "32",
    "40"  => "40",
    "48"  => "48",
    "60"  => "60",
    "80"  => "80",
    "100" => "100",
);

$Customfontsize = array(
    "20"  => "20",
    "24"  => "24",
    "32"  => "32",
    "40"  => "40",
    "48"  => "48",
    "60"  => "60",
    "80"  => "80",
    "100" => "100",
);

$contentfontsize = array(
    "12" => "12",
    "13" => "13",
    "14" => "14",
    "15" => "15",
    "16" => "16",
    "17" => "17",
    "18" => "18",
    "19" => "19",
    "20" => "20",
    "22" => "22",
    "24" => "24",
);

$contdownFontSize = array(
    "28" => "28",
    "29" => "29",
    "30" => "30",
    "31" => "31",
    "32" => "32",
    "33" => "33",
    "34" => "34",
    "35" => "35",
    "36" => "36",
    "37" => "37",
    "38" => "38",
    "39" => "39",
    "40" => "40",
    "41" => "41",
    "42" => "42",
    "43" => "43",
    "44" => "44",
    "45" => "45",
    "46" => "46",
    "47" => "47",
    "48" => "48",
    "49" => "49",
    "50" => "50",
);

//Remove animation from VC shortcodes
vc_remove_param("vc_icon", "css_animation");
vc_remove_param("vc_separator", "css_animation");
vc_remove_param("vc_separator", "el_id");
vc_remove_param("vc_facebook", "css_animation");
vc_remove_param("vc_tweetmeme", "css_animation");
vc_remove_param("vc_googleplus", "css_animation");
vc_remove_param("vc_pinterest", "css_animation");
vc_remove_param("vc_single_image", "css_animation");
vc_remove_param("vc_gmaps", "css_animation");
vc_remove_param("vc_flickr", "css_animation");
vc_remove_param("vc_basic_grid", "css_animation");
vc_remove_param("vc_masonry_grid", "css_animation");
vc_remove_param("vc_zigzag", "css_animation");

/*-----------------------------------------------------------------------------------*/
/* Section
/*-----------------------------------------------------------------------------------*/
// Remove VC Button Element
vc_remove_element("vc_section");

/*-----------------------------------------------------------------------------------*/
/*  hoverbox
/*-----------------------------------------------------------------------------------*/
// Remove VC hoverbox  Element
vc_remove_element("vc_hoverbox");

if (class_exists("MC4WP_MailChimp")) {
    // Check if mailpoet be active then run below code
    vc_map(
        array(
            "name"             => esc_html__("Newsletter Subscription Form", "aventa"),
            "description"      => esc_html__("MailChimp subscription forms", "aventa"),
            "base"             => "rad_newsletter",
            "category"         => "Aventa",
            "weight"           => 9,
            "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
            "icon"             => "icon-wpb-newsletter",
            "params"           => array(
                array(
                    "type"        => "dropdown",
                    "holder"      => "",
                    "class"       => "",
                    "heading"     => esc_html__("MC4WP Form", "aventa"),
                    "param_name"  => "form_id",
                    "value"       => rad_get_MC4WP_forms(),
                    "description" => esc_html__("Select a MC4WP form", "aventa"),
                ),
                array(
                    "type"        => "dropdown",
                    "class"       => "",
                    "admin_label" => false,
                    "heading"     => esc_html__("Align", "aventa"),
                    "param_name"  => "align",
                    "value"       => array(
                        esc_html__("Right", "aventa")  => "right",
                        esc_html__("Center", "aventa") => "center",
                        esc_html__("left", "aventa")   => "left",
                    ),
                ),
                array(
                    "type"        => "dropdown",
                    "class"       => "",
                    "admin_label" => false,
                    "heading"     => esc_html__("Style", "aventa"),
                    "param_name"  => "style",
                    "value"       => array(
                        esc_html__("Dark", "aventa")  => "dark",
                        esc_html__("Light", "aventa") => "light",
                    ),
                ),
                array(
                    "type"        => "dropdown",
                    "admin_label" => false,
                    "class"       => "",
                    "heading"     => esc_html__("Animation", "aventa"),
                    "param_name"  => "animation",
                    "description" => esc_html__("Select animation type", "aventa"),
                    "value"       => $animations,
                    "group"       => esc_html__("Animation", "aventa"),
                ),
                array(
                    "type"        => "textfield",
                    "admin_label" => false,
                    "class"       => "",
                    "heading"     => esc_html__("Animation Delay", "aventa"),
                    "param_name"  => "delay",
                    "value"       => "",
                    "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                    "group"       => esc_html__("Animation", "aventa"),
                ),
                array(
                    "type"        => "vc_multiselect",
                    "class"       => "",
                    "heading"     => esc_html__("Animation in Responsive", "aventa"),
                    "param_name"  => "responsive_animation",
                    "options"     => array("disable" => "Disable animation"),
                    "value"       => "disable",
                    "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                    "group"       => esc_html__("Animation", "aventa"),
                ),
            ),
        )
    );
}

/*-----------------------------------------------------------------------------------*/
/* Accordion
/*-----------------------------------------------------------------------------------*/

vc_remove_element("vc_tta_accordion");

vc_map(
    array(
        "name"                    => esc_html__("Accordion Block", "aventa"),
        "description"             => esc_html__("Display information in collapsible rows", "aventa"),
        "base"                    => "rad_accordion_group",
        "category"                => "Aventa",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-accordion-group",
        "as_parent"               => array("only" => "rad_tta"),
        "is_container"            => true,
        "show_settings_on_create" => false,
        "js_view"                 => "RADBackendTtaAccordionView",
        "custom_markup"           => "
        <div class=\"vc_tta-container\" data-vc-action=\"collapseAll\">
            <div class=\"vc_general vc_tta vc_tta-accordion vc_tta-color-backend-accordion-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-o-shape-group vc_tta-controls-align-left vc_tta-gap-2\">
               <div class=\"vc_tta-panels vc_clearfix {{container-class}}\">
                  {{ content }}
                  <div class=\"vc_tta-panel vc_tta-section-append\">
                     <div class=\"vc_tta-panel-heading\">
                        <h4 class=\"vc_tta-panel-title vc_tta-controls-icon-position-left\">
                           <a href=\"javascript:;\" aria-expanded=\"false\" class=\"vc_tta-backend-add-control\">
                               <span class=\"vc_tta-title-text\">" . esc_html__("Add Section", "aventa") . "</span>
                                <i class=\"vc_tta-controls-icon vc_tta-controls-icon-plus\"></i>
                            </a>
                        </h4>
                     </div>
                  </div>
               </div>
            </div>
        </div>",
        "default_content"         => "
        [rad_tta title=\"" . sprintf("%s %d", esc_html__("Section", "aventa"), 1) . "\"][/rad_tta]
        [rad_tta title=\"" . sprintf("%s %d", esc_html__("Section", "aventa"), 2) . "\"][/rad_tta]
            ",
        "params"                  => array(
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon Position", "aventa"),
                "param_name"  => "icon_position",
                "value"       => array(
                    esc_html__("Left side of title", "aventa")  => "left",
                    esc_html__("Right side of title", "aventa") => "right",
                ),
            ),
            array(
                "type"        => "checkbox",
                "class"       => "",
                "heading"     => esc_html__("Allow collapse all?", "aventa"),
                "param_name"  => "allow_collapse_all",
                "description" => esc_html__("Checked and select an icon.", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "align",
                "description" => esc_html__("Select alignment", "aventa"),
                "value"       => array(
                    esc_html__("Left", "aventa")  => "left",
                    esc_html__("Right", "aventa") => "right",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Color", "aventa"),
                "param_name"  => "color",
                "value"       => "",
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Tabs
/*-----------------------------------------------------------------------------------*/

vc_remove_element("vc_tta_tabs");

vc_map(
    array(
        "name"                    => esc_html__("Tab Block", "aventa"),
        "description"             => esc_html__("Organize text-heavy content with multiple tabs", "aventa"),
        "base"                    => "rad_tab_group",
        "category"                => "Aventa",
        "class"                   => "wpb_vc_tta_tabs vc_tta-container",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-tab-group",
        "as_parent"               => array("only" => "rad_tta"),
        //"content_element" => true,
        "is_container"            => true,
        "show_settings_on_create" => false,
        "js_view"                 => "RADBackendTtaTabsView",
        "custom_markup"           => "
            <div class=\"vc_tta-container\" data-vc-action=\"collapse\">
                <div class=\"vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left\">
                    <div class=\"vc_tta-tabs-container\">" . "<ul class=\"vc_tta-tabs-list\">" . "<li class=\"vc_tta-tab\" data-vc-tab data-vc-target-model-id=\"{{ model_id }}\" data-element_type=\"vc_tta_section\"><a href=\"javascript:;\" data-vc-tabs data-vc-container=\".vc_tta\" data-vc-target=\"[data-model-id='{{ model_id }}']\" data-vc-target-model-id=\"{{ model_id }}\"><span class=\"vc_tta-title-text\">{{ section_title }}</span></a></li>" . "</ul>
                    </div>
                    <div class=\"vc_tta-panels vc_clearfix {{container-class}}\">
                      {{ content }}
                    </div>
                </div>
            </div>",
        "default_content"         => "
        [rad_tta title=\"" . sprintf("%s %d", esc_html__("Tab", "aventa"), 1) . "\"][/rad_tta]
        [rad_tta title=\"" . sprintf("%s %d", esc_html__("Tab", "aventa"), 2) . "\"][/rad_tta]
            ",
        "admin_enqueue_js"        => array(
            vc_asset_url("lib/vc_tabs/vc-tabs.min.js"),
        ),
        "params"                  => array(
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "value"       => array(
                    esc_html__("Hover color", "aventa") => "color",
                    esc_html__("Line", "aventa")        => "line",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon Position", "aventa"),
                "param_name"  => "icon_position",
                "value"       => array(
                    esc_html__("Icon at top", "aventa")         => "top",
                    esc_html__("Left side of title", "aventa")  => "left",
                    esc_html__("Right side of title", "aventa") => "right",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Color", "aventa"),
                "param_name"  => "color",
                "value"       => "",
                "description" => "",
            ),
            array(
                "type"        => "vc_number",
                "admin_label" => false,
                "class"       => "",
                "label"       => esc_html__("Active section number", "aventa"),
                "param_name"  => "active_section",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "align",
                "description" => esc_html__("Select alignment", "aventa"),
                "value"       => array(
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Right", "aventa")  => "right",
                ),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Add a Title for your tabs.", "aventa"),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Title font", "aventa"),
                "param_name"       => "font",
                "description"      => esc_html__("Select title font", "aventa"),
                "value"            => $fonts,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "class"            => "",
                "admin_label"      => false,
                "heading"          => esc_html__("Title Type", "aventa"),
                "param_name"       => "type",
                "description"      => esc_html__("Select the heading(h1,h2,h3,h4,h5,h6).", "aventa"),
                "value"            => $headings,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Title font-size", "aventa"),
                "param_name"       => "size",
                "min"              => "20",
                "max"              => "80",
                "step"             => "1",
                "value"            => "20",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Letter Spacing", "aventa"),
                "param_name"  => "letter_spacing",
                "description" => esc_html__("Select a spacing amount for your title.", "aventa"),
                "value"       => array(
                    "0" => "0",
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                    "5" => "5",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* TTA Section
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"                      => esc_html__("Section", "aventa"),
        "base"                      => "rad_tta",
        "category"                  => "Aventa",
        "weight"                    => 9,
        "admin_enqueue_css"         => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"          => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                      => "icon-wpb-tta-section",
        "allowed_container_element" => "vc_row",
        "is_container"              => true,
        "as_child"                  => array(
            "only" => "rad_tab_group,rad_tour_group,rad_accordion_group",
        ),
        "description"               => esc_html__("Section for Tabs, Tours, Accordions.", "aventa"),
        "js_view"                   => "VcBackendTtaSectionView",
        "custom_markup"             => "
            <div class=\"vc_tta-panel-heading\">
                <h4 class=\"vc_tta-panel-title vc_tta-controls-icon-position-left\"><a href=\"javascript:;\" data-vc-target=\"[data-model-id='{{ model_id }}']\" data-vc-accordion data-vc-container=\".vc_tta-container\"><span class=\"vc_tta-title-text\">{{ section_title }}</span><i class=\"vc_tta-controls-icon vc_tta-controls-icon-plus\"></i></a></h4>
            </div>
            <div class=\"vc_tta-panel-body\">
                {{ editor_controls }}
                <div class=\"{{ container-class }}\">
                {{ content }}
                </div>
            </div>",
        "default_content"           => "",
        "params"                    => array(
            array(
                "type"       => "textfield",
                "class"      => "",
                "heading"    => esc_html__("Title", "aventa"),
                "param_name" => "title",
                "value"      => "",
            ),
            array(
                "type"        => "checkbox",
                "class"       => "",
                "heading"     => esc_html__("Add icon?", "aventa"),
                "param_name"  => "add_icon",
                "description" => esc_html__("Checked and select an icon.", "aventa"),
            ),
            array(
                "type"        => "vc_icons",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon", "aventa"),
                "param_name"  => "icon",
                "value"       => "",
                "description" => esc_html__("Select an icon to be located at title", "aventa"),
                "dependency"  => array(
                    "element" => "add_icon",
                    "value"   => "true",
                ),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Slideshow
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"                    => esc_html__("Slideshow", "aventa"),
        "description"             => esc_html__("Design elegant and customizable slideshows", "aventa"),
        "base"                    => "rad_slideshow",
        "category"                => "Aventa",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-slideshow-carousel",
        "as_parent"               => array("only" => "rad_slideshow_item"),
        "is_container"            => true,
        "show_settings_on_create" => false,
        "js_view"                 => "RADBackendTtaSlideshowView",
        "custom_markup"           => "
        <div class=\"vc_tta-container\" data-vc-action=\"collapseAll\">
            <div class=\"vc_general vc_tta vc_tta-accordion vc_tta-color-backend-accordion-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-o-shape-group vc_tta-controls-align-left vc_tta-gap-2\">
               <div class=\"vc_tta-panels vc_clearfix {{container-class}}\">
                  {{ content }}
                  <div class=\"vc_tta-panel vc_tta-section-append\">
                     <div class=\"vc_tta-panel-heading\">
                        <h4 class=\"vc_tta-panel-title vc_tta-controls-icon-position-left\">
                           <a href=\"javascript:;\" aria-expanded=\"false\" class=\"vc_tta-backend-add-control\">
                               <span class=\"vc_tta-title-text\">" . esc_html__("Add item", "aventa") . "</span>
                                <i class=\"vc_tta-controls-icon vc_tta-controls-icon-plus\"></i>
                            </a>
                        </h4>
                     </div>
                  </div>
               </div>
            </div>
        </div>",
        "default_content"         => "
        [rad_slideshow_item title=\"" . esc_html__("Item", "aventa") . "\"][/rad_slideshow_item]
        [rad_slideshow_item title=\"" . esc_html__("Item", "aventa") . "\"][/rad_slideshow_item]
            ",
        "params"                  => array(
            array(
                "type"        => "textfield",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Display title above items", "aventa"),
            ),
            array(
                "type"        => "vc_rangefield",
                "label"       => "px",
                "heading"     => esc_html__("Title font-size", "aventa"),
                "param_name"  => "title_size",
                "min"         => "12",
                "max"         => "60",
                "step"        => "1",
                "value"       => "12",
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Image Size", "aventa"),
                "param_name"  => "image_size",
                "description" => esc_html__("Select image size", "aventa"),
                "value"       => array(
                    esc_html__("Full", "aventa")      => "full",
                    esc_html__("medium", "aventa")    => "medium",
                    esc_html__("thumbnail", "aventa") => "thumbnail",
                    esc_html__("Custom", "aventa")    => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image width", "aventa"),
                "param_name"  => "image_width",
                "value"       => "",
                "description" => esc_html__("Width", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image height", "aventa"),
                "param_name"  => "image_height",
                "value"       => "",
                "description" => esc_html__("Height", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"       => "vc_multiselect",
                "class"      => "custom_image_size",
                "heading"    => esc_html__("image size crop", "aventa"),
                "param_name" => "image_crop",
                "options"    => array("true" => "Crop image"),
                "value"      => "",
                "dependency" => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text Color", "aventa"),
                "param_name"  => "color",
                "value"       => "",
                "description" => esc_html__("Choose color of text", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Background Color", "aventa"),
                "param_name"  => "bg_color",
                "value"       => "",
                "description" => esc_html__("Choose background color", "aventa"),
            ),
        ),
    )
);

vc_map(
    array(
        "name"             => esc_html__("Slideshow item", "aventa"),
        "base"             => "rad_slideshow_item",
        "weight"           => 9,
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-slideshow-item",
        "as_child"         => array(
            "only" => "rad_slideshow",
        ),
        "description"      => esc_html__("Item for slideshow", "aventa"),
        "params"           => array(
            array(
                "type"        => "attach_image",
                "class"       => "",
                "heading"     => esc_html__("Image URL", "aventa"),
                "param_name"  => "img_id",
                "description" => esc_html__("Choose an image.", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
            ),
            array(
                "type"             => "vc_link",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Link", "aventa"),
                "param_name"       => "url",
                "value"            => "",
                "description"      => esc_html__("Optional URL to another web page.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Slideshow
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"                    => esc_html__("Reveal Slideshow", "aventa"),
        "description"             => esc_html__("Create beautiful hassle-free slideshows", "aventa"),
        "base"                    => "rad_reveal_slideshow",
        "category"                => "Aventa",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-reveal-slideshow",
        "show_settings_on_create" => false,
        "params"                  => array(
            array(
                "type"        => "attach_images",
                "class"       => "",
                "heading"     => esc_html__("Images", "aventa"),
                "param_name"  => "ids",
                "value"       => "",
                "description" => esc_html__("Select images from media library.", "aventa"),
            ),
            array(
                "type"        => "vc_rangefield",
                "label"       => "%",
                "heading"     => esc_html__("Height", "aventa"),
                "param_name"  => "height",
                "min"         => "30",
                "max"         => "200",
                "step"        => "1",
                "value"       => "50",
                "description" => "Height calculated based on x% of width(x = your entered value)",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Image Size", "aventa"),
                "param_name"  => "image_size",
                "description" => esc_html__("Select image size", "aventa"),
                "value"       => array(
                    esc_html__("Full", "aventa")      => "full",
                    esc_html__("medium", "aventa")    => "medium",
                    esc_html__("thumbnail", "aventa") => "thumbnail",
                    esc_html__("Custom", "aventa")    => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image width", "aventa"),
                "param_name"  => "image_width",
                "value"       => "",
                "description" => esc_html__("Width", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image height", "aventa"),
                "param_name"  => "image_height",
                "value"       => "",
                "description" => esc_html__("Height", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"       => "vc_multiselect",
                "class"      => "custom_image_size",
                "heading"    => esc_html__("image size crop", "aventa"),
                "param_name" => "image_crop",
                "options"    => array("true" => "Crop image"),
                "value"      => "",
                "dependency" => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Navigation Color", "aventa"),
                "param_name"  => "nv_color",
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
                "description" => esc_html__("Choose color of text", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("pagination Color", "aventa"),
                "param_name"  => "pg_color",
                "value"       => "",
                "description" => esc_html__("Choose background color", "aventa"),
            ),
        ),
    )
);
/*-----------------------------------------------------------------------------------*/
/* Tour
/*-----------------------------------------------------------------------------------*/

vc_remove_element("vc_tta_tour");
vc_map(
    array(
        "name"                    => esc_html__("Tour Block", "aventa"),
        "description"             => esc_html__("Vertically tabbed content", "aventa"),
        "base"                    => "rad_tour_group",
        "category"                => "Aventa",
        "class"                   => "wpb_vc_tta_tabs vc_tta-container",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-tour-group",
        "as_parent"               => array("only" => "rad_tab"),
        //"content_element" => true,
        "is_container"            => true,
        "show_settings_on_create" => false,
        "js_view"                 => "RADBackendTtaTourView",
        "custom_markup"           => "
            <div class=\"vc_tta-container\" data-vc-action=\"collapse\">
            <div class=\"vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-left vc_tta-controls-align-left\">
                <div class=\"vc_tta-tabs-container\">" . "<ul class=\"vc_tta-tabs-list\">" . "<li class=\"vc_tta-tab\" data-vc-tab data-vc-target-model-id=\"{{ model_id }}\"><a href=\"javascript:;\" data-vc-container=\".vc_tta\" data-vc-target=\"[data-model-id='{{ model_id }}']\" data-vc-target-model-id=\"{{ model_id }}\" data-vc-tabs>{{ section_title }}</a></li>" . "</ul>
                </div>
                <div class=\"vc_tta-panels {{container-class}}\">
                  {{ content }}
                </div>
            </div>
        </div>",
        "default_content"         => "
        [rad_tta title=\"" . sprintf("%s %d", esc_html__("Tab", "aventa"), 1) . "\"][/rad_tta]
        [rad_tta title=\"" . sprintf("%s %d", esc_html__("Tab", "aventa"), 2) . "\"][/rad_tta]
            ",
        "admin_enqueue_js"        => array(
            vc_asset_url("lib/vc_tabs/vc-tabs.min.js"),
        ),
        "params"                  => array(
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "value"       => array(
                    esc_html__("hover color", "aventa") => "color",
                    esc_html__("line", "aventa")        => "line",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Color", "aventa"),
                "param_name"  => "color",
                "value"       => "",
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon Position", "aventa"),
                "param_name"  => "icon_position",
                "value"       => array(
                    esc_html__("Right side of title", "aventa") => "right",
                    esc_html__("Left side of title", "aventa")  => "left",

                ),
            ),
            array(
                "type"        => "vc_number",
                "admin_label" => false,
                "class"       => "",
                "label"       => esc_html__("Active section number", "aventa"),
                "param_name"  => "active_section",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "align",
                "description" => esc_html__("Select alignment", "aventa"),
                "value"       => array(
                    esc_html__("Left", "aventa")  => "left",
                    esc_html__("Right", "aventa") => "right",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Single image
/*-----------------------------------------------------------------------------------*/
//Empty_Space - height on responsive mode
vc_add_param("vc_single_image",
    array(
        "type"             => "dropdown",
        "admin_label"      => false,
        "class"            => "",
        "heading"          => esc_html__("Image Animation", "aventa"),
        "param_name"       => "img_animation",
        "description"      => esc_html__("Select animation type for image", "aventa"),
        "value"            => $img_animations,
        "group"            => esc_html__("Animation", "aventa"),
        "edit_field_class" => "vc_col-xs-4",
    )
);

vc_add_param("vc_single_image",
    array(
        "type"             => "textfield",
        "admin_label"      => false,
        "class"            => "",
        "heading"          => esc_html__("Animation Delay", "aventa"),
        "param_name"       => "delay",
        "value"            => "",
        "description"      => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
        "group"            => esc_html__("Animation", "aventa"),
        "edit_field_class" => "vc_col-xs-4",
    )
);

vc_add_param("vc_single_image",
    array(
        "type"             => "vc_multiselect",
        "class"            => "",
        "heading"          => esc_html__("Animation in Responsive", "aventa"),
        "param_name"       => "responsive_animation",
        "options"          => array("disable" => "Disable animation"),
        "value"            => "disable",
        "description"      => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
        "group"            => esc_html__("Animation", "aventa"),
        "edit_field_class" => "vc_col-xs-4",
    )
);

/*-----------------------------------------------------------------------------------*/
/* Empty_Space
/*-----------------------------------------------------------------------------------*/
//Empty_Space - height on responsive mode
vc_add_param("vc_empty_space", array(
    "type"        => "textfield",
    "weight"      => 1,
    "admin_label" => true,
    "heading"     => esc_html__("Height (on mobile & tablet devices)", "aventa"),
    "param_name"  => "responsive_height",
    "description" => esc_html__("Enter empty space height on responsive (Note: CSS measurement units allowed).", "aventa"),
));

vc_remove_param("vc_empty_space", "height");
vc_add_param("vc_empty_space", array(
    "type"        => "textfield",
    "weight"      => 2,
    "admin_label" => true,
    "heading"     => esc_html__("Height (on Desktop)", "aventa"),
    "param_name"  => "height",
    "description" => esc_html__("Enter empty space height (Note: CSS measurement units allowed).", "aventa"),
));

/*-----------------------------------------------------------------------------------*/
/* Row
/*-----------------------------------------------------------------------------------*/

// remove VC default row animation
vc_remove_param("vc_row", "css_animation");

// remove content placement
vc_remove_param("vc_row", "gap");

// remove parallax speed of video
vc_remove_param("vc_row", "parallax_speed_video");

// remove parallax speed of bg
vc_remove_param("vc_row", "parallax_speed_bg");

// remove font color
vc_remove_param("vc_row", "font_color");

// remove margin bottom
vc_remove_param("vc_row", "margin_bottom");

// remove bg color
vc_remove_param("vc_row", "bg_color");

// remove bg image
vc_remove_param("vc_row", "bg_image");

// remove row padding
vc_remove_param("vc_row", "padding");

//remove image repeat Option
vc_remove_param("vc_row", "bg_image_repeat");

//remove css option
vc_remove_param("vc_row", "css");

//remove class option
vc_remove_param("vc_row", "el_class");

//remove full-width option
vc_remove_param("vc_row", "full_width");

//remove parallax option
vc_remove_param("vc_row", "parallax");

//remove parallax image
vc_remove_param("vc_row", "parallax_image");

//remove row id
vc_remove_param("vc_row", "el_id");

//remove row video bg
vc_remove_param("vc_row", "video_bg");

//remove row video bg
vc_remove_param("vc_row", "video_bg_url");

//remove row video bg
vc_remove_param("vc_row", "full_height");

// remove content placement
vc_remove_param("vc_row", "content_placement");

// remove parallax type
vc_remove_param("vc_row", "video_bg_parallax");

// remove parallax type
vc_remove_param("vc_row", "equal_height");

// remove parallax type
vc_remove_param("vc_row", "columns_placement");

$row_setting = array(
    "name"                    => "Row, Parallax, Video",
    "show_settings_on_create" => true,
    "weight"                  => 10,
);
vc_map_update("vc_row", $row_setting);

$space_setting = array(
    "weight" => 10,
);
vc_map_update("vc_empty_space", $space_setting);

$separator_setting = array(
    "show_settings_on_create" => true,
    "controls"                => "",
    "weight"                  => 9,
);
vc_map_update("vc_separator", $separator_setting);

vc_add_param("vc_row", array(
    "type"                    => "dropdown",
    "class"                   => "",
    "holder"                  => "span",
    "show_settings_on_create" => true,
    "heading"                 => esc_html__("Container Type", "aventa"),
    "param_name"              => "row_type",
    "description"             => esc_html__("Choose different types of containers and set the options.", "aventa"),
    "value"                   => array(
        esc_html__("Row", "aventa")            => "row",
        esc_html__("Parallax", "aventa")       => "parallax",
        esc_html__("Mouse parallax", "aventa") => "mouse_parallax",
        esc_html__("Video", "aventa")          => "video",
    ),
));

vc_add_param("vc_row", array(
    "type"        => "vc_multiselect",
    "class"       => "",
    "heading"     => esc_html__("Mute video", "aventa"),
    "param_name"  => "sound",
    "options"     => array("off" => "Mute video"),
    "description" => esc_html__("Mute video of background", "aventa"),
    "value"       => "",
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("video"),
    ),
));

vc_add_param("vc_row", array(
    "type"        => "checkbox",
    "class"       => "",
    "heading"     => esc_html__("Equal height", "aventa"),
    "param_name"  => "equal_height",
    "description" => esc_html__("If checked columns will be set to equal height.", "aventa"),
    "value"       => "",
    "group"       => esc_html__("Inner Columns", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Columns gap", "aventa"),
    "param_name"  => "gap",
    "description" => esc_html__("Select gap between columns in row.", "aventa"),
    "value"       => array(
        "30px - default" => "30",
        "0px"            => "zero",
        "1px"            => "1",
        "5px"            => "5",
        "10px"           => "10",
        "15px"           => "15",
        "20px"           => "20",
        "25px"           => "25",
        "35px"           => "35",
    ),
    "group"       => esc_html__("Inner Columns", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "checkbox",
    "class"       => "",
    "heading"     => esc_html__("Full height", "aventa"),
    "param_name"  => "full_height",
    "description" => esc_html__("If checked row will be set to full height.", "aventa"),
    "value"       => "",
));

vc_add_param("vc_row", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Columns position", "aventa"),
    "param_name"  => "columns_placement",
    "description" => esc_html__("Select columns position within row.", "aventa"),
    "value"       => array(
        esc_html__("Middle", "aventa") => "middle",
        esc_html__("Top", "aventa")    => "top",
        esc_html__("Bottom", "aventa") => "bottom",
    ),
    "dependency"  => array(
        "element"   => "full_height",
        "not_empty" => true,
    ),
));

// row spacing - Padding
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Padding Top", "aventa"),
    "param_name"  => "row_padding_top",
    "description" => esc_html__("insert top padding for current row . example : 200 ", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Padding Bottom", "aventa"),
    "param_name"  => "row_padding_bottom",
    "description" => esc_html__("Insert bottom padding for current row . example : 200", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Padding Right", "aventa"),
    "param_name"  => "row_padding_right",
    "description" => esc_html__("Insert Right padding for current row . example : 200", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Padding Left", "aventa"),
    "param_name"  => "row_padding_left",
    "description" => esc_html__("Insert left padding for current row . example : 200", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

// row spacing - Padding on mobile
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Top Padding on responsive", "aventa"),
    "param_name"  => "row_responsive_padding_top",
    "description" => esc_html__("insert top padding for current row . example : 50 ", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Bottom Padding on responsive", "aventa"),
    "param_name"  => "row_responsive_padding_bottom",
    "description" => esc_html__("Insert bottom padding for current row . example : 50", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Right Padding on responsive", "aventa"),
    "param_name"  => "row_responsive_padding_right",
    "description" => esc_html__("Insert Right padding for current row . example : 50", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Left Padding on responsive", "aventa"),
    "param_name"  => "row_responsive_padding_left",
    "description" => esc_html__("Insert left padding for current row . example : 50", "aventa"),
    "group"       => esc_html__("Padding", "aventa"),
));

// row spacing - margin
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Margin Top", "aventa"),
    "param_name"  => "row_margin_top",
    "description" => esc_html__("Insert top margin for current row . example : 200", "aventa"),
    "group"       => esc_html__("Margin", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Margin Bottom", "aventa"),
    "param_name"  => "row_margin_bottom",
    "description" => esc_html__("Insert bottom margin for current row . example : 200", "aventa"),
    "group"       => esc_html__("Margin", "aventa"),
));

// row spacing - margin on mobile
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Top Margin on responsive", "aventa"),
    "param_name"  => "row_responsive_margin_top",
    "description" => esc_html__("insert top margin for current row . example : 50 ", "aventa"),
    "group"       => esc_html__("Margin", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Bottom Margin on responsive", "aventa"),
    "param_name"  => "row_responsive_margin_bottom",
    "description" => esc_html__("Insert bottom margin for current row . example : 50", "aventa"),
    "group"       => esc_html__("Margin", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Type", "aventa"),
    "param_name"  => "type",
    "description" => esc_html__("Full-width will use all of your screen width, while Boxed will created an invisible box in middle of your screen.", "aventa"),
    "value"       => array(
        esc_html__("Boxed", "aventa")            => "grid",
        esc_html__("Boxed from left", "aventa")  => "left_side_margin",
        esc_html__("Boxed from right", "aventa") => "right_side_margin",
        esc_html__("Full Width", "aventa")       => "full_width",
    ),
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("row"),
    ),
));

//background image
vc_add_param("vc_row", array(
    "type"        => "attach_image",
    "class"       => "",
    "heading"     => esc_html__("Image URL", "aventa"),
    "param_name"  => "background_img_id",
    "description" => esc_html__("Choose an image to be used as this section background.", "aventa"),
    "value"       => "",
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("row", "parallax", "mouse_parallax"),

    ),
));

vc_add_param("vc_row", array(
    "type"        => "dropdown",
    "heading"     => esc_html__("background image position", "aventa"),
    "param_name"  => "background_position",
    "description" => esc_html__("Choose background position for bckground image.", "aventa"),
    "value"       => array(
        esc_html__("Center Center", "aventa") => "center center",
        esc_html__("Center Top", "aventa")    => "center top",
        esc_html__("Center Bottom", "aventa") => "center bottom",
        esc_html__("Left Top", "aventa")      => "left top",
        esc_html__("Left Center", "aventa")   => "left center",
        esc_html__("Left Bottom", "aventa")   => "left bottom",
        esc_html__("Right Top", "aventa")     => "right top",
        esc_html__("Right Center", "aventa")  => "right center",
        esc_html__("Right Bottom", "aventa")  => "right bottom",
    ),
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("parallax", "row"),
    ),
));

//background color
vc_add_param("vc_row", array(
    "type"        => "colorpicker",
    "class"       => "",
    "heading"     => esc_html__("Background Color", "aventa"),
    "param_name"  => "background_color",
    "description" => esc_html__("Choose a color to be used as this section background. Please noticed that background color, has higher priority than background image.", "aventa"),
    "value"       => "",
    "description" => "",
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("row", "expandable", "content_menu"),
    ),
));

// Add min height For row
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Minimum Height", "aventa"),
    "param_name"  => "min_height",
    "description" => esc_html__("Insert minimum height for parallax section . example : 550", "aventa"),
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("parallax", "mouse_parallax"),
    ),
));

// parallax speed
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "class"       => "",
    "heading"     => esc_html__("Parallax Speed", "aventa"),
    "param_name"  => "parallax_speed",
    "description" => esc_html__("parallax speed 0 = page scrolling speed ,parallax speed above 0 = parallax is faster than page scrolling speed. Enter a number between 0 - 100", "aventa"),
    "value"       => "100",
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("parallax"),
    ),
));

// video webm
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "class"       => "",
    "heading"     => "Video background (webm) file url",
    "value"       => "",
    "param_name"  => "video_webm",
    "description" => "",
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("video"),
    ),
));

// video Mp4
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "class"       => "",
    "heading"     => "Video background (mp4) file url",
    "value"       => "",
    "param_name"  => "video_mp4",
    "description" => "",
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("video"),
    ),
));

//Video Preview Image
vc_add_param("vc_row", array(
    "type"        => "attach_image",
    "class"       => "",
    "heading"     => esc_html__("Video Preview Image", "aventa"),
    "param_name"  => "video_image",
    "value"       => "",
    "description" => esc_html__("Enter an image address which will be shown instead of video in tablet and mobile devices. Also it will be shown if the video does not load correctly.", "aventa"),
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("video"),

    ),
));

// video height
vc_add_param("vc_row", array(
    "type"        => "textfield",
    "class"       => "",
    "heading"     => "Video Section Height",
    "value"       => "",
    "param_name"  => "video_height",
    "description" => esc_html__("Use pixels (px). example :  550px", "aventa"),
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("video"),
    ),
));

// Overlay color
vc_add_param("vc_row", array(
    "type"        => "colorpicker",
    "class"       => "",
    "heading"     => esc_html__("Overlay Color", "aventa"),
    "param_name"  => "overlay_color",
    "value"       => "",
    "description" => esc_html__("Select optional overlay color.", "aventa"),
    "dependency"  => array(
        "element" => "row_type",
        "value"   => array("video", "parallax", "mouse_parallax"),
    ),

));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Extra class name", "aventa"),
    "param_name"  => "el_class",
    "description" => esc_html__("Style particular content element differently - add a class name and refer to it in custom CSS.", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Animation", "aventa"),
    "param_name"  => "row_animation",
    "description" => esc_html__("Select animation type", "aventa"),
    "value"       => $animations,
    "group"       => esc_html__("Animation", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "textfield",
    "class"       => "",
    "heading"     => esc_html__("Animation Delay", "aventa"),
    "param_name"  => "row_animation_delay",
    "value"       => "",
    "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
    "group"       => esc_html__("Animation", "aventa"),
));

vc_add_param("vc_row", array(
    "type"        => "vc_multiselect",
    "class"       => "",
    "heading"     => esc_html__("Animation in Responsive", "aventa"),
    "param_name"  => "responsive_animation",
    "options"     => array("disable" => "Disable animation"),
    "value"       => "disable",
    "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
    "group"       => esc_html__("Animation", "aventa"),
));

/*-----------------------------------------------------------------------------------*/
/* VC Column
/*-----------------------------------------------------------------------------------*/
vc_remove_param("vc_column", "css_animation");
vc_add_param("vc_column", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Vertical Position", "aventa"),
    "param_name"  => "vertical_position",
    "description" => esc_html__("Specify the vertical position of the content. ( works only On Equal height row)", "aventa"),
    "value"       => array(
        esc_html__("Top", "aventa")    => "top",
        esc_html__("Middle", "aventa") => "middle",
        esc_html__("Bottom", "aventa") => "bottom",
    ),
));

/*-----------------------------------------------------------------------------------*/
/* VC Column
/*-----------------------------------------------------------------------------------*/

vc_add_param("vc_column_inner", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Vertical Position", "aventa"),
    "param_name"  => "vertical_position",
    "description" => esc_html__("Specify the vertical position of the content. ( works only On Equal height row)", "aventa"),
    "value"       => array(
        esc_html__("Top", "aventa")    => "top",
        esc_html__("Middle", "aventa") => "middle",
        esc_html__("Bottom", "aventa") => "bottom",
    ),
));

/*-----------------------------------------------------------------------------------*/
/*  contact form 7
/*-----------------------------------------------------------------------------------*/

vc_add_param("contact-form-7", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Style", "aventa"),
    "param_name"  => "html_class",
    "description" => esc_html__("Select contact form style.", "aventa"),
    "value"       => array(
        esc_html__("Dark / Left", "aventa")    => "dark_left",
        esc_html__("Dark / Center", "aventa")  => "dark_center",
        esc_html__("Dark / Right", "aventa")   => "dark_right",
        esc_html__("Light / Left", "aventa")   => "light_left",
        esc_html__("Light / Center", "aventa") => "light_center",
        esc_html__("Light / Right", "aventa")  => "light_right",
    ),
));

// remove param title
vc_remove_param("contact-form-7", "title");

/*-----------------------------------------------------------------------------------*/
/* VC block text
/*-----------------------------------------------------------------------------------*/

$column_text_setting = array(
    "weight" => 9,
);
vc_map_update("vc_column_text", $column_text_setting);

vc_remove_param("vc_column_text", "css_animation");
vc_add_param("vc_column_text", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Animation", "aventa"),
    "param_name"  => "text_animation",
    "description" => esc_html__("Select animation type", "aventa"),
    "value"       => $animations,
    "group"       => esc_html__("Animation", "aventa"),
));

vc_add_param("vc_column_text", array(
    "type"        => "textfield",
    "class"       => "",
    "heading"     => esc_html__("Animation Delay", "aventa"),
    "param_name"  => "text_animation_delay",
    "value"       => "",
    "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
    "group"       => esc_html__("Animation", "aventa"),
));

vc_add_param("vc_column_text", array(
    "type"        => "vc_multiselect",
    "class"       => "",
    "heading"     => esc_html__("Animation in Responsive", "aventa"),
    "param_name"  => "responsive_animation",
    "options"     => array("disable" => "Disable animation"),
    "value"       => "disable",
    "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
    "group"       => esc_html__("Animation", "aventa"),
));

/*-----------------------------------------------------------------------------------*/
/* Separator
/*-----------------------------------------------------------------------------------*/

vc_remove_param("vc_separator", "style");
vc_remove_param("vc_separator", "align");
vc_remove_param("vc_separator", "el_width");
vc_remove_param("vc_separator", "el_class");
vc_remove_param("vc_separator", "accent_color");
vc_remove_param("vc_separator", "color");
vc_remove_param("vc_separator", "border_width");
vc_remove_param("vc_separator", "css"); // remove design tab options

vc_add_param("vc_separator", array(
    "type"        => "colorpicker",
    "holder"      => "div",
    "class"       => "",
    "heading"     => esc_html__("Separator Color", "aventa"),
    "param_name"  => "color",
    "value"       => "",
    "description" => esc_html__("Select optional Separator color ", "aventa"),
));

// Separator
vc_add_param("vc_separator", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Separator Size", "aventa"),
    "param_name"  => "size",
    "description" => esc_html__("Choose the size of separator", "aventa"),
    "value"       => array(
        esc_html__("Full Width", "aventa")         => "full",
        esc_html__("Small", "aventa")              => "small",
        esc_html__("Small Center", "aventa")       => "small-center",
        esc_html__("Medium", "aventa")             => "medium",
        esc_html__("Medium Center", "aventa")      => "medium-center",
        esc_html__("Extra Small", "aventa")        => "extra-small",
        esc_html__("Extra Small Center", "aventa") => "extra-small-center",
    ),
));

vc_add_param("vc_separator", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Margin Top", "aventa"),
    "param_name"  => "margin_top",
    "description" => esc_html__("Insert top margin for current separator . example : 200", "aventa"),
    "group"       => esc_html__("Margin", "aventa"),
));

vc_add_param("vc_separator", array(
    "type"        => "textfield",
    "heading"     => esc_html__("Margin Bottom", "aventa"),
    "param_name"  => "margin_bottom",
    "description" => esc_html__("Insert bottom margin for current separator . example : 200", "aventa"),
    "group"       => esc_html__("Margin", "aventa"),
));

vc_add_param("vc_separator", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Border style", "aventa"),
    "param_name"  => "style",
    "description" => esc_html__("Select border style", "aventa"),
    "value"       => array(
        esc_html__("Solid", "aventa")  => "solid",
        esc_html__("Dashed", "aventa") => "dashed",
        esc_html__("Dotted", "aventa") => "dotted",
        esc_html__("Double", "aventa") => "double",
        esc_html__("Groove", "aventa") => "groove",
        esc_html__("Inset", "aventa")  => "inset",
        esc_html__("Outset", "aventa") => "outset",
        esc_html__("Ridge", "aventa")  => "ridge",
    ),
));

vc_add_param("vc_separator", array(
    "type"        => "dropdown",
    "class"       => "",
    "heading"     => esc_html__("Separator Size", "aventa"),
    "param_name"  => "thickness",
    "description" => esc_html__("Select thickness of separator", "aventa"),
    "value"       => array(
        "1px"  => "1",
        "2px"  => "2",
        "3px"  => "3",
        "4px"  => "4",
        "5px"  => "5",
        "6px"  => "6",
        "7px"  => "7",
        "8px"  => "8",
        "9px"  => "9",
        "10px" => "10",
    ),
));

/*-----------------------------------------------------------------------------------*/
/* Title separator
/*-----------------------------------------------------------------------------------*/
vc_remove_element("vc_text_separator");

/*-----------------------------------------------------------------------------------*/
/* toggle
/*-----------------------------------------------------------------------------------*/

vc_remove_element("vc_toggle");
vc_map(
    array(
        "name"                      => esc_html__("Toggle Block", "aventa"),
        "base"                      => "rad_toggle",
        "category"                  => "Aventa",
        "weight"                    => 9,
        "admin_enqueue_css"         => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"          => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                      => "icon-wpb-toggle",
        "allowed_container_element" => "vc_row",
        "is_container"              => true,
        "js_view"                   => "VcColumnView",
        "description"               => esc_html__("Expandable/collapsible block", "aventa"),
        "params"                    => array(
            array(
                "type"       => "textfield",
                "class"      => "",
                "heading"    => esc_html__("Title", "aventa"),
                "param_name" => "title",
                "value"      => "",
            ),
            array(
                "type"        => "checkbox",
                "class"       => "",
                "heading"     => esc_html__("Open?", "aventa"),
                "param_name"  => "open",
                "description" => esc_html__("Checked if you want to be open.", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "align",
                "description" => esc_html__("Select alignment", "aventa"),
                "value"       => array(
                    esc_html__("Left", "aventa")  => "left",
                    esc_html__("Right", "aventa") => "right",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Title Color", "aventa"),
                "param_name"  => "title_color",
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Testimonials
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"                    => esc_html__("Testimonial", "aventa"),
        "description"             => esc_html__("Showcase customers opinion with testimonial", "aventa"),
        "base"                    => "rad_testimonial",
        "category"                => "Aventa",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-testimonial",
        "as_parent"               => array("only" => "rad_testimonial_item"),
        "content_element"         => true,
        "is_container"            => true,
        "show_settings_on_create" => false,
        "js_view"                 => "RADBackendTtaTestimonialView",
        "custom_markup"           => "
        <div class=\"vc_tta-container\" data-vc-action=\"collapseAll\">
            <div class=\"vc_general vc_tta vc_tta-accordion vc_tta-color-backend-accordion-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-o-shape-group vc_tta-controls-align-left vc_tta-gap-2\">
               <div class=\"vc_tta-panels vc_clearfix {{container-class}}\">
                  {{ content }}
                  <div class=\"vc_tta-panel vc_tta-section-append\">
                     <div class=\"vc_tta-panel-heading\">
                        <h4 class=\"vc_tta-panel-title vc_tta-controls-icon-position-left\">
                           <a href=\"javascript:;\" aria-expanded=\"false\" class=\"vc_tta-backend-add-control\">
                               <span class=\"vc_tta-title-text\">" . esc_html__("Add item", "aventa") . "</span>
                                <i class=\"vc_tta-controls-icon vc_tta-controls-icon-plus\"></i>
                            </a>
                        </h4>
                     </div>
                  </div>
               </div>
            </div>
        </div>",
        "default_content"         => "
        [rad_testimonial_item author=\"" . esc_html__("John doe", "aventa") . "\"][/rad_testimonial_item]
        [rad_testimonial_item author=\"" . esc_html__("John doe", "aventa") . "\"][/rad_testimonial_item]
        ",
        "params"                  => array(
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "description" => esc_html__("Select testimonial style.", "aventa"),
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("column", "aventa"),
                "param_name"  => "visible_items",
                "description" => esc_html__("Number of visible items", "aventa"),
                "value"       => array(
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

vc_map(
    array(
        "name"              => esc_html__("Testimonial Item", "aventa"),
        "base"              => "rad_testimonial_item",
        "category"          => "Aventa",
        "weight"            => 9,
        "admin_enqueue_css" => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"  => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"              => "icon-wpb-testimonial-item",
        "as_child"          => array("only" => "rad_testimonial"),
        "params"            => array(
            array(
                "type"        => "attach_image",
                "class"       => "",
                "heading"     => esc_html__("Image URL", "aventa"),
                "param_name"  => "image_url",
                "value"       => "",
                "description" => esc_html__("URL of the image", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Name", "aventa"),
                "param_name"  => "author",
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Job", "aventa"),
                "param_name"  => "job",
            ),
            array(
                "type"        => "textarea",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Statement", "aventa"),
                "param_name"  => "text",
                "description" => esc_html__("Type down the statement.", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Horizontal progress bar
/*-----------------------------------------------------------------------------------*/

vc_map(array(
    "name"             => esc_html__("Progress Bar", "aventa"),
    "description"      => esc_html__("Visual way to show off your skills", "aventa"),
    "base"             => "rad_progressbar",
    "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
    "icon"             => "icon-wpb-progressbar",
    "category"         => "Aventa",
    "weight"           => 9,
    "params"           => array(
        array(
            "type"        => "textfield",
            "holder"      => "div",
            "class"       => "",
            "heading"     => esc_html__("Title", "aventa"),
            "param_name"  => "title",
            "value"       => "",
            "description" => "",
        ),
        array(
            "type"        => "colorpicker",
            "class"       => "",
            "heading"     => esc_html__("Title Color", "aventa"),
            "param_name"  => "title_color",
            "description" => "",
        ),
        array(
            "type"        => "textfield",
            "class"       => "",
            "heading"     => esc_html__("Percentage", "aventa"),
            "param_name"  => "percent",
            "value"       => "",
            "description" => esc_html__("For example if you want to enter 85% just enter 85 .", "aventa"),
        ),
        array(
            "type"        => "colorpicker",
            "class"       => "",
            "heading"     => esc_html__("Active Background Color", "aventa"),
            "param_name"  => "fill_color",
            "description" => "",
        ),
        array(
            "type"        => "colorpicker",
            "class"       => "",
            "heading"     => esc_html__("Inactive Background Color", "aventa"),
            "param_name"  => "bar_color",
            "description" => "",
        ),
        array(
            "type"        => "dropdown",
            "class"       => "",
            "heading"     => esc_html__("Animation", "aventa"),
            "param_name"  => "animation",
            "description" => esc_html__("Select animation type", "aventa"),
            "value"       => $animations,
            "group"       => esc_html__("Animation", "aventa"),
        ),
        array(
            "type"        => "textfield",
            "class"       => "",
            "heading"     => esc_html__("Animation Delay", "aventa"),
            "param_name"  => "delay",
            "value"       => "",
            "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
            "group"       => esc_html__("Animation", "aventa"),
        ),
        array(
            "type"        => "vc_multiselect",
            "class"       => "",
            "heading"     => esc_html__("Animation in Responsive", "aventa"),
            "param_name"  => "responsive_animation",
            "options"     => array("disable" => "Disable animation"),
            "value"       => "disable",
            "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
            "group"       => esc_html__("Animation", "aventa"),
        ),
    ),
));

/*-----------------------------------------------------------------------------------*/
/* SoundCloud
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("SoundCloud", "aventa"),
        "description"      => esc_html__("Embed audio clips from SoundCloud", "aventa"),
        "base"             => "rad_audio",
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-soundcloud",
        "weight"           => 9,
        "params"           => array(
            array(
                "type"        => "textfield",
                "holder"      => "",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("SoundCloud URL", "aventa"),
                "param_name"  => "soundcloud_id",
                "value"       => "",
                "description" => esc_html__("Enter SoundCloud track URL here", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("SoundCloud Player Style", "aventa"),
                "param_name"  => "soundcloud_style",
                "value"       => array(
                    esc_html__("Full background album art", "aventa") => "full_width_thumbnail",
                    esc_html__("Thumbnail album art", "aventa")       => "small_thumbnail",
                ),
                "description" => esc_html__("Choose a style for SoundCloud element.", "aventa"),
            ),

            array(
                "type"        => "textfield",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("SoundCloud Player Height", "aventa"),
                "param_name"  => "soundcloud_height",
                "value"       => "",
                "description" => esc_html__("Enter SoundCloud height, for example 300.", "aventa"),
                "dependency"  => array(
                    "element" => "soundcloud_style",
                    "value"   => "full_width_thumbnail",
                ),
            ), array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Player Color", "aventa"),
                "param_name"  => "soundcloud_color",
                "description" => "",
                "dependency"  => array(
                    "element" => "soundcloud_style",
                    "value"   => "small_thumbnail",
                ),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Embed Video
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Embed Video", "aventa"),
        "description"      => esc_html__("Embed video from internal/external sources", "aventa"),
        "base"             => "rad_video",
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-embed_video",
        "weight"           => 9,
        "params"           => array(
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Video Display Type", "aventa"),
                "param_name"  => "video_display_type",
                "value"       => array(
                    esc_html__("local Video", "aventa")                       => "local_video",
                    esc_html__("Embedded Video (Youtube)", "aventa")          => "embeded_video_youtube",
                    esc_html__("Embedded Video (Vimeo)", "aventa")            => "embeded_video_vimeo",
                    esc_html__("Local Video Popup", "aventa")                 => "local_video_popup",
                    esc_html__("Embedded Video  ( Youtube Popup )", "aventa") => "embeded_video_youtube_popup",
                    esc_html__("Embedded Video ( Vimeo Popup )", "aventa")    => "embeded_video_vimeo_popup",
                ),
                "description" => esc_html__("Select video type.", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Play Button Alignment", "aventa"),
                "param_name"  => "alignment",
                "description" => esc_html__("Select Video Play Button alignment.", "aventa"),
                "value"       => array(
                    esc_html__("center", "aventa") => "center",
                    esc_html__("left", "aventa")   => "left",
                    esc_html__("right", "aventa")  => "right",
                ),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video_popup", "embeded_video_youtube_popup", "embeded_video_vimeo_popup"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "heading"     => esc_html__("Video Aspect Ratio", "aventa"),
                "param_name"  => "el_aspect",
                "value"       => array(
                    "16:9"   => "169",
                    "4:3"    => "43",
                    "2.35:1" => "235",
                ),
                "description" => esc_html__("Select video aspect ratio.", "aventa"),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("embeded_video_youtube", "embeded_video_vimeo"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Auto-play", "aventa"),
                "param_name"  => "video_autoplay",
                "value"       => array(
                    esc_html__("Enable", "aventa")  => "enable",
                    esc_html__("Disable", "aventa") => "disable",
                ),
                "description" => esc_html__("Enable or disable video auto-play.", "aventa"),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup", "embeded_video_youtube_popup", "embeded_video_vimeo_popup"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Loop", "aventa"),
                "param_name"  => "loop",
                "value"       => array(
                    esc_html__("Disable", "aventa") => "no",
                    esc_html__("Enable", "aventa")  => "yes",
                ),
                "description" => esc_html__("Enable or disable video loop.", "aventa"),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup"),
                ),
            ),
            array(
                "type"        => "attach_image",
                "class"       => "",
                "heading"     => esc_html__("Video Poster Image", "aventa"),
                "param_name"  => "video_poster_image",
                "description" => "This image will bw shown while the video is loading.",
                "admin_label" => false,
                "value"       => "",
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup"),
                ),
            ),
            array(
                "type"        => "attach_image",
                "class"       => "",
                "heading"     => esc_html__("Video Cover Image", "aventa"),
                "param_name"  => "video_background_image",
                "description" => "Cover image of video shortcode(Optional).",
                "value"       => "",
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video_popup", "embeded_video_youtube_popup", "embeded_video_vimeo_popup"),
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Self Hosted Video (.webm video type)", "aventa"),
                "param_name"  => "video_webm",
                "value"       => "",
                "admin_label" => false,
                "description" => "Please provide a URL to all of the video types",
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup"),
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Self Hosted Video (.mp4 video type)", "aventa"),
                "param_name"  => "video_mp4",
                "value"       => "",
                "admin_label" => false,
                "description" => esc_html__("Please provide a URL to all of the video types", "aventa"),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup"),
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Self Hosted Video (.ogv video type)", "aventa"),
                "param_name"  => "video_ogv",
                "value"       => "",
                "admin_label" => false,
                "description" => esc_html__("Please provide a URL to all of the video types", "aventa"),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Video Play Button Color", "aventa"),
                "param_name"  => "video_play_button_color",
                "description" => esc_html__("Select play button style.", "aventa"),
                "value"       => array(
                    esc_html__("Light", "aventa") => "light",
                    esc_html__("Dark", "aventa")  => "dark",
                ),
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("local_video", "local_video_popup", "embeded_video_youtube_popup", "embeded_video_vimeo_popup"),
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Vimoe Video URL", "aventa"),
                "param_name"  => "video_vimeo_id",
                "value"       => "",
                "admin_label" => false,
                "description" => "Enter vimeo video URL",
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("embeded_video_vimeo", "embeded_video_vimeo_popup"),
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("YouTube Video URL", "aventa"),
                "param_name"  => "video_youtube_id",
                "value"       => "",
                "admin_label" => false,
                "description" => "Enter YouTube video URL",
                "dependency"  => array(
                    "element" => "video_display_type",
                    "value"   => array("embeded_video_youtube", "embeded_video_youtube_popup"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Image Box
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"             => esc_html__("Banner", "aventa"),
        "description"      => esc_html__("Make impressive special announcements", "aventa"),
        "base"             => "rad_banner",
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-banner",
        "weight"           => 9,
        "params"           => array(
            array(
                "type"        => "vc_imageselect",
                "admin_label" => false,
                "heading"     => esc_html__("Banner Type", "aventa"),
                "param_name"  => "banner_type",
                "value"       => array(
                    "general"  => "general",
                    "hover"    => "hover",
                    "creative" => "creative",
                ),
                "description" => "",
            ),
            array(
                "type"             => "attach_image",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Image", "aventa"),
                "param_name"       => "image",
                "value"            => "",
                "description"      => esc_html__("URL of the image", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "attach_image",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Second Image", "aventa"),
                "param_name"       => "image2",
                "value"            => "",
                "description"      => esc_html__("URL of the second image", "aventa"),
                "dependency"       => array(
                    "element" => "banner_type",
                    "value"   => array("creative"),
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "textarea",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Title", "aventa"),
                "param_name"       => "title",
                "value"            => "",
                "description"      => esc_html__("Enter title text", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "textarea",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Subtitle", "aventa"),
                "param_name"       => "subtitle",
                "value"            => "",
                "description"      => esc_html__("Enter subtitle text", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "textarea",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text", "aventa"),
                "param_name"  => "text",
                "value"       => "",
                "description" => esc_html__("Enter your text here", "aventa"),
            ),
            array(
                "type"             => "dropdown",
                "class"            => "",
                "admin_label"      => false,
                "heading"          => esc_html__("Title Type", "aventa"),
                "param_name"       => "title_type",
                "description"      => esc_html__("Select the heading(h1,h2,h3,h4,h5,h6).", "aventa"),
                "value"            => $headings,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Title font-size", "aventa"),
                "param_name"       => "title_size",
                "min"              => "10",
                "max"              => "80",
                "step"             => "1",
                "value"            => "20",
                "description"      => "",
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Subtitle font-size", "aventa"),
                "param_name"       => "subtitle_size",
                "min"              => "10",
                "max"              => "40",
                "step"             => "1",
                "value"            => "15",
                "description"      => "",
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Content font-size", "aventa"),
                "param_name"       => "content_size",
                "min"              => "10",
                "max"              => "40",
                "step"             => "1",
                "value"            => "15",
                "description"      => "",
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text Color", "aventa"),
                "param_name"       => "color",
                "value"            => "",
                "description"      => esc_html__("Select optional text color.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("link Color", "aventa"),
                "param_name"       => "link_color",
                "value"            => "",
                "description"      => esc_html__("Select optional color for link.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Hover background color", "aventa"),
                "param_name"       => "hover_bg",
                "value"            => "",
                "dependency"       => array(
                    "element" => "banner_type",
                    "value"   => array("hover"),
                ),
                "description"      => esc_html__("Select optional text color.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("title font", "aventa"),
                "param_name"       => "title_font",
                "description"      => esc_html__("Select title font", "aventa"),
                "value"            => $fonts,
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("subtitle font", "aventa"),
                "param_name"       => "subtitle_font",
                "description"      => esc_html__("Select subtitle font", "aventa"),
                "value"            => $fonts,
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Content font", "aventa"),
                "param_name"       => "content_font",
                "description"      => esc_html__("Select content font", "aventa"),
                "value"            => $fonts,
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text Align", "aventa"),
                "param_name"       => "align",
                "description"      => esc_html__("Select text align", "aventa"),
                "value"            => array(
                    esc_html__("Left", "aventa")  => "left",
                    esc_html__("Right", "aventa") => "right",
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_link",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Link", "aventa"),
                "param_name"       => "url",
                "value"            => "",
                "description"      => esc_html__("Optional URL to another web page.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Animation", "aventa"),
                "param_name"       => "animation",
                "description"      => esc_html__("Select animation type", "aventa"),
                "value"            => $animations,
                "group"            => esc_html__("Animation", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Image Animation", "aventa"),
                "param_name"       => "img_animation",
                "description"      => esc_html__("Select animation type for image", "aventa"),
                "value"            => $img_animations,
                "group"            => esc_html__("Animation", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "textfield",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Animation Delay", "aventa"),
                "param_name"       => "delay",
                "value"            => "",
                "description"      => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"            => esc_html__("Animation", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_multiselect",
                "class"            => "",
                "heading"          => esc_html__("Animation in Responsive", "aventa"),
                "param_name"       => "responsive_animation",
                "options"          => array("disable" => "Disable animation"),
                "value"            => "disable",
                "description"      => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"            => esc_html__("Animation", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
        ),
    )
);
/*-----------------------------------------------------------------------------------*/
/* Animated Text
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"             => esc_html__("Advance Marquee", "aventa"),
        "description"      => esc_html__("Animate text horizontally", "aventa"),
        "base"             => "rad_marquee",
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-marquee",
        "weight"           => 9,
        "params"           => array(
            array(
                "type"        => "textarea",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Enter title", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Styles", "aventa"),
                "param_name"  => "style",
                "description" => esc_html__("Select one of styles.", "aventa"),
                "value"       => array(
                    esc_html__("Animated text", "aventa")                       => "simple",
                    esc_html__("Animated text with Image background", "aventa") => "image",
                ),
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Image URL", "aventa"),
                "param_name"  => "image",
                "value"       => "",
                "description" => esc_html__("URL of the image", "aventa"),
                "dependency"  => array(
                    "element"            => "style",
                    "value_not_equal_to" => "simple",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Front text color", "aventa"),
                "param_name"  => "front_color",
                "value"       => "",
                "description" => esc_html__("Select a color for your front text.", "aventa"),
                "dependency"  => array(
                    "element"            => "style",
                    "value_not_equal_to" => "simple",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text color", "aventa"),
                "param_name"  => "back_color",
                "value"       => "",
                "description" => esc_html__("Select a color for your main text.", "aventa"),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Font", "aventa"),
                "param_name"       => "font",
                "description"      => esc_html__("Select font", "aventa"),
                "value"            => $fonts,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "unit",
                "heading"          => esc_html__("Size", "aventa"),
                "description"      => esc_html__("It is a value between 1 to 30.", "aventa"),
                "param_name"       => "size",
                "min"              => "1",
                "max"              => "30",
                "step"             => "1",
                "value"            => "30",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation duration", "aventa"),
                "param_name"  => "speed",
                "description" => esc_html__("Select one of available options.", "aventa"),
                "value"       => array(
                    esc_html__("Faster", "aventa") => "4",
                    esc_html__("Fast", "aventa")   => "8",
                    esc_html__("Medium", "aventa") => "12",
                    esc_html__("Slow", "aventa")   => "16",
                    esc_html__("Slower", "aventa") => "20",
                ),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Custom Heading
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Custom Heading", "aventa"),
        "description"      => esc_html__("Heading with icon/text background", "aventa"),
        "base"             => "rad_custom_heading",
        "category"         => "Aventa",
        "weight"           => 10,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-custom-heading",
        "params"           => array(
            array(
                "type"        => "textarea",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Enter title text", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "alignment",
                "description" => esc_html__("Select alignment of the heading.", "aventa"),
                "value"       => array(
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Center", "aventa") => "center",
                ),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("title font", "aventa"),
                "param_name"       => "font",
                "description"      => esc_html__("Select title font", "aventa"),
                "value"            => $fonts,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "class"            => "",
                "admin_label"      => false,
                "heading"          => esc_html__("Title Type", "aventa"),
                "param_name"       => "type",
                "description"      => esc_html__("Select the heading(h1,h2,h3,h4,h5,h6).", "aventa"),
                "value"            => $headings,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Title font-size", "aventa"),
                "param_name"       => "size",
                "min"              => "20",
                "max"              => "80",
                "step"             => "1",
                "value"            => "20",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Title color ", "aventa"),
                "param_name"  => "color",
                "value"       => "",
                "description" => esc_html__("Select optional title color ", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Letter Spacing", "aventa"),
                "param_name"  => "letter_spacing",
                "description" => esc_html__("Select a spacing amount for your title.", "aventa"),
                "value"       => array(
                    "0" => "0",
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                    "5" => "5",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title Background Style", "aventa"),
                "param_name"  => "background_style",
                "description" => esc_html__("Select a style for your title background.", "aventa"),
                "value"       => array(
                    esc_html__("Icon in Background", "aventa") => "icon",
                    esc_html__("text in Background", "aventa") => "text",
                ),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Background Title", "aventa"),
                "param_name"  => "bg_title",
                "value"       => "",
                "description" => esc_html__("Enter title background text", "aventa"),
                "dependency"  => array(
                    "element" => "background_style",
                    "value"   => "text",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Background title color", "aventa"),
                "param_name"  => "bg_color",
                "value"       => "",
                "description" => esc_html__("Select optional background color", "aventa"),
            ),
            array(
                "type"        => "vc_icons",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon", "aventa"),
                "param_name"  => "icon",
                "value"       => "",
                "description" => esc_html__("Select an icon to be located at title background", "aventa"),
                "dependency"  => array(
                    "element" => "background_style",
                    "value"   => "icon",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Custom Heading
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Heading", "aventa"),
        "description"      => esc_html__("Line-styled heading with subtitles", "aventa"),
        "base"             => "rad_heading",
        "category"         => "Aventa",
        "weight"           => 10,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-custom-heading",
        "params"           => array(
            array(
                "type"        => "textarea",
                "class"       => "",
                "admin_label" => true,
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Enter title text", "aventa"),
            ),
            array(
                "type"        => "textarea",
                "heading"     => esc_html__("Subtitle 1", "aventa"),
                "param_name"  => "subtitle1",
                "value"       => "",
                "description" => esc_html__("Enter subtitle-1 text", "aventa"),
            ),
            array(
                "type"        => "textarea",
                "heading"     => esc_html__("Subtitle 2", "aventa"),
                "param_name"  => "subtitle2",
                "value"       => "",
                "description" => esc_html__("Enter subtitle-2 text", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "heading"     => esc_html__("Subtitle options", "aventa"),
                "param_name"  => "options",
                "description" => esc_html__("Select subtitle options.", "aventa"),
                "value"       => array(
                    esc_html__("Simple", "aventa")               => "simple",
                    esc_html__("Subtitle 1 with line", "aventa") => "with-line sub1-line",
                    esc_html__("Subtitle 2 with line", "aventa") => "with-line sub2-line",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "alignment",
                "description" => esc_html__("Select alignment of the heading.", "aventa"),
                "value"       => array(
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Right", "aventa")  => "right",
                ),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Title font", "aventa"),
                "param_name"       => "title_font",
                "description"      => esc_html__("Select title font", "aventa"),
                "value"            => $fonts,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Subtitles font", "aventa"),
                "param_name"       => "subs_font",
                "description"      => esc_html__("Select subtitles font", "aventa"),
                "value"            => $fonts,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "class"            => "",
                "admin_label"      => false,
                "heading"          => esc_html__("Title Type", "aventa"),
                "param_name"       => "type",
                "description"      => esc_html__("Select the heading(h1,h2,h3,h4,h5,h6).", "aventa"),
                "value"            => $headings,
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Title font-size", "aventa"),
                "param_name"       => "title_size",
                "min"              => "20",
                "max"              => "80",
                "step"             => "1",
                "value"            => "28",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Subtitle-1 font-size", "aventa"),
                "param_name"       => "sub1_size",
                "min"              => "10",
                "max"              => "30",
                "step"             => "1",
                "value"            => "15",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Subtitle-2 font-size", "aventa"),
                "param_name"       => "sub2_size",
                "min"              => "10",
                "max"              => "30",
                "step"             => "1",
                "value"            => "15",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Title color ", "aventa"),
                "param_name"  => "title_color",
                "value"       => "",
                "description" => esc_html__("Select optional color of title", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Subtitle-1 color ", "aventa"),
                "param_name"  => "sub1_color",
                "value"       => "",
                "description" => esc_html__("Select optional color of subtitle1", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "class"       => "",
                "heading"     => esc_html__("Subtitle-2 color ", "aventa"),
                "param_name"  => "sub2_color",
                "value"       => "",
                "description" => esc_html__("Select optional color of subtitle2", "aventa"),
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Title Letter Spacing", "aventa"),
                "param_name"       => "title_letter_spacing",
                "min"              => "0",
                "max"              => "5",
                "step"             => "1",
                "value"            => "0",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Subtitle 1 Letter Spacing", "aventa"),
                "param_name"       => "sub1_letter_spacing",
                "min"              => "0",
                "max"              => "5",
                "step"             => "1",
                "value"            => "2",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "vc_rangefield",
                "label"            => "px",
                "heading"          => esc_html__("Subtitle 2 Letter Spacing", "aventa"),
                "param_name"       => "sub2_letter_spacing",
                "min"              => "0",
                "max"              => "5",
                "step"             => "1",
                "value"            => "2",
                "description"      => "",
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Icon Box top circle
/*-----------------------------------------------------------------------------------*/
vc_map(
    array(
        "name"             => esc_html__("Icon Block", "aventa"),
        "description"      => esc_html__("Icon block with a title, and description", "aventa"),
        "base"             => "rad_icon_block",
        "category"         => "Aventa",
        "weight"           => 8,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-icon-block",
        "params"           => array(
            array(
                "type"       => "dropdown",
                "class"      => "icon_position",
                "heading"    => esc_html__("Icon position", "aventa"),
                "param_name" => "position",
                "value"      => array(
                    esc_html__("Top", "aventa")   => "top",
                    esc_html__("Left", "aventa")  => "left",
                    esc_html__("Right", "aventa") => "right",
                ),
            ),
            array(
                "type"       => "dropdown",
                "class"      => "alignment",
                "heading"    => esc_html__("Alignment ", "aventa"),
                "param_name" => "alignment",
                "value"      => array(
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Right", "aventa")  => "right",
                ),
                "dependency" => array(
                    "element" => "position",
                    "value"   => "top",
                ),
            ),
            array(
                "type"        => "vc_icons",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon", "aventa"),
                "param_name"  => "icon",
                "value"       => "",
                "description" => esc_html__("Select an icon to be located at the top of the box.", "aventa"),
            ),
            array(
                "type"       => "vc_rangefield",
                "label"      => "px",
                "heading"    => esc_html__("Icon size(px)", "aventa"),
                "param_name" => "size",
                "min"        => "15",
                "max"        => "150",
                "step"       => "1",
                "value"      => "40",
            ),
            array(
                "type"       => "vc_rangefield",
                "label"      => "px",
                "heading"    => esc_html__("Icon roundness", "aventa"),
                "param_name" => "roundness",
                "min"        => "0",
                "max"        => "100",
                "step"       => "1",
                "value"      => "0",
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Enter title text", "aventa"),
            ),
            array(
                "type"        => "textarea",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text", "aventa"),
                "param_name"  => "text",
                "value"       => "",
                "description" => esc_html__("Enter some text for your icon block.", "aventa"),
            ),
            array(
                "type"       => "vc_rangefield",
                "label"      => "px",
                "heading"    => esc_html__("Title font size(px)", "aventa"),
                "param_name" => "title_size",
                "min"        => "15",
                "max"        => "70",
                "step"       => "1",
                "value"      => "20",
            ),
            array(
                "type"       => "vc_rangefield",
                "label"      => "px",
                "heading"    => esc_html__("Text font size(px)", "aventa"),
                "param_name" => "text_size",
                "min"        => "10",
                "max"        => "70",
                "step"       => "1",
                "value"      => "14",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Title font", "aventa"),
                "param_name"       => "title_font",
                "description"      => esc_html__("Select title font", "aventa"),
                "value"            => $fonts,
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text font", "aventa"),
                "param_name"       => "text_font",
                "description"      => esc_html__("Select text font", "aventa"),
                "value"            => $fonts,
                "group"            => esc_html__("Custom style", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title Color ", "aventa"),
                "param_name"  => "title_color",
                "value"       => "",
                "description" => esc_html__("Select optional title color.", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("text Color", "aventa"),
                "param_name"  => "text_color",
                "value"       => "",
                "description" => esc_html__("Select optional content color", "aventa"),
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Icon Color", "aventa"),
                "param_name"       => "icon_color",
                "value"            => "",
                "description"      => esc_html__("Select optional icon color.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Icon bg Color", "aventa"),
                "param_name"       => "icon_bg_color",
                "value"            => "",
                "description"      => esc_html__("Select optional background color of icon.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Icon Border Color", "aventa"),
                "param_name"       => "icon_border_color",
                "value"            => "",
                "description"      => esc_html__("Select optional icon border color.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Icon color on hover", "aventa"),
                "param_name"       => "icon_hover_color",
                "value"            => "",
                "description"      => esc_html__("Select optional icon color.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Icon bg color on hover", "aventa"),
                "param_name"       => "icon_hover_bg_color",
                "value"            => "",
                "description"      => esc_html__("Select optional background color of icon.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Icon border color on hover", "aventa"),
                "param_name"       => "icon_hover_border_color",
                "value"            => "",
                "description"      => esc_html__("Select optional icon border color.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select an animation for Icon box.", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Social icon
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Social Icons", "aventa"),
        "description"      => esc_html__("Link to all your social media profiles", "aventa"),
        "base"             => "rad_socials",
        "category"         => "Aventa",
        "weight"           => 8,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-social",
        "params"           => array(
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Type", "aventa"),
                "param_name"  => "type",
                "description" => esc_html__("Select icon/text style.", "aventa"),
                "value"       => array(
                    esc_html__("Icon", "aventa") => "icon",
                    esc_html__("Text", "aventa") => "text",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "description" => esc_html__("Select dark/light style.", "aventa"),
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
            ),
            array(
                "type"       => "dropdown",
                "heading"    => esc_html__("Direction", "aventa"),
                "param_name" => "direction",
                "value"      => array(
                    esc_html__("Horizontal", "aventa") => "horizontal",
                    esc_html__("Vertical", "aventa")   => "vertical",
                ),
            ),
            array(
                "type"       => "dropdown",
                "heading"    => esc_html__("Have Background ?", "aventa"),
                "param_name" => "background",
                "value"      => array(
                    esc_html__("No", "aventa")  => "no",
                    esc_html__("Yes", "aventa") => "yes",
                ),
                "dependency" => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Instagram URL", "aventa"),
                "param_name" => "instagram",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Facebook URL", "aventa"),
                "param_name" => "facebook",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Twitter URL", "aventa"),
                "param_name" => "twitter",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Vimeo URL", "aventa"),
                "param_name" => "vimeo",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("YouTube URL", "aventa"),
                "param_name" => "youtube",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Google+ URL", "aventa"),
                "param_name" => "google",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Dribbble URL", "aventa"),
                "param_name" => "dribbble",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Tumblr URL", "aventa"),
                "param_name" => "tumblr",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Linkedin URL", "aventa"),
                "param_name" => "linkedin",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Flickr URL", "aventa"),
                "param_name" => "flickr",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Github URL", "aventa"),
                "param_name" => "github",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Last.fm URL", "aventa"),
                "param_name" => "lastfm",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Paypal URL", "aventa"),
                "param_name" => "paypal",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("RSS URL", "aventa"),
                "param_name" => "feed",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Skype URL", "aventa"),
                "param_name" => "skype",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("WordPress URL", "aventa"),
                "param_name" => "wordpress",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Yahoo URL", "aventa"),
                "param_name" => "yahoo",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Steam URL", "aventa"),
                "param_name" => "steam",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Reddit URL", "aventa"),
                "param_name" => "reddit",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("StumbleUpon URL", "aventa"),
                "param_name" => "stumbleupon",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Pinterest URL", "aventa"),
                "param_name" => "pinterest",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("DeviantArt URL", "aventa"),
                "param_name" => "deviantart",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Xing URL", "aventa"),
                "param_name" => "xing",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Blogger URL", "aventa"),
                "param_name" => "blogger",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("SoundCloud URL", "aventa"),
                "param_name" => "soundcloud",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Delicious URL", "aventa"),
                "param_name" => "delicious",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Foursquare URL", "aventa"),
                "param_name" => "foursquare",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Behance URL", "aventa"),
                "param_name" => "behance",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 1-URL", "aventa"),
                "param_name" => "custom1",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 1-name", "aventa"),
                "param_name" => "custom1_name",
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom social 1-image", "aventa"),
                "param_name"  => "custom1_image",
                "description" => esc_html__("Choose an image to be used as social icon logo. ( best size : 20px * 25px ) ", "aventa"),
                "value"       => "",
                "dependency"  => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 2-URL", "aventa"),
                "param_name" => "custom2",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 2-name", "aventa"),
                "param_name" => "custom2_name",
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom social 2-image", "aventa"),
                "param_name"  => "custom2_image",
                "description" => esc_html__("Choose an image to be used as social icon logo. ( best size : 20px * 25px ) ", "aventa"),
                "value"       => "",
                "dependency"  => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 3-URL", "aventa"),
                "param_name" => "custom3",
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 3-name", "aventa"),
                "param_name" => "custom3_name",
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom social 3-image", "aventa"),
                "param_name"  => "custom3_image",
                "description" => esc_html__("Choose an image to be used as social icon logo. ( best size : 20px * 25px ) ", "aventa"),
                "value"       => "",
                "dependency"  => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/*  Count Down
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Count Down", "aventa"),
        "description"      => esc_html__("Countdown timer for limited-time offers, or events", "aventa"),
        "base"             => "rad_countdown",
        "category"         => "Aventa",
        "weight"           => 8,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-coundown",
        "params"           => array(
            array(
                "type"        => "vc_date",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("count to", "aventa"),
                "param_name"  => "end_date",
                "value"       => "",
                "description" => esc_html__("Enter the final date. Format : Month/Day/Year, Hour:Minute AM-PM. Notes that the entered date must be greater than current date!", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Color", "aventa"),
                "param_name"  => "color",
                "description" => esc_html__("Choose the color of numbers", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Label Color", "aventa"),
                "param_name"  => "label_color",
                "description" => esc_html__("Choose the color of labels", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("countdown Font Size", "aventa"),
                "param_name"  => "fontsize",
                "description" => esc_html__("Select the font size of the countdown.", "aventa"),
                "value"       => $contdownFontSize,
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Alignment", "aventa"),
                "param_name"  => "alignment",
                "description" => esc_html__("Select alignment of the countdown.", "aventa"),
                "value"       => array(
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Center", "aventa") => "center",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select entrance animation", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),

        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Counter Box
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Counter Block", "aventa"),
        "description"      => esc_html__("Animated number counter", "aventa"),
        "base"             => "rad_counter",
        "category"         => "Aventa",
        "weight"           => 8,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-counter-block",
        "params"           => array(
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Number", "aventa"),
                "param_name"  => "number",
                "value"       => "",
                "description" => esc_html__("Enter the number that is going to be shown in counter", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Enter a title", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Description", "aventa"),
                "param_name"  => "description",
                "value"       => "",
                "description" => esc_html__("Enter a description text", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Number Color", "aventa"),
                "param_name"  => "number_color",
                "value"       => "",
                "description" => esc_html__("Select optional color of number", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title Color", "aventa"),
                "param_name"  => "title_color",
                "value"       => "",
                "description" => esc_html__("Select optional color of title", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text Color", "aventa"),
                "param_name"  => "text_color",
                "value"       => "",
                "description" => esc_html__("Select optional color of text", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select counter animation", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/*  Piechart
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Chart", "aventa"),
        "description"      => esc_html__("Display data in a creative way", "aventa"),
        "base"             => "rad_chart",
        "category"         => "Aventa",
        "weight"           => 9,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-chart",

        "params"           => array(
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Pie Chart Progress Percentage", "aventa"),
                "param_name"  => "percent",
                "value"       => "",
                "description" => esc_html__("Enter the number that shows your progress in related skill here.", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Pie Chart Percentage visibility", "aventa"),
                "param_name"  => "percent_display",
                "value"       => array(
                    esc_html__("Enable", "aventa")  => "enable",
                    esc_html__("Disable", "aventa") => "disable",
                ),
                "description" => esc_html__("You can enable Or disable progress bar percentage visibility.", "aventa"),
            ),
            array(
                "type"        => "vc_icons",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon", "aventa"),
                "param_name"  => "icon",
                "value"       => "",
                "description" => esc_html__("Select an icon to be located into the chart.", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Main Color", "aventa"),
                "param_name"  => "main_color",
                "value"       => "#444",
                "description" => esc_html__("Enter the main color of pie chart that includes its icon, percentage related data and dot color.", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Pie chart bar color", "aventa"),
                "param_name"  => "bar_color",
                "value"       => "",
                "description" => esc_html__("Enter optional Pie Chart bar color", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Pie chart track color", "aventa"),
                "param_name"  => "track_color",
                "value"       => "",
                "description" => esc_html__("Enter optional Pie Chart track color", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Pie chart Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
                "description" => esc_html__("Enter pie chart title.", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Title Color", "aventa"),
                "param_name"  => "title_color",
                "value"       => "",
                "description" => esc_html__("Select optional title color. ", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Pie Chart Subtitle", "aventa"),
                "param_name"  => "subtitle",
                "value"       => "",
                "description" => esc_html__("Enter pie chart subtitle.", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Subtitle Color", "aventa"),
                "param_name"  => "subtitle_color",
                "value"       => "",
                "description" => esc_html__("Select optional subtitle color.", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select an animation for pie chart.", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/*  Team member
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Team Member", "aventa"),
        "description"      => esc_html__("Introduce the members of your team", "aventa"),
        "base"             => "rad_team_member",
        "category"         => "Aventa",
        "weight"           => 9,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-teammemmber",

        "params"           => array(
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Name", "aventa"),
                "param_name"  => "name",
                "value"       => "",
                "description" => esc_html__("Name of the team member", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Job Title", "aventa"),
                "param_name"  => "job_title",
                "value"       => "",
                "description" => esc_html__("Team member job title", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "description" => esc_html__("Choose between dark and light styles", "aventa"),
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Image", "aventa"),
                "param_name"  => "image",
                "value"       => "",
                "description" => esc_html__("Optional URL of member image", "aventa"),
            ),
            array(
                "type"        => "vc_link",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Link", "aventa"),
                "param_name"  => "url",
                "value"       => "",
                "description" => esc_html__("Optional URL to another web page", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select team member animation", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Instagram URL", "aventa"),
                "param_name" => "instagram",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Facebook URL", "aventa"),
                "param_name" => "facebook",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Twitter URL", "aventa"),
                "param_name" => "twitter",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Vimeo URL", "aventa"),
                "param_name" => "vimeo",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("YouTube URL", "aventa"),
                "param_name" => "youtube",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Google+ URL", "aventa"),
                "param_name" => "google",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Dribbble URL", "aventa"),
                "param_name" => "dribbble",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Tumblr URL", "aventa"),
                "param_name" => "tumblr",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Linkedin URL", "aventa"),
                "param_name" => "linkedin",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Flickr URL", "aventa"),
                "param_name" => "flickr",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Github URL", "aventa"),
                "param_name" => "github",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Last.fm URL", "aventa"),
                "param_name" => "lastfm",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Paypal URL", "aventa"),
                "param_name" => "paypal",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("RSS URL", "aventa"),
                "param_name" => "feed",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Skype URL", "aventa"),
                "param_name" => "skype",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("WordPress URL", "aventa"),
                "param_name" => "wordpress",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Yahoo URL", "aventa"),
                "param_name" => "yahoo",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Steam URL", "aventa"),
                "param_name" => "steam",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Reddit URL", "aventa"),
                "param_name" => "reddit",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("StumbleUpon URL", "aventa"),
                "param_name" => "stumbleupon",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Pinterest URL", "aventa"),
                "param_name" => "pinterest",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("DeviantArt URL", "aventa"),
                "param_name" => "deviantart",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Xing URL", "aventa"),
                "param_name" => "xing",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Blogger URL", "aventa"),
                "param_name" => "blogger",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("SoundCloud URL", "aventa"),
                "param_name" => "soundcloud",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Delicious URL", "aventa"),
                "param_name" => "delicious",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Foursquare URL", "aventa"),
                "param_name" => "foursquare",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Behance URL", "aventa"),
                "param_name" => "behance",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 1-URL", "aventa"),
                "param_name" => "custom1",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 1-name", "aventa"),
                "param_name" => "custom1_name",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom social 1-image", "aventa"),
                "param_name"  => "custom1_image",
                "description" => esc_html__("Choose an image to be used as social icon logo. ( best size : 20px * 25px ) ", "aventa"),
                "value"       => "",
                "group"       => esc_html__("Socials", "aventa"),
                "dependency"  => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 2-URL", "aventa"),
                "param_name" => "custom2",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 2-name", "aventa"),
                "param_name" => "custom2_name",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom social 2-image", "aventa"),
                "param_name"  => "custom2_image",
                "description" => esc_html__("Choose an image to be used as social icon logo. ( best size : 20px * 25px ) ", "aventa"),
                "value"       => "",
                "group"       => esc_html__("Socials", "aventa"),
                "dependency"  => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 3-URL", "aventa"),
                "param_name" => "custom3",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"       => "textfield",
                "heading"    => esc_html__("Custom social 3-name", "aventa"),
                "param_name" => "custom3_name",
                "group"      => esc_html__("Socials", "aventa"),
            ),
            array(
                "type"        => "attach_image",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom social 3-image", "aventa"),
                "param_name"  => "custom3_image",
                "description" => esc_html__("Choose an image to be used as social icon logo. ( best size : 20px * 25px ) ", "aventa"),
                "value"       => "",
                "group"       => esc_html__("Socials", "aventa"),
                "dependency"  => array(
                    "element" => "type",
                    "value"   => "icon",
                ),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/*  Button
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Button", "aventa"),
        "description"      => esc_html__("Fully-customizable buttons", "aventa"),
        "base"             => "rad_button",
        "category"         => "Aventa",
        "weight"           => 9,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-button",
        "params"           => array(
            array(
                "type"        => "vc_link",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Link", "aventa"),
                "param_name"  => "url",
                "value"       => "",
                "description" => esc_html__("URL to another web page", "aventa"),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Size", "aventa"),
                "param_name"       => "size",
                "description"      => esc_html__("Choose one of three button sizes", "aventa"),
                "value"            => array(
                    esc_html__("Standard", "aventa") => "standard",
                    esc_html__("Small", "aventa")    => "small",
                    esc_html__("Large", "aventa")    => "large",
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Alignment", "aventa"),
                "param_name"       => "alignment",
                "description"      => esc_html__("Choose one of available button alignments.", "aventa"),
                "value"            => array(
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Right", "aventa")  => "right",
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Position", "aventa"),
                "param_name"       => "position",
                "description"      => esc_html__("Choose one of available button styles", "aventa"),
                "value"            => array(
                    esc_html__("Inline", "aventa")        => "inline",
                    esc_html__("In a new line", "aventa") => "block",
                ),
                "dependency"       => array(
                    "element" => "alignment",
                    "value"   => array("left", "right"),
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text & Icon Color", "aventa"),
                "param_name"       => "text_color",
                "value"            => "",
                "description"      => esc_html__("Enter optional color for button text and icon.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Border Color", "aventa"),
                "param_name"       => "border_color",
                "value"            => "",
                "description"      => esc_html__("Select an optional border color for your button.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Bg Color", "aventa"),
                "param_name"       => "background_color",
                "value"            => "",
                "description"      => esc_html__("Select border color for your button.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text & Icon On-hover Color", "aventa"),
                "param_name"       => "text_hover_color",
                "value"            => "",
                "description"      => esc_html__("The color of button text and icon on hover mode.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Border hover Color", "aventa"),
                "param_name"       => "border_hover_color",
                "value"            => "",
                "description"      => esc_html__("Select an optional border hover color for your button.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("bg On-hover Color", "aventa"),
                "param_name"       => "bg_hover_color",
                "value"            => "",
                "description"      => esc_html__("Select an optional on-hover bg color for your button.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),

            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Border Radius ", "aventa"),
                "param_name"       => "border_radius",
                "value"            => array(
                    "0px"  => "0px",
                    "3px"  => "3px",
                    "5px"  => "5px",
                    "40px" => "40px",
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "vc_icons",
                "heading"     => esc_html__("Select Icon", "aventa"),
                "param_name"  => "icon",
                "description" => esc_html__("Select an icon to be shown in buttons", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Show icon", "aventa"),
                "param_name"  => "show",
                "description" => esc_html__("Show icon on hover or at first", "aventa"),
                "value"       => array(
                    esc_html__("At first", "aventa") => "first",
                    esc_html__("On hover", "aventa") => "hover",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Icon Position", "aventa"),
                "param_name"  => "icon_position",
                "value"       => array(
                    esc_html__("Icon at right", "aventa") => "right",
                    esc_html__("Icon at left", "aventa")  => "left",
                ),
            ),
            array(
                "type"       => "css_editor",
                "heading"    => esc_html__("Css", "aventa"),
                "param_name" => "css",
                "group"      => esc_html__("Design options", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/*  Link
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Link", "aventa"),
        "description"      => esc_html__("Link to any internal/external webpage", "aventa"),
        "base"             => "rad_link",
        "category"         => "Aventa",
        "weight"           => 9,
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-link",
        "params"           => array(
            array(
                "type"        => "vc_link",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Link", "aventa"),
                "param_name"  => "url",
                "value"       => "",
                "description" => esc_html__("URL to another web page", "aventa"),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Alignment", "aventa"),
                "param_name"       => "alignment",
                "description"      => esc_html__("Choose one of available alignments.", "aventa"),
                "value"            => array(
                    esc_html__("Left", "aventa")   => "left",
                    esc_html__("Center", "aventa") => "center",
                    esc_html__("Right", "aventa")  => "right",
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Position", "aventa"),
                "param_name"       => "position",
                "description"      => esc_html__("Choose one of available position", "aventa"),
                "value"            => array(
                    esc_html__("Inline", "aventa")        => "inline",
                    esc_html__("In a new line", "aventa") => "block",
                ),
                "dependency"       => array(
                    "element" => "alignment",
                    "value"   => array("left", "right"),
                ),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text Color", "aventa"),
                "param_name"       => "color",
                "value"            => "",
                "description"      => esc_html__("Enter optional color for text.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"             => "colorpicker",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Text On-hover Color", "aventa"),
                "param_name"       => "hover_color",
                "value"            => "#eee",
                "description"      => esc_html__("The color on hover mode.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"       => "css_editor",
                "heading"    => esc_html__("Css", "aventa"),
                "param_name" => "css",
                "group"      => esc_html__("Design options", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);
/*-----------------------------------------------------------------------------------*/
/*  image Carousel
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"             => esc_html__("Image Carousel", "aventa"),
        "description"      => esc_html__("Cycle through a group of images", "aventa"),
        "base"             => "rad_image_carousel",
        "weight"           => 9,
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-imagecarousel",
        "params"           => array(
            array(
                "type"        => "dropdown",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Free mode", "aventa"),
                "param_name"  => "freemode",
                "options"     => array("yes" => "Free mode"),
                "description" => esc_html__("Free mode: slides will not have fixed positions", "aventa"),
                "value"       => array(
                    esc_html__("Normal", "aventa")    => "no",
                    esc_html__("Free mode", "aventa") => "yes",
                ),
            ),
            array(
                "type"        => "attach_images",
                "class"       => "",
                "heading"     => esc_html__("Images", "aventa"),
                "param_name"  => "images",
                "value"       => "",
                "description" => esc_html__("Select images from media library.", "aventa"),
            ),
            array(
                "type"        => "vc_rangefield",
                "label"       => "% of browser width",
                "heading"     => esc_html__("Items maximum width(just in free mode)", "aventa"),
                "param_name"  => "freemode_max_width",
                "min"         => "10",
                "max"         => "100",
                "step"        => "1",
                "value"       => "40",
                "description" => "Each item has its own width but it should be set max-width.",
                "dependency"  => array(
                    "element" => "freemode",
                    "value"   => "yes",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Visible Items", "aventa"),
                "param_name"  => "visible_items",
                "description" => esc_html__("Enter the maximum number of visible items that you want to be visible in the carousel.", "aventa"),
                "value"       => array(
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                    "5" => "5",
                    "6" => "6",
                    "7" => "7",
                    "8" => "8",
                ),
                "dependency"  => array(
                    "element" => "freemode",
                    "value"   => "no",
                ),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Gutter", "aventa"),
                "param_name"  => "gutter",
                "options"     => array("no" => "No gutter"),
                "description" => esc_html__("Remove gutter between items", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Navigation type", "aventa"),
                "param_name"  => "navigation",
                "description" => esc_html__("Choose type of navigation. Next/Prev button or scrollbar or pagination bullets", "aventa"),
                "value"       => array(
                    esc_html__("Next/Prev buttons", "aventa")  => "next-prev",
                    esc_html__("Scrollbar", "aventa")          => "scrollbar",
                    esc_html__("Pagination bullets", "aventa") => "pagination",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Navigation Style", "aventa"),
                "param_name"  => "nav_style",
                "description" => esc_html__("Choose dark or light style", "aventa"),
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
            ),
            array(
                "type"        => "dropdown",
                "heading"     => esc_html__("Carousel Image Size", "aventa"),
                "param_name"  => "image_size",
                "description" => esc_html__("Select image size", "aventa"),
                "value"       => array(
                    esc_html__("Full", "aventa")      => "full",
                    esc_html__("medium", "aventa")    => "medium",
                    esc_html__("thumbnail", "aventa") => "thumbnail",
                    esc_html__("Custom", "aventa")    => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("image width", "aventa"),
                "param_name"  => "image_width",
                "value"       => "",
                "description" => esc_html__("Width", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("image height", "aventa"),
                "param_name"  => "image_height",
                "value"       => "",
                "description" => esc_html__("Height", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"       => "vc_multiselect",
                "class"      => "custom_image_size",
                "heading"    => esc_html__("image crop", "aventa"),
                "param_name" => "image_crop",
                "options"    => array("yes" => "Crop image"),
                "value"      => "",
                "dependency" => array(
                    "element" => "image_size",
                    "value"   => "custom",

                ),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Hover Zoom effect", "aventa"),
                "param_name"  => "zoom",
                "options"     => array("yes" => "Enable"),
                "description" => esc_html__("Zoom effect on hover", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Entrance animation", "aventa"),
                "param_name"  => "entrance_animation",
                "description" => esc_html__("Animation if items when appeard in screen", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"             => "dropdown",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Image Animation", "aventa"),
                "param_name"       => "img_animation",
                "description"      => esc_html__("Select animation type for image", "aventa"),
                "value"            => $img_animations,
                "group"            => esc_html__("Animation", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Autoplay", "aventa"),
                "param_name"  => "is_autoplay",
                "description" => esc_html__("Autoplay of carousel", "aventa"),
                "value"       => array(
                    esc_html__("Off", "aventa") => "off",
                    esc_html__("On", "aventa")  => "on",
                ),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Carousel Gallery
/*-----------------------------------------------------------------------------------*/

vc_map(
    array(
        "name"                    => esc_html__("Gallery Carousel", "aventa"),
        "description"             => esc_html__("Series of images with title, subtitle, and overlay effect", "aventa"),
        "base"                    => "rad_carousel_gallery",
        "category"                => "Aventa",
        "weight"                  => 9,
        "admin_enqueue_css"       => array(RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/css/wpbakery.css"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-gallery-carousel",
        "as_parent"               => array("only" => "rad_gallery_item"),
        "is_container"            => true,
        "show_settings_on_create" => false,
        "js_view"                 => "RADBackendTtaCarouselGalleryView",
        "custom_markup"           => "
        <div class=\"vc_tta-container\" data-vc-action=\"collapseAll\">
            <div class=\"vc_general vc_tta vc_tta-accordion vc_tta-color-backend-accordion-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-o-shape-group vc_tta-controls-align-left vc_tta-gap-2\">
               <div class=\"vc_tta-panels vc_clearfix {{container-class}}\">
                  {{ content }}
                  <div class=\"vc_tta-panel vc_tta-section-append\">
                     <div class=\"vc_tta-panel-heading\">
                        <h4 class=\"vc_tta-panel-title vc_tta-controls-icon-position-left\">
                           <a href=\"javascript:;\" aria-expanded=\"false\" class=\"vc_tta-backend-add-control\">
                               <span class=\"vc_tta-title-text\">" . esc_html__("Add item", "aventa") . "</span>
                                <i class=\"vc_tta-controls-icon vc_tta-controls-icon-plus\"></i>
                            </a>
                        </h4>
                     </div>
                  </div>
               </div>
            </div>
        </div>",
        "default_content"         => "
        [rad_gallery_item title=\"" . esc_html__("Item", "aventa") . "\"][/rad_gallery_item]
        [rad_gallery_item title=\"" . esc_html__("Item", "aventa") . "\"][/rad_gallery_item]
            ",
        "params"                  => array(
            array(
                "type"        => "dropdown",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Free mode", "aventa"),
                "param_name"  => "freemode",
                "options"     => array("yes" => "Free mode"),
                "description" => esc_html__("Free mode: slides will not have fixed positions", "aventa"),
                "value"       => array(
                    esc_html__("Normal", "aventa")    => "no",
                    esc_html__("Free mode", "aventa") => "yes",
                ),
            ),
            array(
                "type"        => "vc_rangefield",
                "label"       => "% of browser width",
                "heading"     => esc_html__("Items maximum width(just in free mode)", "aventa"),
                "param_name"  => "freemode_max_width",
                "min"         => "10",
                "max"         => "100",
                "step"        => "1",
                "value"       => "40",
                "description" => "Each item has its own width but it should be set max-width.",
                "dependency"  => array(
                    "element" => "freemode",
                    "value"   => "yes",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Visible Items", "aventa"),
                "param_name"  => "visible_items",
                "description" => esc_html__("Enter the maximum number of visible items that you want to be visible in the carousel.", "aventa"),
                "value"       => array(
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                    "5" => "5",
                    "6" => "6",
                    "7" => "7",
                    "8" => "8",
                ),
                "dependency"  => array(
                    "element" => "freemode",
                    "value"   => "no",
                ),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Gutter", "aventa"),
                "param_name"  => "gutter",
                "options"     => array("no" => "No gutter"),
                "description" => esc_html__("Remove gutter between items", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Image Size", "aventa"),
                "param_name"  => "image_size",
                "description" => esc_html__("Select image size", "aventa"),
                "value"       => array(
                    esc_html__("Full", "aventa")      => "full",
                    esc_html__("medium", "aventa")    => "medium",
                    esc_html__("thumbnail", "aventa") => "thumbnail",
                    esc_html__("Custom", "aventa")    => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image width", "aventa"),
                "param_name"  => "image_width",
                "value"       => "",
                "description" => esc_html__("Width", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image height", "aventa"),
                "param_name"  => "image_height",
                "value"       => "",
                "description" => esc_html__("Height", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"       => "vc_multiselect",
                "class"      => "custom_image_size",
                "heading"    => esc_html__("image size crop", "aventa"),
                "param_name" => "image_crop",
                "options"    => array("true" => "Crop image"),
                "value"      => "",
                "dependency" => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Navigation type", "aventa"),
                "param_name"  => "navigation",
                "description" => esc_html__("Choose type of navigation. Next/Prev button or scrollbar or pagination bullets", "aventa"),
                "value"       => array(
                    esc_html__("Next/Prev buttons", "aventa")  => "next-prev",
                    esc_html__("Scrollbar", "aventa")          => "scrollbar",
                    esc_html__("Pagination bullets", "aventa") => "pagination",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Navigation Style", "aventa"),
                "param_name"  => "nav_style",
                "description" => esc_html__("Choose dark or light style", "aventa"),
                "value"       => array(
                    esc_html__("Light", "aventa") => "light",
                    esc_html__("Dark", "aventa")  => "dark",
                ),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Custom hover Color", "aventa"),
                "param_name"  => "hover_color",
                "value"       => "",
                "description" => esc_html__("Enter a custom hover color", "aventa"),
            ),
            array(
                "type"       => "vc_rangefield",
                "label"      => "px",
                "heading"    => esc_html__("Title font size(px)", "aventa"),
                "param_name" => "title_size",
                "min"        => "15",
                "max"        => "80",
                "step"       => "1",
                "value"      => "20",
            ),
            array(
                "type"       => "vc_rangefield",
                "label"      => "px",
                "heading"    => esc_html__("Subtitle font size(px)", "aventa"),
                "param_name" => "subtitle_size",
                "min"        => "14",
                "max"        => "40",
                "step"       => "1",
                "value"      => "14",
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Autoplay", "aventa"),
                "param_name"  => "is_autoplay",
                "description" => esc_html__("Autoplay of carousel", "aventa"),
                "value"       => array(
                    esc_html__("On", "aventa")  => "on",
                    esc_html__("Off", "aventa") => "off",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Entrance animation", "aventa"),
                "param_name"  => "entrance_animation",
                "description" => esc_html__("Animation if items when appeard in screen", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "textfield",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
        ),
    )
);

vc_map(
    array(
        "name"             => esc_html__("Gallery Item", "aventa"),
        "base"             => "rad_gallery_item",
        "weight"           => 9,
        "category"         => "Aventa",
        "front_enqueue_js" => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"             => "icon-wpb-imagecarousel",
        "as_child"         => array(
            "only" => "rad_carousel_gallery",
        ),
        "description"      => esc_html__("Gallery item for Carousel gallery", "aventa"),
        "js_view"          => "VcBackendTtaSectionView",
        "custom_markup"    => "
            <div class=\"vc_tta-panel-heading\">
                <h4 class=\"vc_tta-panel-title vc_tta-controls-icon-position-left\"><a href=\"javascript:;\" data-vc-target=\"[data-model-id='{{ model_id }}']\" data-vc-accordion data-vc-container=\".vc_tta-container\"><span class=\"vc_tta-title-text\">{{ title }}</span><i class=\"vc_tta-controls-icon vc_tta-controls-icon-plus\"></i></a></h4>
            </div>
            <div class=\"vc_tta-panel-body\">
                {{ editor_controls }}
                <div class=\"{{ container-class }}\">
                {{ }}
                </div>
            </div>",
        "params"           => array(
            array(
                "type"        => "attach_image",
                "admin_label" => true,
                "class"       => "",
                "heading"     => esc_html__("Image URL", "aventa"),
                "param_name"  => "img_id",
                "description" => esc_html__("Choose an image.", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Title", "aventa"),
                "param_name"  => "title",
                "value"       => "",
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Subtitle", "aventa"),
                "param_name"  => "subtitle",
                "value"       => "",
            ),
            array(
                "type"             => "vc_link",
                "admin_label"      => false,
                "class"            => "",
                "heading"          => esc_html__("Link", "aventa"),
                "param_name"       => "url",
                "value"            => "",
                "description"      => esc_html__("Optional URL to another web page.", "aventa"),
                "edit_field_class" => "vc_col-xs-4",
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* VC masonry grid
/*-----------------------------------------------------------------------------------*/
// remove filter
vc_remove_param("vc_masonry_grid", "show_filter");
vc_remove_param("vc_masonry_grid", "filter_source");
vc_remove_param("vc_masonry_grid", "exclude_filter");
vc_remove_param("vc_masonry_grid", "filter_style");
vc_remove_param("vc_masonry_grid", "filter_align");
vc_remove_param("vc_masonry_grid", "filter_color");
vc_remove_param("vc_masonry_grid", "filter_size");

// remove load more button style
vc_remove_param("vc_masonry_grid", "button_color");
vc_remove_param("vc_masonry_grid", "button_size");
vc_remove_param("vc_masonry_grid", "button_style");

// remove pagination options
vc_remove_param("vc_masonry_grid", "arrows_design");
vc_remove_param("vc_masonry_grid", "arrows_color");
vc_remove_param("vc_masonry_grid", "arrows_position");
vc_remove_param("vc_masonry_grid", "paging_design");
vc_remove_param("vc_masonry_grid", "paging_color");

/*-----------------------------------------------------------------------------------*/
/* Masonry blog- Card Blog
/*-----------------------------------------------------------------------------------*/

$posts_cats = array();
$cat_args   = array(
    "orderby"    => "term_id",
    "order"      => "ASC",
    "hide_empty" => false,
);

$terms = get_terms("category", $cat_args);

foreach ($terms as $taxonomy) {
    $posts_cats[$taxonomy->slug] = $taxonomy->name;
}

vc_map(
    array(
        "base"                    => "rad_card_blog",
        "name"                    => esc_html__("Card Blog", "aventa"),
        "description"             => esc_html__("Show blog posts in card layout", "aventa"),
        "front_enqueue_js"        => RAD_THEME_INC_URI . "/admin/compatibility/wpbakery/js/frontend.js",
        "icon"                    => "icon-wpb-blog",
        "show_settings_on_create" => false,
        "category"                => "Aventa",
        "weight"                  => 8,
        "params"                  => array(
            array(
                "type"       => "dropdown",
                "heading"    => esc_html__("Card Style", "aventa"),
                "param_name" => "blog_style",
                "value"      => array(
                    esc_html__("Classic", "aventa") => "classic",
                    esc_html__("Modern", "aventa")  => "modern",
                ),
            ),
            array(
                "type"       => "dropdown",
                "heading"    => esc_html__("Number of columns", "aventa"),
                "param_name" => "blog_column",
                "value"      => array(
                    "3" => "3",
                    "4" => "4",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Blog Categories", "aventa"),
                "param_name"  => "blog_filter",
                "value"       => array(
                    esc_html__("All", "aventa")    => "all",
                    esc_html__("Custom", "aventa") => "custom",
                ),
                "description" => "",
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("category", "aventa"),
                "param_name"  => "blog_category",
                "options"     => $posts_cats,
                "defaults"    => "all",
                "admin_label" => false,
                "description" => "Selected categories to be shown in blog section.",
                "value"       => "",
                "dependency"  => array(
                    "element" => "blog_filter",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Layout Mode", "aventa"),
                "param_name"  => "blog_layout_mode",
                "dependency"  => array(
                    "element" => "blog_style",
                    "value"   => "classic",
                ),
                "description" => esc_html__("Choose masonry or fitrow for blog layout", "aventa"),
                "value"       => array(
                    esc_html__("Masonry", "aventa")  => "masonry",
                    esc_html__("Fit Rows", "aventa") => "fitRows",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Image size", "aventa"),
                "param_name"  => "blog_image_size",
                "description" => esc_html__("Select image size for blog", "aventa"),
                "value"       => array(
                    esc_html__("Large", "aventa")  => "large",
                    esc_html__("Scaled", "aventa") => "scaled",
                ),
            ),
            array(
                "type"           => "textfield",
                "heading"        => esc_html__("Number of posts", "aventa"),
                "param_name"     => "blog_post_number",
                "value"          => "16",
                "defaultSetting" => array(
                    "min"    => "0",
                    "max"    => "30",
                    "prefix" => "",
                    "step"   => "1",
                ),
                "description"    => "Number of posts per page, minimum valid number is 0 and maximum valid number of posts is 30.",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Show Author", "aventa"),
                "group"       => esc_html__("Display", "aventa"),
                "param_name"  => "show_author",
                "value"       => array(
                    esc_html__("Visible", "aventa")   => "yes",
                    esc_html__("Invisible", "aventa") => "no",
                ),
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Show Comments", "aventa"),
                "group"       => esc_html__("Display", "aventa"),
                "param_name"  => "show_comments",
                "value"       => array(
                    esc_html__("Invisible", "aventa") => "no",
                    esc_html__("Visible", "aventa")   => "yes",
                ),
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Category Visibility", "aventa"),
                "group"       => esc_html__("Display", "aventa"),
                "param_name"  => "blog_category_visibility",
                "value"       => array(
                    esc_html__("Visible", "aventa")   => "yes",
                    esc_html__("Invisible", "aventa") => "no",
                ),
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Load more button visibility", "aventa"),
                "group"       => esc_html__("Display", "aventa"),
                "param_name"  => "load_more_visibility",
                "value"       => array(
                    esc_html__("Visible", "aventa")   => "yes",
                    esc_html__("Invisible", "aventa") => "no",
                ),
                "description" => "",
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Entrance Animation", "aventa"),
                "param_name"  => "entrance_animation",
                "description" => esc_html__("Animation if items when appeard in screen", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text Color", "aventa"),
                "param_name"  => "blog_foreground_color",
                "description" => esc_html__("Choose dark or light style of text", "aventa"),
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
                "group"       => esc_html__("Design", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Load more style", "aventa"),
                "param_name"  => "load_more_style",
                "description" => esc_html__("Choose dark or light style for load more in blog.", "aventa"),
                "value"       => array(
                    esc_html__("Dark", "aventa")  => "dark",
                    esc_html__("Light", "aventa") => "light",
                ),
                "group"       => esc_html__("Design", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "heading"     => esc_html__("Background Color", "aventa"),
                "param_name"  => "blog_background_color",
                "value"       => "#f8f8f8",
                "admin_label" => false,
                "opacity"     => false,
                "group"       => esc_html__("Design", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "heading"     => esc_html__("Quote Post Background Color", "aventa"),
                "param_name"  => "quote_blog_background_color",
                "value"       => "#000",
                "admin_label" => false,
                "opacity"     => false,
                "group"       => esc_html__("Design", "aventa"),
            ),
            array(
                "type"        => "colorpicker",
                "heading"     => esc_html__("Quote Post text Color", "aventa"),
                "param_name"  => "quote_blog_text_color",
                "value"       => "#fff",
                "admin_label" => false,
                "opacity"     => false,
                "group"       => esc_html__("Design", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Video & sound icon style", "aventa"),
                "param_name"  => "blog_multimedia_icon_style",
                "description" => esc_html__("Choose dark or light style for sound and video blog types.", "aventa"),
                "value"       => array(
                    esc_html__("Light", "aventa") => "light",
                    esc_html__("Dark", "aventa")  => "dark",
                ),
                "group"       => esc_html__("Design", "aventa"),
            ),
        ),
    )
);

/*-----------------------------------------------------------------------------------*/
/* Woocommerce elements
/*-----------------------------------------------------------------------------------*/

if (!function_exists("rad_vc_change_woocommerce_elements")) {

    function rad_vc_change_woocommerce_elements()
    {
        // animation array
        $animations = array(
            "None"                => "none",
            "Fade in"             => "fade-in",
            "Fade in from top"    => "fade-in-top",
            "Fade in from left"   => "fade-in-left",
            "Fade in from right"  => "fade-in-right",
            "Fade in from bottom" => "fade-in-bottom",
        );
        //*---------------------------*/
        /* Set icons
        //*---------------------------*/
        vc_map_update("product", array("icon" => "icon-wpb-product"));
        vc_map_update("product_page", array("icon" => "icon-wpb-product_page"));
        vc_map_update("product_category", array("icon" => "icon-wpb-product_category"));
        vc_map_update("product_categories", array("icon" => "icon-wpb-product_categories"));
        vc_map_update("add_to_cart", array("icon" => "icon-wpb-add_to_cart"));
        vc_map_update("add_to_cart_url", array("icon" => "icon-wpb-add_to_cart_url"));
        vc_map_update("products", array("icon" => "icon-wpb-products"));
        vc_map_update("recent_products", array("icon" => "icon-wpb-recent_products"));
        vc_map_update("sale_products", array("icon" => "icon-wpb-sale_products"));
        vc_map_update("best_selling_products", array("icon" => "icon-wpb-best_selling_products"));
        vc_map_update("top_rated_products", array("icon" => "icon-wpb-top_rated_products"));
        vc_map_update("featured_products", array("icon" => "icon-wpb-featured_products"));
        vc_map_update("product_attribute", array("icon" => "icon-wpb-product_attribute"));
        vc_map_update("related_products", array("icon" => "icon-wpb-related_products"));
        vc_map_update("shop_messages", array("icon" => "icon-wpb-shop_messages"));
        vc_map_update("woocommerce_order_tracking", array("icon" => "icon-wpb-woocommerce_order_tracking"));
        vc_map_update("woocommerce_cart", array("icon" => "icon-wpb-woocommerce_cart"));
        vc_map_update("woocommerce_checkout", array("icon" => "icon-wpb-woocommerce_checkout"));
        vc_map_update("woocommerce_my_account", array("icon" => "icon-wpb-woocommerce_my_account"));

        //*---------------------------*/
        /* Single Product shortcode
        //*---------------------------*/
        vc_map(array(
            "name"        => esc_html__("Single Product", "aventa"),
            "base"        => "product",
            "icon"        => "icon-wpb-single-product",
            "weight"      => 0,
            "category"    => esc_html__("WooCommerce", "aventa"),
            "description" => esc_html__("Show a single product by ID or SKU", "aventa"),
            "params"      => array(
                array(
                    "type"        => "autocomplete",
                    "heading"     => esc_html__("Select Identifier", "aventa"),
                    "param_name"  => "id",
                    "description" => esc_html__("Input product ID or product SKU or product title to see suggestions", "aventa"),
                ),
                array(
                    "type"       => "hidden",
                    // This will not show on render, but will be used when defining value for autocomplete
                    "param_name" => "sku",
                ),
                array(
                    "type"        => "dropdown",
                    "holder"      => "",
                    "class"       => "",
                    "admin_label" => false,
                    "heading"     => esc_html__("Gutter", "aventa"),
                    "param_name"  => "gutter",
                    "description" => esc_html__("Select gutter between items in a row", "aventa"),
                    "value"       => array(
                        esc_html__("one unit", "aventa") => 0,
                        esc_html__("two unit", "aventa") => 1,
                    ),
                ),
                array(
                    "type"        => "dropdown",
                    "admin_label" => false,
                    "class"       => "",
                    "heading"     => esc_html__("Style", "aventa"),
                    "param_name"  => "style",
                    "description" => esc_html__("Choose style of items", "aventa"),
                    "value"       => array(
                        esc_html__("Buttons on hover", "aventa")    => "bt-hover",
                        esc_html__("Quick-view on hover", "aventa") => "qv-hover",
                        esc_html__("General", "aventa")             => "general",
                        esc_html__("Creative", "aventa")            => "creative",
                    ),
                ),
                array(
                    "type"        => "dropdown",
                    "class"       => "",
                    "heading"     => esc_html__("Image Size", "aventa"),
                    "param_name"  => "image_size",
                    "group"       => esc_html__("image", "aventa"),
                    "description" => esc_html__("Select image size", "aventa"),
                    "value"       => array(
                        esc_html__("Single Product Image", "aventa") => "woocommerce_single",
                        esc_html__("Product Thumbnails", "aventa")   => "woocommerce_thumbnail",
                        esc_html__("Full", "aventa")                 => "full",
                        esc_html__("Custom", "aventa")               => "custom",
                    ),
                ),
                array(
                    "type"        => "textfield",
                    "class"       => "custom_image_size",
                    "admin_label" => false,
                    "heading"     => esc_html__("Custom image width", "aventa"),
                    "param_name"  => "image_size_width",
                    "group"       => esc_html__("image", "aventa"),
                    "value"       => "",
                    "description" => esc_html__("Width", "aventa"),
                    "dependency"  => array(
                        "element" => "image_size",
                        "value"   => "custom",
                    ),
                ),
                array(
                    "type"        => "textfield",
                    "class"       => "custom_image_size",
                    "admin_label" => false,
                    "heading"     => esc_html__("Custom image height", "aventa"),
                    "param_name"  => "image_size_height",
                    "value"       => "",
                    "group"       => esc_html__("image", "aventa"),
                    "description" => esc_html__("Height", "aventa"),
                    "dependency"  => array(
                        "element" => "image_size",
                        "value"   => "custom",
                    ),
                ),
                array(
                    "type"       => "vc_multiselect",
                    "class"      => "custom_image_size",
                    "heading"    => esc_html__("image size crop", "aventa"),
                    "param_name" => "image_size_crop",
                    "options"    => array("true" => "Crop image"),
                    "value"      => "",
                    "group"      => esc_html__("image", "aventa"),
                    "dependency" => array(
                        "element" => "image_size",
                        "value"   => "custom",
                    ),
                ),
                array(
                    "type"        => "dropdown",
                    "class"       => "",
                    "heading"     => esc_html__("Hover Image", "aventa"),
                    "param_name"  => "hover_image",
                    "description" => esc_html__("Show or hide hover image if exist", "aventa"),
                    "value"       => array(
                        esc_html__("Show", "aventa") => "show",
                        esc_html__("Hide", "aventa") => "hide",
                    ),
                ),
                array(
                    "type"        => "dropdown",
                    "class"       => "",
                    "heading"     => esc_html__("Entrance Animation", "aventa"),
                    "param_name"  => "entrance_animation",
                    "description" => esc_html__("Animation if items when appeard in screen", "aventa"),
                    "value"       => $animations,
                    "group"       => esc_html__("Animation", "aventa"),
                ),
                array(
                    "type"        => "vc_multiselect",
                    "class"       => "",
                    "heading"     => esc_html__("Animation in Responsive", "aventa"),
                    "param_name"  => "responsive_animation",
                    "options"     => array("disable" => "Disable animation"),
                    "value"       => "disable",
                    "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                    "group"       => esc_html__("Animation", "aventa"),
                ),
                array(
                    "type"        => "dropdown",
                    "admin_label" => false,
                    "class"       => "",
                    "heading"     => esc_html__("Autoplay", "aventa"),
                    "param_name"  => "is_autoplay",
                    "description" => esc_html__("Autoplay of carousel", "aventa"),
                    "value"       => array(
                        esc_html__("Off", "aventa") => "off",
                        esc_html__("On", "aventa")  => "on",
                    ),
                    "dependency"  => array(
                        "element" => "layout",
                        "value"   => "carousel",
                    ),
                ),
                array(
                    "type"        => "vc_multiselect",
                    "class"       => "",
                    "admin_label" => false,
                    "heading"     => esc_html__("Quick View Button", "aventa"),
                    "param_name"  => "quickview",
                    "options"     => array("disable" => "Disable quickview"),
                    "description" => "Disable quick view button",
                    "value"       => "",
                ),
                array(
                    "type"        => "vc_multiselect",
                    "class"       => "",
                    "admin_label" => false,
                    "heading"     => esc_html__("wishlist button", "aventa"),
                    "param_name"  => "wishlist",
                    "options"     => array("disable" => "Disable wishlist"),
                    "description" => esc_html__("Disable wishlist button", "aventa"),
                    "value"       => "",
                ),
            ),
        ));

        // Add autocomplete functionality to search in porducts shortcode
        if (class_exists("Vc_Vendor_Woocommerce")) {
            $vc_vendor_wc = new Vc_Vendor_Woocommerce();
            //Filters For autocomplete param:
            //For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
            add_filter("vc_autocomplete_product_2_id_callback", array(
                &$vc_vendor_wc,
                "productIdAutocompleteSuggester",
            ), 10, 1); // Get suggestion(find). Must return an array
            add_filter("vc_autocomplete_product_2_id_render", array(
                &$vc_vendor_wc,
                "productIdAutocompleteRender",
            ), 10, 1); // Render exact product. Must return an array (label,value)
            //For param: ID default value filter
            add_filter("vc_form_fields_render_field_product_2_id_param_value", array(
                &$vc_vendor_wc,
                "productIdDefaultValue",
            ), 10, 4); // Defines default value for param if not provided. Takes from other param value.

            add_filter("vc_autocomplete_featured_products_category_callback", array(
                &$vc_vendor_wc,
                "productCategoryCategoryAutocompleteSuggesterBySlug",
            ), 10, 1); // Get suggestion(find). Must return an array
            add_filter("vc_autocomplete_featured_products_category_render", array(
                &$vc_vendor_wc,
                "productCategoryCategoryRenderBySlugExact",
            ), 10, 1);
            add_filter("vc_autocomplete_recent_products_category_callback", array(
                &$vc_vendor_wc,
                "productCategoryCategoryAutocompleteSuggesterBySlug",
            ), 10, 1); // Get suggestion(find). Must return an array
            add_filter("vc_autocomplete_recent_products_category_render", array(
                &$vc_vendor_wc,
                "productCategoryCategoryRenderBySlugExact",
            ), 10, 1);
            add_filter("vc_autocomplete_best_selling_products_category_callback", array(
                &$vc_vendor_wc,
                "productCategoryCategoryAutocompleteSuggesterBySlug",
            ), 10, 1); // Get suggestion(find). Must return an array
            add_filter("vc_autocomplete_best_selling_products_category_render", array(
                &$vc_vendor_wc,
                "productCategoryCategoryRenderBySlugExact",
            ), 10, 1);

            add_filter("vc_autocomplete_top_rated_products_category_callback", array(
                &$vc_vendor_wc,
                "productCategoryCategoryAutocompleteSuggesterBySlug",
            ), 10, 1); // Get suggestion(find). Must return an array
            add_filter("vc_autocomplete_top_rated_products_category_render", array(
                &$vc_vendor_wc,
                "productCategoryCategoryRenderBySlugExact",
            ), 10, 1);
            add_filter("vc_autocomplete_featured_products_tag_callback", "productTagsAutocompleteSuggesterBySlug", 10, 1); // Get tags suggestion(find) in featured products
            add_filter("vc_autocomplete_featured_products_tag_render", "productTagsRenderBySlugExact", 10, 1);
            add_filter("vc_autocomplete_best_selling_products_tag_callback", "productTagsAutocompleteSuggesterBySlug", 10, 1); // Get tags suggestion(find) in best selling products
            add_filter("vc_autocomplete_best_selling_products_tag_render", "productTagsRenderBySlugExact", 10, 1);
            add_filter("vc_autocomplete_top_rated_products_tag_callback", "productTagsAutocompleteSuggesterBySlug", 10, 1); // Get tags suggestion(find) in top rated products
            add_filter("vc_autocomplete_top_rated_products_tag_render", "productTagsRenderBySlugExact", 10, 1);
            add_filter("vc_autocomplete_recent_products_tag_callback", "productTagsAutocompleteSuggesterBySlug", 10, 1); // Get tags suggestion(find) in recent products
            add_filter("vc_autocomplete_recent_products_tag_render", "productTagsRenderBySlugExact", 10, 1);

        }

        //*---------------------------*/
        /* woocommerce shortcodes with carousel capability
        //*---------------------------*/

        $wc_shortcode_category_setting = array(
            array(
                "type"        => "autocomplete",
                "heading"     => esc_html__("Categories", "aventa"),
                "param_name"  => "category",
                "settings"    => array(
                    "multiple" => true,
                    "sortable" => true,
                ),
                "save_always" => true,
                "description" => esc_html__("Leave it empty if you wish to get products of all categories", "aventa"),
            ),
            array(
                "type"        => "autocomplete",
                "heading"     => esc_html__("Product Tags", "aventa"),
                "param_name"  => "tag",
                "settings"    => array(
                    "multiple" => true,
                    "sortable" => true,
                ),
                "save_always" => true,
                "description" => esc_html__("Leave it empty if you wish to get products with all tags", "aventa"),
            ),
        );

        $wc_shortcode_setting = array(
            array(
                "type"        => "vc_number",
                "admin_label" => false,
                "label"       => esc_html__("Determines how many products to show on the page", "aventa"),
                "param_name"  => "limit",
                "value"       => "",
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Columns", "aventa"),
                "param_name"  => "columns",
                "description" => esc_html__("Select number of items in a row", "aventa"),
                "value"       => array(
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                    "5" => "5",
                    "6" => "6",
                ),
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Gutter", "aventa"),
                "param_name"  => "gutter",
                "description" => esc_html__("Select gutter between items in a row", "aventa"),
                "value"       => array(
                    esc_html__("one unit", "aventa") => 0,
                    esc_html__("two unit", "aventa") => 1,
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Carousel/Grid Mode", "aventa"),
                "param_name"  => "layout",
                "description" => esc_html__("Enable Carousel/Grid mode for products", "aventa"),
                "value"       => array(
                    esc_html__("Grid", "aventa")     => "grid",
                    esc_html__("Carousel", "aventa") => "carousel",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Grid Mode", "aventa"),
                "param_name"  => "grid_mode",
                "description" => esc_html__("Choose style of grid", "aventa"),
                "value"       => array(
                    esc_html__("General", "aventa") => "general",
                    esc_html__("Sticky", "aventa")  => "sticky",
                    esc_html__("Scatter", "aventa") => "scatter",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => "grid",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "description" => esc_html__("Choose style of items", "aventa"),
                "value"       => array(
                    esc_html__("Buttons on hover", "aventa")    => "bt-hover",
                    esc_html__("Quick-view on hover", "aventa") => "qv-hover",
                    esc_html__("General", "aventa")             => "general",
                    esc_html__("Creative", "aventa")            => "creative",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Image Size", "aventa"),
                "param_name"  => "image_size",
                "group"       => esc_html__("image", "aventa"),
                "description" => esc_html__("Select image size", "aventa"),
                "value"       => array(
                    esc_html__("Single Product Image", "aventa") => "woocommerce_single",
                    esc_html__("Product Thumbnails", "aventa")   => "woocommerce_thumbnail",
                    esc_html__("Full", "aventa")                 => "full", // DO IT LATER : CHECK IT, Maybe its imposssible to have full size with lazy-loading (wrong with/height issue)
                    esc_html__("Custom", "aventa")               => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image width", "aventa"),
                "param_name"  => "image_size_width",
                "group"       => esc_html__("image", "aventa"),
                "value"       => "",
                "description" => esc_html__("Width", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image height", "aventa"),
                "param_name"  => "image_size_height",
                "value"       => "",
                "group"       => esc_html__("image", "aventa"),
                "description" => esc_html__("Height", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"       => "vc_multiselect",
                "class"      => "custom_image_size",
                "heading"    => esc_html__("image size crop", "aventa"),
                "param_name" => "image_size_crop",
                "options"    => array("true" => "Crop image"),
                "value"      => "",
                "group"      => esc_html__("image", "aventa"),
                "dependency" => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Hover Image", "aventa"),
                "param_name"  => "hover_image",
                "description" => esc_html__("Show or hide hover image if exist", "aventa"),
                "value"       => array(
                    esc_html__("Show", "aventa") => "show",
                    esc_html__("Hide", "aventa") => "hide",
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Entrance Animation", "aventa"),
                "param_name"  => "entrance_animation",
                "description" => esc_html__("Animation if items when appeard in screen", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "heading"     => esc_html__("Animation in Responsive", "aventa"),
                "param_name"  => "responsive_animation",
                "options"     => array("disable" => "Disable animation"),
                "value"       => "disable",
                "description" => esc_html__("Disable animation in mobiles and tablet devices.", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Autoplay", "aventa"),
                "param_name"  => "is_autoplay",
                "description" => esc_html__("Autoplay of carousel", "aventa"),
                "value"       => array(
                    esc_html__("Off", "aventa") => "off",
                    esc_html__("On", "aventa")  => "on",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => "carousel",
                ),
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Navigation type", "aventa"),
                "param_name"  => "navigation",
                "description" => esc_html__("Choose type of navigation. Next/Prev button or scrollbar or pagination bullets", "aventa"),
                "value"       => array(
                    esc_html__("Next/Prev buttons", "aventa")  => "next-prev",
                    esc_html__("Scrollbar", "aventa")          => "scrollbar",
                    esc_html__("Pagination bullets", "aventa") => "pagination",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Navigations Style", "aventa"),
                "param_name"  => "nav_style",
                "description" => esc_html__("Choose dark or light style of navigation", "aventa"),
                "value"       => array(
                    esc_html__("Light", "aventa") => "light",
                    esc_html__("Dark", "aventa")  => "dark",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => "carousel",
                ),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Quick View Button", "aventa"),
                "param_name"  => "quickview",
                "options"     => array("disable" => "Disable quickview"),
                "description" => "Disable quick view button",
                "value"       => "",
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("wishlist button", "aventa"),
                "param_name"  => "wishlist",
                "options"     => array("disable" => "Disable wishlist"),
                "description" => esc_html__("Disable wishlist button", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Pagination", "aventa"),
                "param_name"  => "paginate",
                "options"     => array("true" => "Enable pagination"),
                "value"       => "",
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => array("grid"),
                ),
            ),
        );

        vc_add_params("recent_products", $wc_shortcode_category_setting);
        vc_add_params("best_selling_products", $wc_shortcode_category_setting);
        vc_add_params("top_rated_products", $wc_shortcode_category_setting);
        vc_add_params("featured_products", $wc_shortcode_category_setting);
        vc_add_params("products", $wc_shortcode_setting);

        vc_add_params("recent_products", $wc_shortcode_setting);
        vc_add_params("sale_products", $wc_shortcode_setting);
        vc_add_params("best_selling_products", $wc_shortcode_setting);
        vc_add_params("top_rated_products", $wc_shortcode_setting);
        vc_add_params("featured_products", $wc_shortcode_setting);
        vc_add_params("product_category", $wc_shortcode_setting);
        vc_add_params("product_attribute", $wc_shortcode_setting);

        vc_remove_param("recent_products", "per_page");
        vc_remove_param("sale_products", "per_page");
        vc_remove_param("best_selling_products", "per_page");
        vc_remove_param("top_rated_products", "per_page");
        vc_remove_param("featured_products", "per_page");
        vc_remove_param("product_category", "per_page");
        vc_remove_param("product_attribute", "per_page");

        //*---------------------------*/
        /* Product categories
        //*---------------------------*/
        $categories_options = array(
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "weight"      => 4,
                "heading"     => esc_html__("Style", "aventa"),
                "param_name"  => "style",
                "description" => esc_html__("Select styles of product categories", "aventa"),
                "value"       => array(
                    esc_html__("Hover", "aventa")    => "1",
                    esc_html__("General", "aventa")  => "2",
                    esc_html__("Creative", "aventa") => "3",
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "weight"      => 3,
                "heading"     => esc_html__("Carousel/Grid Mode", "aventa"),
                "param_name"  => "layout",
                "description" => esc_html__("Enable Carousel/Grid mode for products", "aventa"),
                "value"       => array(
                    esc_html__("Grid", "aventa")     => "grid",
                    esc_html__("Carousel", "aventa") => "carousel",
                ),
                "dependency"  => array(
                    "element" => "style",
                    "value"   => array("1", "2"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "weight"      => 2,
                "heading"     => esc_html__("Grid type", "aventa"),
                "param_name"  => "grid_type",
                "description" => esc_html__("Choose grid type", "aventa"),
                "value"       => array(
                    esc_html__("Standard", "aventa") => "standard",
                    esc_html__("Masonry", "aventa")  => "masonry",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => array("grid"),
                ),
            ),
            array(
                "type"        => "vc_imageselect",
                "admin_label" => false,
                "weight"      => 1,
                "heading"     => esc_html__("Masonry style", "aventa"),
                "param_name"  => "masonry_style",
                "value"       => array(
                    "i2a" => "i2a",
                    "i3a" => "i3a",
                    "i3b" => "i3b",
                    "i4a" => "i4a",
                    "i4b" => "i4b",
                    "i5a" => "i5a",
                    "i5b" => "i5b",
                    "i5c" => "i5c",
                ),
                "dependency"  => array(
                    "element" => "grid_type",
                    "value"   => array("masonry"),
                ),
                "description" => esc_html__("Choose the best style to fit the number of categories. Notice: this option just work in category hover style", "aventa"),
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Columns", "aventa"),
                "param_name"  => "columns",
                "description" => esc_html__("Select number of columns", "aventa"),
                "value"       => array(
                    "1" => "1",
                    "2" => "2",
                    "3" => "3",
                    "4" => "4",
                    "5" => "5",
                    "6" => "6",
                ),
                "dependency"  => array(
                    "element" => "grid_type",
                    "value"   => array("standard"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Image size", "aventa"),
                "param_name"  => "image_size",
                "description" => esc_html__("Select image size", "aventa"),
                "value"       => array(
                    esc_html__("Single Product Image", "aventa") => "woocommerce_single",
                    esc_html__("Product Thumbnails", "aventa")   => "woocommerce_thumbnail",
                    esc_html__("Full", "aventa")                 => "full",
                    esc_html__("Custom", "aventa")               => "custom",
                ),
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "heading"     => esc_html__("Navigation type", "aventa"),
                "param_name"  => "navigation",
                "description" => esc_html__("Choose type of navigation. Next/Prev button or scrollbar or pagination bullets", "aventa"),
                "value"       => array(
                    esc_html__("Next/Prev buttons", "aventa")  => "next-prev",
                    esc_html__("Scrollbar", "aventa")          => "scrollbar",
                    esc_html__("Pagination bullets", "aventa") => "pagination",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => array("carousel"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Navigations Style", "aventa"),
                "param_name"  => "nav_style",
                "description" => esc_html__("Choose dark or light style of navigation", "aventa"),
                "value"       => array(
                    esc_html__("Light", "aventa") => "light",
                    esc_html__("Dark", "aventa")  => "dark",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => "carousel",
                ),
            ),

            array(
                "type"        => "dropdown",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Autoplay", "aventa"),
                "param_name"  => "is_autoplay",
                "description" => esc_html__("Autoplay of carousel", "aventa"),
                "value"       => array(
                    esc_html__("Off", "aventa") => "off",
                    esc_html__("On", "aventa")  => "on",
                ),
                "dependency"  => array(
                    "element" => "layout",
                    "value"   => "carousel",
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("Custom image size", "aventa"),
                "param_name"  => "image_size_width",
                "value"       => "",
                "description" => esc_html__("Width", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),

            array(
                "type"        => "textfield",
                "class"       => "custom_image_size",
                "admin_label" => false,
                "heading"     => esc_html__("image size height", "aventa"),
                "param_name"  => "image_size_height",
                "value"       => "",
                "description" => esc_html__("Height", "aventa"),
                "dependency"  => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"       => "vc_multiselect",
                "class"      => "custom_image_size",
                "heading"    => esc_html__("image size crop", "aventa"),
                "param_name" => "image_size_crop",
                "options"    => array("yes" => "Crop image"),
                "value"      => "",
                "dependency" => array(
                    "element" => "image_size",
                    "value"   => "custom",
                ),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Hide empty categories", "aventa"),
                "param_name"  => "hide_empty",
                "options"     => array("true" => "Hide empty"),
                "description" => esc_html__("Hide categories that have no any products", "aventa"),
                "value"       => "",
            ),
            array(
                "type"        => "dropdown",
                "holder"      => "",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Gutter", "aventa"),
                "param_name"  => "gutter",
                "description" => esc_html__("Select gutter between items in a row", "aventa"),
                "value"       => array(
                    esc_html__("one unit", "aventa") => 0,
                    esc_html__("two unit", "aventa") => 1,
                ),
                "dependency"  => array(
                    "element" => "style",
                    "value"   => array("1", "2"),
                ),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Hover Color", "aventa"),
                "param_name"  => "hover_color",
                "value"       => "",
                "description" => esc_html__("Enter a custom hover color", "aventa"),
                "dependency"  => array(
                    "element" => "style",
                    "value"   => array("1", "2"),
                ),
            ),
            array(
                "type"        => "colorpicker",
                "admin_label" => false,
                "class"       => "",
                "heading"     => esc_html__("Text color", "aventa"),
                "param_name"  => "text_color",
                "value"       => "",
                "description" => esc_html__("Select category text color", "aventa"),
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Show Product count", "aventa"),
                "param_name"  => "count",
                "options"     => array("enable" => "Show product count"),
                "description" => "Show product count",
                "value"       => "",
            ),
            array(
                "type"        => "vc_multiselect",
                "class"       => "",
                "admin_label" => false,
                "heading"     => esc_html__("Show category description", "aventa"),
                "param_name"  => "description",
                "options"     => array("enable" => "Show category description"),
                "description" => "Show category description",
                "value"       => "enable",
                "dependency"  => array(
                    "element" => "style",
                    "value"   => array("1", "2"),
                ),
            ),
            array(
                "type"        => "dropdown",
                "class"       => "",
                "heading"     => esc_html__("Animation", "aventa"),
                "param_name"  => "entrance_animation",
                "description" => esc_html__("Select animation type", "aventa"),
                "value"       => $animations,
                "group"       => esc_html__("Animation", "aventa"),
                "dependency"  => array(
                    "element" => "style",
                    "value"   => array("1", "2"),
                ),
            ),
            array(
                "type"        => "textfield",
                "class"       => "",
                "heading"     => esc_html__("Animation Delay", "aventa"),
                "param_name"  => "delay",
                "value"       => "",
                "description" => esc_html__("Enter animation delay (in milliseconds), for example if you want 3 seconds delay, you should enter 3000 .", "aventa"),
                "group"       => esc_html__("Animation", "aventa"),
                "dependency"  => array(
                    "element" => "style",
                    "value"   => array("1", "2"),
                ),
            ),
        );

        vc_add_params("product_categories", $categories_options);

    }
}

add_action("vc_after_mapping", "rad_vc_change_woocommerce_elements", 15);

/*-----------------------------------------------------------------------------------*/
/* VC basic grid
/*-----------------------------------------------------------------------------------*/
// remove filter
vc_remove_param("vc_basic_grid", "show_filter");
vc_remove_param("vc_basic_grid", "filter_source");
vc_remove_param("vc_basic_grid", "exclude_filter");
vc_remove_param("vc_basic_grid", "filter_style");
vc_remove_param("vc_basic_grid", "filter_align");
vc_remove_param("vc_basic_grid", "filter_color");
vc_remove_param("vc_basic_grid", "filter_size");

// remove load more button style
vc_remove_param("vc_basic_grid", "button_color");
vc_remove_param("vc_basic_grid", "button_size");
vc_remove_param("vc_basic_grid", "button_style");

// remove pagination options
vc_remove_param("vc_basic_grid", "arrows_design");
vc_remove_param("vc_basic_grid", "arrows_color");
vc_remove_param("vc_basic_grid", "arrows_position");
vc_remove_param("vc_basic_grid", "paging_design");
vc_remove_param("vc_basic_grid", "paging_color");

/*-----------------------------------------------------------------------------------*/
/* Add container functionality to shortcodes
/*-----------------------------------------------------------------------------------*/
if (class_exists("WPBakeryShortCodesContainer")) {

    class WPBakeryShortCode_rad_toggle extends WPBakeryShortCodesContainer
    {}
}

class WPBakeryShortCode_rad_tab_group extends WPBakeryShortCode
{
    protected $controls_css_settings = "out-tc vc_controls-content-widget";
}
class WPBakeryShortCode_rad_tour_group extends WPBakeryShortCode
{
    public $layout = "tabs";
}

class WPBakeryShortCode_rad_slideshow extends WPBakeryShortCode
{
    protected $controls_css_settings = "out-tc vc_controls-content-widget";
}

class WPBakeryShortCode_rad_accordion_group extends WPBakeryShortCode
{
    protected $controls_css_settings = "out-tc vc_controls-content-widget";
}

class WPBakeryShortCode_rad_testimonial extends WPBakeryShortCode
{
    protected $controls_css_settings = "out-tc vc_controls-content-widget";
}

class WPBakeryShortCode_rad_carousel_gallery extends WPBakeryShortCode
{
    protected $controls_css_settings = "out-tc vc_controls-content-widget";
}

VcShortcodeAutoloader::getInstance()->includeClass("WPBakeryShortCode_Vc_Tta_Accordion");

if (class_exists("WPBakeryShortCode_Vc_Tta_Accordion")) {

    class WPBakeryShortCode_rad_tta extends WPBakeryShortCode_Vc_Tta_Accordion
    {
        protected $controls_css_settings = "tc vc_control-container";
        protected $controls_list         = array(
            "add",
            "edit",
            "clone",
            "delete",
        );
        protected $backened_editor_prepend_controls = false;
        /**
         * @return string
         */
        public function containerContentClass()
        {
            return "wpb_column_container vc_container_for_children vc_clearfix";
        }
    }

    class WPBakeryShortCode_rad_gallery_item extends WPBakeryShortCode_Vc_Tta_Accordion
    {
        protected $controls_css_settings = "tc vc_control-container";
        protected $controls_list         = array(
            "edit",
            "clone",
            "delete",
        );
        protected $backened_editor_prepend_controls = false;
        /**
         * @return string
         */
        public function containerContentClass()
        {
            return "wpb_column_container vc_container_for_children vc_clearfix";
        }
    }
}

if (class_exists("WPBakeryShortCode")) {

    class WPBakeryShortCode_rad_testimonial_item extends WPBakeryShortCode
    {

        // Show Images in images Selector ( VC )
        public function singleParamHtmlHolder($param, $value)
        {
            $output = "";
            // Compatibility fixes
            $old_names = array("yellow_message", "blue_message", "green_message", "button_green", "button_grey", "button_yellow", "button_blue", "button_red", "button_orange");
            $new_names = array("alert-block", "alert-info", "alert-success", "btn-success", "btn", "btn-info", "btn-primary", "btn-danger", "btn-warning");
            $value     = str_ireplace($old_names, $new_names, $value);

            $param_name = isset($param["param_name"]) ? $param["param_name"] : "";
            $type       = isset($param["type"]) ? $param["type"] : "";
            $class      = isset($param["class"]) ? $param["class"] : "";

            if (isset($param["holder"]) == false || $param["holder"] == "hidden") {
                $output .= "<input type=\"hidden\" class=\"wpb_vc_param_value " . esc_attr($param_name . " " . $type . " " . $class) . "\" name=\"" . esc_attr($param_name) . "\" value=\"" . esc_attr($value) . "\" />";
                if (($param["type"]) == "attach_image") {
                    $element_icon = $this->settings("icon");
                    $img          = wpb_getImageBySize(array("attach_id" => (int) preg_replace("/[^\d]/", "", $value), "thumb_size" => "thumbnail"));
                    $this->setSettings("logo", ($img ? $img["thumbnail"] : "<img width=\"150\" height=\"15\" src=\"" . esc_url(vc_asset_url("vc/blank.gif")) . "\" class=\"attachment-thumbnail vc_element-icon\" data-name=\"" . esc_attr($param_name) . "\" alt=\"" . esc_attr__("Slug", "aventa") . "\" title=\"" . esc_attr__("Slug", "aventa") . "\" style=\"display: none;\" />") . "<span class=\"no_image_image vc_element-icon" . esc_attr((!empty($element_icon) ? " " . $element_icon : "") . ($img && !empty($img["p_img_large"][0]) ? " image-exists" : "")) . "\" />");
                    $output .= $this->outputTitleTrue($this->settings["name"]);

                }

            } else {
                $output .= "<" . $param["holder"] . " class=\"wpb_vc_param_value " . esc_attr($param_name . " " . $type . " " . $class) . "\" name=\"" . esc_attr($param_name) . "\">" . $value . "</" . $param["holder"] . ">";
            }

            if (!empty($param["admin_label"]) && $param["admin_label"] === true) {

                $output .= sprintf("<span class=\"vc_admin_label admin_label_" . esc_attr($param["param_name"]) . (empty($value) ? " hidden-label" : "") . "\"><label>%s</label>: " . $value . "</span>", esc_attr($param["heading"]));

            }

            return $output;
        }
        protected function outputTitle($title)
        {
            return "";
        }
        protected function outputTitleTrue($title)
        {
            return "<h4 class=\"wpb_element_title\">" . $title . " " . $this->settings("logo") . "</h4>";
        }
    }

    class WPBakeryShortCode_rad_image_carousel extends WPBakeryShortCode
    {

        public function singleParamHtmlHolder($param, $value)
        {
            $output = "";
            // Compatibility fixes
            $old_names = array("yellow_message", "blue_message", "green_message", "button_green", "button_grey", "button_yellow", "button_blue", "button_red", "button_orange");
            $new_names = array("alert-block", "alert-info", "alert-success", "btn-success", "btn", "btn-info", "btn-primary", "btn-danger", "btn-warning");
            $value     = str_ireplace($old_names, $new_names, $value);

            $param_name = isset($param["param_name"]) ? $param["param_name"] : "";
            $type       = isset($param["type"]) ? $param["type"] : "";
            $class      = isset($param["class"]) ? $param["class"] : "";

            if (isset($param["holder"]) == false || $param["holder"] == "hidden" || $param["holder"] == "") {
                $output .= "<input type=\"hidden\" class=\"wpb_vc_param_value " . esc_attr($param_name . " " . $type . " " . $class) . "\" name=\"" . esc_attr($param_name) . "\" value=\"" . esc_attr($value) . "\" />";
                if (($param["type"]) == "attach_images") {
                    $images_ids = empty($value) ? array() : explode(",", trim($value));
                    $output .= "<ul class=\"attachment-thumbnails thumb-attach-images" . (!empty($images_ids) ? " image-exists" : "") . "\" data-name=\"" . esc_attr($param_name) . "\">";
                    foreach ($images_ids as $image) {
                        $img = wpb_getImageBySize(array("attach_id" => (int) $image, "thumb_size" => "thumbnail"));
                        $output .= ($img ? "<li>" . $img["thumbnail"] . "</li>" : "<li><img width=\"32\" height=\"32\" test=\"" . esc_url($image) . "\" src=\"" . esc_url(vc_asset_url("vc/blank.gif")) . "\" class=\"attachment-thumbnail\" alt=\"" . esc_attr__("Slug", "aventa") . "\" title=\"" . esc_attr__("Slug", "aventa") . "\" /></li>");
                    }
                    $output .= "</ul>";
                }

            } else {
                $output .= "<" . $param["holder"] . " class=\"wpb_vc_param_value " . esc_attr($param_name . " " . $type . " " . $class) . "\" name=\"" . esc_attr($param_name) . "\">" . $value . "</" . $param["holder"] . ">";
            }

            if (!empty($param["admin_label"]) && $param["admin_label"] === true) {

                $output .= sprintf("<span class=\"vc_admin_label admin_label_" . $param["param_name"] . (empty($value) ? " hidden-label" : "") . "\"><label>%s</label>: " . $value . "</span>", esc_attr($param["heading"]));

            }

            return $output;
        }
    }

}

if (!function_exists("productTagsAutocompleteSuggesterBySlug")) {
    function productTagsAutocompleteSuggesterBySlug($query, $slug = true)
    {
        global $wpdb;
        $cat_id          = (int) $query;
        $query           = trim($query);
        $post_meta_infos = $wpdb->get_results($wpdb->prepare("SELECT a.term_id AS id, b.name as name, b.slug AS slug
                        FROM {$wpdb->term_taxonomy} AS a
                        INNER JOIN {$wpdb->terms} AS b ON b.term_id = a.term_id
                        WHERE a.taxonomy = 'product_tag' AND (a.term_id = '%d' OR b.slug LIKE '%%%s%%' OR b.name LIKE '%%%s%%' )", $cat_id > 0 ? $cat_id : -1, stripslashes($query), stripslashes($query)), ARRAY_A);

        $result = array();
        if (is_array($post_meta_infos) && !empty($post_meta_infos)) {
            foreach ($post_meta_infos as $value) {
                $data          = array();
                $data["value"] = $slug ? $value["slug"] : $value["id"];
                $data["label"] = esc_html__("Id", "aventa") . ": " . $value["id"] . ((strlen($value["name"]) > 0) ? " - " . esc_html__("Name", "aventa") . ": " . $value["name"] : "") . ((strlen($value["slug"]) > 0) ? " - " . esc_html__("Slug", "aventa") . ": " . $value["slug"] : "");
                $result[]      = $data;
            }
        }

        return $result;
    }
}
if (!function_exists("productTagsRenderBySlugExact")) {
    function productTagsRenderBySlugExact($query)
    {
        $query = $query["value"];
        $query = trim($query);
        $term  = get_term_by("slug", $query, "product_tag");

        if (is_wp_error($term) || !$term) {
            return false;
        }

        $data          = array();
        $data["value"] = $term->slug;
        $data["label"] = esc_html__("Id", "aventa") . ": " . $term->term_id . " - " . esc_html__("Name", "aventa") . ": " . $term->name;

        return $data;
    }
}
