<?php

namespace Aventa;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Tour_Block_Widget extends Widget_Base{

  public function get_name() {
    return "rad-tour-block";
  }

  public function get_title() {
    return esc_html__("Tour Block", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-post-list";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Tour Block", "aventa" ),
			]
		);

    // Tour active item
		$this->add_control(
			"tour_active_item", 
      [
				"label" => esc_html__( "Active Item", "aventa" ),
				"type" => Controls_Manager::NUMBER,
        "separator" => "after",
        "default" => 0
			]
		);

    // Tour item fields
    $tour_item = new Repeater();

    // Tour item icon
    $tour_item->add_control(
      "tour_show_icon",
      [
        "label" => esc_html__( "Show Icon?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    $tour_item->add_control(
      "tour_icon", 
      [
        "label" => esc_html__( "Icon", "aventa" ),
        "type" => Rad_Icons_Control::TYPE,
        "default" => "smile",
        "condition" => [
          "tour_show_icon" => "true"
        ]
      ]
    );

    // Tour item title
		$tour_item->add_control(
			"tour_item_title", 
      [
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Item Title" , "aventa" ),
        "separator" => "after"
			]
		);

    // Tour item content
		$tour_item->add_control(
			"tour_item_content", [
				"label" => esc_html__( "Content", "aventa" ),
				"type" => Controls_Manager::WYSIWYG,
				"default" => esc_html__( "Item content. Click the edit button to change this text." , "aventa" ),
			]
		);

    // Tour item repeater
		$this->add_control(
			"tour_items",
			[
				"label" => esc_html__( "tour Items", "aventa" ),
				"type" => Controls_Manager::REPEATER,
				"fields" => $tour_item->get_controls(),
				"default" => [
					[
						"tour_item_title" => esc_html__( 'Item #1', "aventa" ),
						"tour_item_content" => esc_html__( "Item content. Click the edit button to change this text.", "aventa"),
					],
					[
						"tour_item_title" => esc_html__( 'Item #2', "aventa" ),
						"tour_item_content" => esc_html__( "Item content. Click the edit button to change this text.", "aventa"),
					],
				],
				"title_field" => "{{{ tour_item_title }}}",
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // tour icon position
    $this->add_control(
      "tour_icon_position",
      [
        "label" => esc_html__( "Icon Position", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "i-left" => [
            "title" => esc_html__( "Left", "aventa" ),
            "icon" => "eicon-h-align-left",
          ],
          "i-right" => [
            "title" => esc_html__( "Right", "aventa" ),
            "icon" => "eicon-h-align-right",
          ]
        ],
        "default" => "i-left"
      ]
    );

    // Tour alignment
    Rad_Helpers::alignment($this, "tour_alignment", [], [ "left", "right" ], "left", false);

    // Tour hover style
    $this->add_control(
      "tour_hover_style",
      [
        "label" => esc_html__( "Hover Style", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "color-style" => esc_html__( "Change Color", "aventa" ),
          "line-style" => esc_html__( "Show Line", "aventa" ),
        ],
        "default" => "color-style"
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "tour_items" ] ) {
			return;
		}

    $classes = [ 
      "tab-block", 
      "tour-block", 
      "resp-block"
    ];

    // User inputs
		$tour_items       = $settings[ "tour_items" ];
		$alignment        = esc_html( $settings[ "tour_alignment" ] );
    $hover_style      = esc_html( $settings[ "tour_hover_style" ] );
    $icon_position    = esc_html( $settings[ "tour_icon_position" ] );
    $active_item      = is_numeric( $settings[ "tour_active_item" ] )
      ? esc_html( $settings[ "tour_active_item" ] )
      : 0 ;

    // Assign proper class based on selected options
    $classes[] = $alignment;
    $classes[] = $hover_style;
    $classes[] = $icon_position;

    // Element attributes
		$this->add_render_attribute( "tour_block_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "tour_nav_wrapper", "class", "tab-nav" );
		$this->add_render_attribute( "tour_contents_wrapper", "class", "tab-contents" );
		$this->add_render_attribute( "tour_content", "class", "tab-content" );

    // HTML elements
    if ( $tour_items ) {
      // nav and contents array holds html code of each individual tour item
      $nav_array = [];
      $contents_array = [];

			foreach (  $tour_items as $key => $tour_item ) {
        // Add active class to the first item, and remove it from others
        if ( $key == $active_item ) {
          $this->add_render_attribute( "tour_nav_item", "class", "active" );
          $this->add_render_attribute( "tour_content", "class", "active" );
        } else if ( $key == $active_item + 1 ) {
          $this->remove_render_attribute( "tour_nav_item", "class", "active" );
          $this->remove_render_attribute( "tour_content", "class", "active" );
        }

        $this->add_render_attribute( "tour_nav_item", "data-id", $key, true );
        
        $title    = esc_html( $tour_item[ "tour_item_title" ] );
        $content  = $tour_item[ "tour_item_content" ];
        $has_icon = esc_html( $tour_item[ "tour_show_icon" ] );
        $icon 	  = ( $has_icon )
          ? \Rad_Icon_Manager::get_icon( 
            esc_html( $tour_item[ "tour_icon" ] ), 
            "all"
          )
          : null;

        // Add icon to the title based on position
        $title = ( $icon_position == "i-right" )
          ? $title . $icon 
          : $icon . $title;

        $nav_item_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "li",
          $this->get_render_attribute_string( "tour_nav_item" ),
          $title
        );

        $content_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "tour_content" ),
          $content
        );

        $nav_array[]        = $nav_item_html;
        $contents_array[]   = $content_html;
			}

      // Tour nav wrapper
      $nav_wrapper_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "ul",
        $this->get_render_attribute_string( "tour_nav_wrapper" ),
        implode( "", $nav_array )
      );

      // Tour contents wrapper
      $contents_wrapper_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>', 
        "div",
        $this->get_render_attribute_string( "tour_contents_wrapper" ),
        implode( "", $contents_array )
      );

      // Final HTML to render
      $html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>',
        "div",
        $this->get_render_attribute_string( "tour_block_wrapper" ),
        $nav_wrapper_html . $contents_wrapper_html
      );
  
      echo "$html";
		}

  }

}