<?php

namespace Aventa;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Testimonial_Widget extends Widget_Base{

  public function get_name() {
    return "rad-testimonial";
  }

  public function get_title() {
    return esc_html__("Testimonial", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-testimonial-carousel";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Testimonials", "aventa" ),
			]
		);

    $testimonial_item = new Repeater();

    // Testimonial name
		$testimonial_item->add_control(
			"testimonial_name", [
				"label" => esc_html__( "Name", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "John Doe" , "aventa" )
			]
		);

    // Testimonial job
		$testimonial_item->add_control(
			"testimonial_job", [
				"label" => esc_html__( "Job", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "Developer" , "aventa" )
			]
		);

    // Testimonial text
		$testimonial_item->add_control(
			"testimonial_text", [
				"label" => esc_html__( "Text", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
        "default" => esc_html( "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." )
			]
		);

    // Testimonial image
    $testimonial_item->add_control(
			"testimonial_image",
			[
				"label" => esc_html__( "Image", "aventa" ),
				"type" => Controls_Manager::MEDIA,
				"default" => [
					"url" => Utils::get_placeholder_image_src(),
				]
			]
		); 

    $this->add_control(
			"testimonials",
			[
				"label" => esc_html__( "Testimonials", "aventa" ),
				"type" => Controls_Manager::REPEATER,
				"fields" => $testimonial_item->get_controls(),
				"default" => [
					[
						"testimonial_name" => esc_html__( "John Doe", "aventa" ),
						"testimonial_job" => esc_html__( "Founder", "aventa" ),
						"testimonial_text" => esc_html__( "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", "aventa" ),
						"testimonial_image" => [
              "url" => Utils::get_placeholder_image_src()
            ]
					]
				],
				"title_field" => "{{{ testimonial_name }}}",
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Testimonials style
    $this->add_control(
      "testimonial_style",
      [
        "label" => esc_html__( "Style", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "light" => esc_html__( "Light", "aventa" ),
          "dark" => esc_html__( "Dark", "aventa" ),
        ],
        "default" => "dark"
      ]
    );

    // Testimonials columns
    $this->add_control(
      "testimonial_columns",
      [
        "label" => esc_html__( "Columns", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "1" => "1",
          "2" => "2",
          "3" => "3",
          "4" => "4",
        ],
        "default" => "1"
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "testimonials" ] ) {
			return;
		}

    $classes = [ 
      "testimonial-block",
      "resp-block",
      "carousel"
    ];

    // User inputs
		$testimonials   = $settings[ "testimonials" ];
    $columns        = esc_attr( $settings[ "testimonial_columns" ] );
		$style          = esc_html( $settings[ "testimonial_style" ] );

    // Assign proper class based on selected options
    $classes[] = $style;

    // Element attributes
		$this->add_render_attribute( "testimonial_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "swiper_container", "class", "swiper-container" );
		$this->add_render_attribute( "swiper_container", "data-visibleitems", $columns );
		$this->add_render_attribute( "swiper_wrapper", "class", "swiper-wrapper" );
		$this->add_render_attribute( "swiper_pagination", "class", "swiper-pagination" );
		$this->add_render_attribute( "testimonial_item", "class", "swiper-slide msg" );
		$this->add_render_attribute( "testimonial_image", "class", "img" );
		$this->add_render_attribute( "testimonial_author", "class", "author" );
		$this->add_render_attribute( "testimonial_name", "class", "name" );
		$this->add_render_attribute( "testimonial_job", "class", "job" );
		$this->add_render_attribute( "testimonial_text", "class", "quote" );

    if ( $testimonials ) {

      // Holds each individual testimonial
      $items_array = []; 
      
      foreach ( $testimonials as $testimonial ) {
        $name  = esc_html( $testimonial[ "testimonial_name" ] );
        $job   = esc_html( $testimonial[ "testimonial_job" ] );
        $text  = esc_html( $testimonial[ "testimonial_text" ] );
        $image = $testimonial[ "testimonial_image" ][ "id" ]
          ? esc_url ( $testimonial[ "testimonial_image" ][ "url" ] )
          : Utils::get_placeholder_image_src();

        $this->add_render_attribute( "testimonial_image", "style", "background-image: url($image)", true );

        // HTML elements
        $text_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "testimonial_text" ),
          $text
        );

        $image_html = sprintf( 
          '<%1$s %2$s></%1$s>', 
          "span",
          $this->get_render_attribute_string( "testimonial_image" )
        );

        $name_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "h4",
          $this->get_render_attribute_string( "testimonial_name" ),
          $name
        );

        $job_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "cite",
          $this->get_render_attribute_string( "testimonial_job" ),
          $job
        );

        $author_html = sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "testimonial_author" ),
          $name_html . $job_html
        );

        $testimonial_item_html  =  sprintf( 
          '<%1$s %2$s>%3$s</%1$s>', 
          "div",
          $this->get_render_attribute_string( "testimonial_item" ),
          "<blockquote>" . $text_html . $image_html . $author_html . "</blockquote>"
        );

        $items_array[] = $testimonial_item_html;
      }

      $swiper_wrapper_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>',
        "div",
        $this->get_render_attribute_string( "swiper_wrapper" ),
        implode( "", $items_array )
      );

      $swiper_pagination_html = sprintf( 
        '<%1$s %2$s></%1$s>',
        "div",
        $this->get_render_attribute_string( "swiper_pagination" )
      );

      $swiper_container_html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>',
        "div",
        $this->get_render_attribute_string( "swiper_container" ),
        $swiper_wrapper_html . $swiper_pagination_html
      );

      // Final HTML to render
      $html = sprintf( 
        '<%1$s %2$s>%3$s</%1$s>',
        "div",
        $this->get_render_attribute_string( "testimonial_wrapper" ),
        $swiper_container_html
      );

      echo "$html";
    }

  }

}