<?php
namespace Aventa;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( "ABSPATH" ) ) {
	exit; // Exit if accessed directly
}

class Rad_Single_Product_Widget extends Widget_Base {

	public function get_name() {
		return "rad-single-product";
	}

	public function get_title() {
		return esc_html__( "Single Product", "aventa" );
	}

	public function get_icon() {
		return "eicon-single-product";
	}

	public function get_keywords() {
		return [ "woocommerce", "shop", "store", "product", "archive", "aventa" ];
	}

	public function get_categories() {
		return [ Rad_Helpers::WC_WIDGETS_CATEGORY ];
	}

	protected function register_controls() {

    $this->start_controls_section(
			"section_query",
			[
				"label" => esc_html__( "Single Product", "aventa" ),
				"tab" => Controls_Manager::TAB_CONTENT,
			]
		);

    $this->add_control(
			"custom_product",
			[
				"label"         => esc_html__( "Product", "aventa" ),
				"type"          => Controls_Manager::SELECT2,
				"options"       => Rad_Helpers::get_products(),
        "description"   => esc_html__( "Search products by id or title.", "aventa" )
			]
		);

		$this->end_controls_section();

		// General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			"product_style",
			[
				"label"         => esc_html__( "Style", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"general" 	=> esc_html__( "General", "aventa" ),
					"creative" 	=> esc_html__( "Creative", "aventa" ),
					"bt-hover" 	=> esc_html__( "Buttons on Hover", "aventa" ),
					"qv-hover" 	=> esc_html__( "Quickview on Hover", "aventa" ),
				],
				"required" 		=> true,
        "default"     => "bt-hover"
			]
		);

		$this->add_control(
			"product_hover_image",
			[
				"label" 				=> esc_html__( "Hover Image", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Show", "aventa" ),
				"label_off" 		=> esc_html__( "Hide", "aventa" ),
				"return_value" 	=> "show",
				"default" 			=> "show"
			]
		);

		$this->add_control(
			"product_quickview_button",
			[
				"label" 				=> esc_html__( "Quick-view Button", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Show", "aventa" ),
				"label_off" 		=> esc_html__( "Hide", "aventa" ),
				"return_value" 	=> "enable",
				"default" 			=> "enable",
				"condition"     => [
					"product_style!" => "qv-hover"
				]
			]
		);

		$this->add_control(
			"product_wishlist_button",
			[
				"label" 				=> esc_html__( "Wishlist Button", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Show", "aventa" ),
				"label_off" 		=> esc_html__( "Hide", "aventa" ),
				"return_value" 	=> "enable",
				"default" 			=> "enable"
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			"section_image_style",
			[
				"label" => esc_html__( "Image", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
      "product_image_size",
      [
        "label" => esc_html__( "Image Size", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "full"   								=> esc_html__( "Full", "aventa" ),
          "woocommerce_single"   	=> esc_html__( "Single Product Image", "aventa" ),
          "woocommerce_thumbnail" => esc_html__( "Product Thumbnail", "aventa" ),
          "custom"   							=> esc_html__( "Custom", "aventa" ),
				],
        "default" => "woocommerce_single"
      ]
    );

    $this->add_control(
			"product_image_dimension",
			[
				"label" => esc_html__( "Image Dimension", "aventa" ),
				"type" => Controls_Manager::IMAGE_DIMENSIONS,
				"description" => esc_html__( "Crop the original image size to any custom size.", "aventa" ),
        "condition" => [
          "products_image_size" => "custom"
        ]
			]
		);

		$this->add_control(
			"product_crop_image",
			[
				"label" 				=> esc_html__( "Crop Image?", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Yes", "aventa" ),
				"label_off" 		=> esc_html__( "No", "aventa" ),
				"return_value" 	=> "true",
				"default" 			=> "true",
				"condition" => [
          "products_image_size" => "custom"
        ]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings();

    if ( !$settings[ "custom_product" ] ) {
      return;
    }

		$atts = [];
    $atts[ "ids" ]            = esc_attr( $settings[ "custom_product" ] );
		$atts[ "style" ] 					= esc_attr( $settings[ "product_style" ] );
		$atts[ "wishlist" ] 			= esc_attr( $settings[ "product_wishlist_button" ] );
		$atts[ "image_size" ]     = esc_attr( $settings[ "product_image_size" ] );

		if ( $atts[ "style" ] != "qv-hover" && $settings[ "product_quickview_button" ] != "enable" ) {
			$atts[ "quickview" ] = "disable";
		}

		if ( $atts[ "image_size" ] == "custom" ) {
			$atts[ "image_size_width" ]     = esc_attr( $settings[ "product_image_dimension" ][ "width" ] );
      $atts[ "image_size_height" ]   	= esc_attr( $settings[ "product_image_dimension" ][ "height" ] );
      $atts[ "image_size_crop" ]      = esc_attr( $settings[ "product_crop_image" ] );
		}

		$html = rad_products( $atts );

    echo "$html";
	}

}
