<?php

namespace Aventa;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Reveal_Slideshow_Widget extends Widget_Base{

  public function get_name() {
    return "rad-reveal-slideshow";
  }

  public function get_title() {
    return esc_html__("Reveal Slideshow", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-slider-push";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Reveal Slideshow", "aventa" ),
			]
		);

    $this->add_control(
			"rs_images",
			[
				"label" => esc_html__( "Images", "aventa" ),
				"type" => Controls_Manager::GALLERY,
				"default" => [],
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    Rad_Helpers::slider(
      $this,
      "rs_height",
      esc_html__( "Height (%)", "aventa" ),
      [],
      50,
      [ "min" => 30, "max" => 200, "step" => 1 ],
      [],
      false
    );

    $this->add_control(
      "rs_cursor_style",
      [
        "label" => esc_html__( "Cursor Style", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "light" => [
            "title" => esc_html__( "Light", "aventa" ),
            "icon" => "fas fa-sun"
          ],
          "dark" => [
            "title" => esc_html__( "Dark", "aventa" ),
            "icon" => "fas fa-moon"
          ]
        ],
        "default" => "dark"
      ]
    );

    $this->add_control(
      "rs_pagination_color",
      [
        "label" => esc_html__( "Pagination Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"selectors" => [
					"{{WRAPPER}} .rs-pagination" => "color: {{VALUE}};",
				],
        "separator" => "after"
      ]
    );

    $this->add_control(
      "rs_image_size",
      [
        "label" => esc_html__( "Image Size", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "full"   => esc_html__( "Full", "aventa" ),
          "medium"   => esc_html__( "Medium", "aventa" ),
          "thumbnail"   => esc_html__( "Thumbnail", "aventa" ),
          "custom"   => esc_html__( "Custom", "aventa" ),
        ],
        "separator" => "before",
        "default" => "full"
      ]
    );

    $this->add_control(
			"rs_image_dimension",
			[
				"label" => esc_html__( "Image Dimension", "aventa" ),
				"type" => Controls_Manager::IMAGE_DIMENSIONS,
				"description" => esc_html__( "Crop the original image size to any custom size.", "aventa" ),
        "condition" => [
          "rs_image_size" => "custom"
        ]
			]
		);

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "rs_images" ] ) {
			return;
		}

    $classes = [ 
      "reveal-slideshow-block", 
      "resp-block"
    ];

    // User inputs
		$slideshow_items  = $settings[ "rs_images" ];
    $cursor_style     = esc_attr( $settings[ "rs_cursor_style" ] );
    $height           = esc_attr( $settings[ "rs_height" ][ "size" ] );
		$image_size       = esc_attr( $settings[ "rs_image_size" ] );
    $image_width      = "";
    $image_height     = "";
    if($image_size == "custom")
    {
      $image_width      = esc_attr( $settings[ "rs_image_dimension" ][ "width" ] );
      $image_height     = esc_attr( $settings[ "rs_image_dimension" ][ "height" ] );
    }
    
    $image_crop       = ( empty( $image_dimension[ "width" ] ) || empty( $image_dimension[ "height" ] ) )
      ? true
      : false ;

    if ( $slideshow_items ) {

      $id = Utils::generate_random_string();
      $height_style = "padding-top:$height%;";
      $attr         = "data-cursor='#$id-p-g-cursor'";

      $html = rad_make_container("div", "", $id, implode(" ", array_filter($classes)), "", "", false);
      $html .= rad_make_container("div", "", "", "rsl-images custom-cursor", $height_style, $attr, false);

      $counter = 0;
      foreach ($slideshow_items as $slideshow_item) {

        $image_id = esc_attr( $slideshow_item[ "id" ] );

        $image = rad_get_image_url(
          $image_id, 
          "", 
          "item", 
          $image_size, 
          $image_width, 
          $image_height, 
          $image_crop, 
          true
        );

        if ( $image == "" ) continue;
        //skip this iteration

        $attr  = "data-item='" . ($counter + 1) . "'";
        $class = ($counter == 0) ? "active" : "go-out";
        $html .= rad_make_container("div", "", "", "slideshow-item " . $class, $height_style, $attr, false);

        $attr = "data-src='$image'";
        $html .= rad_make_container("div", "", "", "img lazy-load bg-lazy-load lazy-load-on-load ", "", $attr, true);
        $html .= "</div>";
        $counter++;
      }

      $html .= "</div>";
      $html .= "<span id='$id-p-g-cursor' class='rad-cursor rad-rsls-cursor $cursor_style' ><span></span></span>";
      $html .= "<span class='rs-pagination' ><span class='current'>1</span>/" . esc_html( $counter ) . "</span>";
      $html .= "</div>";

      echo "$html";
    }

  }

}