<?php
namespace Aventa;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( "ABSPATH" ) ) {
	exit; // Exit if accessed directly
}

class Rad_Product_Categories_Widget extends Widget_Base {

	public function get_name() {
		return "rad-product_categories";
	}

	public function get_title() {
		return esc_html__( "Product Categories", "aventa" );
	}

	public function get_icon() {
		return "eicon-product-categories";
	}

	public function get_keywords() {
		return [ "woocommerce", "shop", "store", "product", "archive", "aventa" ];
	}

	public function get_categories() {
		return [ Rad_Helpers::WC_WIDGETS_CATEGORY ];
	}

	protected function register_controls() {

    $this->start_controls_section(
			"section_query",
			[
				"label" => esc_html__( "Product Categories", "aventa" ),
				"tab" => Controls_Manager::TAB_CONTENT,
			]
		);

    $this->add_control(
			"custom_categories",
			[
				"label"         => esc_html__( "Select Categories", "aventa" ),
				"type"          => Controls_Manager::SELECT2,
				"multiple"      => true,
				"options"       => Rad_Helpers::get_wc_categories()
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			"section_settings",
			[ "label" => esc_html__( "Settings", "aventa" ) ]
		);

    $this->add_control(
			"pc_show_description",
			[
				"label" 				=> esc_html__( "Category Description", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Show", "aventa" ),
				"label_off" 		=> esc_html__( "Hide", "aventa" ),
				"return_value" 	=> "enable",
				"default" 			=> "enable",
				"condition"     => [
          "pc_style!" => "3"
        ]
			]
		);

    $this->add_control(
			"pc_product_count",
			[
				"label" 				=> esc_html__( "Categories Item Count", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Show", "aventa" ),
				"label_off" 		=> esc_html__( "Hide", "aventa" ),
				"return_value" 	=> "enable",
				"default" 			=> "enable"
			]
		);

    $this->add_control(
			"pc_hide_empty",
			[
				"label" 				=> esc_html__( "Hide Empty Categories?", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Yes", "aventa" ),
				"label_off" 		=> esc_html__( "No", "aventa" ),
				"return_value" 	=> "1",
				"default" 			=> "1"
			]
		);

		$this->add_control(
			"pc_columns",
			[
				"label" => esc_html__( "Columns", "aventa" ),
				"type" => Controls_Manager::NUMBER,
				"min" => 1,
				"max" => 6,
				"default" => 4,
				"condition" => [
					"pc_grid_mode!" => "masonry"
				]
			]
		);

		$this->add_control(
			"pc_limit",
			[
				"label" => esc_html__( "Max Number of Categories", "aventa" ),
				"type" => Controls_Manager::NUMBER,
				"min" => 1
			]
		);

		$this->add_control(
			"pc_order_by",
			[
				"label"         => esc_html__( "Order By", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"date"								=> esc_html__( "Date", "aventa" ),
					"ID"									=> esc_html__( "ID", "aventa" ),
					"author"							=> esc_html__( "Author", "aventa" ),
					"title"								=> esc_html__( "Title", "aventa" ),
					"modified"						=> esc_html__( "Date Modified", "aventa" ),
					"rand"								=> esc_html__( "Random", "aventa" ),
					"comment_count"				=> esc_html__( "Number of Comments", "aventa" ),
					"menu_order"				  => esc_html__( "Menu Order", "aventa" ),
					"menu_order title"  	=> esc_html__( "Menu Order & Title", "aventa" ),
					"include"							=> esc_html__( "Include", "aventa" ),
					"post__in"					 	=> esc_html__( "Custom Post-In", "aventa" )
				],
				"description" 	=> "More at <a href='https://developer.wordpress.org/reference/classes/wp_query/#order-orderby-parameters' target='_blank'>WordPress Codex</a> page.",
        "default"       => "date",
			]
		);

		$this->add_control(
			"pc_sort_order",
			[
				"label"         => esc_html__( "Sort Order", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"ASC" 	=> esc_html__( "Ascending", "aventa" ),
					"DESC" 	=> esc_html__( "Descending", "aventa" ),
				],
        "default"       => "DESC",
			]
		);
		
		$this->end_controls_section();

		// General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    
		$this->add_control(
			"pc_style",
			[
				"label"         => esc_html__( "Style", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"1" 	=> esc_html__( "General", "aventa" ),
					"2" 	=> esc_html__( "Hover", "aventa" ),
					"3" 	=> esc_html__( "Creative", "aventa" )
				],
        "default"     => "1"
			]
		);

		$this->add_control(
			"pc_display_mode",
			[
				"label"         => esc_html__( "Display Mode", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"grid" 	=> esc_html__( "Grid", "aventa" ),
					"carousel" 	=> esc_html__( "Carousel", "aventa" ),
				],
        "default"       => "grid",
        "condition"     => [
          "pc_style!" => "3"
        ]
			]
		);

		$this->add_control(
			"pc_navigation",
			[
				"label"         => esc_html__( "Navigation Type", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"next-prev" 	=> esc_html__( "Next/Prev Button", "aventa" ),
					"scrollbar" 	=> esc_html__( "Scrollbar", "aventa" ),
					"pagination" 	=> esc_html__( "Bullets", "aventa" ),
				],
        "default"       => "next-prev",
				"condition"     => [
					"pc_display_mode" => "carousel"
				]
			]
		);

		$this->add_control(
			"pc_navigation_style",
			[
				"label"         => esc_html__( "Navigation Style", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"dark" 	=> esc_html__( "Dark", "aventa" ),
					"light" 	=> esc_html__( "Light", "aventa" ),
				],
        "default"       => "dark",
				"condition"     => [
					"pc_display_mode" => "carousel"
				]
			]
		);

		$this->add_control(
			"pc_grid_mode",
			[
				"label"         => esc_html__( "Grid Mode", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"standard" 	=> esc_html__( "Standard", "aventa" ),
					"masonry" 		=> esc_html__( "Masonry", "aventa" )
				],
        "default"       => "standard",
				"condition"     => [
          "pc_style!" => "3",
          "pc_display_mode" => "grid"
        ]
			]
		);

		$this->add_control(
			"pc_masonry_style",
			[
				"type" => Rad_Visual_Option_Selector_Control::TYPE,
				"label" => esc_html__( "Masonry Style", "aventa" ),
				"icon_dir" => "masonry_style",
				"options" => [
					"i2a" => "i2a",
					"i3a" => "i3a",
					"i3b" => "i3b",
					"i4a" => "i4a",
					"i4b" => "i4b",
					"i5a" => "i5a",
					"i5b" => "i5b",
					"i5c" => "i5c"
				],
				"default"       => "i2a",
				"condition"     => [
          "pc_grid_mode" => "masonry",
          "pc_display_mode" => "grid",
          "pc_style!" => "3"
        ]
			]
		);

		$this->add_control(
			"pc_hr",
			[ "type" => Controls_Manager::DIVIDER ]
		);

		$this->add_control(
			"pc_gutter",
			[
				"label"         => esc_html__( "Gutter", "aventa" ),
				"type"          => Controls_Manager::SELECT,
				"options"       => [
					"0" 	=> esc_html__( "One Unit", "aventa" ),
					"1" 	=> esc_html__( "Two Units", "aventa" ),
				],
        "default"       => "0"
			]
		);

		$this->add_control(
			"pc_text_color",
			[
				"label"         => esc_html__( "Text Color", "aventa" ),
				"type"          => Controls_Manager::COLOR,
				"separator"			=> "before",
				"default"				=> "#fff",
				"selectors"			=> [
					"{{WRAPPER}} .title > *" => "color: {{VALUE}} !important;"
				]
			]
		);

		$this->add_control(
			"pc_overlay_color",
			[
				"label"         => esc_html__( "Overlay Color", "aventa" ),
				"type"          => Controls_Manager::COLOR,
				"default"				=> "#000",
				"selectors"			=> [
					"{{WRAPPER}} .product-category .product-wrap span.overlay" => "background:linear-gradient(0, {{VALUE}}90,{{VALUE}}30,transparent, transparent) !important;"
				],
				"condition" => [
					"pc_style" => "1"
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			"section_image_style",
			[
				"label" => esc_html__( "Image", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
      "pc_image_size",
      [
        "label" => esc_html__( "Image Size", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "full"   								=> esc_html__( "Full", "aventa" ),
          "woocommerce_single"   	=> esc_html__( "Single Product Image", "aventa" ),
          "woocommerce_thumbnail" => esc_html__( "Product Thumbnail", "aventa" ),
          "custom"   							=> esc_html__( "Custom", "aventa" ),
				],
        "default" => "woocommerce_single"
      ]
    );

    $this->add_control(
			"pc_image_dimension",
			[
				"label" => esc_html__( "Image Dimension", "aventa" ),
				"type" => Controls_Manager::IMAGE_DIMENSIONS,
				"description" => esc_html__( "Crop the original image size to any custom size.", "aventa" ),
        "condition" => [
          "pc_image_size" => "custom"
        ]
			]
		);

		$this->add_control(
			"pc_crop_image",
			[
				"label" 				=> esc_html__( "Crop Image?", "aventa" ),
				"type" 					=> Controls_Manager::SWITCHER,
				"label_on" 			=> esc_html__( "Yes", "aventa" ),
				"label_off" 		=> esc_html__( "No", "aventa" ),
				"return_value" 	=> "true",
				"default" 			=> "true",
				"condition" => [
          "pc_image_size" => "custom"
        ]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings();

		$atts = [];
		$atts[ "columns" ] 				= esc_attr( $settings[ "pc_columns" ] );
		$atts[ "orderby" ] 				= esc_attr( $settings[ "pc_order_by" ] );
		$atts[ "order" ] 					= esc_attr( $settings[ "pc_sort_order" ] );
		$atts[ "limit" ] 					= esc_attr( $settings[ "pc_limit" ] );
		$atts[ "style" ] 					= esc_attr( $settings[ "pc_style" ] );
    $atts[ "gutter" ]   			= esc_attr( $settings[ "pc_gutter" ] );
		$atts[ "grid_type" ] 			= esc_attr( $settings[ "pc_grid_mode" ] );
		$atts[ "count" ]  				= esc_attr( $settings[ "pc_product_count" ] );
		$atts[ "description" ]  	= esc_attr( $settings[ "pc_show_description" ] );
		$atts[ "image_size" ]    	= esc_attr( $settings[ "pc_image_size" ] );
		$atts[ "hide_empty" ]    	= $settings[ "pc_hide_empty" ] ? 1 : 0;

		if ( $settings[ "custom_categories" ] ) {
			$atts[ "ids" ] = implode( ", ",  array_map( "esc_attr", $settings[ "custom_categories" ] ) );
		}

		if ( $atts[ "image_size" ] == "custom" ) {
			$atts[ "image_size_width" ]     = esc_attr( $settings[ "pc_image_dimension" ][ "width" ] );
      $atts[ "image_size_height" ]   	= esc_attr( $settings[ "pc_image_dimension" ][ "height" ] );
      $atts[ "image_size_crop" ]      = esc_attr( $settings[ "pc_crop_image" ] );
		}

		if ( $this->is_control_visible( "pc_masonry_style" ) ) {
			$atts[ "masonry_style" ] 	= esc_attr( $settings[ "pc_masonry_style" ] );
		}

		if ( $this->is_control_visible( "pc_navigation" ) ) {
			$atts[ "navigation" ] = esc_attr( $settings[ "pc_navigation" ] );
			$atts[ "nav_style" ] 	= esc_attr( $settings[ "pc_navigation_style" ] );
		}

		if ( $settings[ "pc_style" ] != "3" ) {
			$atts[ "layout" ] = $settings[ "pc_display_mode" ];
		}

		$html = rad_product_categories( $atts );

    echo "$html";
	}

}
