<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Image_Carousel_Widget extends Widget_Base{

  public function get_name() {
    return "rad-image-carousel";
  }

  public function get_title() {
    return esc_html__("Image Carousel", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-slides";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Image Carousel", "aventa" ),
			]
		);

    // Image carousel gallery
    $this->add_control(
			"ic_images",
			[
				"label" => esc_html__( "Images", "aventa" ),
				"type" => Controls_Manager::GALLERY,
				"default" => [],
			]
		);


		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
      "ic_visible_items",
      [
        "label" => esc_html__( "Visible Items", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "1" => 1,
          "2" => 2,
          "3" => 3,
          "4" => 4,
          "5" => 5,
          "6" => 6,
          "7" => 7,
          "8" => 8
        ],
        "default" => "1"
      ]
    );

    $this->add_control(
      "ic_nav_type",
      [
        "label" => esc_html__( "Navigation Type", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "next-prev"   => esc_html__( "Next/Prev Buttons", "aventa" ),
          "scrollbar"   => esc_html__( "Scrollbar", "aventa" ),
          "bullets"  => esc_html__( "Bullets", "aventa" ),
        ],
        "default" => "next-prev"
      ]
    );

    $this->add_control(
      "ic_nav_style",
      [
        "label" => esc_html__( "Navigation Style", "aventa" ),
        "type" => Controls_Manager::CHOOSE,
        "options" => [
          "light" => [
            "title" => esc_html__( "Light", "aventa" ),
            "icon" => "fas fa-sun"
          ],
          "dark" => [
            "title" => esc_html__( "Dark", "aventa" ),
            "icon" => "fas fa-moon"
          ]
        ],
        "default" => "dark"
      ]
    );
    
    $this->add_control(
      "ic_hover_effect",
      [
        "label" => esc_html__( "Hover Zoom Effect", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    $this->add_control(
      "ic_freemode",
      [
        "label" => esc_html__( "Freemode", "aventa" ),
        "description" => esc_html__( "Freemode: Slides won't have fixed positions.", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true"
      ]
    );

    $this->add_control(
      "ic_autoplay",
      [
        "label" => esc_html__( "Autoplay", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    $this->add_control(
      "ic_gutter",
      [
        "label" => esc_html__( "Gutter", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "default" => "true",
        "return_value" => "true"
      ]
    );

    $this->add_control(
      "ic_image_size",
      [
        "label" => esc_html__( "Image Size", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "full"   => esc_html__( "Full", "aventa" ),
          "medium"   => esc_html__( "Medium", "aventa" ),
          "thumbnail"   => esc_html__( "Thumbnail", "aventa" ),
          "custom"   => esc_html__( "Custom", "aventa" ),
        ],
        "separator" => "before",
        "default" => "full"
      ]
    );

    $this->add_control(
			"ic_image_dimension",
			[
				"label" => esc_html__( "Image Dimension", "aventa" ),
				"type" => Controls_Manager::IMAGE_DIMENSIONS,
				"description" => esc_html__( "Crop the original image size to any custom size.", "aventa" ),
        "condition" => [
          "ic_image_size" => "custom"
        ]
			]
		);

    $this->add_control(
			"ic_animation",
			[
				"label" => esc_html__( "Animation", "aventa" ),
				"type" => Controls_Manager::SELECT,
				"default" => "img-anim-zoom-in",
				"options" => [
          "img-anim-zoom-in" => esc_html__( "Zoom-In", "aventa" ),
          "img-anim-mask" => esc_html__( "Mask", "aventa" ),
          "" => esc_html__( "None", "aventa" )
				],
        "separator" => "before"
			]
		);

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "ic_images" ] ) {
			return;
		}

    $classes = [ 
      "image-carousel-block", 
      "resp-block",
      "carousel"
    ];

    // User inputs
		$images           = $settings[ "ic_images" ];
		$visible_items    = esc_attr( $settings[ "ic_visible_items" ] );
		$nav_type         = esc_attr( $settings[ "ic_nav_type" ] );
		$nav_style         = esc_attr( $settings[ "ic_nav_style" ] );
		$hover_effect     = esc_attr( $settings[ "ic_hover_effect" ] );
		$freemode         = esc_attr( $settings[ "ic_freemode" ] );
		$is_autoplay      = $settings[ "ic_autoplay" ] ? "on" : "off";
		$gutter           = esc_attr( $settings[ "ic_gutter" ] );
		$image_size       = esc_attr( $settings[ "ic_image_size" ] );
		$image_width      = esc_attr( $settings[ "ic_image_dimension" ][ "width" ] );
		$image_height     = esc_attr( $settings[ "ic_image_dimension" ][ "height" ] );
    $animation        = esc_attr( $settings[ "ic_animation" ] );
    $image_crop       = ( empty( $image_dimension[ "width" ] ) || empty( $image_dimension[ "height" ] ) )
      ? true
      : false ;

    // Assign proper class based on selected options
    $classes[] = $nav_style;
    $classes[] = $hover_effect  ?   "zoom-effect"         : "";
    $classes[] = $freemode      ?   "freemode"            : "";
    $classes[] = !$gutter       ?   "no-gutter"           : "";
    $classes[] = $animation     ?   "img-anim $animation" : "";

    if ( $images ) {

      // Attributes
      $visible_attr  = "data-visibleitems='$visible_items'";
      $autoplay_attr = "data-autoplay='$is_autoplay'";

      // HTML
      $html = "";
      $html .= rad_make_container("div", "", "", implode( " ",  $classes ), "", $autoplay_attr, false);
      $html .= rad_make_container("div", "", "", "swiper-container", "", $visible_attr, false);
      $html .= rad_make_container("div", "", "", "swiper-wrapper", "", "", false);

      foreach ($images as $image) {

        $image = rad_get_image( 
          $image[ "id" ], 
          "", 
          esc_attr__("item", "aventa"), 
          $image_size, 
          $image_width,
          $image_height,
          $image_crop,
          true
        );

        if ($image == "") {
          continue;
        }

        $style        = "padding-top:" . rad_get_height_percentage($image) . "%;";
        $slider_style = "";

        if ( $freemode ) {
          $slider_style = "width:" . rad_get_image_width($image) . "px;";
          $slider_style .= "max-width:40vw;";
        }

        $html .= rad_make_container("div", "", "", "swiper-slide item carousel_item", $slider_style, "", false);
        $html .= rad_make_container("div", "", "", "img img-container lazy-load lazy-load-on-load", $style, "", false);
        $html .= rad_make_container("div", "", "", "img-wrap", "", "", false);
        $html .= $image;
        $html .= "</div>";
        $html .= "</div>";
        $html .= "</div>";
      }

      $html .= "</div></div>";

      if ( $nav_type == "next-prev" ) 
      {
        $html .= rad_make_container("div", "", "", "rad-carousel-next unselectable", "", "");
        $html .= rad_make_container("div", "", "", "rad-carousel-prev unselectable", "", "");
      } 
      elseif ( $nav_type == "scrollbar" ) 
      {
        $html .= rad_make_container("div", "", "", "swiper-scrollbar", "", "");
      } 
      else {
        $html .= rad_make_container("div", "", "", "swiper-pagination", "", "");
      }

      $html .= "</div>";

      echo "$html";
    }

  }

}