<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Custom_Heading_Widget extends Widget_Base{

  public function get_name() {
    return "rad-custom-heading";
  }

  public function get_title() {
    return esc_html__("Custom Heading", "aventa");
  }

	public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-font";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Custom Heading", "aventa" ),
			]
		);

		$this->add_control(
			"title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Heading Title", "aventa" ),
			]
		);

		$this->end_controls_section();

    // General settings
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		Rad_Helpers::alignment( $this, "align" );

    $this->add_control(
			"title_background_style",
			[
				"label" => esc_html__( "Background Style", "aventa" ),
				"type" => Controls_Manager::SELECT,
				"options" => [
				  "icon" => esc_html__( "Icon", "aventa" ),
				  "text" => esc_html__( "Text", "aventa" ),
				],
        "default" => "icon"
			]
		);

		$this->add_control(
			"title_background_color",
			[
				"label" => esc_html__( "Background Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#ededed",
				"selectors" => [
					"{{WRAPPER}} .bg" => "color: {{VALUE}}; fill: {{VALUE}}",
				],
			]
		);

		Rad_Helpers::slider( 
			$this, 
			"background_size",  
			esc_html__( "Background Size", "aventa" ),
			["{{WRAPPER}} .custom-heading-block .bg" => "font-size: {{SIZE}}{{UNIT}};"],
			48,
			[ "min" => 20, "max" => 100, "step" => 1 ], 
			[ "title_background_style" => "text" ]
		);

		// Text background control
		$this->add_control(
			"title_background_text",
			[
				"label" => esc_html__( "Background Text", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"condition" => [
					"title_background_style" => "text",
				],
				"default" => "Background"
			]
		);

		// Icon background control
		$this->add_control(
			"title_background_icon",
			[
				"label" => esc_html__( "Background Icon", "aventa" ),
				"type" => Rad_Icons_Control::TYPE,
				"default" => "acorn",
				"condition" => [
					"title_background_style" => "icon",
				],
			]
		);

		$this->end_controls_section();


		// Title style
		$this->start_controls_section(
			"section_title_style",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		Rad_Helpers::heading_tag( $this, "title_tag" );

		Rad_Helpers::typography( $this, "title", ".title" );

		$this->end_controls_section();

  }
  

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( "" === $settings["title"] ) {
			return;
		}

    $classes = [ 
      "custom-heading-block",
      $settings["align"],
    ];

		// User inputs
		$title 		= esc_html( $settings[ "title" ] );
		$bg_icon 	= \Rad_Icon_Manager::get_icon( 
			esc_html( $settings[ "title_background_icon" ] ), 
			"all"
		);
		$bg_text 	= esc_html( $settings[ "title_background_text" ] );

		// Element attributes
		$this->add_render_attribute( "title", "class", "title" );
		$this->add_render_attribute( "title_background_icon", "class", "bg icon" );
		$this->add_render_attribute( "title_background_text", "class", "bg text" );

		$this->add_inline_editing_attributes( "title" );

		// HTML elements
		$title_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      Utils::validate_html_tag( $settings[ "title_tag" ] ), 
      $this->get_render_attribute_string( "title" ), 
      $title 
    );

		// Generate element based on selected background style
		if ( $settings["title_background_style"] == "text" ) {

			$background_html = sprintf( 
				'<%1$s %2$s>%3$s</%1$s>', 
				"span",
				$this->get_render_attribute_string( "title_background_text" ), 
				$bg_text
			);

		} else if ( $settings["title_background_style"] == "icon" ) {

			$background_html = sprintf( 
				'<%1$s %2$s>%3$s</%1$s>', 
				"span",
				$this->get_render_attribute_string( "title_background_icon" ), 
				$bg_icon
			);
			
		}

		// Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      "class='" . implode( " ", array_map( "esc_attr", $classes ) ) . "'",
      $title_html . $background_html
    );

    echo "$html";
  }

}