<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 

class Rad_Count_Down_Widget extends Widget_Base{

  public function get_name() {
    return "rad-count-down";
  }

  public function get_title() {
    return esc_html__("Count Down", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-countdown";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Count Down", "aventa" ),
			]
		);

    // Count Down due date
		$this->add_control(
			"cd_due_date", 
      [
				"label" => esc_html__( "Due Date", "aventa" ),
				"type" => Controls_Manager::DATE_TIME,
        "default" => date("Y-m-d H:i", strtotime("+10 day"))
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Count Down alignment
    Rad_Helpers::alignment( $this, "cd_alignment" );
    
    // Count Down font size
    Rad_Helpers::slider( 
      $this,
      "cd_font_size",
      "Font Size",
      [ "{{WRAPPER}} .countdown-timer" => "font-size: {{SIZE}}{{UNIT}}" ],
      40,
      [ "min" => 28, "max" => 50, "step" => 1 ]
    );

    // Count Down number color
    $this->add_control(
      "cd_number_color",
      [
        "label" => esc_html__( "Number Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .countdown-timer .time-block .number" => "color: {{VALUE}}"
        ],
        "default" => "#000",
        "separator" => "before"
      ]
    );

    // Count Down label color
    $this->add_control(
      "cd_label_color",
      [
        "label" => esc_html__( "Label Color", "aventa" ),
        "type" => Controls_Manager::COLOR,
        "selectors" => [
          "{{WRAPPER}} .countdown-timer .time-block .label" => "color: {{VALUE}}",
        ],
        "default" => "#000",
      ]
    );

		$this->end_controls_section();

  }

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( !$settings[ "cd_due_date" ] ) {
			return;
		}

    $classes = [ 
      "countdown-timer",
      "resp-block"
    ];

    // User inputs
		$due_date     = esc_html( $settings[ "cd_due_date" ] );
    $due_date     = str_replace(" ", "T", $due_date);
		$alignment    = esc_html( $settings[ "cd_alignment" ] );

    // Assign proper class based on selected options
    $classes[] = $alignment;

    // Element attributes
		$this->add_render_attribute( "cd_wrapper", "class", implode( " ", array_map( "esc_attr", $classes ) ) );
		$this->add_render_attribute( "cd_wrapper", "data-end", esc_attr( $due_date ) );
		$this->add_render_attribute( "cd_time_block", "class", "time-block" );
		$this->add_render_attribute( "cd_label", "class", "label" );
		$this->add_render_attribute( "cd_days", "class", "days number" );
		$this->add_render_attribute( "cd_hours", "class", "hours number" );
		$this->add_render_attribute( "cd_minutes", "class", "minutes number" );
		$this->add_render_attribute( "cd_seconds", "class", "seconds number" );

    ?>
    
    <div <?php echo "" . $this->get_render_attribute_string( "cd_wrapper" ) ?> >
      <div <?php echo "" . $this->get_render_attribute_string( "cd_time_block" ) ?> >
        <span <?php echo "" . $this->get_render_attribute_string( "cd_days" ) ?> >0</span>
        <span <?php echo "" . $this->get_render_attribute_string( "cd_label" ) ?> ><?php echo esc_html__( "Days", "aventa" ); ?></span>
      </div>
      <div <?php echo "" . $this->get_render_attribute_string( "cd_time_block" ) ?> >
        <span <?php echo "" . $this->get_render_attribute_string( "cd_hours" ) ?> >0</span>
        <span <?php echo "" . $this->get_render_attribute_string( "cd_label" ) ?> ><?php echo esc_html__( "Hours", "aventa" ); ?></span>
      </div>
      <div <?php echo "" . $this->get_render_attribute_string( "cd_time_block" ) ?> >
        <span <?php echo "" . $this->get_render_attribute_string( "cd_minutes" ) ?> >0</span>
        <span <?php echo "" . $this->get_render_attribute_string( "cd_label" ) ?> ><?php echo esc_html__( "Mins", "aventa" ); ?></span>
      </div>
      <div <?php echo "" . $this->get_render_attribute_string( "cd_time_block" ) ?> >
        <span <?php echo "" . $this->get_render_attribute_string( "cd_seconds" ) ?> >0</span>
        <span <?php echo "" . $this->get_render_attribute_string( "cd_label" ) ?> ><?php echo esc_html__( "Secs", "aventa" ); ?></span>
      </div>
    </div>
    
    <?php
  }

}