<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Chart_Widget extends Widget_Base{

  public function get_name() {
    return "rad-chart";
  }

  public function get_title() {
    return esc_html__("Chart", "aventa");
  }

  public function get_icon() {
    return "eicon-counter-circle";
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {

		// Widget content
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Chart", "aventa" ),
			]
		);

    // Chart display mode
    $this->add_control(
      "chart_display_mode",
      [
        "label" => esc_html__( "Display Mode", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "percentage"  => esc_html__( "Percent", "aventa" ),
          "icon"        => esc_html__( "Icon", "aventa" ),
          "both"        => esc_html__( "Both", "aventa" ),
        ],
        "default" => "percentage",
      ]
    );

    // Chart progress percentage
    $this->add_control(
      "chart_progress_percentage",
      [
        "label" => esc_html__( "Progress Percentage", "aventa" ),
        "type" => Controls_Manager::NUMBER,
        "min" => 0,
        "max" => 100,
        "step" => 1,
        "default" => 85,
      ]
    );

    // Chart icon
    $this->add_control(
      "chart_icon",
      [
        "label" => esc_html__( "Chart Icon", "aventa" ),
        "type" => Rad_Icons_Control::TYPE,
        "default" => "acorn",
        "condition" => [
          "chart_display_mode!" => "percentage",
        ],
      ]
    );

    $this->add_control(
			"content_divider",
			[ "type" => Controls_Manager::DIVIDER ]
		);

    // Chart title
    $this->add_control(
			"chart_title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXT,
				"default" => esc_html__( "Chart Title", "aventa" ),
			]
		);

    // Chart subtitle
    $this->add_control(
			"chart_subtitle",
			[
				"label" => esc_html__( "Subtitle", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html( "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." ),
			]
		);

		$this->end_controls_section();

    // General style
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

    // Chart data color
		$this->add_control(
			"chart_data_color",
			[
				"label" => esc_html__( "Data Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#000",
        "description" => esc_html__( "Color of icon, percentage, and % symbol", "aventa" ),
				"selectors" => [
          "{{WRAPPER}} .chart-block .chart-wrapper" => "color: {{VALUE}}; fill: {{VALUE}};",
				],
			]
		);

    $this->add_control(
			"style_divider",
			[ "type" => Controls_Manager::DIVIDER ]
		);

    // Chart progress bar color
		$this->add_control(
			"chart_bar_color",
			[
				"label" => esc_html__( "Bar Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#000",
			]
		);

    // Chart track color
		$this->add_control(
			"chart_track_color",
			[
				"label" => esc_html__( "Track Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#eee",
			]
		);

    $this->add_control(
			"style_divider1",
			[ "type" => Controls_Manager::DIVIDER ]
		);
    
    // Chart title color
		$this->add_control(
			"chart_title_color",
			[
				"label" => esc_html__( "Title Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#000",
				"selectors" => [
          "{{WRAPPER}} .chart-block .title" => "color: {{VALUE}};",
				],
			]
		);

    // Chart subtitle color
		$this->add_control(
			"chart_subtitle_color",
			[
				"label" => esc_html__( "Subtitle Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
				"default" => "#444",
				"selectors" => [
          "{{WRAPPER}} .chart-block .subtitle" => "color: {{VALUE}};",
				],
			]
		);

		$this->end_controls_section();
  }
  

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( 
      "" === $settings["chart_progress_percentage"] && 
      "" === $settings["chart_title"]               &&
      "" === $settings["chart_subtitle"] 
    ) {
			return;
		}

    $classes = [ 
      "chart-block", 
      "resp-block"
    ];

    // User inputs
		$title 		  = esc_html( $settings[ "chart_title" ] );
		$subtitle 	= esc_html( $settings[ "chart_subtitle" ] );
		$percentage = esc_html( $settings[ "chart_progress_percentage" ] );
		$display_mode = esc_html( $settings[ "chart_display_mode" ] );
		$icon 	    = \Rad_Icon_Manager::get_icon( 
      esc_html( $settings[ "chart_icon" ] ), 
      "all"
    );
    $bar_color = esc_attr( $settings[ "chart_bar_color" ] );
    $track_color = esc_attr( $settings[ "chart_track_color" ] );

    // Assign proper class based on display mode
    if ( $display_mode != "both" ) {
      $classes[] = $display_mode == "percentage"
        ? "no-icon"
        : "no-percent";
    }

    // Element attributes
		$this->add_render_attribute( "chart_title", "class", "title" );
		$this->add_render_attribute( "chart_subtitle", "class", "subtitle" );
		$this->add_render_attribute( "chart_progress_percentage", "class", "percent" );
		$this->add_render_attribute( "chart_wrapper", "class", "chart-wrapper" );
		$this->add_render_attribute( "chart_wrapper", "data-bar-color", $bar_color );
		$this->add_render_attribute( "chart_wrapper", "data-track-color", $track_color );
		$this->add_render_attribute( "chart_wrapper", "data-percent", esc_attr($percentage) );

    $this->add_inline_editing_attributes( "chart_title", "none" );
    $this->add_inline_editing_attributes( "chart_subtitle", "none" );

    // HTML elements
    $percentage_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "span",
      $this->get_render_attribute_string( "chart_progress_percentage" ),
      "$percentage%"
    );

		$chart_wrapper_html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      $this->get_render_attribute_string( "chart_wrapper" ), 
      $icon . $percentage_html 
    );

		$title_html = sprintf(
      '<%1$s %2$s>%3$s</%1$s>', 
      "span", 
      $this->get_render_attribute_string( "chart_title" ), 
      $title
    );

		$subtitle_html = sprintf(
      '<%1$s %2$s>%3$s</%1$s>', 
      "span", 
      $this->get_render_attribute_string( "chart_subtitle" ), 
      $subtitle
    );

    // Final HTML to render
    $html = sprintf( 
      '<%1$s %2$s>%3$s</%1$s>', 
      "div", 
      "class='" . implode( " ", array_map( "esc_attr", $classes ) ) . "'",
      $chart_wrapper_html . $title_html . $subtitle_html
    );

    echo "$html";
  }

}