<?php

namespace Aventa;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( !defined( "ABSPATH" ) ) exit; 


class Rad_Advance_Marquee_Widget extends Widget_Base{

  public function get_name() {
    return "rad-advance-marquee";
  }

  public function get_title() {
    return esc_html__("Advance Marquee", "aventa");
  }

  public function get_keywords() {
		return [ "aventa" ];
	}

  public function get_icon() {
    return "eicon-animation-text";
  }

  public function get_categories() {
    return [ Rad_Helpers::WIDGETS_CATEGORY ];
  }

  protected function register_controls() {
    $this->start_controls_section(
			"section_title",
			[
				"label" => esc_html__( "Advance Marquee", "aventa" ),
			]
		);

		$this->add_control(
			"am_title",
			[
				"label" => esc_html__( "Title", "aventa" ),
				"type" => Controls_Manager::TEXTAREA,
				"default" => esc_html__( "Text", "aventa" ),
			]
		);

		$this->end_controls_section();

    // General Settings
    $this->start_controls_section(
			"section_general_style",
			[
				"label" => esc_html__( "General", "aventa" ),
				"tab" => Controls_Manager::TAB_STYLE,
			]
		);

		// Styles
    $this->add_control(
      "am_has_background",
      [
        "label" => esc_html__( "Has Background?", "aventa" ),
        "type" => Controls_Manager::SWITCHER,
        "label_on" => esc_html__( "Yes", "aventa" ),
        "label_off" => esc_html__( "No", "aventa" ),
        "return_value" => "true",
      ]
    );

    $this->add_control(
			"am_background",
			[
				"label" => esc_html__( "Background Image", "aventa" ),
				"type" => Controls_Manager::MEDIA,
        "condition" => [
          "am_has_background" => "true"
        ]
			]
		);

    $this->add_control(
			"am_title_color",
			[
				"label" => esc_html__( "Text Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
        "selectors" => [
					"{{WRAPPER}} .marquee-block > .m-text" => "color: {{VALUE}};"
				]
			]
		);

    $this->add_control(
			"am_front_color",
			[
				"label" => esc_html__( "Front Text Color", "aventa" ),
				"type" => Controls_Manager::COLOR,
        "selectors" => [
					"{{WRAPPER}} .marquee-block .front-wrap .front-text .m-text" => "color: {{VALUE}};"
				],
        "condition" => [
          "am_has_background" => "true"
        ]
			]
		);

    $this->add_control(
      "am_title_font",
      [
        "label" => esc_html__( "Font Family", "aventa" ),
				"type" => Controls_Manager::FONT,
        "selectors" => [
					"{{WRAPPER}} .marquee-block" => "font-family: {{VALUE}}"
        ]
      ]
    );

    $typo_weight_options = [
			"" => esc_html__( "Default", "aventa" ),
		];

		foreach ( array_merge( [ "normal", "bold" ], range( 100, 900, 100 ) ) as $weight ) {
			$typo_weight_options[ $weight ] = ucfirst( $weight );
		}

    $this->add_control(
      "am_title_font_weight",
      [
        "label" => esc_html__( "Font Weight", "aventa" ),
				"type" => Controls_Manager::SELECT,
        "options" => $typo_weight_options,
        "selectors" => [
					"{{WRAPPER}} .marquee-block" => "font-weight: {{VALUE}}"
        ]
      ]
    );

    $this->add_responsive_control(
      "am_title_size",
      [
        "label" => esc_html__( "Font Size", "aventa" ),
				"type" => Controls_Manager::SLIDER,
				"size_units" => [ "vw" ],
				"range" => [
					"vw" => [
						"min" => 1,
						"max" => 30
					],
				],
				"default" => [
					"unit" => "vw",
					"size" => 20,
				],
				"selectors" => [
					"{{WRAPPER}} .marquee-block" => "font-size: {{SIZE}}{{UNIT}}; height: calc( {{SIZE}}{{UNIT}} * 1.5);"
        ],
        "condition" => [
          "am_has_background" => ""
        ]
      ]
    );

    $this->add_responsive_control(
      "am_title_size_bg",
      [
        "label" => esc_html__( "Font Size", "aventa" ),
				"type" => Controls_Manager::SLIDER,
				"size_units" => [ "vw" ],
				"range" => [
					"vw" => [
						"min" => 1,
						"max" => 30
					],
				],
				"default" => [
					"unit" => "vw",
					"size" => 20,
				],
				"selectors" => [
					"{{WRAPPER}} .marquee-block" => "font-size: {{SIZE}}{{UNIT}}; height: auto;"
        ],
        "condition" => [
          "am_has_background" => "true"
        ]
      ]
    );

    $this->add_control(
      "am_speed",
      [
        "label" => esc_html__( "Animation Speed", "aventa" ),
        "type" => Controls_Manager::SELECT,
        "options" => [
          "4"     => esc_html__( "Fastest", "aventa" ),
          "8"     => esc_html__( "Fast", "aventa" ),
          "12"    => esc_html__( "Normal", "aventa" ),
          "16"    => esc_html__( "Slow", "aventa" ),
          "20"    => esc_html__( "Slowest", "aventa" ),
        ],
        "default" => "12",
      ]
    );

		$this->end_controls_section();

  }
  

  protected function render() {
    $settings = $this->get_settings_for_display();

		if ( "" === $settings[ "am_title" ] ) {
			return;
		}

    $classes = [ 
      "marquee-block"
    ];

		// Elements attributes
		$this->add_render_attribute( "title", "class", "title" );
		$this->add_render_attribute( "subtitle1", "class", "subtitle1" );
		$this->add_render_attribute( "subtitle2", "class", "subtitle2" );

		$this->add_inline_editing_attributes( "title" );

		// User inputs
		$title 	            = esc_html( $settings[ "am_title" ] );
		$has_background 	  = esc_html( $settings[ "am_has_background" ] );
		$image_id 	        = isset( $settings[ "am_background" ][ "id" ] )?esc_attr( $settings[ "am_background" ][ "id" ] ) : "";
		$speed 	            = esc_html( $settings[ "am_speed" ] );

    if ( $has_background && $image_id != "" ) {
      $image = wp_get_attachment_image( $image_id, "full", false, array("alt" => $title) );
    } else {
      $image = "";
    }

    // HTML
    $html    = "";

    $animation_duration = "animation-duration:" . (strlen($title) * intval($speed)) . "s";

    $html .= rad_make_container("div", "", "", implode(" ", array_filter($classes)), "", "", false);
    $html .= rad_make_container("div", "", "", "front-wrap", "", "", false);
    $html .= $image;
    $html .= rad_make_container("span", "", "", "front-text", "", "", false);
    $html .= rad_make_container("span", "", "", "m-text", $animation_duration, "", false);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= "</span></span></div>";
    $html .= rad_make_container("span", "", "", "m-text", $animation_duration, "", false);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= rad_make_container("span", str_repeat($title . "<span class=\"m-space\"></span>", 4), "", "", "", "", true);
    $html .= "</span></div>";

    echo "$html";
  }

}