<?php

namespace Aventa;

use Elementor\Base_Data_Control;

class Rad_Visual_Option_Selector_Control extends Base_Data_Control {

  const TYPE = "rad-visual-option-selector";

	public function get_type() {
		return $this::TYPE;
	}

  public function enqueue() { 
    wp_register_script( "rad_visual_option_selector_js", Rad_Helpers::ELEMENTOR_DIR_PATH . "controls/js/visual-option-selector.js", [ "jquery" ], false, true );
    wp_register_style( "rad_visual_option_selector_css", Rad_Helpers::ELEMENTOR_DIR_PATH . "controls/css/visual-option-selector.css" );
    wp_enqueue_script( "rad_visual_option_selector_js" );
    wp_enqueue_style( "rad_visual_option_selector_css" );
  }

	public function content_template() {
    $control_uid = $this->get_control_uid();
    ?>
      <div>

        <div style="margin-bottom: 10px;">
          <label class="elementor-control-title">{{{ data.label }}}</label>
        </div>

        <div class="visual-options-container">
          <# if ( data.options ) { #>
            <# for( let option in data.options ) { #> 
              <div class="visual-option-item">
                  <input id="{{option}}" type="radio" name="{{data.name}}" value="{{option}}" />
                  <label for="{{option}}" title="{{option}}">
                    <img src="<?php echo RAD_THEME_INC_URI . "/admin/assets/img/icons/" ?>{{data.icon_dir}}/{{data.options[ option ]}}.png">
                  </label>
              </div>
            <# } #>
          <# } #>
          <input id="<?php echo esc_attr( $control_uid ); ?>" type="hidden" class="visual-option-selector-value" data-setting="{{ data.name }}" value="{{ data.default }}" />
        </div>

      </div>
    <?php

	}

}