<?php

namespace Aventa;

use Elementor\Base_Data_Control;

class Rad_Icons_Control extends Base_Data_Control {

  const TYPE = "rad-icons-control";

	public function get_type() {
		return $this::TYPE;
	}

  public function enqueue() { 
    wp_register_script( "rad_icon_select", Rad_Helpers::ELEMENTOR_DIR_PATH . "controls/js/icons.js", [ "jquery" ], false, true );
    wp_localize_script( "rad_icon_select", "rad_data", [ "icons" => $this->get_icons() ] );
    wp_enqueue_script( "rad_icon_select" );
  }

  public function get_icons() {
    
    $icons      = \Rad_Icon_Manager::get_light_icons();
    $icon_block = array();

    foreach ($icons as $name => $svg) {
      $icon_block[] = (object) [ 
        "id" => esc_attr( $name ), 
        "text" => esc_attr( $name ),
        "svg" => $svg,
      ];
    }

    $icons = \Rad_Icon_Manager::get_solid_icons();

    foreach ($icons as $name => $svg) {
      $icon_block[] = (object) [ 
        "id" => esc_attr( $name ), 
        "text" => esc_attr( $name ),
        "svg" => $svg,
      ];
    }

    $icons = \Rad_Icon_Manager::get_brand_icons();

    foreach ($icons as $name => $svg) {
      $icon_block[] = (object) [ 
        "id" => esc_attr( $name ), 
        "text" => esc_attr( $name ),
        "svg" => $svg,
      ];
    }

    return json_encode( $icon_block );

  }

	public function content_template() {
    $control_uid = $this->get_control_uid();
    ?>
      <div>

        <div style="margin-bottom: 10px;">
          <label class="elementor-control-title">{{{ data.label }}}</label>
        </div>

        <select class="icon-select"></select>

        <input id="<?php echo esc_attr( $control_uid ); ?>" type="hidden" class="icon-save-value" data-setting="{{ data.name }}" value="{{ data.default }}" />

      </div>
    <?php

	}

}