<?php

/** @var $theme WP_Theme */
$theme = wp_get_theme();

$version = $theme->Version;
if (is_child_theme()) {
    $parent_theme = wp_get_theme(get_template());
    $version      = $parent_theme->Version;
}

define("RAD_THEME", $theme->Name);
define("RAD_THEME_AUTHOR", $theme->Author);
define("RAD_THEME_VERSION", $version);
define("RAD_OPTIONS_KEY", "theme_aventa_options");

/**************************************************
FOLDERS
 **************************************************/

define("RAD_THEME_DIR", get_parent_theme_file_path());
define("RAD_THEME_INC", RAD_THEME_DIR . "/inc");
define("RAD_THEME_ADMIN", RAD_THEME_INC . "/admin");
define("RAD_THEME_CSS", RAD_THEME_DIR . "/assets/css");

/**************************************************
FOLDER URI
 **************************************************/

define("RAD_THEME_URI", get_parent_theme_file_uri());
define("RAD_THEME_INC_URI", RAD_THEME_URI . "/inc");
define("RAD_THEME_ASSETS_URI", RAD_THEME_URI . "/assets");
define("RAD_THEME_IMAGES_URI", RAD_THEME_ASSETS_URI . "/img");

/**************************************************
LOAD FRAMEOWRK
 **************************************************/

require_once RAD_THEME_INC . "/loader.php";
