<?php
//Main colors
$acc    = rad_get_option("style-accent-color");//Accent color
$hc     = rad_get_option("style-highlight-color");//Highlight color
$lc     = rad_get_option("style-link-color");//Link color
$lhc    = rad_get_option("style-link-hover-color");//Link hover color

//Preloader
$preloader_bg_color = rad_get_option("preloader_bg_color");
$preloader_color = rad_get_option("preloader_color");

//topbar
$topbar_bg_color = rad_get_option("topbar_bg_color");
$topbar_border_color = rad_get_option("topbar_border_color");

//cart bg color
$initial_shop_cart_text_color = rad_get_option("initial-shop-cart-text-color");
$shop_cart_text_color = rad_get_option("shop-cart-text-color");


//Initial menu value
$initialMenuBgColor = rad_get_option("initial-menu-background-color");
$initialMenuTextColor = rad_get_option("initial-menu-text-color");
$initialMenuBorderColor =  rad_get_option("initial-menu-border-color");

//Menu Styles
$menuBgColor = rad_get_option("menu-background-color") ;
$menuTextColor =  rad_get_option("menu-text-color");
$menuBorderColor =  rad_get_option("menu-border-color");

//Submenu Styles
$submenuBgColor = rad_get_option("submenu-background-color") ;
$submenuTextColor =  rad_get_option("submenu-text-color");

/*Hamburger menu*/
$hamburgerMenuBgColor =  rad_get_option("hamburger-menu-bg-color");
$hamburgerMenuTextColor =  rad_get_option("hamburger-menu-text-color");

/*Hamburger menu*/
$collectionBgColor =  rad_get_option("collection-bg-color");
$collectionTextColor =  rad_get_option("collection-text-color");

$header_mode = rad_get_option( "header-mode");
$bg_color    = rad_get_option( "header-bg");
$text_color  = rad_get_option( "header-text-color");
$wc_header_mode = rad_get_option( "wc-header-category");

/*Footer*/
$footer_bg_color = rad_get_option("footer-bg-color");
$footer_bg_image = rad_get_option("footer-bg-image");
$footer_bg_image = ($footer_bg_image != "") ? " url(\"" . esc_url(rad_get_image_url($footer_bg_image,"full")) . "\")" : "";

/* Custom social icons */
$social_icon_1 = rad_get_option("social_custom1_image");
$social_icon_2 = rad_get_option("social_custom2_image");
$social_icon_3 = rad_get_option("social_custom3_image");

/*************************************************************/
/*  Fonts
/*************************************************************/
$body_font_spec = rad_get_option("font-body");
/* Check for old bug of saved options with wrong values */
if($body_font_spec == "default")
{
    $body_font_spec = "theme_default";
}

$body_font_variants = "";
if( $body_font_spec == "theme_default")
{
    $body_font = "theme_default";
}
elseif($body_font_spec != "")
{
    $body_font_spec = explode(":",$body_font_spec);
    if(isset($body_font_spec[1]) && isset($body_font_spec[2]))
    {
        $body_font = trim($body_font_spec[1]);
        $body_font_variants = trim($body_font_spec[2]);
    }
    else
    {
        $body_font = "theme_default";
        $body_font_variants = "";
    }
}


$nav_font_spec = rad_get_option("font-navigation");
/* Check for old bug of saved options with wrong values */
if($nav_font_spec == "default")
{
    $nav_font_spec = "theme_default";
}

$nav_font_variants = "";
if( $nav_font_spec == "theme_default")
{
    $nav_font = "theme_default";
}
elseif($body_font_spec != "")
{
    $nav_font_spec = explode(":",$nav_font_spec);
    
    if(isset($nav_font_spec[1]) && isset($nav_font_spec[2]))
    {
        $nav_font = trim($nav_font_spec[1]);
        $nav_font_variants = trim($nav_font_spec[2]);
    }
    else
    {
        $nav_font = "theme_default";
        $nav_font_variants = "";
    }
}

$heading_font_spec = rad_get_option("font-headings");
/* Check for old bug of saved options with wrong values */
if($heading_font_spec == "default")
{
    $heading_font_spec = "theme_default";
}

$heading_font_variants = "";
if( $heading_font_spec == "theme_default")
{
    $heading_font = "theme_default";
}
elseif($body_font_spec != "")
{
    $heading_font_spec = explode(":",$heading_font_spec);
    if(isset($heading_font_spec[1]) && isset($heading_font_spec[2]))
    {
        $heading_font = trim($heading_font_spec[1]);
        $heading_font_variants = trim($heading_font_spec[2]);
    }
    else
    {
        $heading_font = "theme_default";
        $heading_font_variants = "";
    }
    
}

/*************************************************************/
/*  Header
/*************************************************************/
if(rad_is_wc_active() && is_product_category())
{
    $term = get_queried_object();
    $category_id = $term->term_id;

    if(get_term_meta( $category_id ,"cat-header-bg-color", true ) != "")
    {
        $bg_color = get_term_meta( $category_id ,"cat-header-bg-color", true);
    }

    if(get_term_meta( $category_id ,"cat-header-text-color", true ) != "")
    {
        $text_color = get_term_meta( $category_id ,"cat-header-text-color", true );
    }
    if($wc_header_mode != "disable")
    {
        $header_mode = "1";
    }
    
}
elseif(is_page() || is_home() || (rad_is_wc_active() && is_shop()))
{
    if(rad_get_meta( "page-header-mode", true ) != "")
    {
        $header_mode = rad_get_meta( "page-header-mode", true );
    }

    $header_override = rad_get_meta( "page-header-custom", true );

    if($header_override == "custom")
    {
        if(rad_get_meta( "page-header-bg", true ) != "")
        {
            $bg_color    = rad_get_meta( "page-header-bg");
        }

        if(rad_get_meta( "page-header-text-color", true ) != "")
        {
            $text_color  = rad_get_meta( "page-header-text-color", true );
        }
    }

    
}

if($header_mode == "1")
{
    if($bg_color != "")
    {
        echo "#header.overlay:before { background-color:". esc_attr($bg_color) . ";}";
    }
    
    if($text_color != "")
    {
        echo "#header *,#header h1,#cat-disply li span { color:". esc_attr($text_color) . ";}";
        echo "#header a .underline-style:after { background-color:". esc_attr($text_color) . ";}";
        echo "#header .woocommerce-breadcrumb span { border-color:". esc_attr($text_color) . ";}";
    }
}

if(rad_get_meta("menu") == "custom") // overrided menu styles in current page
{
    //Initial menu value
    $initialMenuBgColor = rad_get_meta("initial-menu-background-color");
    $initialMenuTextColor = rad_get_meta("initial-menu-text-color");
    $initialMenuBorderColor =  rad_get_meta("initial-menu-border-color");
    $initial_shop_cart_text_color =  rad_get_meta("initial-shop-cart-text-color");

    if(rad_get_option("menu-state") == "double-state")
    {
        //Menu Styles
        $menuBgColor = rad_get_meta("menu-background-color") ;
        $menuTextColor =  rad_get_meta("menu-text-color");
        $menuBorderColor =  rad_get_meta("menu-border-color");
        $shop_cart_text_color =  rad_get_meta("shop-cart-text-color");
    }

}

if(rad_is_wc_active() && is_product_category())
{
    $initialMenuTextColor = rad_get_option("initial-wc-cat-menu-text-color");
    $initial_shop_cart_text_color =  rad_get_option("initial-wc-cat-shop-cart-text-color");
}

/*************************************************************/
/*  Hamburger menu colors
/*************************************************************/

if($hamburgerMenuBgColor) {
    echo ".hamburger-menu .hamburger-menus:before {";
    echo "background:" . esc_attr($hamburgerMenuBgColor);
    echo "}";
}

if($hamburgerMenuTextColor) {
    echo ".hamburger-menus .swiper-slide > ul li a,
    #hamburger-menu-bar,
    #hamburger-menu-bar label,
    #hamburger-menu-bar .topbar_lang_flag .lang-sel a {";
    echo "color:" . esc_attr($hamburgerMenuTextColor);
    echo "}";

    echo ".hamburger-menus .inner a:before {";
    echo "background-color:" . esc_attr($hamburgerMenuTextColor);
    echo "}";
}

/*************************************************************/
/*  Collection colors
/*************************************************************/
if($collectionBgColor) {
    echo ".toggle-aside.collection-aside.bg:before {";
    echo "background:" . esc_attr($collectionBgColor);
    echo "}";
}

if($collectionTextColor) {
    echo ".collection-aside .shop,
    body .collection-aside .title,
    .collection-aside .cat {";
    echo "color:" . esc_attr($collectionTextColor);
    echo "}";
}


if($collectionTextColor) {
    echo "#rad-menu.collection-active .aside-close:before,
    #rad-menu.collection-active .aside-close:after,
    .collection-aside .shop:after {";
    echo "background-color:" . esc_attr($collectionTextColor);
    echo "}";
}

/*************************************************************/
/*  Cart
/*************************************************************/
if($initial_shop_cart_text_color) {
    echo "#rad-menu .wishlist-btn .number,#rad-menu .cart-btn .cart-count {";
    echo "color:" . esc_attr($initial_shop_cart_text_color) . ";";
    echo "}";
}


if(rad_get_option("menu-state") == "double-state" && $shop_cart_text_color) {
    echo "#rad-menu:hover .wishlist-btn .number,
    #rad-menu.state2 .wishlist-btn .number,
    #rad-menu:hover .cart-btn .cart-count,
    #rad-menu.state2 .cart-btn .cart-count {";
    echo "color:" . esc_attr($shop_cart_text_color) . ";";
    echo "}";
}

/*************************************************************/
/*  Menu buttons
/*************************************************************/
if($initialMenuTextColor)
{
    echo "header .hamburger-menu-btn span,
    header .hamburger-menu-btn span:before,
    header .hamburger-menu-btn span:after,
    #rad-menu .navigation li a > span:before,
    #rad-menu:hover .navigation li a:before {";
    echo "background-color:" . esc_attr($initialMenuTextColor);
    echo "}";    
}

if($menuTextColor)
{
    echo "header.state2 .hamburger-menu-btn span,
    header.double-state:hover .hamburger-menu-btn span,
    header.state2 .hamburger-menu-btn span:before,
    header.double-state:hover .hamburger-menu-btn span:before,
    header.state2 .hamburger-menu-btn span:after,
    header.double-state:hover .hamburger-menu-btn span:after,
    #rad-menu.state2 .navigation li a:before,
    #rad-menu.double-state:hover .navigation li a:before {";
    echo "background-color:" . esc_attr($menuTextColor);
    echo "}";
}

/*************************************************************/
/*  Menu
/*************************************************************/
if($initialMenuBgColor)
{
    echo "#rad-menu #menu-bg {";
    echo "background-color:" . esc_attr($initialMenuBgColor) . ";";
    echo "border-color:" . esc_attr($initialMenuBorderColor) . ";";
    echo "}";
}

if($menuBgColor || $menuBorderColor)
{
    echo "#rad-menu.double-state:not(.aside-open):hover #menu-bg, #rad-menu.state2 #menu-bg, #rad-menu.search-active #menu-bg {";
    if($menuBgColor) {
        echo "background-color:" . esc_attr($menuBgColor) . ";";
    }

    if($menuBorderColor) {
        echo "border-color: " . esc_attr($menuBorderColor) . ";";
    }
    echo "}";
}

if($initialMenuTextColor)
{
    echo "#rad-menu .navigation > ul > li > a,
    #rad-menu .search-button,
    #rad-menu .wishlist-btn,
    #rad-menu .header-account > a,
    #rad-menu .header-currency .dd-selected-text,
    #rad-menu .cart-btn {";
    echo "color:" . esc_attr($initialMenuTextColor) . ";";
    echo "fill:" . esc_attr($initialMenuTextColor) . ";";
    echo "}";

    echo ".header-currency .dd-selected .dd-selected-text:after,
    .header-currency .dd-selected .dd-selected-text:before {";
    echo "border-color:" . esc_attr($initialMenuTextColor);
    echo "}";
}

if($menuTextColor)
{
    echo "#rad-menu .wishlist-btn .number,
    #rad-menu .cart-btn .cart-count {";
    echo "background-color:" . esc_attr($initialMenuTextColor) . ";";
    echo "}";

    echo "#rad-menu.double-state:hover .navigation li a > span:before,
    #rad-menu.state2 .navigation li a > span:before,
    #rad-menu.state2 .wishlist-btn .number,
    #rad-menu.double-state:hover .wishlist-btn .number,
    #rad-menu.state2 .cart-btn .cart-count,
    #rad-menu.double-state:hover .cart-btn .cart-count {";
    echo "background-color:" . esc_attr($menuTextColor) . ";";
    echo "}"; 

    echo "#rad-menu.state2 .navigation > ul > li > a,
    #rad-menu.double-state:hover .navigation > ul > li > a,
    #rad-menu.state2 .search-button,
    #rad-menu.double-state:hover .search-button,
    #rad-menu.state2 .wishlist-btn,
    #rad-menu.double-state:hover .wishlist-btn,
    #rad-menu.state2 .header-account > a,
    #rad-menu.double-state:hover .header-account > a,
    #rad-menu.state2 .cart-btn:before,
    #rad-menu.double-state:hover .cart-btn:before,
    #rad-menu.state2 .header-currency .dd-selected-text,
    #rad-menu.double-state:hover .header-currency .dd-selected-text,
    #rad-menu.state2 .cart-btn,
    #rad-menu.double-state:hover .cart-btn {";
    echo "color:" . esc_attr($menuTextColor) . ";";
    echo "fill:" . esc_attr($menuTextColor) . ";";
    echo "}";

    echo "#rad-menu.state2 .dd-selected .header-currency .dd-selected-text:after,
    #rad-menu.double-state:hover .header-currency .dd-selected .dd-selected-text:after,
    #rad-menu.state2 .dd-selected .header-currency .dd-selected-text:before,
    #rad-menu.double-state:hover .header-currency .dd-selected .dd-selected-text:before {";
    echo "border-color:" . esc_attr($menuTextColor);
    echo "}";
}

/*************************************************************/
/*  Submenu
/*************************************************************/
if($submenuBgColor) {
    echo ".header-currency ul.dd-options:before,
    .account-links:before,
    #rad-menu .navigation li ul:before {";
    echo "background-color :" . esc_attr($submenuBgColor);
    echo "}";
}

if($submenuTextColor) {
    echo ".header-currency .dd-option .dd-option-text,
    #rad-menu .header-account ul a,
    #rad-menu .navigation li li > a,
    #rad-menu .navigation li li.headline {";
    echo "color :" . esc_attr($submenuTextColor);
    echo "}";

    echo "header .navigation > ul > li:not(.mega-menu-parent) li.menu-item-has-children:before,
    header .navigation > ul > li:not(.mega-menu-parent) li.menu-item-has-children:after {";
    echo "border-color :" . esc_attr($submenuTextColor);
    echo "}";

}

/*************************************************************/
/*  links
/*************************************************************/
echo "a{ color:" . esc_attr($lc) . "}";
echo "a:hover{ color:" . esc_attr($lhc) . "}";

/* Text Selection */
echo "::-moz-selection { background:" . esc_attr($hc) . "}";
echo "::selection {background:" . esc_attr($hc) . "}";

/*************************************************************/
/*  Accent colors
/*************************************************************/
if($acc) {
    echo ".woocommerce #content input.button,
    .woocommerce a.button,
    .woocommerce button.button,
    .woocommerce input.button,
    .woocommerce-page #content input.button,
    .woocommerce-page a.button,
    .woocommerce-page button.button,
    .woocommerce-page input.button,
    .woocommerce.single-product .nice-select ul.list li:first-child:hover,
    .woocommerce a.button,.woocommerce-page a.button,
    .woocommerce a.button.alt,.woocommerce-page a.button.alt,
    .woocommerce #respond input#submit.alt:hover,
    .woocommerce a.button.alt:hover,
    .woocommerce button.button.alt:hover,
    .woocommerce input.button.alt:hover,
    .woocommerce input.button#place_order,
    .wp-block-search .wp-block-search__button,
    .product.woocommerce.add_to_cart_inline a.added_to_cart,
    .progress-bar-block .fill,
    .touchevents .woocommerce #commentform .button.button-large,
    .woocommerce #commentform .button.button-large:hover,
    .widget.widget_woocommerce-dropdown-cart li .qbutton.chckoutbtn,
    .woocommerce form.register input.button,
    .woocommerce form.login input.button,
    .woocommerce form.login input.button:hover,
    .woocommerce form.register input.button:hover,
    .woocommerce button.button.alt,
    .widget-area .product-categories li.cat-item.current-cat > a:before,
    .sidebar .widget_shopping_cart_content a.checkout.wc-forward.button,
    .widget_shopping_cart_content a.wc-forward.button,
    body.rad-body #respond input#submit,
    body.rad-body input[type='submit'],
    body.rad-body input[type='button'],
    body.rad-body .button {";
    echo "background-color:" . esc_attr($acc);
    echo "}";

    echo ".woocommerce .cart-collaterals .cart_totals tr.order-total strong,
    .woocommerce table.shop_table td.product-subtotal span,
    .woocommerce table.shop_table form.woocommerce-shipping-calculator a,
    .project-detail li:last-child .project-subtitle a:hover,
    .widget-area .product-categories li.current-cat > a,
    .widget-area .product-subcategories li.current-cat > a,
    .woocommerce-page ul.products li.product:not(.disable-hover):hover span.product-button ~ span:hover a,
    .product_meta> span a:hover,
    .widget_ranged_price_filter li.current a,
    .widget_order_by_filter li.current, .widget_order_by_filter li.current a,
    .woocommerce .widget_shopping_cart .total .amount, .woocommerce.widget_shopping_cart .total .amount,
    .woocommerce ul.cart_list li .quantity, .woocommerce ul.product_list_widget li .quantity,
    .woocommerce form .form-row .required,
    .woocommerce table.shop_table tfoot td, 
    .woocommerce div.product form.cart table.group_table label a:hover,
    .single-post .post-tags a:hover,
    .single-post span.post-author a:hover,
    .single-post span.post-categories a:hover,
    div.wpcf7-mail-sent-ok,
    .search-item .count,
    .pageNavigation .more-link-arrow:hover,
    #rad-resp-nav a:hover,
    ul li.woocommerce-MyAccount-navigation-link a:hover,
    ul li.woocommerce-MyAccount-navigation-link.is-active a,
    .widget_product_tag_cloud.collapse .show_more_tags:hover,
    .widget_product_categories .cats-toggle:hover,
    .widget_product_categories .cats-toggle.toggle-active,
    form.woocommerce-currency-switcher-form .dd-option .dd-option-text:hover {";
    echo "color:" . esc_attr($acc);
    echo "}";

    echo ".woocommerce div.product form.cart .group_table .woocommerce-grouped-product-list-item__price,
    .woocommerce div.product form.cart .group_table .price,
    .woocommerce p.stars.selected a:not(.active):before,
    .woocommerce p.stars.selected a.active:before, .woocommerce p.stars:hover a:before,
    .woocommerce .woocommerce-breadcrumb a:hover,
    .yith-wcwl-add-to-wishlist .yith-wcwl-add-button a:hover,
    .yith-wcwl-add-to-wishlist .yith-wcwl-wishlistaddedbrowse a:hover,
    .yith-wcwl-add-to-wishlist .yith-wcwl-wishlistexistsbrowse a:hover,
    .yith-wcwl-wishlistaddedbrowse:before, .yith-wcwl-wishlistexistsbrowse:before,
    .yith-wcwl-wishlistaddedbrowse:hover {";
    echo "color:" . esc_attr($acc) . "!important";
    echo "}";


    echo ".widget-area .product-categories li.cat-item.current-cat > a:before,
    .widget-area .product-categories li.cat-item a:hover:before,
    .widget-area .product-categories li.cat-item a:hover:before {";
    echo "border-color:" . esc_attr($acc);
    echo "}";

    echo ".touchevents .woocommerce #commentform .button.button-large,
    .woocommerce #commentform .button.button-large:hover,
    .woocommerce .widget_layered_nav ul.imagelist li.chosen a img {";
    echo "border-color:". esc_attr($acc);
    echo "}";
}

/*************************************************************/
/*  Topbar
/*************************************************************/
if ( $topbar_bg_color ) {
    echo "#topbar,#topbar .lang-sel ul.lang_link:before  {";
    echo "background-color:" . esc_attr($topbar_bg_color);
    echo "}";
}

if ( $topbar_border_color ) {
    echo "#topbar {";
    echo "border-bottom-color:" . esc_attr($topbar_border_color);
    echo "}";
} 

/*************************************************************/
/*  Preloader
/*************************************************************/
if ( $preloader_bg_color) { 

    echo "#preloader {";
    echo "background-color:" . esc_attr($preloader_bg_color); 
    echo "}";
}

if ( $preloader_color ) {
    echo "#preloader.line .p-item:after, #preloader.ripple1 .p-item:after {";
    echo "background:" . esc_attr($preloader_color);
    echo "}";

    echo "#preloader.ripple2 .p-item:before, #preloader.ripple2 .p-item:after {";
    echo "border-color:" . esc_attr($preloader_color);
    echo "}";
}

/*************************************************************/
/*  Footer background
/*************************************************************/
if ($footer_bg_color != "" || $footer_bg_image != "") {
    echo "footer.dark, footer.light {";
    echo "background:" . esc_attr($footer_bg_color) . $footer_bg_image;
    echo "}";
}

/*************************************************************/
/*  body font
/*************************************************************/
if ( $body_font !== "theme_default") {
    echo "html,body {";
    echo "font-family:" . esc_html($body_font) .", sans-serif;";
    echo rad_get_font_variant_attribute($body_font_variants);
    echo "}";
}

/*************************************************************/
/*  Headings
/*************************************************************/
if ( $heading_font !== "theme_default") {
    echo "h1,h2,h3,h4,h5,h6 {";
    echo "font-family:" . esc_html($heading_font) . ", sans-serif;";
    echo rad_get_font_variant_attribute($heading_font_variants);
    echo "}";
}

/*************************************************************/
/*  Menu font
/*************************************************************/

if ( $nav_font !== "theme_default") {
    echo ".header-account a,.topbar_lang_flag .lang-sel a,#hamburger-menu-bar label,header .navigation > ul > li > a,.menu-list a span,header .navigation li.mega-menu-parent div > ul > li.menu-item-has-children > a {";
    echo "font-family:" . esc_html($nav_font) .", sans-serif;";
    echo rad_get_font_variant_attribute($nav_font_variants);
    echo "}";
}

/*************************************************************/
/*  Social icons
/*************************************************************/
if($social_icon_1 != "")
{

    echo "span.icon.icon-custom1 {";
    echo "background-image: url(\"" . esc_url(rad_get_image_url($social_icon_1,"full")) . "\");";
    echo "}";
}

if($social_icon_2 != "")
{

echo "span.icon.icon-custom2 {";
echo "background-image: url(\"" . esc_url(rad_get_image_url($social_icon_2,"full")) . "\");";
echo "}";

}

if($social_icon_3 != "")
{
    echo "span.icon.icon-custom3 {";
    echo "background-image: url(\"" . esc_url(rad_get_image_url($social_icon_3,"full")) . "\");";
    echo "}";
}

/*************************************************************/
/*  print custom styles of shortcodes
/*************************************************************/
echo rad_get_meta( "rad_custom_style", true );


/*************************************************************/
/*  font size
/*************************************************************/
$main_font_size = str_replace("px", "", rad_get_option("main-font-size"));
$h1_font_size = str_replace("px", "", rad_get_option("h1-font-size"));
$h2_font_size = str_replace("px", "", rad_get_option("h2-font-size"));
$h3_font_size = str_replace("px", "", rad_get_option("h3-font-size"));
$h4_font_size = str_replace("px", "", rad_get_option("h4-font-size"));
$h5_font_size = str_replace("px", "", rad_get_option("h5-font-size"));
$h6_font_size = str_replace("px", "", rad_get_option("h6-font-size"));

$navigation_font_size = str_replace("px", "", rad_get_option("navigation-font-size"));
if ( $main_font_size !== "" && ctype_digit($main_font_size) && intval($main_font_size) != 15 ) {
    echo "html,body{font-size:" . esc_html($main_font_size) ."px;}";
}

if ( $h1_font_size !== "" && ctype_digit($h1_font_size)) {
    echo "h1{font-size:" . esc_html($h1_font_size ) ."px;}";
    echo "#header h1{font-size:" . esc_html($h1_font_size * 0.7 ) ."px;}";
}
if ( $h2_font_size !== "" && ctype_digit($h2_font_size)) {
    echo "h2{font-size:" . esc_html($h2_font_size ) ."px;}";
}
if ( $h3_font_size !== "" && ctype_digit($h3_font_size)) {
    echo "h3{font-size:" . esc_html($h3_font_size ) ."px;}";
}
if ( $h4_font_size !== "" && ctype_digit($h4_font_size)) {
    echo "h4{font-size:" . esc_html($h4_font_size ) ."px;}";
}
if ( $h5_font_size !== "" && ctype_digit($h5_font_size)) {
    echo "h5{font-size:" . esc_html($h5_font_size ) ."px;}";
}
if ( $h6_font_size !== "" && ctype_digit($h6_font_size)) {
    echo "h6{font-size:" . esc_html($h6_font_size ) ."px;}";
}

if ( $navigation_font_size !== "" && ctype_digit($navigation_font_size) && intval($navigation_font_size) != 14 ) {
    echo "#rad-menu > span,#rad-menu .navigation > ul > li > a,#rad-menu .navigation li li > a,.header-account a";
    echo "{font-size:" . esc_html($navigation_font_size) ."px;}";
}

/*************************************************************/
/*  print written custom styles in theme settings panel
/*************************************************************/
rad_e_option("additional-css");
?>
