<?php

class Rad_Custom_Menu_Items
{

    /**
     * Add menu meta box
     */
    public function __construct()
    {
        add_action("admin_init", array($this, "add_meta_box"));
        add_filter("wp_setup_nav_menu_item", array($this, "customize_menu_item_label"));
        add_filter("nav_menu_item_output", array($this, "menu_class"), 10, 5);

        add_action("wp_update_nav_menu_item", array($this, "wp_update_nav_menu_item"), 10, 3);
    }

    public function add_meta_box()
    {
        add_meta_box(
            "rad_menu_custom_item_types",
            __("Aventa - Menu items", "aventa"),
            array($this, "menu_custom_item_types"),
            "nav-menus",
            "side",
            "high"
        );
    }

    public function menu_class($item_output, $item, $depth, $args, $id)
    {
        $type = "";
        if ($item->object == "custom") {
            $type = get_post_meta($item->ID, "_menu_item_rad_menu_type", true);
            return str_ireplace("class=\"menu-item ", "class=\"menu-item menu-type-" . $type . " ", $item_output);
        }

        return $item_output;
    }

    /**
     * Change item label depending on the link
     */
    public function customize_menu_item_label($menu_item)
    {
        if ("custom" !== $menu_item->type) {
            return $menu_item;
        }

        $menu_item->rad_menu_type          = isset($menu_item->rad_menu_type) ? $menu_item->rad_menu_type : get_post_meta($menu_item->ID, "_menu_item_rad_menu_type", true);
        $menu_item->rad_menu_button_text   = isset($menu_item->rad_menu_button_text) ? $menu_item->rad_menu_button_text : get_post_meta($menu_item->ID, "_menu_item_rad_menu_button_text", true);
        $menu_item->rad_menu_shortcode     = isset($menu_item->rad_menu_shortcode) ? $menu_item->rad_menu_shortcode : get_post_meta($menu_item->ID, "_menu_item_rad_menu_shortcode", true);
        $menu_item->rad_menu_column        = isset($menu_item->rad_menu_column) ? $menu_item->rad_menu_column : get_post_meta($menu_item->ID, "_menu_item_rad_menu_column", true);
        $menu_item->rad_menu_heading_level = isset($menu_item->rad_menu_heading_level) ? $menu_item->rad_menu_heading_level : get_post_meta($menu_item->ID, "_menu_item_rad_menu_heading_level", true);

        switch ($menu_item->rad_menu_type) {
            case "banner":
                $menu_item->type_label = __("Banner", "aventa");
                break;
            case "collection":
                $menu_item->type_label = __("Collection", "aventa");
                break;
            case "column":
                $menu_item->type_label = __("Column", "aventa");
                break;
            case "headline":
                $menu_item->type_label = __("Headline", "aventa");
                break;
        }

        return $menu_item;
    }

    public function customize_nav_menu_available_item_types($item_types)
    {
        // This would work if could query the custom items from somewhere.
        return $item_types;
    }

    /**
     * Displays a metabox for the custom links menu item.
     *
     * @global int        $_nav_menu_placeholder
     * @global int|string $nav_menu_selected_id
     */
    public function menu_custom_item_types()
    {
        global $_nav_menu_placeholder, $nav_menu_selected_id;

        $_nav_menu_placeholder = 0 > $_nav_menu_placeholder ? $_nav_menu_placeholder - 1 : -1;

        ?>
        <div class="posttypediv" id="custom-item-types">
            <div id="tabs-panel-custom-item-types" class="tabs-panel tabs-panel-active">
                <ul id ="custom-item-types-checklist" class="categorychecklist form-no-clear">
                    <li>
                        <label class="menu-item-title">
                            <input type="radio" class="menu-item-checkbox" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="-1"> <?php _e("WC Collection", "aventa");?>
                        </label>
                        <input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="custom">
                        <input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php _e("Collection", "aventa");?>">
                        <input type="hidden" class="menu-item-url" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-url]" value="#collection">
                    </li>
                    <li>
                        <label class="menu-item-title">
                            <input type="radio" class="menu-item-checkbox" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="-1"> <?php _e("Column *", "aventa");?>
                        </label>
                        <input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="custom">
                        <input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php _e("Column", "aventa");?>">
                        <input type="hidden" class="menu-item-url" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-url]" value="#column">
                    </li>
                    <li>
                        <label class="menu-item-title">
                            <input type="radio" class="menu-item-checkbox" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="-1"> <?php _e("Headline *", "aventa");?>
                        </label>
                        <input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="custom">
                        <input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php _e("Headline", "aventa");?>">
                        <input type="hidden" class="menu-item-url" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-url]" value="#headline">
                    </li>
                    <li>
                        <label class="menu-item-title">
                            <input type="radio" class="menu-item-checkbox" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="-1"> <?php _e("Banner *", "aventa");?>
                        </label>
                        <input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="custom">
                        <input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php _e("Banner", "aventa");?>">
                        <input type="hidden" class="menu-item-url" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-url]" value="#banner">
                    </li>
                </ul>
            </div>
            <p><?php _e("* Mega menu items.", "aventa");?></p>
            <input type="hidden" value="custom" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" />

            <p class="button-controls wp-clearfix">
                <span class="add-to-menu">
                    <input type="submit"<?php wp_nav_menu_disabled_check($nav_menu_selected_id);?> class="button-secondary submit-add-to-menu right" value="<?php esc_attr_e("Add to Menu", "aventa");?>" name="add-custom-menu-item" id="submit-custom-item-types" />
                    <span class="spinner"></span>
                </span>
            </p>

        </div><!-- /.custom-item-types -->
        <?php
}

    public function wp_update_nav_menu_item($menu_id = 0, $menu_item_db_id = 0, $args = array())
    {
        if (!current_user_can("edit_theme_options")) {
            return;
        }

        // Add new menu item via ajax.
        if (isset($_REQUEST["menu-settings-column-nonce"]) && wp_verify_nonce($_REQUEST["menu-settings-column-nonce"], "add-menu_item")) {
            if (!empty($_POST["menu-item"]["-1"]["menu-item-url"])) {

                $type = str_replace("#", "", $_POST["menu-item"]["-1"]["menu-item-url"]);
                update_post_meta(
                    $menu_item_db_id,
                    "_menu_item_rad_menu_type",
                    sanitize_text_field($type)
                );
                update_post_meta(
                    $menu_item_db_id,
                    "_menu_item_url",
                    ""
                );
            }
        }

        // Update settings for existing menu items.
        if (isset($_REQUEST["update-nav-menu-nonce"]) && wp_verify_nonce($_REQUEST["update-nav-menu-nonce"], "update-nav_menu")) {
            if (!empty($_POST["menu-item-button-text"][$menu_item_db_id])) {
                update_post_meta(
                    $menu_item_db_id,
                    "_menu_item_rad_menu_button_text",
                    sanitize_text_field($_POST["menu-item-button-text"][$menu_item_db_id])
                );
            }

            if (!empty($_POST["menu-item-shortcode"][$menu_item_db_id])) {
                update_post_meta(
                    $menu_item_db_id,
                    "_menu_item_rad_menu_shortcode",
                    sanitize_text_field($_POST["menu-item-shortcode"][$menu_item_db_id])
                );
            }

            if (!empty($_POST["menu-item-column"][$menu_item_db_id])) {
                update_post_meta(
                    $menu_item_db_id,
                    "_menu_item_rad_menu_column",
                    sanitize_text_field($_POST["menu-item-column"][$menu_item_db_id])
                );
            }

            if (!empty($_POST["menu-item-heading-level"][$menu_item_db_id])) {
                update_post_meta(
                    $menu_item_db_id,
                    "_menu_item_rad_menu_heading_level",
                    sanitize_text_field($_POST["menu-item-heading-level"][$menu_item_db_id])
                );
            }
        }

    }

}

new rad_Custom_Menu_Items();