<?php

/**
 * The helper functions
 *
 * @link       https://themeforest.net/user/rado-studio/portfolio
 * @since      1.0.0
 *
 * @package    Aventa_core
 */

/*-----------------------------------------------------------------*/
// Check if current request is an AJAX request */
/*-----------------------------------------------------------------*/
if (!function_exists("rad_is_ajax_request")) {
    function rad_is_ajax_request()
    {
        if (!empty($_SERVER["HTTP_X_REQUESTED_WITH"]) && strtolower($_SERVER["HTTP_X_REQUESTED_WITH"]) == "xmlhttprequest") {
            return true;
        }

        return false;
    }
}

function rad_define_post_options($initiator)
{
    add_action("add_meta_boxes", array($initiator, "rad_define_meta_boxes"));
}

/******************************************************
 * Product single : Social share
 *******************************************************/
if (!function_exists("rad_social_share")) {
    function rad_social_share($style = "dark", $direction = "vertical")
    {
        global $post;
        $socialshare = rad_get_option("social_share_display"); //theme settings;
        if ($socialshare != 0) {
            $fbshare        = rad_get_option("social_share_facebook");
            $googleshare    = rad_get_option("social_share_google");
            $emailshare     = rad_get_option("social_share_mail");
            $twittershare   = rad_get_option("social_share_twitter");
            $pinterestshare = rad_get_option("social_share_pinterest");

            // try getting featured image -  pinterest icon
            $featured_img = get_the_post_thumbnail_url($post->ID, "full");
            $featured_img = ($featured_img == false) ? "" : $featured_img;

            $url   = urlencode(esc_url(get_permalink(get_the_ID())));
            $title = urlencode(get_the_title());

            $social_share_facebook  = "http://www.facebook.com/sharer.php?u=" . $url;
            $social_share_twitter   = "https://twitter.com/intent/tweet?original_referer=" . $url . "&amp;source=tweetbutton&amp;text=" . $title . "&amp;url=" . $url;
            $social_share_google    = "https://plus.google.com/share?url=" . $url;
            $social_share_mail      = "mailto:?subject=" . esc_html__("Check this ", "aventa") . "&body=" . $url;
            $social_share_pinterest = "http://pinterest.com/pin/create/button/?url=" . $url . "&amp;media=" . esc_url($featured_img) . "&amp;description=" . $title;

            $socials = array(
                "facebook"  => array(
                    "name" => "facebook-f",
                    "url"  => ($fbshare == "1") ? $social_share_facebook : "",
                ),
                "twitter"   => array(
                    "name" => "twitter",
                    "url"  => ($twittershare == "1") ? $social_share_twitter : "",
                ),
                "pinterest" => array(
                    "name" => "pinterest-p",
                    "url"  => ($pinterestshare == "1") ? $social_share_pinterest : "",
                ),
                "mail"      => array(
                    "name" => "mail",
                    "url"  => ($emailshare == "1") ? $social_share_mail : "",
                ),
            );
            $classes = array("social-icons", $style . "-style", "share", $direction);
            echo rad_social_icons("social-share", $socials, $classes, "icon");
        }
    }
}
