<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://themeforest.net/user/rado-studio/portfolio
 * @since      1.0.0
 *
 * @package    Aventa_core
 * @subpackage Aventa_core/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aventa_core
 * @subpackage Aventa_core/public
 * @author     Rado studio <help.radostudio@gmail.com>
 */
class Aventa_core_Public
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of the plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {

        $this->plugin_name = $plugin_name;
        $this->version     = $version;

        //Use shortcodes in text widgets.
        add_filter("widget_text", "do_shortcode");

        if (!has_action("rad_wc_register_taxonomy_before_import")) {
            add_action("rad_wc_register_taxonomy_before_import", array($this, "register_WC_taxonomy_before_import"));
        }

        add_action("wp_footer", array($this, "rad_remove_VC_scripts"));

    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Aventa_core_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Aventa_core_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        $theme = wp_get_theme(); // gets the current theme
        if ("Aventa" != $theme->name && "Aventa-child" != $theme->name) {
            wp_enqueue_style($this->plugin_name . "_css", plugin_dir_url(__DIR__) . "assets/css/style.css", array(), $this->version, "all");
        }

    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Aventa_core_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Aventa_core_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        $theme = wp_get_theme(); // gets the current theme
        if ("Aventa" != $theme->name && "Aventa-child" != $theme->name) {
            wp_enqueue_script($this->plugin_name . "_css", plugin_dir_url(__DIR__) . "assets/js/script.js", array("jquery"), $this->version, false);
        }

    }

    public function add_widgets()
    {

        /**
         * Load all the widgets
         */
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-video.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-wishlist.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-advanced-layered-nav.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-ranged-price-filter.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-on-sale-filter.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-in-stock-filter.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-layered-nav-filters.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-order-by-filter.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-woocommerce-rating-filter.php";
        require_once plugin_dir_path(dirname(__FILE__)) . "includes/widgets/widget-recent-posts.php";

        if (class_exists("woocommerce")) {
            if (class_exists("Rad_Woocommerce_Wishlist_Widget")) {
                register_widget("Rad_Woocommerce_Wishlist_Widget");
            }

            if (class_exists("Rad_WC_Widget_On_Sale_Filter")) {
                register_widget("Rad_WC_Widget_On_Sale_Filter");
            }

            if (class_exists("Rad_WC_Widget_In_Stock_Filter")) {
                register_widget("Rad_WC_Widget_In_Stock_Filter");
            }

            // Remove default widget
            if (class_exists("WC_Widget_Rating_Filter")) {
                unregister_widget("WC_Widget_Rating_Filter");
            }

            if (class_exists("Rad_WC_Widget_Rating_Filter")) {
                register_widget("Rad_WC_Widget_Rating_Filter");
            }

            // Remove default widget
            if (class_exists("WC_Widget_Layered_Nav_Filters")) {
                unregister_widget("WC_Widget_Layered_Nav_Filters");
            }
            if (class_exists("Rad_WC_Widget_Rating_Filter")) {
                register_widget("Rad_WC_Widget_Rating_Filter");
            }

            if (class_exists("Rad_WC_Widget_Order_By_Filter")) {
                register_widget("Rad_WC_Widget_Order_By_Filter");
            }

            if (class_exists("Rad_WC_Widget_Ranged_Price_Filter")) {
                register_widget("Rad_WC_Widget_Ranged_Price_Filter");
            }

            // Remove default widget
            if (class_exists("WC_Widget_Layered_Nav")) {
                unregister_widget("WC_Widget_Layered_Nav");
            }

            if (class_exists("Rad_Advanced_WC_Widget_Layered_Nav")) {
                register_widget("Rad_Advanced_WC_Widget_Layered_Nav");
            }
        }

        if (class_exists("Rad_Facebook_Widget")) {
            register_widget("Rad_Facebook_Widget");
        }

        if (class_exists("Rad_Video_Widget")) {
            register_widget("Rad_Video_Widget");
        }

        if (class_exists("RAD_Widget_Recent_Posts")) {
            register_widget("RAD_Widget_Recent_Posts");
        }
    }

    public function rad_sc_woocommerce_shortcodes_changes()
    {
        if (!class_exists("woocommerce")) {
            return;
        }

        //Remove WC shortcodes
        remove_shortcode("product");
        remove_shortcode("products");
        remove_shortcode("recent_products");
        remove_shortcode("sale_products");
        remove_shortcode("best_selling_products");
        remove_shortcode("top_rated_products");
        remove_shortcode("featured_products");
        remove_shortcode("product_attribute");
        remove_shortcode("product_categories");
        remove_shortcode("product_category");

        //Add WC shortcodes and define handler for them
        add_shortcode("product", "rad_sc_product");
        add_shortcode("products", "rad_products");
        add_shortcode("recent_products", "rad_recent_products");
        add_shortcode("sale_products", "rad_sale_products");
        add_shortcode("best_selling_products", "rad_best_selling_products");
        add_shortcode("top_rated_products", "rad_top_rated_products");
        add_shortcode("featured_products", "rad_featured_products");
        add_shortcode("product_attribute", "rad_product_attribute");
        add_shortcode("product_categories", "rad_product_categories");
        add_shortcode("product_category", "rad_product_category");
    }

    // Remove below Scripts becuase cause bug and We replace Our functionality
    public function rad_remove_VC_scripts($handles = array())
    {

        wp_deregister_style("vc_tta_style");
        wp_dequeue_style("vc_tta_style");

        wp_deregister_script("vc_accordion_script");
        wp_dequeue_script("vc_accordion_script");

        wp_deregister_script("vc_tta_autoplay_script");
        wp_dequeue_script("vc_tta_autoplay_script");

        wp_deregister_script("vc_tabs_script");
        wp_dequeue_script("vc_tabs_script");

        wp_deregister_script("waypoints");
        wp_dequeue_script("waypoints");
    }

    public function add_shortcodes()
    {
        //Separators
        add_shortcode("vc_separator", "rad_sc_separator");

        //Team Member
        add_shortcode("rad_team_member", "rad_team_member_handler");

        //Testimonials shortcode
        add_shortcode("rad_testimonial", "rad_testimonial_handler");
        add_shortcode("rad_testimonial_item", "rad_testimonial_item_handler");

        //Pie Chart
        add_shortcode("rad_chart", "rad_chart_handler");

        //Horizontal progress bar
        add_shortcode("rad_progressbar", "rad_progressbar_handler");

        //Social Icon
        add_shortcode("rad_socials", "rad_socials_block");

        //Title
        add_shortcode("rad_heading", "rad_heading_handler");

        //Custom Title
        add_shortcode("rad_custom_heading", "rad_custom_heading_handler");

        //Image-Box
        add_shortcode("rad_banner", "rad_banner_block");

        //Slideshow
        add_shortcode("rad_slideshow", "rad_slideshow_handler");
        add_shortcode("rad_slideshow_item", "rad_slideshow_item_handler");

        //Animated Text
        add_shortcode("rad_marquee", "rad_marquee_handler");

        //Icon block
        add_shortcode("rad_icon_block", "rad_icon_block_handler");

        //Countdown
        add_shortcode("rad_countdown", "rad_sc_countdown");

        //Counter Box
        add_shortcode("rad_counter", "rad_counter_handler");

        //Embed Video
        add_shortcode("rad_video", "rad_sc_embed_video");

        // Audio SoundCloud
        add_shortcode("rad_audio", "rad_sc_audio_soundcloud");

        // Tabs, Tour, Accordion, TTA section
        add_shortcode("rad_tab_group", "rad_tab_group_handler");
        add_shortcode("rad_tour_group", "rad_tour_group_handler");
        add_shortcode("rad_accordion_group", "rad_accordion_group_handler");
        add_shortcode("rad_tta", "rad_tta_handler");

        // Button
        add_shortcode("rad_button", "rad_button_block");

        // Link
        add_shortcode("rad_link", "rad_link_handler");

        // Toggle block
        add_shortcode("rad_toggle", "rad_toggle_handler");

        // slideshow pro
        add_shortcode("rad_reveal_slideshow", "rad_reveal_slideshow_handler");

        // Image carousel
        add_shortcode("rad_image_carousel", "rad_image_carousel_handler");

        // Carousel Gallery
        add_shortcode("rad_carousel_gallery", "rad_gallery_carousel_handler");
        add_shortcode("rad_gallery_item", "rad_gallery_carousel_item_handler");

        // Newsletter(subscribtion form)
        add_shortcode("rad_newsletter", "rad_newsletter_handler");

        // Card blog
        add_shortcode("rad_card_blog", "rad_card_blog_handler");
    }

    //Built-in Slider custom Post type
    public function create_custom_slider_post_type()
    {

        $labels = array(
            "name"               => __("Slides", "aventa"),
            "singular_name"      => __("Slide", "aventa"),
            "add_new"            => __("Add New Slide", "aventa"),
            "add_new_item"       => __("Add New Slide", "aventa"),
            "edit_item"          => __("Edit Slide", "aventa"),
            "new_item"           => __("New Slide", "aventa"),
            "view_item"          => __("View Slide", "aventa"),
            "search_items"       => __("Search Slide", "aventa"),
            "not_found"          => __("No Slides found", "aventa"),
            "not_found_in_trash" => __("No Slides found in Trash", "aventa"),
            "parent_item_colon"  => "",
        );

        $args = array(
            "labels"              => $labels,
            "public"              => true,
            "capability_type"     => "post",
            "has_archive"         => true,
            "hierarchical"        => false,
            "exclude_from_search" => false,
            "menu_position"       => 60,
            "menu_icon"           => plugin_dir_url(__DIR__) . "assets/img/slider.png",
            "rewrite"             => array("slug" => "slides", "with_front" => true),
            "supports"            => array("title",
                "editor",
                "thumbnail",
            ),
            "show_in_nav_menus"   => false,
        );

        register_post_type("slider", $args);

        /* Register the corresponding taxonomy */

        register_taxonomy("slider_cats", "slider",
            array("hierarchical" => true,
                "label"              => __("Categories", "aventa"),
                "singular_label"     => __("Category", "aventa"),
                "rewrite"            => array("slug" => "slider_cats", "hierarchical" => true),
                "show_in_nav_menus"  => false,
            ));
    }

    public function register_WC_taxonomy_before_import($term_domain)
    {
        register_taxonomy(
            $term_domain,
            apply_filters("woocommerce_taxonomy_objects_" . $term_domain, array("product")),
            apply_filters("woocommerce_taxonomy_args_" . $term_domain, array(
                "hierarchical" => true,
                "show_ui"      => false,
                "query_var"    => true,
                "rewrite"      => false,
            ))
        );
    }

}
