<?php

/**
 *
 * @link              https://themeforest.net/user/rado-studio/portfolio
 * @since             1.0.0
 * @package           Aventa core
 *
 * @wordpress-plugin
 * Plugin Name:       Aventa Core
 * Plugin URI:        https://themeforest.net/user/rado-studio/portfolio
 * Description:       Core features of Aventa theme.
 * Version:           1.6
 * Author:            Rado studio
 * Author URI:        https://themeforest.net/user/rado-studio/portfolio
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       aventa
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined("WPINC")) {
    die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-aventa-core-activator.php
 */
function rad_activate_aventa_core()
{
    require_once plugin_dir_path(__FILE__) . "includes/class-aventa-core-activator.php";
    Aventa_core_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-aventa-core-deactivator.php
 */
function rad_deactivate_aventa_core()
{
    require_once plugin_dir_path(__FILE__) . "includes/class-aventa-core-deactivator.php";
    Aventa_core_Deactivator::deactivate();
}

register_activation_hook(__FILE__, "rad_activate_aventa_core");
register_deactivation_hook(__FILE__, "rad_deactivate_aventa_core");

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . "includes/class-aventa-core.php";

/**
 * Prepare demo importer.
 *
 * @since    1.0.0
 */
function rad_aventa_demo_importer_preparation()
{
    global $pagenow;
    if ($pagenow == "admin.php" && isset($_GET["page"]) && $_GET["page"] == "aventa_demo_importer") {
        if (!defined("WP_LOAD_IMPORTERS")) {
            define("WP_LOAD_IMPORTERS", true);
        }
    }

}
rad_aventa_demo_importer_preparation();

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function rad_run_aventa_core()
{
    $plugin = new Aventa_core();
    $plugin->run();

}
rad_run_aventa_core();
