<?php

abstract class Rad_Meta_Box
{
    protected $postType;

    public function __construct($postType)
    {

        $this->postType = $postType;

        add_action("after_setup_theme", array(&$this, "rad_CreatePostType"), 0);
        add_action("add_meta_boxes", array(&$this, "rad_define_meta_boxes"));
        add_action("admin_print_scripts-post-new.php", array(&$this, "rad_InitScripts"));
        add_action("admin_print_scripts-post.php", array(&$this, "rad_InitScripts"));

        /* Save post meta on the "save_post" hook. */
        add_action("save_post", array(&$this, "rad_SaveData"), 10, 2);

    }

    public function rad_SaveData($post_id = false, $post = false)
    {

        /* Verify the nonce before proceeding. */
        $nonce = "aventa_post_nonce";

        if (!isset($_POST[$nonce]) || !wp_verify_nonce($_POST[$nonce], "theme-post-meta-form")) {
            return $post_id;
        }

        // check autosave
        if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) {
            return $post_id;
        }

        if ($post->post_type != $this->postType || !current_user_can("edit_post", $post_id)) {
            return $post_id;
        }

        //CRUD Operation
        foreach ($this->rad_GetOptionsForStore() as $key => $settings) {
            //Let the derived class intercept the process
            if ($this->rad_OnProcessFieldForStore($post_id, $key, $settings)) {
                continue;
            }

            $postedVal = isset($_POST[$key]) ? $_POST[$key] : "";
            $val       = get_post_meta($post_id, $key, false);

            if (is_array($postedVal)) {
                //Insert
                if (!empty($postedVal) && empty($val)) {
                    add_post_meta($post_id, $key, $postedVal);

                }
                //Delete
                elseif (!empty($val) && empty($postedVal)) {
                    delete_post_meta($post_id, $key);

                    //Delete the attachment as well
                    if ($settings["type"] == "upload") {
                        rad_delete_attachment($val);
                    }
                }
                //Update
                elseif (!empty($val) && !empty($postedVal) && $postedVal != $val) {
                    update_post_meta($post_id, $key, $postedVal);
                }

            } else {
                //Insert
                if ($postedVal != "" && empty($val)) {
                    add_post_meta($post_id, $key, $postedVal);

                }
                //Delete
                elseif (!empty($val) && $postedVal == "") {
                    delete_post_meta($post_id, $key);

                    //Delete the attachment as well
                    if ($settings["type"] == "upload") {
                        rad_delete_attachment($val);
                    }
                }
                //Update
                elseif ($postedVal != "" && !empty($val) && $postedVal != $val) {
                    update_post_meta($post_id, $key, $postedVal);
                }

            }
        }

        //save custom styles of shortcodes
        if ($post != false) {
            if ( class_exists( "WPBMap" ) ) {
                WPBMap::addAllMappedShortcodes();
            }

            //$content = do_shortcode(do_shortcode($post->post_content));
            $content    = apply_filters("the_content", $post->post_content);
            $all_styles = "";

            preg_match_all("#<style>(.*?)</style>#i", $content, $styles);

            if (count($styles) > 0) {
                foreach ($styles[1] as $style) {
                    $all_styles .= $style;
                }

                update_post_meta($post_id, "rad_custom_style", $all_styles);
            } else {
                update_post_meta($post_id, "rad_custom_style", "");
            }
        }

        return $post_id;
    }

    public function rad_OnProcessFieldForStore($post_id, $key, $settings)
    {
        return false;
    }

    public function rad_CreatePostType()
    {

    }

    protected function rad_GetOptionsForStore()
    {
        $options = $this->rad_GetOptions();
        $values  = array();

        foreach ($options as $box) {
            foreach ($box["options"] as $section) {
                foreach ($section["fields"] as $key => $field) {
                    $ignore = rad_array_value("dontsave", rad_array_value("meta", $field, array()), false);

                    if ($ignore) {
                        continue;
                    }

                    $values[$key] = $field;
                }
            }
        }

        return $values;
    }

    protected function rad_GetOptions()
    {
        return array();
    }

    public function rad_define_meta_boxes()
    {
        $options = $this->rad_GetOptions();

        foreach ($options as $box) {

            add_meta_box(
                $box["id"], // $id
                $box["title"], // $title
                array(&$this, "rad_show_beta_box"), // $callback
                $this->postType, // $page
                $box["context"], // $context
                $box["priority"], // $priority
                $box["options"]
            );

        }

    }

    public function rad_show_beta_box($post, $metabox)
    {
        $args = $metabox["args"];

        $form = new rad_FieldTemplate(new rad_PostOptionsProvider(), dirname(__FILE__));

        echo "" . $form->rad_GetTemplate("meta-box-template", $args);
    }

    public function rad_InitScripts()
    {
        global $post_type;

        if ($post_type != $this->postType) {
            return;
        }

        $this->rad_RegisterScripts();
        $this->rad_EnqueueScripts();
    }

    protected function rad_RegisterScripts()
    {
        wp_register_script("rad-jquery-easing", RAD_THEME_INC_URI . "/admin/assets/js/jquery.easing.1.3.js", array("jquery"), "1.3.0");

        wp_register_style("rad-nouislider-style", RAD_THEME_INC_URI . "/admin/assets/css/jquery.nouislider.min.css", false, "7.0.10", "screen");
        wp_register_script("rad-nouislider-script", RAD_THEME_INC_URI . "/admin/assets/js/jquery.nouislider.min.js", array("jquery"), "7.0.10");

        wp_register_script("rad-colorpicker-alpha", RAD_THEME_INC_URI . "/admin/assets/js/wp-color-picker-alpha.js", array("wp-color-picker"), "1.2.2");
        $color_picker_strings = array(
            "clear"            => esc_html__("Clear", "aventa"),
            "clearAriaLabel"   => esc_html__("Clear color", "aventa"),
            "defaultString"    => esc_html__("Default", "aventa"),
            "defaultAriaLabel" => esc_html__("Select default color", "aventa"),
            "pick"             => esc_html__("Select Color", "aventa"),
            "defaultLabel"     => esc_html__("Color value", "aventa"),
        );
        wp_localize_script("rad-colorpicker-alpha", "wpColorPickerL10n", $color_picker_strings);

        wp_register_style("rad-admin-style", RAD_THEME_INC_URI . "/admin/assets/css/style.css", false, "1.0.0", "screen");
        wp_register_script("rad-admin-script", RAD_THEME_INC_URI . "/admin/assets/js/admin.js", array("jquery"), "1.0.0");
    }

    protected function rad_EnqueueScripts()
    {
        wp_enqueue_media();
        wp_enqueue_script("hoverIntent");
        wp_enqueue_script("rad-jquery-easing");

        wp_enqueue_style("rad-nouislider-style");
        wp_enqueue_script("rad-nouislider-script");

        wp_enqueue_style("wp-color-picker");
        wp_enqueue_script("wp-color-picker");
        wp_enqueue_script("rad-colorpicker-alpha");

        wp_enqueue_style("rad-admin-style");
        wp_enqueue_script("rad-admin-script");
    }
}
