<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( "ABSPATH" ) ) {
	exit;
}

if ( $upsells ) : ?>

<div class="container">
	<div class="up-sells upsells products">
        <div class="related  carousel woocommerce wc-shortcode no-resp-anim">

		    <h2><?php esc_html_e( "You may also like&hellip;", "aventa" ) ?></h2>

		    <?php woocommerce_product_loop_start(); ?>

            <div class="swiper-container" data-visibleitems="4">
                    <div class="swiper-wrapper">

			            <?php foreach ( $upsells as $upsell ) : ?>

				            <?php
				 	            $post_object = get_post( $upsell->get_id() );

					            setup_postdata( $GLOBALS["post"] =& $post_object );

					            wc_get_template_part( "content", "product" ); ?>

			            <?php endforeach; ?>
                </div>
	        </div>

            <div class="rad-carousel-next unselectable"></div>
            <div class="rad-carousel-prev unselectable"></div>

		    <?php woocommerce_product_loop_end(); ?>

	    </div>
	</div>
</div>

<?php endif;

wp_reset_postdata();
