<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.1
 */

defined( "ABSPATH" ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( "wc_get_gallery_image_html" ) ) {
	return;
}

global $post, $product;
$attachment_ids = $product-> get_gallery_image_ids();

//Rado codes

$has_post_thumbnail = has_post_thumbnail()? true : false;
$image_count 		= count($attachment_ids) + ( $has_post_thumbnail ? 1 : 0 );
$post_thumbnail_url = $has_post_thumbnail ? get_the_post_thumbnail_url() : "";
$processed_images 	= array();

//variation images
$variable_images = array();
$variable_image_ids = array();
$variable_image_titles = array();
if( $product->is_type( "variable" ) ){
	$get_variations = sizeof( $product->get_children() ) <= apply_filters( "woocommerce_ajax_variation_threshold", 30, $product );
	$available_variations = $get_variations ? $product->get_available_variations() : array();
	
	foreach ($available_variations as $variable) {
		if(isset($variable["image_id"]))
		{

			$variable_image_ids[] = $variable["image_id"];
		}

		if(isset($variable["image"]["url"]) && $variable["image"]["url"] != "")
		{
			if ($has_post_thumbnail) {
					$variable_images[] = esc_url($variable["image"]["url"]);
					$variable_image_titles[] = esc_attr($variable["image"]["title"]);
			} else {
				$variable_images[] = esc_url($variable["image"]["url"]);
				$variable_image_titles[] = esc_attr($variable["image"]["title"]);
			}
		}	

	}

	$variable_images = array_unique($variable_images);
	$variable_image_titles = array_unique($variable_image_titles);
}

///add number of variation images
$image_count += count($variable_images);

$gallery_style = rad_get_option("product-gallery-style");

$product_gallery_popup = rad_get_option("product_gallery_popup");

$class = $gallery_style . "-gallery";
$class .= ($product_gallery_popup == 1) ? " rad-product-zoom-popup" : "";
$class .= (count($attachment_ids) + count($variable_images) == 0) ? " no-gallery" : "";
$slide_class = ($gallery_style == "classic" || $gallery_style == "carousel") ? "swiper-slide p-g-item" : "p-g-item";

$slide_class .= ($product_gallery_popup == 1)? " custom-cursor" : "";


$images_output = array();

if($image_count >= 1)
{
        
	$slide_num = 0;

	if ( $product->get_image_id() )					
	{

        $image_attr = rad_get_wc_image_attr( get_post_thumbnail_id(), "woocommerce_single" );
        
		if(is_array($image_attr) && $image_attr["src"] != "") {
			$image_url = $image_attr["src"];
			$image = "<img src=\"" . esc_url( $image_attr["src"] ) . "\" alt=\"" . esc_attr( $product->get_title() ) . "\" width=\"" . esc_attr( $image_attr["width"] ) . "\"";

			if($image_attr["height"] != "")
			{
				$image .= " height=\"" . esc_attr( $image_attr["height"] ) . "\"";
			}
			
			if($image_attr["srcset"] != "")
			{
				$image .= " srcset=\"" . esc_attr( $image_attr["srcset"] ) . "\"";
			}

			if($image_attr["sizes"] != "")
			{
				$image .= " sizes=\"" . esc_attr( $image_attr["sizes"] ) . "\"";
			}

			$image .= " />";
		}

		if(!in_array($product->get_image_id(), $variable_image_ids) )
        {

			$processed_images[] = $image_url;	
	
        	$images_output[] = apply_filters( "woocommerce_single_product_image_html", sprintf( "<div class=\"%s\" data-slide=\"%s\" data-cursor=\"#p-g-cursor\">%s</div>", esc_attr($slide_class), esc_attr($slide_num), $image, $post->ID ));
        	$slide_num++;
        }
	}

	//Process variable images at first (remove duplicate images of gallery)
	if( $product->is_type( "variable" ) ){
		$iterateor = 0;
		foreach ($variable_images as $raw_img_url) {

            $alt = "";
	        if(isset($variable_image_titles[$iterateor]))
	        {
	        	$alt = $variable_image_titles[$iterateor];
	        }
	        $variable_image_attr = "";
            $variable_image_id 	 = rad_get_image_id($raw_img_url);
            if($variable_image_id != -1)
            {	
            	$variable_image_attr = rad_get_wc_image_attr( $variable_image_id, "woocommerce_single" );
            }
            $variable_image_url  = $raw_img_url;


			if(is_array($variable_image_attr) && $variable_image_attr["src"] != "") {
				$variable_image_url = $variable_image_attr["src"];
				$variable_image = "<img src=\"" . esc_url( $variable_image_attr["src"] ) . "\" alt=\"" . esc_attr( $alt ) . "\" width=\"" . esc_attr( $variable_image_attr["width"] ) . "\"";

				if($variable_image_attr["height"] != "")
				{
					$variable_image .= " height=\"" . esc_attr( $variable_image_attr["height"] ) . "\"";
				}
				
				if($variable_image_attr["srcset"] != "")
				{
					$variable_image .= " srcset=\"" . esc_attr( $variable_image_attr["srcset"] ) . "\"";
				}

				if($variable_image_attr["sizes"] != "")
				{
					$variable_image .= " sizes=\"" . esc_attr( $variable_image_attr["sizes"] ) . "\"";
				}

				$variable_image .= "/>";


			}
			else {
				$variable_image = "<img src=\"" . esc_url( $raw_img_url ) . "\" alt=\"" . esc_attr( $alt ) . "\"/>";
			}
			
			if(in_array($variable_image_url, $processed_images))
			{
				continue;
			}
	        $processed_images[] = $variable_image_url;	
	        
			
           	$images_output[] = apply_filters( "woocommerce_single_product_image_html", sprintf( "<div class=\"%s\" data-slide=\"%s\" data-variableimageurl=\"%s\" data-cursor=\"#p-g-cursor\">%s</div>", esc_attr($slide_class), esc_attr($slide_num), esc_url($variable_image_url), $variable_image, $post->ID ));

			$iterateor++;
			$slide_num++;

		}
	}



	foreach ( $attachment_ids as $attachment_id ) {

        $image_attr = rad_get_wc_image_attr( $attachment_id, "woocommerce_single" );

		if(is_array($image_attr) && $image_attr["src"] != "") {
			$image_url = $image_attr["src"];
			$image = "<img src=\"" . esc_url( $image_attr["src"] ) . "\" alt=\"" . esc_attr( $product->get_title() ) . "\" width=\"" . esc_attr( $image_attr["width"] ) . "\"";

			if($image_attr["height"] != "")
			{
				$image .= " height=\"" . esc_attr( $image_attr["height"] ) . "\"";
			}

			if($image_attr["srcset"] != "")
			{
				$image .= " srcset=\"" . esc_attr( $image_attr["srcset"] ) . "\"";
			}

			if($image_attr["sizes"] != "")
			{
				$image .= " sizes=\"" . esc_attr( $image_attr["sizes"] ) . "\"";
			}

			$image .= "/>";
		}
		
		if(in_array($image_url, $processed_images))
		{
			continue;
		}

		$processed_images[] = $image_url;	
		
	
        $images_output[] = apply_filters( "woocommerce_single_product_image_html", sprintf( "<div class=\"%s\" data-slide=\"%s\" data-cursor=\"#p-g-cursor\">%s</div>", esc_attr($slide_class), esc_attr($slide_num), $image, $post->ID ));
        $slide_num++;
	}
}
?>
<div class="images">
	<?php
	if($gallery_style == "creative" && isset($images_output[0]))
	{
		echo str_replace("class=\"", "class=\"creative-gallery-first ", $images_output[0]);
		unset($images_output[0]);
	}
	?>
    <div id="product-fullview-thumbs" class="<?php echo esc_attr($class); ?>">
		<?php
		if($gallery_style == "classic" || $gallery_style == "carousel")
		{
			echo "<div class=\"swiper-container clearfix\"><div class=\"swiper-wrapper\">" . implode("",$images_output) . "</div><div class=\"rad-carousel-next unselectable\"></div>
			<div class=\"rad-carousel-prev unselectable\"></div></div>";
		}
		else
		{
			echo implode("",$images_output);
		}
		?>
    </div>
	<?php do_action( "woocommerce_product_thumbnails" ); ?>
</div>